/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceSearchListener;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.impl.DeviceDriveManager;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerRSSFeed;
import com.aelitis.azureus.core.devices.impl.DeviceManagerUPnPImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererManual;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererTemplateImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivoManager;
import com.aelitis.azureus.core.devices.impl.DeviceiTunesManager;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

public class DeviceManagerImpl
implements DeviceManager,
AEDiagnosticsEvidenceGenerator {
    private static final String LOGGER_NAME = "Devices";
    private static final String CONFIG_FILE = "devices.config";
    private static final String AUTO_SEARCH_CONFIG_KEY = "devices.config.auto_search";
    private static final String RSS_ENABLE_CONFIG_KEY = "devices.config.rss_enable";
    private static final String RSS_PORT_CONFIG_KEY = "devices.config.rss_port";
    private static final String RSS_LOCAL_ONLY_CONFIG_KEY = "devices.config.rss_local_only";
    private static final int RSS_PORT_CONFIG__DEFAULT = 6905;
    private static final String CONFIG_DEFAULT_WORK_DIR = "devices.config.def_work_dir";
    protected static final int DEVICE_UPDATE_PERIOD = 5000;
    private static DeviceManagerImpl singleton;
    private List<DeviceImpl> device_list = new ArrayList<DeviceImpl>();
    private Map<String, DeviceImpl> device_map = new HashMap<String, DeviceImpl>();
    private DeviceTivoManager tivo_manager;
    private DeviceManagerUPnPImpl upnp_manager;
    private DeviceDriveManager drive_manager;
    private static final int LT_DEVICE_ADDED = 1;
    private static final int LT_DEVICE_CHANGED = 2;
    private static final int LT_DEVICE_ATTENTION = 3;
    private static final int LT_DEVICE_REMOVED = 4;
    private static final int LT_INITIALIZED = 5;
    private ListenerManager<DeviceManagerListener> listeners = ListenerManager.createAsyncManager("DM:ld", new ListenerManagerDispatcher<DeviceManagerListener>(){

        @Override
        public void dispatch(DeviceManagerListener listener, int type, Object value) {
            Device device = (Device)value;
            switch (type) {
                case 1: {
                    listener.deviceAdded(device);
                    break;
                }
                case 2: {
                    listener.deviceChanged(device);
                    break;
                }
                case 3: {
                    listener.deviceAttentionRequest(device);
                    break;
                }
                case 4: {
                    listener.deviceRemoved(device);
                    break;
                }
                case 5: {
                    listener.deviceManagerLoaded();
                }
            }
        }
    });
    private boolean auto_search;
    private boolean rss_enable = false;
    private boolean rss_local_only = true;
    private int rss_port = 0;
    private DeviceManagerRSSFeed rss_publisher;
    private boolean closing;
    private boolean config_unclean;
    private boolean config_dirty;
    private int explicit_search;
    private TranscodeManagerImpl transcode_manager;
    private int getMimeType_fails;
    private AEDiagnosticsLogger logger;
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(10000);
    private volatile boolean initialized = false;

    public static void preInitialise() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceManager getSingleton() {
        Class<DeviceManagerImpl> clazz = DeviceManagerImpl.class;
        synchronized (DeviceManagerImpl.class) {
            if (singleton == null) {
                singleton = new DeviceManagerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected DeviceManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                DeviceManagerImpl.this.initWithCore(core);
            }
        });
    }

    private void initWithCore(final AzureusCore core) {
        COConfigurationManager.addAndFireParameterListeners(new String[]{AUTO_SEARCH_CONFIG_KEY}, new ParameterListener(){

            public void parameterChanged(String name) {
                DeviceManagerImpl.this.auto_search = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.AUTO_SEARCH_CONFIG_KEY, true);
            }
        });
        this.tivo_manager = new DeviceTivoManager(this);
        this.upnp_manager = new DeviceManagerUPnPImpl(this);
        this.loadConfig();
        new DeviceiTunesManager(this);
        this.drive_manager = new DeviceDriveManager(this);
        this.transcode_manager = new TranscodeManagerImpl(this);
        COConfigurationManager.addAndFireParameterListeners(new String[]{RSS_ENABLE_CONFIG_KEY, RSS_LOCAL_ONLY_CONFIG_KEY, RSS_PORT_CONFIG_KEY}, new ParameterListener(){

            public void parameterChanged(String name) {
                boolean new_rss_enable = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.RSS_ENABLE_CONFIG_KEY, false);
                int new_rss_port = COConfigurationManager.getIntParameter(DeviceManagerImpl.RSS_PORT_CONFIG_KEY, 6905);
                boolean new_rss_local = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.RSS_LOCAL_ONLY_CONFIG_KEY, true);
                if (new_rss_enable != DeviceManagerImpl.this.rss_enable || new_rss_port != DeviceManagerImpl.this.rss_port || DeviceManagerImpl.this.rss_local_only != new_rss_local) {
                    DeviceManagerImpl.this.rss_port = new_rss_port;
                    DeviceManagerImpl.this.rss_enable = new_rss_enable;
                    DeviceManagerImpl.this.rss_local_only = new_rss_local;
                    DeviceManagerImpl.this.manageRSS(core);
                }
            }
        });
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stopping(AzureusCore core) {
                DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                synchronized (deviceManagerImpl) {
                    DeviceImpl[] devices;
                    if (DeviceManagerImpl.this.config_dirty || DeviceManagerImpl.this.config_unclean) {
                        DeviceManagerImpl.this.saveConfig();
                    }
                    DeviceManagerImpl.this.closing = true;
                    DeviceManagerImpl.this.transcode_manager.close();
                    for (DeviceImpl device : devices = DeviceManagerImpl.this.getDevices()) {
                        device.close();
                    }
                }
            }
        });
        this.upnp_manager.initialise();
        SimpleTimer.addPeriodicEvent("DeviceManager:update", 5000L, new TimerEventPerformer(){
            private int tick_count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                ArrayList copy;
                ++this.tick_count;
                DeviceManagerImpl.this.transcode_manager.updateStatus(this.tick_count);
                DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                synchronized (deviceManagerImpl) {
                    if (DeviceManagerImpl.this.device_list.size() == 0) {
                        return;
                    }
                    copy = new ArrayList(DeviceManagerImpl.this.device_list);
                }
                for (DeviceImpl device : copy) {
                    device.updateStatus(this.tick_count);
                }
            }
        });
        this.initialized = true;
        this.listeners.dispatch(5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageRSS(final AzureusCore core) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            this.async_dispatcher.dispatch(new AERunnable(){
                final boolean f_enable;
                final int f_port;
                final boolean f_local;
                {
                    this.f_enable = DeviceManagerImpl.this.rss_enable;
                    this.f_port = DeviceManagerImpl.this.rss_port;
                    this.f_local = DeviceManagerImpl.this.rss_local_only;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (DeviceManagerImpl.this.rss_publisher != null) {
                            DeviceManagerImpl.this.rss_publisher.destroy();
                        }
                        if (this.f_enable) {
                            DeviceManagerImpl.this.rss_publisher = new DeviceManagerRSSFeed(DeviceManagerImpl.this, core, this.f_port, this.f_local);
                        }
                    }
                }
            });
        }
    }

    protected void UPnPManagerStarted() {
        this.tivo_manager.startUp();
    }

    protected DeviceManagerUPnPImpl getUPnPManager() {
        return this.upnp_manager;
    }

    public DeviceTemplate[] getDeviceTemplates(int device_type) {
        if (this.transcode_manager == null || device_type != 3) {
            return new DeviceTemplate[0];
        }
        TranscodeProvider[] providers = this.transcode_manager.getProviders();
        ArrayList<DeviceMediaRendererTemplateImpl> result = new ArrayList<DeviceMediaRendererTemplateImpl>();
        for (TranscodeProvider provider2 : providers) {
            TranscodeProfile[] profiles = provider2.getProfiles();
            HashMap<String, DeviceMediaRendererTemplateImpl> class_map = new HashMap<String, DeviceMediaRendererTemplateImpl>();
            for (TranscodeProfile profile : profiles) {
                String classification = profile.getDeviceClassification();
                if (classification.startsWith("apple.")) {
                    classification = "apple.";
                }
                boolean auto = classification.equals("sony.PS3") || classification.equals("microsoft.XBox") || classification.equals("apple.") || classification.equals("nintendo.Wii") || classification.equals("browser.generic");
                DeviceMediaRendererTemplateImpl temp = (DeviceMediaRendererTemplateImpl)class_map.get(classification);
                if (temp == null) {
                    temp = new DeviceMediaRendererTemplateImpl(this, classification, auto);
                    class_map.put(classification, temp);
                    result.add(temp);
                }
                temp.addProfile(profile);
            }
        }
        return result.toArray(new DeviceTemplate[result.size()]);
    }

    public DeviceManager.DeviceManufacturer[] getDeviceManufacturers(int device_type) {
        DeviceTemplate[] templates = this.getDeviceTemplates(device_type);
        HashMap<String, DeviceManufacturerImpl> map = new HashMap<String, DeviceManufacturerImpl>();
        for (DeviceTemplate template : templates) {
            if (template.getType() != device_type) continue;
            String man_str = template.getManufacturer();
            DeviceManufacturerImpl man = (DeviceManufacturerImpl)map.get(man_str);
            if (man == null) {
                man = new DeviceManufacturerImpl(man_str);
                map.put(man_str, man);
            }
            man.addTemplate(template);
        }
        return map.values().toArray(new DeviceManager.DeviceManufacturer[map.size()]);
    }

    protected Device createDevice(int device_type, String classification, String name) throws DeviceManagerException {
        if (device_type == 3) {
            DeviceMediaRendererManual res = new DeviceMediaRendererManual(this, classification, true, name);
            this.addDevice(res);
            return res;
        }
        throw new DeviceManagerException("Can't manually create this device type");
    }

    public void search(final int millis, final DeviceSearchListener listener) {
        new AEThread2("DM:search", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                synchronized (deviceManagerImpl) {
                    DeviceManagerImpl.this.explicit_search++;
                }
                DeviceManagerImpl.this.tivo_manager.search();
                DeviceManagerImpl.this.drive_manager.search();
                AESemaphore sem = new AESemaphore("DM:search");
                DeviceManagerListener dm_listener = new DeviceManagerListener(){

                    public void deviceAdded(Device device) {
                        listener.deviceFound(device);
                    }

                    public void deviceChanged(Device device) {
                    }

                    public void deviceAttentionRequest(Device device) {
                    }

                    public void deviceRemoved(Device device) {
                    }

                    public void deviceManagerLoaded() {
                    }
                };
                try {
                    DeviceManagerImpl.this.addListener(dm_listener);
                    DeviceManagerImpl.this.upnp_manager.search();
                    sem.reserve(millis);
                }
                finally {
                    DeviceManagerImpl deviceManagerImpl2 = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl2) {
                        DeviceManagerImpl.this.explicit_search--;
                    }
                    DeviceManagerImpl.this.removeListener(dm_listener);
                    listener.complete();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl getDevice(String id) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_map.get(id);
        }
    }

    protected DeviceImpl addDevice(DeviceImpl device) {
        return this.addDevice(device, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl addDevice(DeviceImpl device, boolean is_alive) {
        DeviceImpl existing = null;
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceMediaRenderer renderer;
            existing = this.device_map.get(device.getID());
            if (existing != null) {
                existing.updateFrom(device, is_alive);
            } else if (device.getType() == 3 && (renderer = (DeviceMediaRenderer)((Object)device)).getRendererSpecies() == 2 && !renderer.isManual()) {
                for (DeviceImpl d : this.device_list) {
                    DeviceMediaRenderer r;
                    if (d.getType() != 3 || (r = (DeviceMediaRenderer)((Object)d)).getRendererSpecies() != 2 || !r.isManual()) continue;
                    existing = d;
                    this.log("Merging " + device.getString() + " -> " + existing.getString());
                    String secondary_id = device.getID();
                    existing.setSecondaryID(secondary_id);
                    existing.updateFrom(device, is_alive);
                }
            }
            if (existing == null) {
                this.device_list.add(device);
                this.device_map.put(device.getID(), device);
            }
        }
        if (existing != null) {
            return existing;
        }
        device.initialise();
        if (is_alive) {
            device.alive();
        }
        this.deviceAdded(device);
        this.configDirty();
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(DeviceImpl device) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceImpl existing = this.device_map.remove(device.getID());
            if (existing == null) {
                return;
            }
            this.device_list.remove(device);
            String secondary_id = device.getSecondaryID();
            if (secondary_id != null) {
                this.device_map.remove(secondary_id);
            }
        }
        device.destroy();
        this.deviceRemoved(device);
        this.configDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        if (this.getTranscodeManager().getQueue().isTranscoding()) {
            return true;
        }
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            for (DeviceImpl device : this.device_list) {
                if (!device.isBusy()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceImpl[] getDevices() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_list.toArray(new DeviceImpl[this.device_list.size()]);
        }
    }

    public boolean getAutoSearch() {
        return this.auto_search;
    }

    public void setAutoSearch(boolean auto) {
        COConfigurationManager.setParameter(AUTO_SEARCH_CONFIG_KEY, auto);
    }

    public boolean isRSSPublishEnabled() {
        return this.rss_enable;
    }

    public void setRSSPublishEnabled(boolean enabled) {
        COConfigurationManager.setParameter(RSS_ENABLE_CONFIG_KEY, enabled);
    }

    public boolean isRSSLocalOnly() {
        return this.rss_local_only;
    }

    public void setRSSLocalOnly(boolean local_only) {
        COConfigurationManager.setParameter(RSS_LOCAL_ONLY_CONFIG_KEY, local_only);
    }

    public int getRSSPort() {
        return this.rss_port;
    }

    public void setRSSPort(int port) {
        COConfigurationManager.setParameter(RSS_PORT_CONFIG_KEY, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExplicitSearch() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.explicit_search > 0;
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_devices = (List)map.get("devices");
            if (l_devices != null) {
                for (int i = 0; i < l_devices.size(); ++i) {
                    Map m = (Map)l_devices.get(i);
                    try {
                        DeviceImpl device = DeviceImpl.importFromBEncodedMapStatic(this, m);
                        this.device_list.add(device);
                        this.device_map.put(device.getID(), device);
                        String secondary_id = device.getSecondaryID();
                        if (secondary_id != null) {
                            this.device_map.put(secondary_id, device);
                        }
                        device.initialise();
                        this.log("    loaded " + device.getString());
                        continue;
                    }
                    catch (Throwable e) {
                        this.log("Failed to import subscription from " + m, e);
                    }
                }
            }
        }
    }

    protected void configDirty(DeviceImpl device, boolean save_changes) {
        this.deviceChanged(device, save_changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (!DeviceManagerImpl.this.config_dirty) {
                            return;
                        }
                        DeviceManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.closing) {
                return;
            }
            this.config_dirty = false;
            this.config_unclean = false;
            if (this.device_list.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap map = new HashMap();
                ArrayList l_devices = new ArrayList();
                map.put("devices", l_devices);
                for (DeviceImpl device : this.device_list) {
                    try {
                        HashMap d = new HashMap();
                        device.exportToBEncodedMap(d);
                        l_devices.add(d);
                    }
                    catch (Throwable e) {
                        this.log("Failed to save device " + device.getString(), e);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
        }
    }

    protected void deviceAdded(DeviceImpl device) {
        this.configDirty();
        try {
            PlatformDevicesMessenger.qosFoundDevice(device);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        this.listeners.dispatch(1, device);
    }

    protected void deviceChanged(DeviceImpl device, boolean save_changes) {
        if (save_changes) {
            this.configDirty();
        } else {
            this.config_unclean = true;
        }
        this.listeners.dispatch(2, device);
    }

    protected void deviceRemoved(DeviceImpl device) {
        this.configDirty();
        this.listeners.dispatch(4, device);
    }

    protected void requestAttention(DeviceImpl device) {
        this.listeners.dispatch(3, device);
    }

    protected URL getStreamURL(TranscodeFileImpl file, String host) {
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc != null) {
            try {
                DiskManagerFileInfo f = file.getTargetFile();
                String str = (String)ipc.invoke("getContentURL", new Object[]{f});
                if (str != null && str.length() > 0) {
                    if (host != null) {
                        str = str.replace("127.0.0.1", host);
                    }
                    return new URL(str);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getMimeType(TranscodeFileImpl file) {
        if (this.getMimeType_fails > 5) {
            return null;
        }
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc != null) {
            try {
                DiskManagerFileInfo f = file.getTargetFile();
                String str = (String)ipc.invoke("getMimeType", new Object[]{f});
                if (str != null && str.length() > 0) {
                    return str;
                }
            }
            catch (Throwable e) {
                ++this.getMimeType_fails;
                e.printStackTrace();
            }
        }
        return null;
    }

    public File getDefaultWorkingDirectory() {
        return this.getDefaultWorkingDirectory(false);
    }

    public File getDefaultWorkingDirectory(boolean persist) {
        File f;
        String def = COConfigurationManager.getStringParameter(CONFIG_DEFAULT_WORK_DIR, "").trim();
        if (def.length() == 0) {
            String def_dir = COConfigurationManager.getStringParameter("Default save path");
            def = def_dir + File.separator + "transcodes";
        }
        if (!(f = new File(def)).exists() && persist) {
            f.mkdirs();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultWorkingDirectory(File dir) {
        File existing = this.getDefaultWorkingDirectory(false);
        if (!existing.getAbsolutePath().equals(dir.getAbsolutePath())) {
            DeviceManagerImpl deviceManagerImpl = this;
            synchronized (deviceManagerImpl) {
                for (DeviceImpl d : this.device_list) {
                    d.resetWorkingDirectory();
                }
            }
        }
        COConfigurationManager.setParameter(CONFIG_DEFAULT_WORK_DIR, dir.getAbsolutePath());
    }

    public TranscodeManagerImpl getTranscodeManager() {
        return this.transcode_manager;
    }

    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        return this.upnp_manager.getUnassociatedDevices();
    }

    public void addListener(DeviceManagerListener listener) {
        this.listeners.addListener(listener);
        if (this.initialized) {
            this.listeners.dispatch(listener, 5, null);
        }
    }

    public void removeListener(DeviceManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    protected synchronized AEDiagnosticsLogger getLogger() {
        if (this.logger == null) {
            this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
        }
        return this.logger;
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
        diag_logger.log(e);
    }

    public void log(String s) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println(LOGGER_NAME);
        try {
            DeviceImpl[] devices;
            writer.indent();
            for (DeviceImpl device : devices = this.getDevices()) {
                device.generate(writer);
            }
            if (this.transcode_manager != null) {
                this.transcode_manager.generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static class DeviceManufacturerImpl
    implements DeviceManager.DeviceManufacturer {
        private String name;
        private List<DeviceTemplate> templates = new ArrayList<DeviceTemplate>();

        protected DeviceManufacturerImpl(String _name) {
            this.name = _name;
        }

        protected void addTemplate(DeviceTemplate t) {
            this.templates.add(t);
        }

        public String getName() {
            return this.name;
        }

        public DeviceTemplate[] getDeviceTemplates() {
            return this.templates.toArray(new DeviceTemplate[this.templates.size()]);
        }
    }
}

