/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class DeviceManagerRSSFeed
implements TrackerWebPageGenerator {
    private DeviceManagerImpl manager;
    private int port;
    private PluginInterface plugin_interface;
    private TrackerWebContext context;

    protected DeviceManagerRSSFeed(DeviceManagerImpl _manager, AzureusCore _core, int _port, boolean _local_only) {
        this.manager = _manager;
        this.port = _port;
        this.plugin_interface = _core.getPluginManager().getDefaultPluginInterface();
        try {
            this.context = _local_only ? this.plugin_interface.getTracker().createWebContext("DeviceFeed", _port, 1, InetAddress.getByName("127.0.0.1")) : this.plugin_interface.getTracker().createWebContext("DeviceFeed", _port, 1);
            this.context.addPageGenerator(this);
            this.manager.log("RSS feed initialised on port " + _port);
        }
        catch (Throwable e) {
            this.manager.log("Failed to initialise RSS feed on port " + _port, e);
        }
    }

    protected void destroy() {
        if (this.context != null) {
            this.context.destroy();
        }
    }

    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        InetSocketAddress local_address = request2.getLocalAddress();
        if (local_address == null) {
            return false;
        }
        String host = local_address.getAddress().getHostAddress();
        String feed_url = "http://" + host + ":" + this.port + request2.getURL();
        URL url = request2.getAbsoluteURL();
        String path = url.getPath();
        DeviceImpl[] devices = this.manager.getDevices();
        OutputStream os = response.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
        if (path.length() <= 1) {
            response.setContentType("text/html; charset=UTF-8");
            pw.println("<HTML><HEAD><TITLE>Vuze device feeds</TITLE></HEAD><BODY>");
            for (DeviceImpl d : devices) {
                if (d.getType() != 3 || d.isHidden() || !d.isRSSPublishEnabled()) continue;
                String name = d.getName();
                pw.println("<UL><A href=\"/" + URLEncoder.encode(name, "UTF-8") + "\">" + name + "</A></UL>");
            }
            pw.println("</BODY></HTML>");
        } else {
            String device_name = URLDecoder.decode(path.substring(1), "UTF-8");
            DeviceImpl device = null;
            for (DeviceImpl d : devices) {
                if (!d.getName().equals(device_name) || !d.isRSSPublishEnabled()) continue;
                device = d;
                break;
            }
            if (device == null) {
                response.setReplyStatus(404);
                return true;
            }
            if (device instanceof DeviceMediaRendererImpl) {
                ((DeviceMediaRendererImpl)device).browseReceived();
            }
            response.setContentType("application/xml");
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\">");
            pw.println("<channel>");
            String channel_title = "Vuze: " + this.escape(device.getName());
            pw.println("<title>" + channel_title + "</title>");
            pw.println("<link>http://vuze.com</link>");
            pw.println("<atom:link href=\"" + feed_url + "\" rel=\"self\" type=\"application/rss+xml\" />");
            pw.println("<description>Vuze RSS Feed for " + this.escape(device.getName()) + "</description>");
            pw.println("<itunes:image href=\"http://www.vuze.com/img/vuze_icon_128.png\"/>");
            pw.println("<image><url>http://www.vuze.com/img/vuze_icon_128.png</url><title>" + channel_title + "</title><link>http://vuze.com</link></image>");
            TranscodeFileImpl[] _files = device.getFiles();
            ArrayList<TranscodeFileImpl> files = new ArrayList<TranscodeFileImpl>(_files.length);
            files.addAll(Arrays.asList(_files));
            Collections.sort(files, new Comparator<TranscodeFileImpl>(){

                @Override
                public int compare(TranscodeFileImpl f1, TranscodeFileImpl f2) {
                    long added1 = f1.getCreationDateMillis() / 1000L;
                    long added2 = f2.getCreationDateMillis() / 1000L;
                    return (int)(added2 - added1);
                }
            });
            String feed_date_key = "devices.feed_date." + device.getID();
            long feed_date = COConfigurationManager.getLongParameter(feed_date_key);
            boolean new_date = false;
            for (TranscodeFileImpl file : files) {
                long file_date = file.getCreationDateMillis();
                if (file_date <= feed_date) continue;
                new_date = true;
                feed_date = file_date;
            }
            if (new_date) {
                COConfigurationManager.setParameter(feed_date_key, feed_date);
            }
            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(feed_date) + "</pubDate>");
            for (TranscodeFileImpl file : files) {
                if (!file.isComplete() && !file.isTemplate()) continue;
                try {
                    String[] categories;
                    pw.println("<item>");
                    pw.println("<title>" + this.escape(file.getName()) + "</title>");
                    pw.println("<pubDate>" + TimeFormatter.getHTTPDate(file.getCreationDateMillis()) + "</pubDate>");
                    pw.println("<guid isPermaLink=\"false\">" + this.escape(file.getKey()) + "</guid>");
                    for (String category : categories = file.getCategories()) {
                        pw.println("<category>" + category + "</category>");
                    }
                    String mediaContent = "";
                    URL stream_url = file.getStreamURL(host);
                    if (stream_url != null) {
                        String url_ext = stream_url.toExternalForm();
                        long fileSize = file.getTargetFile().getLength();
                        pw.println("<link>" + url_ext + "</link>");
                        mediaContent = "<media:content medium=\"video\" fileSize=\"" + fileSize + "\" url=\"" + url_ext + "\"";
                        String mime_type = file.getMimeType();
                        if (mime_type != null) {
                            mediaContent = mediaContent + " type=\"" + mime_type + "\"";
                        }
                        pw.println("<enclosure url=\"" + url_ext + "\" length=\"" + fileSize + (mime_type == null ? "" : "\" type=\"" + mime_type) + "\"></enclosure>");
                    }
                    String thumb_url = null;
                    String author = null;
                    String description = null;
                    try {
                        Torrent torrent = file.getSourceFile().getDownload().getTorrent();
                        TOTorrent toTorrent = PluginCoreUtils.unwrap(torrent);
                        long duration_secs = PlatformTorrentUtils.getContentVideoRunningTime(toTorrent);
                        if (mediaContent.length() > 0 && duration_secs > 0L) {
                            mediaContent = mediaContent + " duration=\"" + duration_secs + "\"";
                        }
                        thumb_url = PlatformTorrentUtils.getContentThumbnailUrl(toTorrent);
                        author = PlatformTorrentUtils.getContentAuthor(toTorrent);
                        description = PlatformTorrentUtils.getContentDescription(toTorrent);
                        if (description != null) {
                            description = this.escapeMultiline(description);
                            pw.println("<description>" + description + "</description>");
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (mediaContent.length() > 0) {
                        mediaContent = mediaContent + "></media:content>";
                        pw.println(mediaContent);
                    }
                    pw.println("<media:title>" + this.escape(file.getName()) + "</media:title>");
                    if (description != null) {
                        pw.println("<media:description>" + description + "</media:description>");
                    }
                    if (thumb_url != null) {
                        pw.println("<media:thumbnail url=\"" + thumb_url + "\"/>");
                    }
                    if (thumb_url != null) {
                        pw.println("<itunes:image href=\"" + thumb_url + "\"/>");
                    }
                    if (author != null) {
                        pw.println("<itunes:author>" + this.escape(author) + "</itunees:author>");
                    }
                    pw.println("<itunes:summary>" + this.escape(file.getName()) + "</itunes:summary>");
                    pw.println("<itunes:duration>" + TimeFormatter.formatColon(file.getDurationMillis() / 1000L) + "</itunes:duration>");
                    pw.println("</item>");
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            pw.println("</channel>");
            pw.println("</rss>");
        }
        pw.flush();
        return true;
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    protected String escapeMultiline(String str) {
        return XUXmlWriter.escapeXML(str.replaceAll("[\r\n]+", "<BR>"));
    }
}

