/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.content.AzureusContentFilter;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.impl.DeviceContentDirectoryImpl;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceInternetGatewayImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.core.util.UUIDGenerator;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ipc.IPCInterfaceImpl;

public class DeviceManagerUPnPImpl {
    private static final Object KEY_LISTENER_ADDED = new Object();
    private DeviceManagerImpl manager;
    private PluginInterface plugin_interface;
    private UPnP upnp;
    private TorrentAttribute ta_category;
    private volatile IPCInterface upnpav_ipc;
    private Map<InetAddress, String> unassociated_devices = new HashMap<InetAddress, String>();

    protected DeviceManagerUPnPImpl(DeviceManagerImpl _manager) {
        this.manager = _manager;
    }

    protected void initialise() {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                new AEThread2("DMUPnPAsyncStart", true){

                    public void run() {
                        DeviceManagerUPnPImpl.this.startUp();
                    }
                }.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    protected DeviceManagerImpl getManager() {
        return this.manager;
    }

    protected TorrentAttribute getCategoryAttibute() {
        return this.ta_category;
    }

    protected void startUp() {
        UPnPAdapter adapter = new UPnPAdapter(){

            public SimpleXMLParserDocument parseXML(String data) throws SimpleXMLParserDocumentException {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data);
            }

            public ResourceDownloaderFactory getResourceDownloaderFactory() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            }

            public UTTimer createTimer(String name) {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().createTimer(name);
            }

            public void createThread(String name, Runnable runnable) {
                DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().createThread(name, runnable);
            }

            public Comparator getAlphanumericComparator() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
            }

            public void log(Throwable e) {
                Debug.printStackTrace(e);
            }

            public void trace(String str) {
            }

            public void log(String str) {
            }

            public String getTraceDir() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getPluginDirectoryName();
            }
        };
        try {
            this.upnp = UPnPFactory.getSingleton(adapter, null);
            this.upnp.addRootDeviceListener(new UPnPListener(){

                public boolean deviceDiscovered(String USN, URL location) {
                    return true;
                }

                public void rootDeviceFound(UPnPRootDevice device) {
                    DeviceManagerUPnPImpl.this.handleDevice(device, true);
                }
            });
        }
        catch (Throwable e) {
            this.manager.log("UPnP device manager failed", e);
        }
        try {
            this.plugin_interface.addEventListener(new PluginEventListener(){

                public void handleEvent(PluginEvent ev) {
                    PluginInterface pi;
                    int type = ev.getType();
                    if ((type == 8 || type == 9) && (pi = (PluginInterface)ev.getValue()).getPluginID().equals("azupnpav")) {
                        if (type == 8) {
                            DeviceManagerUPnPImpl.this.upnpav_ipc = pi.getIPC();
                            DeviceManagerUPnPImpl.this.addListener(pi);
                        } else {
                            DeviceManagerUPnPImpl.this.upnpav_ipc = null;
                        }
                    }
                }
            });
            PluginInterface pi = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
            if (pi == null) {
                this.manager.log("No UPnPAV plugin found");
            } else {
                this.upnpav_ipc = pi.getIPC();
                this.addListener(pi);
            }
        }
        catch (Throwable e) {
            this.manager.log("Failed to hook into UPnPAV", e);
        }
        this.manager.UPnPManagerStarted();
    }

    protected void addListener(PluginInterface pi) {
        try {
            IPCInterfaceImpl my_ipc = new IPCInterfaceImpl(new Object(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Map<String, Object> browseReceived(TrackerWebPageRequest request2, Map<String, Object> browser_args) {
                    String source;
                    String lc_info;
                    Map headers = request2.getHeaders();
                    String user_agent = (String)headers.get("user-agent");
                    String client_info = (String)headers.get("x-av-client-info");
                    InetSocketAddress client_address = request2.getClientAddress2();
                    boolean handled = false;
                    if (user_agent != null) {
                        String lc_agent = user_agent.toLowerCase();
                        if (lc_agent.contains("playstation 3")) {
                            DeviceManagerUPnPImpl.this.handlePS3(client_address);
                            handled = true;
                        } else if (lc_agent.contains("xbox")) {
                            DeviceManagerUPnPImpl.this.handleXBox(client_address);
                            handled = true;
                        } else if (lc_agent.contains("nintendo wii")) {
                            DeviceManagerUPnPImpl.this.handleWii(client_address);
                            handled = true;
                        }
                    }
                    if (client_info != null && (lc_info = client_info.toLowerCase()).contains("playstation 3")) {
                        DeviceManagerUPnPImpl.this.handlePS3(client_address);
                        handled = true;
                    }
                    if (!handled && (source = (String)browser_args.get("source")) != null && source.equalsIgnoreCase("http")) {
                        DeviceManagerUPnPImpl.this.handleBrowser(client_address);
                        handled = true;
                    }
                    DeviceImpl[] devices = DeviceManagerUPnPImpl.this.manager.getDevices();
                    final ArrayList<DeviceMediaRendererImpl> browse_devices = new ArrayList<DeviceMediaRendererImpl>();
                    for (DeviceImpl device : devices) {
                        if (!(device instanceof DeviceMediaRendererImpl)) continue;
                        DeviceMediaRendererImpl renderer = (DeviceMediaRendererImpl)device;
                        InetAddress device_address = renderer.getAddress();
                        try {
                            if (device_address == null || !device_address.equals(client_address.getAddress()) || !renderer.canFilterFilesView()) continue;
                            browse_devices.add(renderer);
                            renderer.browseReceived();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    if (browse_devices.size() > 0) {
                        Map map = DeviceManagerUPnPImpl.this.unassociated_devices;
                        synchronized (map) {
                            DeviceManagerUPnPImpl.this.unassociated_devices.remove(client_address.getAddress());
                        }
                        result.put("filter", new AzureusContentFilter(){

                            @Override
                            public boolean isVisible(AzureusContentDownload download, Map<String, Object> browse_args) {
                                boolean visible = false;
                                for (DeviceMediaRendererImpl device : browse_devices) {
                                    if (!device.isVisible(download)) continue;
                                    visible = true;
                                }
                                return visible;
                            }

                            @Override
                            public boolean isVisible(AzureusContentFile file, Map<String, Object> browse_args) {
                                boolean visible = false;
                                for (DeviceMediaRendererImpl device : browse_devices) {
                                    if (!device.isVisible(file)) continue;
                                    visible = true;
                                }
                                return visible;
                            }
                        });
                    } else if (request2.getHeader().substring(0, 4).equalsIgnoreCase("POST")) {
                        Map map = DeviceManagerUPnPImpl.this.unassociated_devices;
                        synchronized (map) {
                            DeviceManagerUPnPImpl.this.unassociated_devices.put(client_address.getAddress(), user_agent);
                        }
                    }
                    return result;
                }
            });
            if (this.upnpav_ipc.canInvoke("addBrowseListener", new Object[]{my_ipc})) {
                DeviceImpl[] devices;
                this.upnpav_ipc.invoke("addBrowseListener", new Object[]{my_ipc});
                for (DeviceImpl device : devices = this.manager.getDevices()) {
                    if (!(device instanceof DeviceUPnPImpl)) continue;
                    DeviceUPnPImpl u_d = (DeviceUPnPImpl)device;
                    u_d.resetUPNPAV();
                }
            } else {
                this.manager.log("UPnPAV plugin needs upgrading");
            }
        }
        catch (Throwable e) {
            this.manager.log("Failed to hook into UPnPAV", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        HashMap<InetAddress, String> ud;
        ArrayList<6> result = new ArrayList<6>();
        Map<InetAddress, String> map = this.unassociated_devices;
        synchronized (map) {
            ud = new HashMap<InetAddress, String>(this.unassociated_devices);
        }
        DeviceImpl[] devices = this.manager.getDevices();
        for (final Map.Entry entry : ud.entrySet()) {
            InetAddress address = (InetAddress)entry.getKey();
            boolean already_assoc = false;
            for (DeviceImpl d : devices) {
                if (!(d instanceof DeviceMediaRendererImpl)) continue;
                DeviceMediaRendererImpl r = (DeviceMediaRendererImpl)d;
                if (!d.isAlive() || !r.getAddress().equals(address)) continue;
                already_assoc = true;
                break;
            }
            if (already_assoc) continue;
            result.add(new DeviceManager.UnassociatedDevice(){

                public InetAddress getAddress() {
                    return (InetAddress)entry.getKey();
                }

                public String getDescription() {
                    return (String)entry.getValue();
                }
            });
        }
        return result.toArray(new DeviceManager.UnassociatedDevice[result.size()]);
    }

    protected IPCInterface getUPnPAVIPC() {
        return this.upnpav_ipc;
    }

    public void search() {
        if (this.upnp != null) {
            UPnPRootDevice[] devices;
            for (UPnPRootDevice device : devices = this.upnp.getRootDevices()) {
                this.handleDevice(device, false);
            }
            String[] STs = new String[]{"upnp:rootdevice", "urn:schemas-upnp-org:device:MediaRenderer:1"};
            this.upnp.search(STs);
        }
    }

    protected void handleXBox(InetSocketAddress address) {
        DeviceImpl[] devices = this.manager.getDevices();
        boolean found = false;
        for (DeviceImpl device : devices) {
            if (!(device instanceof DeviceMediaRendererImpl)) continue;
            DeviceMediaRendererImpl renderer = (DeviceMediaRendererImpl)device;
            if (device.getRendererSpecies() != 2) continue;
            found = true;
            if (device.isAlive()) continue;
            renderer.setAddress(address.getAddress());
            device.alive();
        }
        if (!found) {
            this.manager.addDevice(new DeviceMediaRendererImpl(this.manager, "Xbox 360"));
        }
    }

    protected void handlePS3(InetSocketAddress address) {
        this.handleGeneric(address, "ps3", "PS3");
    }

    protected void handleWii(InetSocketAddress address) {
        this.handleGeneric(address, "wii", "Wii");
    }

    protected void handleBrowser(InetSocketAddress address) {
        this.handleGeneric(address, "browser", "Browser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGeneric(InetSocketAddress address, String unique_name, String display_name) {
        String uid;
        DeviceManagerUPnPImpl deviceManagerUPnPImpl = this;
        synchronized (deviceManagerUPnPImpl) {
            uid = COConfigurationManager.getStringParameter("devices.upnp.uid." + unique_name, "");
            if (uid.length() == 0) {
                uid = UUIDGenerator.generateUUIDString();
                COConfigurationManager.setParameter("devices.upnp.uid." + unique_name, uid);
            }
        }
        DeviceMediaRendererImpl device = new DeviceMediaRendererImpl(this.manager, uid, display_name, false);
        device = (DeviceMediaRendererImpl)this.manager.addDevice(device);
        device.setAddress(address.getAddress());
        device.alive();
    }

    protected void handleDevice(UPnPRootDevice root_device, boolean update_if_found) {
        if (!this.manager.getAutoSearch() && !this.manager.isExplicitSearch()) {
            return;
        }
        this.handleDevice(root_device.getDevice(), update_if_found);
    }

    protected void handleDevice(UPnPDevice device, boolean update_if_found) {
        UPnPService[] services = device.getServices();
        ArrayList<DeviceUPnPImpl> new_devices = new ArrayList<DeviceUPnPImpl>();
        ArrayList<UPnPWANConnection> igd_services = new ArrayList<UPnPWANConnection>();
        for (UPnPService service : services) {
            String service_type = service.getServiceType();
            if (service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1") || service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
                UPnPWANConnection wan_service = (UPnPWANConnection)service.getSpecificService();
                igd_services.add(wan_service);
                continue;
            }
            if (!service_type.equals("urn:schemas-upnp-org:service:ContentDirectory:1")) continue;
            new_devices.add(new DeviceContentDirectoryImpl(this.manager, device, service));
        }
        if (igd_services.size() > 0) {
            new_devices.add(new DeviceInternetGatewayImpl(this.manager, device, igd_services));
        }
        if (device.getDeviceType().equals("urn:schemas-upnp-org:device:MediaRenderer:1")) {
            new_devices.add(new DeviceMediaRendererImpl(this.manager, device));
        }
        for (DeviceUPnPImpl new_device : new_devices) {
            DeviceImpl actual_device;
            if (!update_if_found && this.manager.getDevice(new_device.getID()) != null || (actual_device = this.manager.addDevice(new_device)).getTransientProperty(KEY_LISTENER_ADDED) != null) continue;
            actual_device.setTransientProperty(KEY_LISTENER_ADDED, "");
            device.getRootDevice().addListener(new UPnPRootDeviceListener(){

                public void lost(UPnPRootDevice root, boolean replaced) {
                    if (!replaced) {
                        actual_device.dead();
                    }
                }
            });
        }
        for (UPnPDevice d : device.getSubDevices()) {
            this.handleDevice(d, update_if_found);
        }
    }
}

