/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceMediaRendererTemplate;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class DeviceMediaRendererTemplateImpl
implements DeviceMediaRendererTemplate {
    private List<TranscodeProfile> profiles = new ArrayList<TranscodeProfile>();
    private final DeviceManagerImpl manager;
    private final String classification;
    private final String name;
    private final String manufacturer;
    private final boolean auto;

    protected DeviceMediaRendererTemplateImpl(DeviceManagerImpl _manager, String _classification, boolean _auto) {
        this.manager = _manager;
        this.classification = _classification;
        this.auto = _auto;
        int pos = this.classification.indexOf(46);
        this.manufacturer = pos == -1 ? this.classification : this.classification.substring(0, pos);
        pos = this.classification.lastIndexOf(46);
        this.name = pos == -1 ? this.classification : this.classification.substring(pos + 1);
    }

    protected void addProfile(TranscodeProfile profile) {
        this.profiles.add(profile);
    }

    public TranscodeProfile[] getProfiles() {
        return this.profiles.toArray(new TranscodeProfile[this.profiles.size()]);
    }

    public int getType() {
        return 3;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getClassification() {
        return this.classification;
    }

    public String getShortDescription() {
        return null;
    }

    public int getRendererSpecies() {
        return 6;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public Device createInstance(String name) throws DeviceManagerException {
        if (this.auto) {
            throw new DeviceManagerException("Device can't be added manually");
        }
        Device res = this.manager.createDevice(3, this.classification, name);
        return res;
    }
}

