/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivoManager;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTivo
extends DeviceMediaRendererImpl {
    private static final boolean TRACE = false;
    private static final String NL = "\r\n";
    private static Map<String, Comparator<ItemInfo>> sort_comparators = new HashMap<String, Comparator<ItemInfo>>();
    private String server_name;
    private boolean tried_tcp_beacon;

    protected DeviceTivo(DeviceManagerImpl _manager, String _uid, String _classification) {
        super(_manager, _uid, _classification, false);
        this.setName("TiVo");
    }

    protected DeviceTivo(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceTivo)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceTivo other = (DeviceTivo)_other;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    @Override
    public boolean canFilterFilesView() {
        return false;
    }

    @Override
    public boolean canAssociate() {
        return true;
    }

    @Override
    public boolean canShowCategories() {
        return true;
    }

    @Override
    protected boolean getShowCategoriesDefault() {
        return true;
    }

    protected String getMachineName() {
        return this.getPersistentStringProperty("tivo_machine", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void found(DeviceTivoManager _tivo_manager, InetAddress _address, String _server_name, String _machine) {
        String existing;
        boolean first_time = false;
        DeviceTivo deviceTivo = this;
        synchronized (deviceTivo) {
            if (this.server_name == null) {
                this.server_name = _server_name;
                first_time = true;
            }
        }
        if (_machine == null && !this.tried_tcp_beacon) {
            try {
                Socket socket = new Socket();
                try {
                    socket.connect(new InetSocketAddress(_address, 2190), 5000);
                    socket.setSoTimeout(5000);
                    DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
                    byte[] beacon_out = _tivo_manager.encodeBeacon(false, 0);
                    dos.writeInt(beacon_out.length);
                    dos.write(beacon_out);
                    DataInputStream dis = new DataInputStream(socket.getInputStream());
                    int len = dis.readInt();
                    if (len < 65536) {
                        int read;
                        byte[] bytes = new byte[len];
                        for (int pos = 0; pos < len; pos += read) {
                            read = dis.read(bytes, pos, len - pos);
                        }
                        Map<String, String> beacon_in = _tivo_manager.decodeBeacon(bytes, len);
                        _machine = beacon_in.get("machine");
                    }
                }
                finally {
                    socket.close();
                }
            }
            catch (Throwable e) {
            }
            finally {
                this.tried_tcp_beacon = true;
            }
        }
        if (!(_machine == null || (existing = this.getMachineName()) != null && existing.equals(_machine))) {
            this.setPersistentStringProperty("tivo_machine", _machine);
        }
        this.setAddress(_address);
        this.alive();
        if (first_time) {
            this.browseReceived();
        }
    }

    protected boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String source_format;
        InetSocketAddress local_address = request2.getLocalAddress();
        if (local_address == null) {
            return false;
        }
        String host = local_address.getAddress().getHostAddress();
        String url = request2.getURL();
        if (!url.startsWith("/TiVoConnect?")) {
            return false;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return false;
        }
        String[] bits = url.substring(pos + 1).split("&");
        HashMap<String, String> args = new HashMap<String, String>();
        for (String bit : bits) {
            String[] x = bit.split("=");
            args.put(x[0], URLDecoder.decode(x[1], "UTF-8"));
        }
        String command = (String)args.get("Command");
        if (command == null) {
            return false;
        }
        String reply = null;
        if (command.equals("QueryContainer")) {
            String container = (String)args.get("Container");
            if (container == null) {
                return false;
            }
            if (container.equals("/")) {
                reply = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<TiVoContainer>\r\n    <Details>\r\n        <Title>" + this.server_name + "</Title>" + NL + "        <ContentType>x-container/tivo-server</ContentType>" + NL + "        <SourceFormat>x-container/folder</SourceFormat>" + NL + "        <TotalItems>1</TotalItems>" + NL + "    </Details>" + NL + "    <Item>" + NL + "        <Details>" + NL + "            <Title>" + this.server_name + "</Title>" + NL + "            <ContentType>x-container/tivo-videos</ContentType>" + NL + "            <SourceFormat>x-container/folder</SourceFormat>" + NL + "        </Details>" + NL + "        <Links>" + NL + "            <Content>" + NL + "                <Url>/TiVoConnect?Command=QueryContainer&amp;Container=" + DeviceTivo.urlencode("/Content") + "</Url>" + NL + "                <ContentType>x-container/tivo-videos</ContentType>" + NL + "            </Content>" + NL + "        </Links>" + NL + "    </Item>" + NL + "    <ItemStart>0</ItemStart>" + NL + "    <ItemCount>1</ItemCount>" + NL + "</TiVoContainer>";
            } else if (container.startsWith("/Content")) {
                String header;
                String machine;
                int num_to_return;
                int end_index;
                int start_index;
                boolean show_categories = this.getShowCategories();
                String recurse = (String)args.get("Recurse");
                if (recurse != null && recurse.equals("Yes")) {
                    show_categories = false;
                }
                TranscodeFileImpl[] tfs = this.getFiles();
                String category = null;
                HashMap<String, ContainerInfo> categories = null;
                if (show_categories) {
                    if (container.startsWith("/Content/")) {
                        category = container.substring(container.lastIndexOf(47) + 1);
                    } else {
                        categories = new HashMap<String, ContainerInfo>();
                    }
                }
                ArrayList<ItemInfo> items = new ArrayList<ItemInfo>(tfs.length);
                for (TranscodeFileImpl file : tfs) {
                    String[] cats;
                    FileInfo info;
                    if (!file.isComplete() && !this.setupStreamXCode(file)) continue;
                    if (category != null) {
                        String[] cats2;
                        boolean hit = false;
                        for (String c : cats2 = file.getCategories()) {
                            if (!c.equals(category)) continue;
                            hit = true;
                        }
                        if (!hit) continue;
                    }
                    if (!(info = new FileInfo(file, host)).isOK()) continue;
                    boolean skip = false;
                    if (categories != null && (cats = file.getCategories()).length > 0) {
                        skip = true;
                        for (String s : cats) {
                            ContainerInfo cont = (ContainerInfo)categories.get(s);
                            if (cont == null) {
                                cont = new ContainerInfo(s);
                                items.add(cont);
                                categories.put(s, cont);
                            }
                            cont.addChild();
                        }
                    }
                    if (skip) continue;
                    items.add(info);
                }
                String sort_order = (String)args.get("SortOrder");
                if (sort_order != null) {
                    String[] keys = sort_order.split(",");
                    final ArrayList<Comparator<ItemInfo>> comparators = new ArrayList<Comparator<ItemInfo>>();
                    final ArrayList<Boolean> reverses = new ArrayList<Boolean>();
                    for (String key : keys) {
                        Comparator<ItemInfo> comp2;
                        boolean reverse = false;
                        if (key.startsWith("!")) {
                            reverse = true;
                            key = key.substring(1);
                        }
                        if ((comp2 = sort_comparators.get(key)) == null) continue;
                        comparators.add(comp2);
                        reverses.add(reverse);
                    }
                    if (comparators.size() > 0) {
                        Collections.sort(items, new Comparator<ItemInfo>(){

                            @Override
                            public int compare(ItemInfo i1, ItemInfo i2) {
                                for (int i = 0; i < comparators.size(); ++i) {
                                    Comparator comp2 = (Comparator)comparators.get(i);
                                    int res = comp2.compare(i1, i2);
                                    if (res == 0) continue;
                                    if (((Boolean)reverses.get(i)).booleanValue()) {
                                        res = -res;
                                    }
                                    return res;
                                }
                                return 0;
                            }
                        });
                    }
                }
                String item_count = (String)args.get("ItemCount");
                String anchor_offset = (String)args.get("AnchorOffset");
                String anchor = (String)args.get("AnchorItem");
                int num_items = item_count == null ? items.size() : Integer.parseInt(item_count);
                int anchor_index = num_items < 0 ? items.size() : -1;
                if (anchor != null) {
                    for (int i = 0; i < items.size(); ++i) {
                        ItemInfo info = (ItemInfo)items.get(i);
                        if (!anchor.equals(info.getLinkURL())) continue;
                        anchor_index = i;
                    }
                }
                if (anchor_offset != null) {
                    if ((anchor_index += Integer.parseInt(anchor_offset)) < -1) {
                        anchor_index = -1;
                    } else if (anchor_index > items.size()) {
                        anchor_index = items.size();
                    }
                }
                if (num_items > 0) {
                    start_index = anchor_index + 1;
                    end_index = anchor_index + num_items;
                } else {
                    start_index = anchor_index + num_items;
                    end_index = anchor_index - 1;
                }
                if (start_index < 0) {
                    start_index = 0;
                }
                if (end_index >= items.size()) {
                    end_index = items.size() - 1;
                }
                if ((num_to_return = end_index - start_index + 1) < 0) {
                    num_to_return = 0;
                }
                if ((machine = this.getMachineName()) == null) {
                    machine = "TivoHDDVR";
                }
                reply = header = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<TiVoContainer>\r\n    <Tivos>\r\n      <Tivo>" + machine + "</Tivo>" + NL + "    </Tivos>" + NL + "    <ItemStart>" + start_index + "</ItemStart>" + NL + "    <ItemCount>" + num_to_return + "</ItemCount>" + NL + "    <Details>" + NL + "        <Title>" + DeviceTivo.escape(container) + "</Title>" + NL + "        <ContentType>x-container/tivo-videos</ContentType>" + NL + "        <SourceFormat>x-container/folder</SourceFormat>" + NL + "        <TotalItems>" + items.size() + "</TotalItems>" + NL + "    </Details>" + NL;
                for (int i = start_index; i <= end_index; ++i) {
                    ItemInfo item = (ItemInfo)items.get(i);
                    if (item instanceof FileInfo) {
                        FileInfo file = (FileInfo)item;
                        long file_size = file.getTargetSize();
                        reply = reply + "    <Item>\r\n        <Details>\r\n            <Title>" + DeviceTivo.escape(file.getName()) + "</Title>" + NL + "            <ContentType>video/x-tivo-mpeg</ContentType>" + NL + "            <SourceFormat>video/x-ms-wmv</SourceFormat>" + NL;
                        if (file_size > 0L) {
                            reply = reply + "            <SourceSize>" + file_size + "</SourceSize>" + NL;
                        } else {
                            long est_size = file.getEstimatedTargetSize();
                            if (est_size > 0L) {
                                reply = reply + "            <SourceSize>" + est_size + "</SourceSize>" + NL;
                            }
                        }
                        reply = reply + "            <Duration>" + file.getDurationMillis() + "</Duration>" + NL + "            <Description></Description>" + NL + "            <SourceChannel>0</SourceChannel>" + NL + "            <SourceStation></SourceStation>" + NL + "            <SeriesId></SeriesId>" + NL + "            <CaptureDate>" + file.getCaptureDate() + "</CaptureDate>" + NL + "        </Details>" + NL + "        <Links>" + NL + "            <Content>" + NL + "                <ContentType>video/x-tivo-mpeg</ContentType>" + NL + "                    <AcceptsParams>No</AcceptsParams>" + NL + "                    <Url>" + file.getLinkURL() + "</Url>" + NL + "                </Content>" + NL + "                <CustomIcon>" + NL + "                    <ContentType>video/*</ContentType>" + NL + "                    <AcceptsParams>No</AcceptsParams>" + NL + "                    <Url>urn:tivo:image:save-until-i-delete-recording</Url>" + NL + "                </CustomIcon>" + NL + "        </Links>" + NL + "    </Item>" + NL;
                        continue;
                    }
                    ContainerInfo cont = (ContainerInfo)item;
                    reply = reply + "    <Item>\r\n        <Details>\r\n            <Title>" + cont.getName() + "</Title>" + NL + "            <ContentType>x-container/tivo-videos</ContentType>" + NL + "            <SourceFormat>x-container/folder</SourceFormat>" + NL + "            <TotalItems>" + cont.getChildCount() + "</TotalItems>" + NL + "        </Details>" + NL + "        <Links>" + NL + "            <Content>" + NL + "                <Url>" + cont.getLinkURL() + "</Url>" + NL + "                <ContentType>x-container/tivo-videos</ContentType>" + NL + "            </Content>" + NL + "        </Links>" + NL + "    </Item>" + NL;
                }
                String footer = "</TiVoContainer>";
                reply = reply + footer;
            }
        } else if (command.equals("QueryFormats") && (source_format = (String)args.get("SourceFormat")) != null && source_format.startsWith("video")) {
            reply = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<TiVoFormats><Format>\r\n<ContentType>video/x-tivo-mpeg</ContentType><Description/>\r\n</Format></TiVoFormats>";
        }
        if (reply == null) {
            return false;
        }
        response.setContentType("text/xml");
        response.getOutputStream().write(reply.getBytes("UTF-8"));
        return true;
    }

    protected static String urlencode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Throwable e) {
            Debug.out(e);
            return str;
        }
    }

    protected static String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        this.addDP(dp, "devices.tivo.machine", this.getMachineName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            writer.println("tico_machine=" + this.getMachineName());
        }
        finally {
            writer.exdent();
        }
    }

    static {
        sort_comparators.put("Type", new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo o1, ItemInfo o2) {
                if (o1.isContainer() == o2.isContainer()) {
                    return 0;
                }
                if (o1.isContainer()) {
                    return -1;
                }
                return 1;
            }
        });
        sort_comparators.put("Title", new Comparator<ItemInfo>(){
            Comparator<String> c = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(ItemInfo o1, ItemInfo o2) {
                return this.c.compare(o1.getName(), o2.getName());
            }
        });
        sort_comparators.put("CreationDate", new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo o1, ItemInfo o2) {
                long res = o1.getCreationMillis() - o2.getCreationMillis();
                if (res < 0L) {
                    return -1;
                }
                if (res > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        sort_comparators.put("LastChangeDate", sort_comparators.get("CreationDate"));
        sort_comparators.put("CaptureDate", sort_comparators.get("CreationDate"));
    }

    protected static class ContainerInfo
    extends ItemInfo {
        private String name;
        private int child_count;

        protected ContainerInfo(String _name) {
            this.name = _name;
        }

        protected String getName() {
            return this.name;
        }

        protected String getLinkURL() {
            return "/TiVoConnect?Command=QueryContainer&amp;Container=" + DeviceTivo.urlencode("/Content/" + this.name);
        }

        protected void addChild() {
            ++this.child_count;
        }

        protected int getChildCount() {
            return this.child_count;
        }

        public long getCreationMillis() {
            return 0L;
        }

        protected boolean isContainer() {
            return true;
        }
    }

    protected static class FileInfo
    extends ItemInfo {
        private TranscodeFile file;
        private String stream_url;
        private long target_size;
        private long creation_millis;
        boolean ok;

        protected FileInfo(TranscodeFile _file, String _host) {
            this.file = _file;
            try {
                URL url = this.file.getStreamURL(_host);
                if (url == null) {
                    return;
                }
                this.stream_url = url.toExternalForm();
                try {
                    if (this.file.isComplete()) {
                        this.target_size = this.file.getTargetFile().getLength();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.creation_millis = this.file.getCreationDateMillis();
                this.ok = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected boolean isOK() {
            return this.ok;
        }

        protected String getName() {
            return this.file.getName();
        }

        protected String getLinkURL() {
            return this.stream_url;
        }

        protected long getTargetSize() {
            return this.target_size;
        }

        protected long getEstimatedTargetSize() {
            try {
                long duration_secs = this.getDurationMillis() / 1000L;
                if (duration_secs == 0L) {
                    long length = this.file.getSourceFile().getLength();
                    return length * 10L;
                }
                long mb_per_sec = 3L;
                return duration_secs * mb_per_sec * 1024L * 1024L;
            }
            catch (Throwable throwable) {
                return 0L;
            }
        }

        protected long getDurationMillis() {
            return this.file.getDurationMillis();
        }

        public long getCreationMillis() {
            return this.creation_millis;
        }

        protected String getCaptureDate() {
            return "0x" + Long.toString(this.creation_millis / 1000L, 16);
        }

        protected boolean isContainer() {
            return false;
        }
    }

    protected static abstract class ItemInfo {
        protected ItemInfo() {
        }

        protected abstract String getName();

        protected abstract String getLinkURL();

        protected abstract boolean isContainer();

        public abstract long getCreationMillis();
    }
}

