/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTivoManager {
    private static final String LF = "\n";
    private static final int CONTROL_PORT = 2190;
    private DeviceManagerImpl device_manager;
    private PluginInterface plugin_interface;
    private String uid;
    private String server_name = "Vuze";
    private Searcher current_search;
    private volatile boolean manager_destroyed;

    protected DeviceTivoManager(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
    }

    protected void startUp() {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.uid = COConfigurationManager.getStringParameter("devices.tivo.uid", null);
        if (this.uid == null) {
            byte[] bytes = new byte[8];
            RandomUtils.nextBytes(bytes);
            this.uid = Base32.encode(bytes);
            COConfigurationManager.setParameter("devices.tivo.uid", this.uid);
        }
        try {
            String cn = PlatformManagerFactory.getPlatformManager().getComputerName();
            if (cn != null && cn.length() > 0) {
                this.server_name = this.server_name + " on " + cn;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.server_name = (String)this.device_manager.getUPnPManager().getUPnPAVIPC().invoke("getServiceName", new Object[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        boolean found_tivo = false;
        for (DeviceImpl device : this.device_manager.getDevices()) {
            if (!(device instanceof DeviceTivo)) continue;
            found_tivo = true;
            break;
        }
        if (found_tivo || this.device_manager.getAutoSearch()) {
            this.search(found_tivo);
        }
    }

    protected void search() {
        this.search(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void search(boolean persistent) {
        try {
            DeviceTivoManager deviceTivoManager = this;
            synchronized (deviceTivoManager) {
                if (this.current_search == null) {
                    this.current_search = new Searcher(persistent);
                } else if (!this.current_search.wakeup()) {
                    this.current_search = new Searcher(persistent);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected byte[] encodeBeacon(boolean is_broadcast, int my_port) throws IOException {
        String beacon = "tivoconnect=1\nswversion=1\nmethod=" + (is_broadcast ? "broadcast" : "connected") + LF + "identity=" + this.uid + LF + "machine=" + this.server_name + LF + "platform=pc" + LF + "services=TiVoMediaServer:" + my_port + "/http";
        return beacon.getBytes("ISO-8859-1");
    }

    protected Map<String, String> decodeBeacon(byte[] buffer, int length) throws IOException {
        String str = new String(buffer, 0, length, "ISO-8859-1");
        String[] lines = str.split(LF);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.indexOf(61);
            if (pos <= 0) continue;
            map.put(line.substring(0, pos).trim().toLowerCase(), line.substring(pos + 1).trim());
        }
        return map;
    }

    protected boolean receiveBeacon(InetAddress sender, byte[] buffer, int length) {
        try {
            Map<String, String> map = this.decodeBeacon(buffer, length);
            String id = map.get("identity");
            if (id == null || id.equals(this.uid)) {
                return false;
            }
            String platform = map.get("platform");
            if (platform != null && platform.toLowerCase().startsWith("tcd/")) {
                String classification = "tivo." + platform.substring(4).toLowerCase();
                this.foundTiVo(sender, id, classification, map.get("machine"));
                return true;
            }
        }
        catch (Throwable e) {
            this.log("Failed to decode beacon", e);
        }
        return false;
    }

    protected DeviceTivo foundTiVo(InetAddress address, String uid, String classification, String machine) {
        DeviceImpl[] devices;
        uid = "tivo:" + uid;
        for (DeviceImpl device : devices = this.device_manager.getDevices()) {
            if (!(device instanceof DeviceTivo)) continue;
            DeviceTivo tivo = (DeviceTivo)device;
            if (!device.getID().equals(uid)) continue;
            tivo.found(this, address, this.server_name, machine);
            return tivo;
        }
        DeviceTivo new_device = new DeviceTivo(this.device_manager, uid, classification);
        DeviceTivo result = (DeviceTivo)this.device_manager.addDevice(new_device);
        if (result == new_device) {
            new_device.found(this, address, this.server_name, machine);
        }
        return result;
    }

    protected void log(String str) {
        if (this.device_manager == null) {
            System.out.println(str);
        } else {
            this.device_manager.log("TiVo: " + str);
        }
    }

    protected void log(String str, Throwable e) {
        if (this.device_manager == null) {
            System.out.println(str);
            e.printStackTrace();
        } else {
            this.device_manager.log("TiVo: " + str, e);
        }
    }

    protected class Searcher {
        private static final int LIFE_MILLIS = 10000;
        private long start = SystemTime.getMonotonousTime();
        private int tcp_port;
        private DatagramSocket control_socket;
        private TrackerWebContext twc;
        private TimerEventPeriodic timer_event;
        private volatile boolean persistent;
        private volatile boolean search_destroyed;

        protected Searcher(boolean _persistent) throws DeviceManagerException {
            try {
                int last_port = COConfigurationManager.getIntParameter("devices.tivo.net.tcp.port", 0);
                if (last_port > 0) {
                    try {
                        ServerSocket ss = new ServerSocket(last_port);
                        ss.setReuseAddress(true);
                        ss.close();
                    }
                    catch (Throwable e) {
                        last_port = 0;
                    }
                }
                this.twc = DeviceTivoManager.this.plugin_interface.getTracker().createWebContext(last_port, 1);
                this.tcp_port = this.twc.getURLs()[0].getPort();
                COConfigurationManager.setParameter("devices.tivo.net.tcp.port", this.tcp_port);
                this.twc.addPageGenerator(new TrackerWebPageGenerator(){

                    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                        String id = (String)request2.getHeaders().get("tsn");
                        if (id == null) {
                            id = (String)request2.getHeaders().get("tivo_tcd_id");
                        }
                        if (id != null) {
                            Searcher.this.persistent = true;
                            DeviceTivo tivo = DeviceTivoManager.this.foundTiVo(request2.getClientAddress2().getAddress(), id, "tivo.series3", null);
                            return tivo.generate(request2, response);
                        }
                        return false;
                    }
                });
                this.control_socket = new DatagramSocket(null);
                this.control_socket.setReuseAddress(true);
                try {
                    this.control_socket.setSoTimeout(60000);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.control_socket.bind(new InetSocketAddress((InetAddress)null, 2190));
                this.timer_event = SimpleTimer.addPeriodicEvent("Tivo:Beacon", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        if (!DeviceTivoManager.this.manager_destroyed && !Searcher.this.search_destroyed) {
                            Searcher.this.sendBeacon();
                        }
                        if (!Searcher.this.persistent) {
                            DeviceTivoManager deviceTivoManager = DeviceTivoManager.this;
                            synchronized (deviceTivoManager) {
                                if (SystemTime.getMonotonousTime() - Searcher.this.start >= 10000L) {
                                    DeviceTivoManager.this.log("Terminating search, no devices found");
                                    DeviceTivoManager.this.current_search = null;
                                    Searcher.this.destroy();
                                }
                            }
                        }
                    }
                });
                final AESemaphore start_sem = new AESemaphore("TiVo:CtrlListener");
                new AEThread2("TiVo:CtrlListener", true){

                    public void run() {
                        start_sem.release();
                        long successful_accepts = 0L;
                        long failed_accepts = 0L;
                        while (!DeviceTivoManager.this.manager_destroyed && !Searcher.this.search_destroyed) {
                            try {
                                byte[] buf = new byte[8192];
                                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                                Searcher.this.control_socket.receive(packet);
                                ++successful_accepts;
                                failed_accepts = 0L;
                                if (!DeviceTivoManager.this.receiveBeacon(packet.getAddress(), packet.getData(), packet.getLength())) continue;
                                Searcher.this.persistent = true;
                            }
                            catch (SocketTimeoutException e) {
                            }
                            catch (Throwable e) {
                                DeviceTivoManager.this.log("UDP receive on port 2190 failed", e);
                                if ((++failed_accepts <= 100L || successful_accepts != 0L) && failed_accepts <= 1000L) continue;
                                DeviceTivoManager.this.log("    too many failures, abandoning");
                                break;
                            }
                        }
                    }
                }.start();
                start_sem.reserve(5000L);
                this.sendBeacon();
                DeviceTivoManager.this.log("Initiated device search");
            }
            catch (Throwable e) {
                DeviceTivoManager.this.log("Failed to initialise search", e);
                this.destroy();
                throw new DeviceManagerException("Creation failed", e);
            }
        }

        protected void sendBeacon() {
            try {
                byte[] bytes = DeviceTivoManager.this.encodeBeacon(true, this.tcp_port);
                this.control_socket.send(new DatagramPacket(bytes, bytes.length, InetAddress.getByName("255.255.255.255"), 2190));
            }
            catch (Throwable e) {
                DeviceTivoManager.this.log("Failed to send beacon", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wakeup() {
            DeviceTivoManager deviceTivoManager = DeviceTivoManager.this;
            synchronized (deviceTivoManager) {
                if (this.search_destroyed) {
                    return false;
                }
                this.start = SystemTime.getMonotonousTime();
            }
            this.sendBeacon();
            return true;
        }

        protected void destroy() {
            this.search_destroyed = true;
            if (this.twc != null) {
                this.twc.destroy();
                this.twc = null;
            }
            if (this.timer_event != null) {
                this.timer_event.cancel();
                this.timer_event = null;
            }
            if (this.control_socket != null) {
                try {
                    this.control_socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.control_socket = null;
            }
        }
    }
}

