/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerUPnPImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobOutputLeecher;
import com.aelitis.azureus.core.download.DiskManagerFileInfoStream;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.UUIDGenerator;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeviceUPnPImpl
extends DeviceImpl
implements TranscodeTargetListener,
DownloadManagerListener {
    private static final Object UPNPAV_FILE_KEY = new Object();
    private static final Map<String, AzureusContentFile> acf_map = new WeakHashMap<String, AzureusContentFile>();
    private final String MY_ACF_KEY;
    private final DeviceManagerUPnPImpl upnp_manager;
    private volatile UPnPDevice device_may_be_null;
    private IPCInterface upnpav_ipc;
    private TranscodeProfile dynamic_transcode_profile;
    private Map<String, AzureusContentFile> dynamic_xcode_map;

    protected static String getDisplayName(UPnPDevice device) {
        String dn;
        UPnPDevice root = device.getRootDevice().getDevice();
        String fn = root.getFriendlyName();
        if (fn == null || fn.length() == 0) {
            fn = device.getFriendlyName();
        }
        if ((dn = root.getModelName()) == null || dn.length() == 0) {
            dn = device.getModelName();
        }
        if (!(dn == null || dn.length() <= 0 || fn.contains(dn) || dn.contains("Azureus") && !dn.contains("Vuze"))) {
            fn = fn + " (" + dn + ")";
        }
        return fn;
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, UPnPDevice _device, int _type) {
        super(_manager, _type, _type + "/" + _device.getRootDevice().getUSN(), DeviceUPnPImpl.getDisplayName(_device), false);
        this.upnp_manager = _manager.getUPnPManager();
        this.device_may_be_null = _device;
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, int _type, String _classification) {
        super(_manager, _type, UUIDGenerator.generateUUIDString(), _classification, true);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, int _type, String _classification, boolean _manual, String _name) {
        super(_manager, _type, UUIDGenerator.generateUUIDString(), _classification, _manual, _name);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, int _type, String _uuid, String _classification, boolean _manual) {
        super(_manager, _type, _uuid, _classification, _manual);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected String getACFKey() {
        return "DeviceUPnPImpl:device:" + this.getID();
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceUPnPImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceUPnPImpl other = (DeviceUPnPImpl)_other;
        this.device_may_be_null = other.device_may_be_null;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    protected UPnPDevice getUPnPDevice() {
        return this.device_may_be_null;
    }

    @Override
    public boolean isBrowsable() {
        return true;
    }

    @Override
    public Device.browseLocation[] getBrowseLocations() {
        ArrayList<DeviceImpl.browseLocationImpl> locs = new ArrayList<DeviceImpl.browseLocationImpl>();
        UPnPDevice device = this.device_may_be_null;
        if (device != null) {
            URL presentation = this.getPresentationURL(device);
            if (presentation != null) {
                locs.add(new DeviceImpl.browseLocationImpl("device.upnp.present_url", presentation));
            }
            locs.add(new DeviceImpl.browseLocationImpl("device.upnp.desc_url", device.getRootDevice().getLocation()));
        }
        return locs.toArray(new Device.browseLocation[locs.size()]);
    }

    public boolean canFilterFilesView() {
        return true;
    }

    public void setFilterFilesView(boolean filter) {
        boolean existing = this.getFilterFilesView();
        if (existing != filter) {
            this.setPersistentBooleanProperty("rend_filter", filter);
            IPCInterface ipc = this.upnpav_ipc;
            if (ipc != null) {
                try {
                    ipc.invoke("invalidateDirectory", new Object[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getFilterFilesView() {
        return this.getPersistentBooleanProperty("rend_filter", true);
    }

    @Override
    public boolean isLivenessDetectable() {
        return true;
    }

    protected URL getLocation() {
        UPnPDevice device = this.device_may_be_null;
        if (device != null) {
            UPnPRootDevice root = device.getRootDevice();
            return root.getLocation();
        }
        return null;
    }

    public boolean canAssociate() {
        return true;
    }

    public void associate(DeviceManager.UnassociatedDevice assoc) {
        if (this.isAlive()) {
            return;
        }
        this.setAddress(assoc.getAddress());
        this.alive();
    }

    public InetAddress getAddress() {
        try {
            UPnPDevice device = this.device_may_be_null;
            if (device != null) {
                UPnPRootDevice root = device.getRootDevice();
                URL location = root.getLocation();
                return InetAddress.getByName(location.getHost());
            }
            InetAddress address = (InetAddress)this.getTransientProperty("DeviceUPnPImpl:ip");
            if (address != null) {
                return address;
            }
            String last = this.getPersistentStringProperty("rend_ip");
            if (last != null && last.length() > 0) {
                return InetAddress.getByName(last);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    protected void setAddress(InetAddress address) {
        this.setTransientProperty("DeviceUPnPImpl:ip", address);
        this.setPersistentStringProperty("rend_ip", address.getHostAddress());
    }

    protected URL getStreamURL(TranscodeFileImpl file) {
        this.browseReceived();
        return super.getStreamURL(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void browseReceived() {
        TranscodeFileImpl[] transcode_files;
        Object profiles;
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc == null) {
            return;
        }
        TranscodeProfile default_profile = this.getDefaultTranscodeProfile();
        if (default_profile == null) {
            for (TranscodeProfile transcodeProfile : profiles = this.getTranscodeProfiles()) {
                if (!transcodeProfile.isStreamable()) continue;
                default_profile = transcodeProfile;
                break;
            }
        }
        profiles = this;
        synchronized (profiles) {
            if (this.upnpav_ipc != null) {
                return;
            }
            this.upnpav_ipc = ipc;
            if (default_profile != null && default_profile.isStreamable()) {
                this.dynamic_transcode_profile = default_profile;
            }
        }
        if (this.dynamic_transcode_profile != null && this instanceof TranscodeTarget) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    DownloadManager dm = PluginInitializer.getDefaultInterface().getDownloadManager();
                    dm.addListener(DeviceUPnPImpl.this, true);
                }
            });
        }
        this.addListener(this);
        for (TranscodeFileImpl transcodeFileImpl : transcode_files = this.getFiles()) {
            this.fileAdded(transcodeFileImpl, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUPNPAV() {
        DeviceUPnPImpl deviceUPnPImpl = this;
        synchronized (deviceUPnPImpl) {
            TranscodeFileImpl[] transcode_files;
            if (this.upnpav_ipc == null) {
                return;
            }
            this.upnpav_ipc = null;
            this.dynamic_transcode_profile = null;
            this.dynamic_xcode_map = null;
            DownloadManager dm = PluginInitializer.getDefaultInterface().getDownloadManager();
            dm.removeListener(this);
            this.removeListener(this);
            for (TranscodeFileImpl file : transcode_files = this.getFiles()) {
                file.setTransientProperty(UPNPAV_FILE_KEY, null);
            }
        }
    }

    @Override
    public void downloadAdded(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && PlatformTorrentUtils.isContent(torrent, false)) {
            this.addDynamicXCode(download.getDiskManagerFileInfo()[0]);
        }
    }

    @Override
    public void downloadRemoved(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && PlatformTorrentUtils.isContent(torrent, false)) {
            this.removeDynamicXCode(download.getDiskManagerFileInfo()[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDynamicXCode(final DiskManagerFileInfo source) {
        final TranscodeProfile profile = this.dynamic_transcode_profile;
        IPCInterface ipc = this.upnpav_ipc;
        if (profile == null || ipc == null) {
            return;
        }
        try {
            TranscodeFileImpl transcode_file = this.allocateFile(profile, false, source, false);
            AzureusContentFile acf = (AzureusContentFile)transcode_file.getTransientProperty(UPNPAV_FILE_KEY);
            if (acf != null) {
                return;
            }
            final String tf_key = transcode_file.getKey();
            Map<String, AzureusContentFile> map = acf_map;
            synchronized (map) {
                acf = acf_map.get(tf_key);
            }
            if (acf != null) {
                return;
            }
            final DiskManagerFileInfoStream stream_file = new DiskManagerFileInfoStream(new DiskManagerFileInfoStream.StreamFactory(){
                private List<Object> current_requests = new ArrayList<Object>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public DiskManagerFileInfoStream.StreamFactory.StreamDetails getStream(Object request2) throws IOException {
                    2 var5_8;
                    StreamWrapper streamWrapper;
                    try {
                        TranscodeJobImpl job = DeviceUPnPImpl.this.getManager().getTranscodeManager().getQueue().add((TranscodeTarget)((Object)DeviceUPnPImpl.this), profile, source, true);
                        2 var3_5 = this;
                        synchronized (var3_5) {
                            this.current_requests.add(request2);
                        }
                        while (true) {
                            InputStream is;
                            if ((is = job.getStream(1000)) != null) {
                                streamWrapper = new StreamWrapper(is, job);
                                var5_8 = this;
                                break;
                            }
                            int state = job.getState();
                            if (state == 5) {
                                throw new IOException("Transcode failed: " + job.getError());
                            }
                            if (state == 4) {
                                throw new IOException("Transcode failed: job cancelled");
                            }
                            if (state == 3) {
                                throw new IOException("Job complete but no stream!");
                            }
                            var5_8 = this;
                            synchronized (var5_8) {
                                if (!this.current_requests.contains(request2)) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 4, 10, 14, 15] lbl24 : MonitorExitStatement: MONITOREXIT : var5_8
                                    IOException error = new IOException("Stream request cancelled");
                                    job.failed(error);
                                    throw error;
                                }
                            }
                            System.out.println("waiting for stream");
                            continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new IOException("Failed to add transcode job: " + Debug.getNestedExceptionMessage(e));
                    }
                    catch (Throwable throwable) {
                        2 var9_10 = this;
                        synchronized (var9_10) {
                            this.current_requests.remove(request2);
                            throw throwable;
                        }
                    }
                    synchronized (var5_8) {
                        this.current_requests.remove(request2);
                        return streamWrapper;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void destroyed(Object request2) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.current_requests.remove(request2);
                    }
                }
            }, transcode_file.getCacheFile());
            acf = new AzureusContentFile(){

                public DiskManagerFileInfo getFile() {
                    return stream_file;
                }

                public Object getProperty(String name) {
                    if (name.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                        return new Object[]{DeviceUPnPImpl.this, tf_key};
                    }
                    if (name.equals("percent")) {
                        return new Long(1000L);
                    }
                    if (name.equals("eta")) {
                        return new Long(0L);
                    }
                    return null;
                }
            };
            Object object = acf_map;
            synchronized (object) {
                acf_map.put(tf_key, acf);
            }
            transcode_file.setTransientProperty(UPNPAV_FILE_KEY, acf);
            this.syncCategories(transcode_file, true);
            object = this;
            synchronized (object) {
                if (this.dynamic_xcode_map == null) {
                    this.dynamic_xcode_map = new HashMap<String, AzureusContentFile>();
                }
                this.dynamic_xcode_map.put(tf_key, acf);
            }
            ipc.invoke("addContent", new Object[]{acf});
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDynamicXCode(DiskManagerFileInfo source) {
        block11: {
            TranscodeProfile profile = this.dynamic_transcode_profile;
            IPCInterface ipc = this.upnpav_ipc;
            if (profile == null || ipc == null) {
                return;
            }
            try {
                TranscodeFileImpl transcode_file = this.lookupFile(profile, source);
                if (transcode_file == null || transcode_file.isComplete()) break block11;
                AzureusContentFile acf = null;
                Object object = this;
                synchronized (object) {
                    if (this.dynamic_xcode_map != null) {
                        acf = this.dynamic_xcode_map.get(transcode_file.getKey());
                    }
                }
                transcode_file.delete(true);
                if (acf != null) {
                    ipc.invoke("removeContent", new Object[]{acf});
                }
                object = acf_map;
                synchronized (object) {
                    acf_map.remove(transcode_file.getKey());
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setupStreamXCode(TranscodeFileImpl transcode_file) {
        AzureusContentFile acf;
        TranscodeJobImpl job = transcode_file.getJob();
        if (job == null) {
            return transcode_file.isComplete();
        }
        final String tf_key = transcode_file.getKey();
        Map<String, AzureusContentFile> map = acf_map;
        synchronized (map) {
            acf = acf_map.get(tf_key);
        }
        if (acf != null) {
            return true;
        }
        IPCInterface ipc = this.upnpav_ipc;
        if (ipc == null) {
            return false;
        }
        if (transcode_file.getDurationMillis() == 0L) {
            return false;
        }
        try {
            final TranscodeJobOutputLeecher stream_file = new TranscodeJobOutputLeecher(job, transcode_file);
            acf = new AzureusContentFile(){

                public DiskManagerFileInfo getFile() {
                    return stream_file;
                }

                public Object getProperty(String name) {
                    if (name.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                        return new Object[]{DeviceUPnPImpl.this, tf_key};
                    }
                    if (name.equals("percent")) {
                        return new Long(1000L);
                    }
                    if (name.equals("eta")) {
                        return new Long(0L);
                    }
                    return null;
                }
            };
            Map<String, AzureusContentFile> map2 = acf_map;
            synchronized (map2) {
                acf_map.put(tf_key, acf);
            }
            ipc.invoke("addContent", new Object[]{acf});
            this.log("Set up stream-xcode for " + transcode_file.getName());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected boolean isVisible(AzureusContentDownload file) {
        return !this.getFilterFilesView();
    }

    protected boolean isVisible(AzureusContentFile file) {
        String tf_key;
        Object[] x;
        boolean result = this.getFilterFilesView() ? ((x = (Object[])file.getProperty(this.MY_ACF_KEY)) != null && x[0] == this ? this.getTranscodeFile(tf_key = (String)x[1]) != null : false) : true;
        return result;
    }

    @Override
    public void fileAdded(TranscodeFile _transcode_file) {
        this.fileAdded(_transcode_file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileAdded(TranscodeFile _transcode_file, boolean _new_file) {
        TranscodeFileImpl transcode_file = (TranscodeFileImpl)_transcode_file;
        IPCInterface ipc = this.upnpav_ipc;
        DeviceUPnPImpl deviceUPnPImpl = this;
        synchronized (deviceUPnPImpl) {
            if (ipc == null) {
                return;
            }
            if (!transcode_file.isComplete()) {
                this.syncCategories(transcode_file, _new_file);
                return;
            }
            AzureusContentFile acf = (AzureusContentFile)transcode_file.getTransientProperty(UPNPAV_FILE_KEY);
            if (acf != null) {
                return;
            }
            final String tf_key = transcode_file.getKey();
            Map<String, AzureusContentFile> map = acf_map;
            synchronized (map) {
                acf = acf_map.get(tf_key);
            }
            if (acf != null) {
                return;
            }
            try {
                final DiskManagerFileInfo f = transcode_file.getTargetFile();
                acf = new AzureusContentFile(){

                    public DiskManagerFileInfo getFile() {
                        return f;
                    }

                    public Object getProperty(String name) {
                        if (name.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                            return new Object[]{DeviceUPnPImpl.this, tf_key};
                        }
                        if (name.equals("cats")) {
                            TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                            if (tf != null) {
                                return tf.getCategories();
                            }
                            return new String[0];
                        }
                        TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                        if (tf != null) {
                            long res = 0L;
                            if (name.equals("duration")) {
                                res = tf.getDurationMillis();
                            } else if (name.equals("video_width")) {
                                res = tf.getVideoWidth();
                            } else if (name.equals("video_height")) {
                                res = tf.getVideoHeight();
                            } else if (name.equals("date")) {
                                res = tf.getCreationDateMillis();
                            } else {
                                if (name.equals("percent")) {
                                    TranscodeJobImpl job;
                                    res = tf.isComplete() ? 1000L : ((job = tf.getJob()) == null ? 0L : (long)(10 * job.getPercentComplete()));
                                    return res;
                                }
                                if (name.equals("eta")) {
                                    TranscodeJobImpl job;
                                    res = tf.isComplete() ? 0L : ((job = tf.getJob()) == null ? Long.MAX_VALUE : job.getETASecs());
                                    return res;
                                }
                            }
                            if (res > 0L) {
                                return new Long(res);
                            }
                        }
                        return null;
                    }
                };
                transcode_file.setTransientProperty(UPNPAV_FILE_KEY, acf);
                Map<String, AzureusContentFile> map2 = acf_map;
                synchronized (map2) {
                    acf_map.put(tf_key, acf);
                }
                this.syncCategories(transcode_file, _new_file);
                try {
                    ipc.invoke("addContent", new Object[]{acf});
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            catch (TranscodeException e) {
                // empty catch block
            }
        }
    }

    protected void syncCategories(TranscodeFileImpl tf, boolean inherit_from_download) {
        try {
            Download dl = tf.getSourceFile().getDownload();
            if (dl != null) {
                if (inherit_from_download) {
                    this.setCategories(tf, dl);
                }
                final String tf_key = tf.getKey();
                dl.addAttributeListener(new DownloadAttributeListener(){

                    public void attributeEventOccurred(Download download, TorrentAttribute attribute, int eventType) {
                        TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                        if (tf != null) {
                            DeviceUPnPImpl.this.setCategories(tf, download);
                        }
                    }
                }, this.upnp_manager.getCategoryAttibute(), 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setCategories(TranscodeFileImpl tf, Download dl) {
        String cat = dl.getCategoryName();
        if (cat != null && cat.length() > 0 && !cat.equals("Categories.uncategorized")) {
            tf.setCategories(new String[]{cat});
        } else {
            tf.setCategories(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(TranscodeFile file, int type, Object data) {
        if (file.isComplete()) {
            this.fileAdded(file, false);
        }
        if (type == 1 && data == "cat") {
            AzureusContentFile acf;
            Map<String, AzureusContentFile> map = acf_map;
            synchronized (map) {
                acf = acf_map.get(((TranscodeFileImpl)file).getKey());
            }
            if (acf != null) {
                AzureusPlatformContentDirectory.fireChanged(acf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileRemoved(TranscodeFile file) {
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            AzureusContentFile acf = (AzureusContentFile)file.getTransientProperty(UPNPAV_FILE_KEY);
            if (acf == null) {
                return;
            }
            file.setTransientProperty(UPNPAV_FILE_KEY, null);
            try {
                ipc.invoke("removeContent", new Object[]{acf});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        object = acf_map;
        synchronized (object) {
            acf_map.remove(((TranscodeFileImpl)file).getKey());
        }
    }

    protected URL getPresentationURL(UPnPDevice device) {
        String presentation = device.getRootDevice().getDevice().getPresentation();
        if (presentation != null) {
            try {
                URL url = new URL(presentation);
                return url;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        UPnPDevice device = this.device_may_be_null;
        if (device != null) {
            UPnPRootDevice root = device.getRootDevice();
            URL location = root.getLocation();
            this.addDP(dp, "dht.reseed.ip", location.getHost() + ":" + location.getPort());
            String model_details = device.getModelName();
            String model_url = device.getModelURL();
            if (model_url != null && model_url.length() > 0) {
                model_details = model_details + " (" + model_url + ")";
            }
            String manu_details = device.getManufacturer();
            String manu_url = device.getManufacturerURL();
            if (manu_url != null && manu_url.length() > 0) {
                manu_details = manu_details + " (" + manu_url + ")";
            }
            this.addDP(dp, "device.model.desc", device.getModelDescription());
            this.addDP(dp, "device.model.name", model_details);
            this.addDP(dp, "device.model.num", device.getModelNumber());
            this.addDP(dp, "device.manu.desc", manu_details);
        } else {
            InetAddress ia = this.getAddress();
            if (ia != null) {
                this.addDP(dp, "dht.reseed.ip", ia.getHostAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            UPnPDevice device = this.device_may_be_null;
            if (device == null) {
                writer.println("upnp_device=null");
            } else {
                writer.println("upnp_device=" + device.getFriendlyName());
            }
            writer.println("dyn_xcode=" + (this.dynamic_transcode_profile == null ? "null" : this.dynamic_transcode_profile.getName()));
        }
        finally {
            writer.exdent();
        }
    }

    protected static class StreamWrapper
    implements DiskManagerFileInfoStream.StreamFactory.StreamDetails {
        private InputStream is;
        private TranscodeJob job;

        protected StreamWrapper(InputStream _is, TranscodeJob _job) {
            this.is = _is;
            this.job = _job;
        }

        public InputStream getStream() {
            return this.is;
        }

        public boolean hasFailed() {
            long start = SystemTime.getMonotonousTime();
            while (true) {
                int state;
                if ((state = this.job.getState()) == 1) {
                    if (SystemTime.getMonotonousTime() - start > 5000L) {
                        return true;
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Throwable e) {
                        return true;
                    }
                }
                if (state == 5 || state == 4 || state == 7 || state == 6) break;
            }
            return true;
        }
    }
}

