/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class TranscodeJobOutputLeecher
implements DiskManagerFileInfo {
    private TranscodeJobImpl job;
    private TranscodeFileImpl file;
    private File save_to;
    private byte[] hash;

    public TranscodeJobOutputLeecher(TranscodeJobImpl _job, TranscodeFileImpl _file) throws TranscodeException {
        this.job = _job;
        this.file = _file;
        this.save_to = this.file.getCacheFile();
        try {
            this.hash = new SHA1Simple().calculateHash(this.save_to.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void setPriority(boolean b) {
    }

    public void setSkipped(boolean b) {
        throw new RuntimeException("Not supported");
    }

    public void setDeleted(boolean b) {
    }

    public void setLink(File link_destination) {
        throw new RuntimeException("Not supported");
    }

    public File getLink() {
        return null;
    }

    public int getAccessMode() {
        return 1;
    }

    public long getDownloaded() {
        return this.getLength();
    }

    public long getLength() {
        if (this.file.isComplete()) {
            try {
                return this.file.getTargetFile().getLength();
            }
            catch (Throwable e) {
                return -1L;
            }
        }
        return -1L;
    }

    public File getFile() {
        return this.save_to;
    }

    public int getIndex() {
        return 0;
    }

    public int getFirstPieceNumber() {
        return 0;
    }

    public long getPieceSize() {
        return 32768L;
    }

    public int getNumPieces() {
        return -1;
    }

    public boolean isPriority() {
        return false;
    }

    public boolean isSkipped() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public byte[] getDownloadHash() throws DownloadException {
        return this.hash;
    }

    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        return new Channel();
    }

    protected class Channel
    implements DiskManagerChannel {
        private volatile boolean channel_destroyed;
        private RandomAccessFile raf;

        protected Channel() {
        }

        public DiskManagerRequest createRequest() {
            return new request();
        }

        public DiskManagerFileInfo getFile() {
            return TranscodeJobOutputLeecher.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Channel channel2 = this;
            synchronized (channel2) {
                this.channel_destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.raf = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int read(byte[] buffer, long offset, int length) throws IOException {
            Channel channel2 = this;
            synchronized (channel2) {
                if (this.channel_destroyed) {
                    throw new IOException("Channel destroyed");
                }
                if (this.raf == null) {
                    if (TranscodeJobOutputLeecher.this.save_to.exists()) {
                        this.raf = new RandomAccessFile(TranscodeJobOutputLeecher.this.save_to, "r");
                    } else {
                        int state = TranscodeJobOutputLeecher.this.job.getState();
                        if (state == 7) {
                            throw new IOException("Job has been removed");
                        }
                        if (state == 5 || state == 4) {
                            throw new IOException("Job has failed or been cancelled");
                        }
                        if (state == 3) {
                            throw new IOException("Job is complete but file missing");
                        }
                    }
                }
                if (this.raf != null) {
                    if (this.raf.length() > offset) {
                        this.raf.seek(offset);
                        return this.raf.read(buffer, 0, length);
                    }
                    if (TranscodeJobOutputLeecher.this.file.isComplete()) {
                        return -1;
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable e) {
                throw new IOException("Interrupted");
            }
            return 0;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean request_cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            public void setType(int type) {
                if (type != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            public void setOffset(long _offset) {
                this.offset = _offset;
            }

            public void setLength(long _length) {
                this.length = _length == -1L ? Long.MAX_VALUE : _length;
            }

            public void setMaximumReadChunkSize(int size) {
                if (size > 16384) {
                    this.max_read_chunk = size;
                }
            }

            public long getAvailableBytes() {
                return this.getRemaining();
            }

            public long getRemaining() {
                return this.length == Long.MAX_VALUE ? this.length : this.offset + this.length - this.position;
            }

            public void run() {
                try {
                    byte[] buffer = new byte[this.max_read_chunk];
                    long rem = this.length;
                    long pos = this.offset;
                    while (rem > 0L) {
                        if (this.request_cancelled) {
                            throw new Exception("Cancelled");
                        }
                        if (Channel.this.channel_destroyed) {
                            throw new Exception("Destroyed");
                        }
                        int chunk = (int)Math.min(rem, (long)this.max_read_chunk);
                        int len = Channel.this.read(buffer, pos, chunk);
                        if (len == -1) {
                            if (this.length != Long.MAX_VALUE) {
                                throw new Exception("Premature end of stream (complete)");
                            }
                            break;
                        }
                        if (len == 0) {
                            this.sendEvent(new event(pos));
                            continue;
                        }
                        this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                        rem -= (long)len;
                        pos += (long)len;
                    }
                }
                catch (Throwable e) {
                    this.sendEvent(new event(e));
                }
            }

            public void cancel() {
                this.request_cancelled = true;
            }

            public void setUserAgent(String agent) {
            }

            protected void sendEvent(event ev) {
                for (DiskManagerListener l : this.listeners) {
                    l.eventOccurred(ev);
                }
            }

            public void addListener(DiskManagerListener listener) {
                this.listeners.add(listener);
            }

            public void removeListener(DiskManagerListener listener) {
                this.listeners.remove(listener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable _error) {
                    this.event_type = 2;
                    this.error = _error;
                }

                protected event(long _offset) {
                    this.event_type = 3;
                    this.event_offset = _offset;
                }

                protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                    this.event_type = 1;
                    this.buffer = _buffer;
                    this.event_offset = _offset;
                    this.event_length = _length;
                }

                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                public long getOffset() {
                    return this.event_offset;
                }

                public int getLength() {
                    return this.event_length;
                }

                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

