/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeManagerListener;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeProviderVuze;
import com.aelitis.azureus.core.devices.impl.TranscodeQueueImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class TranscodeManagerImpl
implements TranscodeManager {
    private DeviceManagerImpl device_manager;
    private AzureusCore azureus_core;
    private TranscodeProviderVuze vuzexcode_provider;
    private CopyOnWriteList<TranscodeManagerListener> listeners = new CopyOnWriteList();
    private TranscodeQueueImpl queue = new TranscodeQueueImpl(this);
    private AESemaphore init_sem = new AESemaphore("TM:init");

    protected TranscodeManagerImpl(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
        this.azureus_core = AzureusCoreFactory.getSingleton();
        PluginInitializer.getDefaultInterface().addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface[] plugins;
                PluginInterface default_pi = PluginInitializer.getDefaultInterface();
                default_pi.addEventListener(new PluginEventListener(){

                    public void handleEvent(PluginEvent ev) {
                        int type = ev.getType();
                        if (type == 8) {
                            TranscodeManagerImpl.this.pluginAdded((PluginInterface)ev.getValue());
                        }
                        if (type == 9) {
                            TranscodeManagerImpl.this.pluginRemoved((PluginInterface)ev.getValue());
                        }
                    }
                });
                for (PluginInterface pi : plugins = default_pi.getPluginManager().getPlugins()) {
                    if (!pi.getPluginState().isOperational()) continue;
                    TranscodeManagerImpl.this.pluginAdded(pi);
                }
                TranscodeManagerImpl.this.queue.initialise();
                TranscodeManagerImpl.this.init_sem.releaseForever();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pi) {
        block13: {
            TranscodeProviderVuze provider2;
            boolean updated;
            block14: {
                if (pi.getPluginState().isBuiltIn()) {
                    return;
                }
                String plugin_id = pi.getPluginID();
                if (!plugin_id.equals("vuzexcode")) break block13;
                boolean added = false;
                updated = false;
                provider2 = null;
                TranscodeManagerImpl transcodeManagerImpl = this;
                synchronized (transcodeManagerImpl) {
                    if (this.vuzexcode_provider == null) {
                        provider2 = this.vuzexcode_provider = new TranscodeProviderVuze(this, pi);
                        added = true;
                    } else if (pi != this.vuzexcode_provider) {
                        provider2 = this.vuzexcode_provider;
                        this.vuzexcode_provider.update(pi);
                        updated = true;
                    }
                }
                if (!added) break block14;
                for (TranscodeManagerListener listener : this.listeners) {
                    try {
                        listener.providerAdded(provider2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                break block13;
            }
            if (!updated) break block13;
            for (TranscodeManagerListener listener : this.listeners) {
                try {
                    listener.providerUpdated(provider2);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pi) {
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("vuzexcode")) {
            TranscodeProviderVuze provider2 = null;
            TranscodeManagerImpl transcodeManagerImpl = this;
            synchronized (transcodeManagerImpl) {
                if (this.vuzexcode_provider != null) {
                    provider2 = this.vuzexcode_provider;
                    this.vuzexcode_provider.destroy();
                    this.vuzexcode_provider = null;
                }
            }
            if (provider2 != null) {
                for (TranscodeManagerListener listener : this.listeners) {
                    try {
                        listener.providerRemoved(provider2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
    }

    protected void updateStatus(int tick_count) {
        if (this.queue != null) {
            this.queue.updateStatus(tick_count);
        }
    }

    public TranscodeProvider[] getProviders() {
        TranscodeProviderVuze vp = this.vuzexcode_provider;
        if (vp == null) {
            return new TranscodeProvider[0];
        }
        return new TranscodeProvider[]{vp};
    }

    protected TranscodeProfile getProfileFromUID(String uid) {
        for (TranscodeProvider provider2 : this.getProviders()) {
            TranscodeProfile profile = provider2.getProfile(uid);
            if (profile == null) continue;
            return profile;
        }
        return null;
    }

    public TranscodeQueueImpl getQueue() {
        if (!this.init_sem.reserve(10000L)) {
            Debug.out("Timeout waiting for init");
        }
        return this.queue;
    }

    protected DeviceManagerImpl getManager() {
        return this.device_manager;
    }

    protected TranscodeTarget lookupTarget(String target_id) throws TranscodeException {
        DeviceImpl device = this.device_manager.getDevice(target_id);
        if (device instanceof TranscodeTarget) {
            return (TranscodeTarget)((Object)device);
        }
        throw new TranscodeException("Transcode target with id " + target_id + " not found");
    }

    protected DiskManagerFileInfo lookupFile(byte[] hash, int index) throws TranscodeException {
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            if (download == null) {
                throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(hash) + " not found");
            }
            return download.getDiskManagerFileInfo()[index];
        }
        catch (Throwable e) {
            throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(hash) + " not found", e);
        }
    }

    protected void close() {
        this.queue.close();
    }

    public void addListener(TranscodeManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TranscodeManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void log(String str) {
        this.device_manager.log("Trans: " + str);
    }

    protected void log(String str, Throwable e) {
        this.device_manager.log("Trans: " + str, e);
    }

    public void generate(IndentWriter writer) {
        writer.println("Transcode Manager: vuze provider=" + this.vuzexcode_provider);
        this.queue.generate(writer);
    }
}

