/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTDBValueImpl
implements DHTDBValue {
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    private long creation_time;
    private byte[] value;
    private DHTTransportContact originator;
    private DHTTransportContact sender;
    private boolean local;
    private byte flags;
    private byte life_hours;
    private int version;
    private long store_time;

    protected DHTDBValueImpl(long _creation_time, byte[] _value, int _version, DHTTransportContact _originator, DHTTransportContact _sender, boolean _local, int _flags, int _life_hours) {
        this.creation_time = _creation_time;
        this.value = _value;
        this.version = _version;
        this.originator = _originator;
        this.sender = _sender;
        this.local = _local;
        this.flags = (byte)_flags;
        this.life_hours = (byte)_life_hours;
        if (this.value != null && this.value.length == 0) {
            this.value = ZERO_LENGTH_BYTE_ARRAY;
        }
        this.reset();
    }

    protected DHTDBValueImpl(DHTTransportContact _sender, DHTTransportValue _other, boolean _local) {
        this(_other.getCreationTime(), _other.getValue(), _other.getVersion(), _other.getOriginator(), _sender, _local, _other.getFlags(), _other.getLifeTimeHours());
    }

    protected void reset() {
        this.store_time = SystemTime.getCurrentTime();
        if (this.creation_time > this.store_time) {
            this.creation_time = this.store_time;
        }
    }

    public long getCreationTime() {
        return this.creation_time;
    }

    protected void setCreationTime() {
        this.creation_time = SystemTime.getCurrentTime();
    }

    protected void setStoreTime(long l) {
        this.store_time = l;
    }

    protected long getStoreTime() {
        return this.store_time;
    }

    public boolean isLocal() {
        return this.local;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public DHTTransportContact getOriginator() {
        return this.originator;
    }

    public DHTTransportContact getSender() {
        return this.sender;
    }

    public int getFlags() {
        return this.flags & 0xFF;
    }

    public void setFlags(byte _flags) {
        this.flags = _flags;
    }

    public int getLifeTimeHours() {
        return this.life_hours & 0xFF;
    }

    protected void setOriginatorAndSender(DHTTransportContact _originator) {
        this.originator = _originator;
        this.sender = _originator;
    }

    public DHTDBValue getValueForRelay(DHTTransportContact _sender) {
        return new DHTDBValueImpl(_sender, this, this.local);
    }

    public DHTDBValue getValueForDeletion(int _version) {
        DHTDBValueImpl res = new DHTDBValueImpl(this.originator, this, this.local);
        res.value = ZERO_LENGTH_BYTE_ARRAY;
        res.setCreationTime();
        res.version = _version;
        return res;
    }

    public String getString() {
        long now = SystemTime.getCurrentTime();
        return DHTLog.getString(this.value) + " - " + new String(this.value) + "{v=" + this.version + ",f=" + Integer.toHexString(this.flags) + ",ca=" + (now - this.creation_time) + ",sa=" + (now - this.store_time) + ",se=" + this.sender.getString() + ",or=" + this.originator.getString() + "}";
    }
}

