/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;

public class DHTLog {
    public static final boolean GLOBAL_BLOOM_TRACE = false;
    public static final boolean LOCAL_BLOOM_TRACE = false;
    public static final boolean CONTACT_VERIFY_TRACE = false;
    public static final boolean TRACE_VERSIONS = false;
    public static boolean logging_on = false;
    private static DHTLogger logger;

    protected static void setLogging(boolean on) {
        logging_on = on;
    }

    public static boolean isOn() {
        return logging_on;
    }

    public static void log(String str) {
        if (logging_on) {
            if (logger != null) {
                logger.log(str);
            } else {
                System.out.println(str);
            }
        }
    }

    public static void setLogger(DHTLogger l) {
        logger = l;
    }

    public static String getString(byte[] b) {
        if (logging_on) {
            return DHTLog.getString2(b);
        }
        return "";
    }

    public static String getString2(byte[] b) {
        String res = ByteFormatter.nicePrint(b);
        if (res.length() > 8) {
            res = res.substring(0, 8) + "...";
        }
        return res;
    }

    public static String getFullString(byte[] b) {
        return ByteFormatter.nicePrint(b);
    }

    public static String getString(HashWrapper w) {
        if (logging_on) {
            return DHTLog.getString(w.getHash());
        }
        return "";
    }

    public static String getString(DHTTransportContact[] contacts) {
        if (logging_on) {
            String res = "{";
            for (int i = 0; i < contacts.length; ++i) {
                res = res + (i == 0 ? "" : ",") + DHTLog.getString(contacts[i].getID());
            }
            return res + "}";
        }
        return "";
    }

    public static String getString(DHTTransportContact contact) {
        if (logging_on) {
            return contact.getString();
        }
        return "";
    }

    public static String getString(List l) {
        if (logging_on) {
            String res = "{";
            for (int i = 0; i < l.size(); ++i) {
                res = res + (i == 0 ? "" : ",") + DHTLog.getString((DHTTransportContact)l.get(i));
            }
            return res + "}";
        }
        return "";
    }

    public static String getString(Set s) {
        if (logging_on) {
            String res = "{";
            Iterator it = s.iterator();
            while (it.hasNext()) {
                res = res + (res.length() == 1 ? "" : ",") + DHTLog.getString((DHTTransportContact)it.next());
            }
            return res + "}";
        }
        return "";
    }

    public static String getString(Map s) {
        if (logging_on) {
            String res = "{";
            Iterator it = s.keySet().iterator();
            while (it.hasNext()) {
                res = res + (res.length() == 1 ? "" : ",") + DHTLog.getString((HashWrapper)it.next());
            }
            return res + "}";
        }
        return "";
    }

    public static String getString(DHTTransportValue[] values) {
        if (logging_on) {
            if (values == null) {
                return "<null>";
            }
            String res = "";
            for (int i = 0; i < values.length; ++i) {
                res = res + (i == 0 ? "" : ",") + DHTLog.getString(values[i]);
            }
            return res;
        }
        return "";
    }

    public static String getString(DHTTransportValue value) {
        if (logging_on) {
            if (value == null) {
                return "<null>";
            }
            return DHTLog.getString(value.getValue()) + "<" + (value.isLocal() ? "local" : "remote") + ",flags=" + value.getFlags() + ",life=" + value.getLifeTimeHours() + ",orig=" + value.getOriginator().getExternalAddress() + ">";
        }
        return "";
    }
}

