/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReplyFindValue
extends DHTUDPPacketReply {
    public static final int DHT_FIND_VALUE_HEADER_SIZE = 26;
    public static final int DHT_FIND_VALUE_TV_HEADER_SIZE = 25;
    private DHTTransportContact[] contacts;
    private DHTTransportValue[] values;
    private boolean has_continuation;
    private byte diversification_type = 1;

    public DHTUDPPacketReplyFindValue(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1031, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyFindValue(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1031, trans_id);
        boolean is_value;
        if (this.getProtocolVersion() >= 6) {
            this.has_continuation = is.readBoolean();
        }
        if (is_value = is.readBoolean()) {
            if (this.getProtocolVersion() >= 6) {
                this.diversification_type = is.readByte();
            }
            this.values = DHTUDPUtils.deserialiseTransportValues(this, is, 0L);
        } else {
            this.contacts = DHTUDPUtils.deserialiseContacts(this.getTransport(), is);
            if (this.getProtocolVersion() >= 16) {
                DHTUDPUtils.deserialiseVivaldi(this, is);
            }
        }
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.getProtocolVersion() >= 6) {
            os.writeBoolean(this.has_continuation);
        }
        os.writeBoolean(this.values != null);
        if (this.values == null) {
            DHTUDPUtils.serialiseContacts(os, this.contacts);
            if (this.getProtocolVersion() >= 16) {
                DHTUDPUtils.serialiseVivaldi(this, os);
            }
        } else {
            if (this.getProtocolVersion() >= 6) {
                os.writeByte(this.diversification_type);
            }
            try {
                DHTUDPUtils.serialiseTransportValues(this, os, this.values, -this.getClockSkew());
            }
            catch (DHTTransportException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public boolean hasContinuation() {
        return this.has_continuation;
    }

    protected void setValues(DHTTransportValue[] _values, byte _diversification_type, boolean _has_continuation) {
        this.has_continuation = _has_continuation;
        this.diversification_type = _diversification_type;
        this.values = _values;
    }

    protected DHTTransportValue[] getValues() {
        return this.values;
    }

    protected byte getDiversificationType() {
        return this.diversification_type;
    }

    protected void setContacts(DHTTransportContact[] _contacts) {
        this.contacts = _contacts;
    }

    protected DHTTransportContact[] getContacts() {
        return this.contacts;
    }

    public String getString() {
        return super.getString() + ",contacts=" + (this.contacts == null ? "null" : "" + this.contacts.length);
    }
}

