/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPPacketRequest
extends PRUDPPacketRequest
implements DHTUDPPacket {
    public static final int DHT_HEADER_SIZE = 41;
    private DHTTransportUDPImpl transport;
    private byte protocol_version;
    private byte vendor_id = (byte)-1;
    private int network;
    private byte originator_version;
    private long originator_time;
    private InetSocketAddress originator_address;
    private int originator_instance_id;
    private long skew;

    public DHTUDPPacketRequest(DHTTransportUDPImpl _transport, int _type, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_type, _connection_id);
        this.transport = _transport;
        this.protocol_version = _remote_contact.getProtocolVersion();
        if (this.protocol_version > _transport.getProtocolVersion()) {
            this.protocol_version = _transport.getProtocolVersion();
        }
        this.originator_address = _local_contact.getExternalAddress();
        this.originator_instance_id = _local_contact.getInstanceID();
        this.originator_time = SystemTime.getCurrentTime();
    }

    protected DHTUDPPacketRequest(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, int type, long con_id, int trans_id) throws IOException {
        super(type, con_id, trans_id);
        this.protocol_version = is.readByte();
        if (this.protocol_version >= 14) {
            this.vendor_id = is.readByte();
        }
        if (this.protocol_version >= 9) {
            this.network = is.readInt();
        }
        if (this.protocol_version < (this.network == 1 ? (byte)21 : 17)) {
            throw new IOException("Invalid DHT protocol version, please update Azureus");
        }
        this.transport = network_handler.getTransport(this);
        this.originator_version = this.protocol_version >= 9 ? is.readByte() : this.protocol_version;
        this.originator_address = DHTUDPUtils.deserialiseAddress(is);
        this.originator_instance_id = is.readInt();
        this.originator_time = is.readLong();
        this.skew = SystemTime.getCurrentTime() - this.originator_time;
        this.transport.recordSkew(this.originator_address, this.skew);
    }

    protected void postDeserialise(DataInputStream is) throws IOException {
        if (this.protocol_version < 9) {
            this.originator_version = is.available() > 0 ? is.readByte() : this.protocol_version;
            if (this.originator_version > this.getTransport().getProtocolVersion()) {
                this.originator_version = this.getTransport().getProtocolVersion();
            }
        }
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeByte(this.protocol_version);
        if (this.protocol_version >= 14) {
            os.writeByte(0);
        }
        if (this.protocol_version >= 9) {
            os.writeInt(this.network);
        }
        if (this.protocol_version >= 9) {
            os.writeByte(this.getTransport().getProtocolVersion());
        }
        try {
            DHTUDPUtils.serialiseAddress(os, this.originator_address);
        }
        catch (DHTTransportException e) {
            throw new IOException(e.getMessage());
        }
        os.writeInt(this.originator_instance_id);
        os.writeLong(this.originator_time);
    }

    protected void postSerialise(DataOutputStream os) throws IOException {
        if (this.protocol_version < 9) {
            os.writeByte(this.getTransport().getProtocolVersion());
        }
    }

    public DHTTransportUDPImpl getTransport() {
        return this.transport;
    }

    protected long getClockSkew() {
        return this.skew;
    }

    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected byte getVendorID() {
        return this.vendor_id;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int _network) {
        this.network = _network;
    }

    protected byte getOriginatorVersion() {
        return this.originator_version;
    }

    protected InetSocketAddress getOriginatorAddress() {
        return this.originator_address;
    }

    protected void setOriginatorAddress(InetSocketAddress address) {
        this.originator_address = address;
    }

    protected int getOriginatorInstanceID() {
        return this.originator_instance_id;
    }

    public String getString() {
        return super.getString() + ",[prot=" + this.protocol_version + ",ven=" + this.vendor_id + ",net=" + this.network + ",ov=" + this.originator_version + "]";
    }
}

