/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileLimited;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileUnlimited;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class FMFileManagerImpl
implements FMFileManager {
    public static final boolean DEBUG = false;
    protected static FMFileManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected LinkedHashMap map;
    protected AEMonitor map_mon = new AEMonitor("FMFileManager:Map");
    protected HashMap links = new HashMap();
    protected AEMonitor links_mon = new AEMonitor("FMFileManager:Links");
    protected boolean limited;
    protected int limit_size;
    protected AESemaphore close_queue_sem;
    protected List close_queue;
    protected AEMonitor close_queue_mon = new AEMonitor("FMFileManager:CQ");
    protected List files;
    protected AEMonitor files_mon = new AEMonitor("FMFileManager:File");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMFileManager getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new FMFileManagerImpl();
            }
            FMFileManagerImpl fMFileManagerImpl = singleton;
            return fMFileManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected FMFileManagerImpl() {
        this.limit_size = COConfigurationManager.getIntParameter("File Max Open");
        this.limited = this.limit_size > 0;
        this.map = new LinkedHashMap(this.limit_size, 0.75f, true);
        if (this.limited) {
            this.close_queue_sem = new AESemaphore("FMFileManager::closeqsem");
            this.close_queue = new LinkedList();
            AEThread t = new AEThread("FMFileManager::closeQueueDispatcher"){

                public void runSupport() {
                    FMFileManagerImpl.this.closeQueueDispatch();
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected CaseSensitiveFileMap getLinksEntry(TOTorrent torrent) {
        Object links_key;
        try {
            links_key = torrent.getHashWrapper();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            links_key = "";
        }
        CaseSensitiveFileMap links_entry = (CaseSensitiveFileMap)this.links.get(links_key);
        if (links_entry == null) {
            links_entry = new CaseSensitiveFileMap();
            this.links.put(links_key, links_entry);
        }
        return links_entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileLinks(TOTorrent torrent, CaseSensitiveFileMap new_links) {
        try {
            this.links_mon.enter();
            CaseSensitiveFileMap links_entry = this.getLinksEntry(torrent);
            Iterator it = new_links.keySetIterator();
            while (it.hasNext()) {
                File source = (File)it.next();
                File target = new_links.get(source);
                if (target != null && !source.equals(target)) {
                    links_entry.put(source, target);
                    continue;
                }
                links_entry.remove(source);
            }
        }
        finally {
            this.links_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileLink(TOTorrent torrent, File file) {
        try {
            this.links_mon.enter();
            CaseSensitiveFileMap links_entry = this.getLinksEntry(torrent);
            File res = links_entry.get(file);
            if (res == null) {
                res = file;
            }
            File file2 = res;
            return file2;
        }
        finally {
            this.links_mon.exit();
        }
    }

    public FMFile createFile(FMFileOwner owner, File file, int type) throws FMFileManagerException {
        FMFileImpl res = this.limited ? new FMFileLimited(owner, this, file, type) : new FMFileUnlimited(owner, this, file, type);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSlot(FMFileLimited file) {
        FMFileLimited oldest_file = null;
        try {
            this.map_mon.enter();
            if (this.map.size() >= this.limit_size) {
                Iterator it = this.map.keySet().iterator();
                oldest_file = (FMFileLimited)it.next();
                it.remove();
            }
            this.map.put(file, file);
        }
        finally {
            this.map_mon.exit();
        }
        if (oldest_file != null) {
            this.closeFile(oldest_file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            this.map.remove(file);
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usedSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            if (this.map.containsKey(file)) {
                this.map.put(file, file);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(FMFileLimited file) {
        try {
            this.close_queue_mon.enter();
            this.close_queue.add(file);
        }
        finally {
            this.close_queue_mon.exit();
        }
        this.close_queue_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeQueueDispatch() {
        while (true) {
            this.close_queue_sem.reserve();
            FMFileLimited file = null;
            try {
                this.close_queue_mon.enter();
                if (this.close_queue.size() > 0) {
                    file = (FMFileLimited)this.close_queue.remove(0);
                }
            }
            finally {
                this.close_queue_mon.exit();
            }
            if (file == null) continue;
            try {
                file.close(false);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter writer) {
        writer.println("FMFileManager slots");
        try {
            writer.indent();
            try {
                this.map_mon.enter();
                for (FMFileLimited file : this.map.keySet()) {
                    writer.println(file.getString());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static void generateEvidence(IndentWriter writer) {
        FMFileManagerImpl.getSingleton();
        singleton.generate(writer);
    }

    static {
        class_mon = new AEMonitor("FMFileManager:class");
    }
}

