/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.MetaDataUpdateListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;

public class DownloadManagerEnhancer {
    public static final int TICK_PERIOD = 1000;
    public static final int PUBLISHING_CHECK_PERIOD = 15000;
    public static final int PUBLISHING_CHECK_TICKS = 15;
    private static DownloadManagerEnhancer singleton;
    private AzureusCore core;
    private Map<DownloadManager, EnhancedDownloadManager> download_map = new HashMap<DownloadManager, EnhancedDownloadManager>();
    private boolean progressive_enabled;

    public static synchronized DownloadManagerEnhancer initialise(AzureusCore core) {
        if (singleton == null) {
            singleton = new DownloadManagerEnhancer(core);
        }
        return singleton;
    }

    public static synchronized DownloadManagerEnhancer getSingleton() {
        return singleton;
    }

    protected DownloadManagerEnhancer(AzureusCore _core) {
        this.core = _core;
        this.core.getGlobalManager().addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(DownloadManager dm) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadManagerRemoved(DownloadManager dm) {
                EnhancedDownloadManager edm;
                Map map = DownloadManagerEnhancer.this.download_map;
                synchronized (map) {
                    edm = (EnhancedDownloadManager)DownloadManagerEnhancer.this.download_map.remove(dm);
                }
                if (edm != null) {
                    edm.destroy();
                }
            }

            public void destroyInitiated() {
                DownloadManagerEnhancer.this.core.getGlobalManager().resumeDownloads();
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }
        });
        PlatformTorrentUtils.addListener(new MetaDataUpdateListener(){

            public void metaDataUpdated(TOTorrent torrent) {
                DownloadManager dm = DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManager(torrent);
                if (dm == null) {
                    Debug.out("Meta data update: download not found for " + torrent);
                } else {
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(dm);
                    if (edm != null) {
                        edm.refreshMetaData();
                    }
                }
            }
        });
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            public boolean receive(String name, Map values) {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int query(String name, Map values) {
                if (name.equals("az3.downloadmanager.stream.eta")) {
                    Object hash = values.get("hash");
                    byte[] b_hash = null;
                    if (hash instanceof String) {
                        String hash_str = (String)hash;
                        b_hash = hash_str.length() == 32 ? Base32.decode(hash_str) : ByteFormatter.decodeString(hash_str);
                    }
                    if (b_hash != null) {
                        DownloadManagerEnhancer.this.getEnhancedDownload(b_hash);
                    }
                    Map map = DownloadManagerEnhancer.this.download_map;
                    synchronized (map) {
                        for (EnhancedDownloadManager edm : DownloadManagerEnhancer.this.download_map.values()) {
                            if (b_hash != null) {
                                long eta;
                                byte[] d_hash = edm.getHash();
                                if (d_hash == null || !Arrays.equals(b_hash, d_hash)) continue;
                                if (edm.getDownloadManager().isDownloadComplete(false)) {
                                    return 0;
                                }
                                if (!edm.supportsProgressiveMode()) {
                                    return Integer.MIN_VALUE;
                                }
                                if (!edm.getProgressiveMode()) {
                                    edm.setProgressiveMode(true);
                                }
                                if ((eta = edm.getProgressivePlayETA()) > Integer.MAX_VALUE) {
                                    return Integer.MAX_VALUE;
                                }
                                return (int)eta;
                            }
                            if (!edm.getProgressiveMode()) continue;
                            long eta = edm.getProgressivePlayETA();
                            if (eta > Integer.MAX_VALUE) {
                                return Integer.MAX_VALUE;
                            }
                            return (int)eta;
                        }
                    }
                }
                return Integer.MIN_VALUE;
            }
        });
        SimpleTimer.addPeriodicEvent("DownloadManagerEnhancer:speedChecker", 1000L, new TimerEventPerformer(){
            private int tick_count;

            public void perform(TimerEvent event2) {
                ++this.tick_count;
                boolean check_publish = this.tick_count % 15 == 0;
                List downloads = DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManagers();
                for (int i = 0; i < downloads.size(); ++i) {
                    DownloadManager download = (DownloadManager)downloads.get(i);
                    int state = download.getState();
                    if (state != 50 && state != 60) continue;
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(download);
                    if (edm == null) {
                        return;
                    }
                    edm.updateStats(this.tick_count);
                    if (state != 60 || !check_publish) continue;
                    edm.checkPublishing();
                }
            }
        });
        DiskManagerChannelImpl.addListener(new DiskManagerChannelImpl.channelCreateListener(){

            public void channelCreated(DiskManagerChannel channel2) {
                try {
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(PluginCoreUtils.unwrap(channel2.getFile().getDownload()));
                    if (edm == null) {
                        return;
                    }
                    if (edm.getDownloadManager().isDownloadComplete(true)) {
                        return;
                    }
                    if (!edm.getProgressiveMode() && edm.supportsProgressiveMode()) {
                        Debug.out("Enabling progressive mode for '" + edm.getName() + "' due to external stream");
                        edm.setProgressiveMode(true);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    protected AzureusCore getCore() {
        return this.core;
    }

    public EnhancedDownloadManager getEnhancedDownload(byte[] hash) {
        DownloadManager dm = this.core.getGlobalManager().getDownloadManager(new HashWrapper(hash));
        if (dm == null) {
            return null;
        }
        return this.getEnhancedDownload(dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedDownloadManager getEnhancedDownload(DownloadManager manager) {
        DownloadManager dm2 = manager.getGlobalManager().getDownloadManager(manager.getTorrent());
        if (dm2 != manager) {
            return null;
        }
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            EnhancedDownloadManager res = this.download_map.get(manager);
            if (res == null) {
                res = new EnhancedDownloadManager(this, manager);
                this.download_map.put(manager, res);
            }
            return res;
        }
    }

    public boolean isProgressiveAvailable() {
        if (this.progressive_enabled) {
            return true;
        }
        PluginInterface ms_pi = this.core.getPluginManager().getPluginInterfaceByID("azupnpav", true);
        if (ms_pi != null) {
            this.progressive_enabled = true;
        }
        return this.progressive_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager findDownloadManager(String hash) {
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            for (DownloadManager dm : this.download_map.keySet()) {
                String thisHash;
                TOTorrent torrent = dm.getTorrent();
                if (!PlatformTorrentUtils.isContent(torrent, true) || !hash.equals(thisHash = PlatformTorrentUtils.getContentHash(torrent))) continue;
                return dm;
            }
        }
        return null;
    }
}

