/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.drivedetector.impl;

import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.impl.DriveDetectedInfoImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.Debug;

public class DriveDetectorImpl
implements DriveDetector {
    private AEMonitor2 mon_driveDetector = new AEMonitor2("driveDetector");
    private CopyOnWriteList<DriveDetectedListener> listListeners = new CopyOnWriteList(1);
    private List<File> listDrives = new ArrayList<File>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DriveDetectedListener l) {
        File[] drives;
        this.mon_driveDetector.enter();
        try {
            if (this.listListeners.contains(l)) {
                return;
            }
            this.listListeners.add(l);
            drives = this.listDrives.toArray(new File[0]);
        }
        finally {
            this.mon_driveDetector.exit();
        }
        for (File drive : drives) {
            try {
                l.driveDetected(new DriveDetectedInfoImpl(drive));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void removeListener(DriveDetectedListener l) {
        this.listListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveDetected(File location) {
        block7: {
            location = this.normaliseFile(location);
            this.mon_driveDetector.enter();
            try {
                if (!this.listDrives.contains(location)) {
                    this.listDrives.add(location);
                    break block7;
                }
                return;
            }
            finally {
                this.mon_driveDetector.exit();
            }
        }
        for (DriveDetectedListener l : this.listListeners) {
            try {
                l.driveDetected(new DriveDetectedInfoImpl(location));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveRemoved(File location) {
        location = this.normaliseFile(location);
        this.mon_driveDetector.enter();
        try {
            if (!this.listDrives.remove(location)) {
                return;
            }
        }
        finally {
            this.mon_driveDetector.exit();
        }
        for (DriveDetectedListener l : this.listListeners) {
            try {
                l.driveRemoved(new DriveDetectedInfoImpl(location));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected File normaliseFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Throwable e) {
            Debug.out(e);
            return f;
        }
    }
}

