/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.browser;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import java.util.Map;

public abstract class BrowserTransaction {
    private int id;
    private String type;
    private ClientMessageContext context;
    private boolean running = false;
    private boolean cancelled = false;
    private boolean completed = false;

    public BrowserTransaction(int id, String type, ClientMessageContext context2) {
        this.id = id;
        this.type = type;
        this.context = context2;
    }

    public boolean cancel() {
        this.debug("cancel");
        if (!this.running || this.completed || this.cancelled) {
            return false;
        }
        this.debug("canceling");
        if (!this.canceling()) {
            return false;
        }
        this.debug("cancelled");
        this.cancelled = true;
        this.context.getTransactionManager().removeTransaction(this);
        return true;
    }

    protected boolean canceling() {
        return true;
    }

    protected void debug(String message) {
        this.context.debug("[" + this + "] " + message);
    }

    protected void debug(String message, Throwable t) {
        this.context.debug("[" + this + "] " + message, t);
    }

    protected void executeInBrowser(String javascript) {
        if (this.context.getTransaction(this.type) == this) {
            this.context.executeInBrowser(javascript);
        } else {
            this.debug("Non-current transaction cannot execute: " + javascript);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void sendBrowserMessage(String key, String op) {
        this.sendBrowserMessage(key, op, null);
    }

    protected void sendBrowserMessage(String key, String op, Map params) {
        if (this.context.getTransaction(this.type) == this) {
            this.context.sendBrowserMessage(key, op, params);
        } else {
            this.debug("Non-current transaction cannot send: " + key + "." + op);
        }
    }

    public boolean start() {
        this.debug("start");
        if (this.running || this.completed || this.cancelled) {
            return false;
        }
        this.debug("starting");
        if (!this.starting()) {
            return false;
        }
        this.debug("started");
        this.running = true;
        return true;
    }

    protected boolean starting() {
        return true;
    }

    protected boolean stop() {
        this.debug("stop");
        if (!this.running) {
            return false;
        }
        this.debug("stopping");
        if (!this.stopping()) {
            return false;
        }
        this.debug("stopped");
        this.running = false;
        this.completed = !this.cancelled;
        this.context.getTransactionManager().removeTransaction(this);
        return true;
    }

    protected boolean stopping() {
        return true;
    }

    public String toString() {
        return this.type + "-" + this.id + (this.running ? "-running" : "") + (this.cancelled ? "-cancelled" : "") + (this.completed ? "-completed" : "");
    }
}

