/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.browser;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserTransaction;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class BrowserTransactionManager {
    private ClientMessageContext context;
    private Map txnCtors = new HashMap();
    private Map txns = new HashMap();
    private int lastTxnId = 0;

    public BrowserTransactionManager(ClientMessageContext context2) {
        this.context = context2;
    }

    public synchronized BrowserTransaction cancelTransaction(String type) {
        BrowserTransaction txn = this.getTransaction(type);
        if (txn != null) {
            txn.cancel();
        }
        return txn;
    }

    protected BrowserTransaction createTransaction(String type) {
        Constructor ctor = (Constructor)this.txnCtors.get(type);
        if (ctor == null) {
            throw new IllegalStateException("Unregistered transaction type: " + type);
        }
        try {
            Object[] params = new Object[]{new Integer(this.getNextTransactionId()), type, this.context};
            return (BrowserTransaction)ctor.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating transaction for type " + type, e);
        }
    }

    private int getNextTransactionId() {
        return ++this.lastTxnId;
    }

    public synchronized BrowserTransaction getTransaction(String type) {
        return (BrowserTransaction)this.txns.get(type);
    }

    public void registerTransactionType(String type, Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Transaction class must be non-null");
        }
        if (!BrowserTransaction.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Transaction class " + clazz.getName() + " must be a subclass of Transaction");
        }
        try {
            Class[] ctorParams = new Class[]{Integer.TYPE, String.class, ClientMessageContext.class};
            Constructor ctor = clazz.getConstructor(ctorParams);
            this.txnCtors.put(type, ctor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access appropriate constructor for " + clazz.getName());
        }
    }

    synchronized boolean removeTransaction(BrowserTransaction txn) {
        if (txn != this.getTransaction(txn.getType())) {
            return false;
        }
        return this.txns.remove(txn.getType()) == txn;
    }

    public synchronized BrowserTransaction startTransaction(String type) {
        this.cancelTransaction(type);
        BrowserTransaction txn = this.createTransaction(type);
        if (txn != null) {
            if (!txn.start()) {
                return null;
            }
            this.txns.put(type, txn);
        }
        return txn;
    }
}

