/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddyRequest;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.VuzeBuddySyncListener;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PlatformBuddyMessenger {
    public static final String LISTENER_ID_BUDDY = "buddy";
    public static final String LISTENER_ID_INVITE = "invite";
    public static final String OP_SYNC = "sync";
    public static final String OP_GETINVITES = "fetch";
    public static final String OP_COUNTINVITES = "count";
    public static final String OP_INVITE = "invite";
    public static final String OP_REMOVEBUDDY = "ditch";
    public static final String OP_STARTSHARE = "start-share";
    private static long lastSyncCheck = 0L;

    public static void sync(VuzeBuddySyncListener l) throws NotLoggedInException {
        PlatformBuddyMessenger.sync(null, l);
    }

    public static void sync(final String[] pks, final VuzeBuddySyncListener l) throws NotLoggedInException {
        lastSyncCheck = SystemTime.getCurrentTime();
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID_BUDDY, OP_SYNC, new Object[]{"pks", pks}, 1000L);
        message.setRequiresAuthorization(true, false);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (!replyType.equals(PlatformMessenger.REPLY_RESULT)) {
                    return;
                }
                long updateTime = SystemTime.getCurrentTime();
                List buddies = MapUtils.getMapList(reply, "buddies", null);
                try {
                    if (buddies == null) {
                        return;
                    }
                    if (buddies.size() > 0) {
                        VuzeBuddyManager.setSaveDelayed(true);
                    }
                    for (Map mapBuddy : buddies) {
                        String loginID = MapUtils.getMapString(mapBuddy, "login-id", null);
                        VuzeBuddy buddy = VuzeBuddyManager.getBuddyByLoginID(loginID);
                        if (buddy != null) {
                            buddy.loadFromMap(mapBuddy);
                        } else {
                            buddy = VuzeBuddyManager.createNewBuddy(mapBuddy, true);
                        }
                        if (buddy == null) continue;
                        buddy.setLastUpdated(updateTime);
                    }
                    if (pks == null) {
                        VuzeBuddyManager.removeBuddiesOlderThan(updateTime, false);
                    }
                    VuzeBuddyManager.setSaveDelayed(false);
                }
                finally {
                    if (l != null) {
                        l.syncComplete();
                    }
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void getInvites() throws NotLoggedInException {
        PlatformMessage message = new PlatformMessage("AZMSG", "invite", OP_GETINVITES, new Object[0], 1000L);
        message.setRequiresAuthorization(true, false);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (!replyType.equals(PlatformMessenger.REPLY_RESULT)) {
                    return;
                }
                List invitations = MapUtils.getMapList(reply, "invitations", Collections.EMPTY_LIST);
                VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
                ArrayList<VuzeActivitiesEntry> existingInvites = new ArrayList<VuzeActivitiesEntry>();
                for (int i = 0; i < allEntries.length; ++i) {
                    VuzeActivitiesEntryBuddyRequest inviteEntry;
                    VuzeActivitiesEntry entry = allEntries[i];
                    if (!(entry instanceof VuzeActivitiesEntryBuddyRequest) || (inviteEntry = (VuzeActivitiesEntryBuddyRequest)entry).getBuddy() == null) continue;
                    existingInvites.add(entry);
                }
                VuzeActivitiesEntry[] entries = existingInvites.toArray(new VuzeActivitiesEntry[0]);
                VuzeActivitiesManager.removeEntries(entries, true);
                if (invitations.size() == 0) {
                    return;
                }
                for (Map mapInvitation : invitations) {
                    Map mapBuddy = MapUtils.getMapMap(mapInvitation, "buddy-info", Collections.EMPTY_MAP);
                    long addedOn = SystemTime.getOffsetTime(MapUtils.getMapLong(mapInvitation, "added-secs-ago", 0L) * -1000L);
                    String inviteCode = MapUtils.getMapString(mapInvitation, "code", null);
                    String acceptURL = MapUtils.getMapString(mapInvitation, "accept-url", null);
                    long attempNumber = MapUtils.getMapLong(mapInvitation, "number", 0L);
                    if (mapBuddy.isEmpty() || inviteCode == null || acceptURL == null) continue;
                    VuzeActivitiesEntryBuddyRequest existingEntry = null;
                    for (VuzeActivitiesEntryBuddyRequest vuzeActivitiesEntryBuddyRequest : existingInvites) {
                        if (!inviteCode.equals(vuzeActivitiesEntryBuddyRequest.getBuddy().getCode())) continue;
                        existingEntry = vuzeActivitiesEntryBuddyRequest;
                        break;
                    }
                    VuzeBuddy futureBuddy = VuzeBuddyManager.createPotentialBuddy(null);
                    String string = MapUtils.getMapString(mapBuddy, "login-id", null);
                    VuzeBuddy existingBuddy = VuzeBuddyManager.getBuddyByLoginID(string);
                    if (existingBuddy != null) continue;
                    futureBuddy.loadFromMap(mapBuddy);
                    futureBuddy.setCode(inviteCode);
                    if (existingEntry != null) {
                        existingEntry.init(futureBuddy, acceptURL, attempNumber);
                    } else {
                        existingEntry = new VuzeActivitiesEntryBuddyRequest();
                        existingEntry.init(futureBuddy, acceptURL, attempNumber);
                    }
                    existingEntry.setTimestamp(addedOn);
                    VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{existingEntry});
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void getNumPendingInvites() {
        PlatformMessage message = new PlatformMessage("AZMSG", "invite", OP_COUNTINVITES, new Object[0], 1000L);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                int count = MapUtils.getMapInt(reply, PlatformBuddyMessenger.OP_COUNTINVITES, 0);
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void invite(String loginID, String userMessage) throws NotLoggedInException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("message", userMessage);
        ArrayList invitations = new ArrayList();
        HashMap<String, String> invitation = new HashMap<String, String>();
        parameters.put("invitations", invitations);
        invitation.put("type", "username");
        invitation.put("value", loginID);
        invitations.add(invitation);
        PlatformMessage message = new PlatformMessage("AZMSG", "invite", "invite", parameters, 1000L);
        message.setRequiresAuthorization(true, false);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void remove(final VuzeBuddy buddy, boolean login) throws NotLoggedInException {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID_BUDDY, OP_REMOVEBUDDY, new Object[]{"username", buddy.getLoginID()}, 1000L);
        message.setRequiresAuthorization(true, login);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                VuzeBuddyManager.log("removal of " + buddy.getLoginID() + " from webapp: " + replyType);
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void startShare(String referer, String hash) {
        boolean loggedIn = LoginInfoManager.getInstance().isLoggedIn();
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID_BUDDY, OP_STARTSHARE, new Object[]{"referer", referer, "logged-in", new Boolean(loggedIn), "torrent-hash", hash}, 1000L);
        if (loggedIn) {
            try {
                message.setRequiresAuthorization(true, false);
            }
            catch (NotLoggedInException e) {
                Debug.out(e);
            }
        }
        PlatformMessenger.queueMessage(message, null);
    }

    public static long getLastSyncCheck() {
        return lastSyncCheck;
    }
}

