/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformConfigMessenger {
    public static final String LISTENER_ID = "config";
    private static int iRPCVersion = 0;
    private static String playAfterURL = null;
    private static boolean sendStats = true;
    protected static long buddySyncOnShareMinTime;
    private static boolean doUrlQOS;
    private static boolean platformLoginComplete;
    protected static List platformLoginCompleteListeners;

    public static void login(long contentNetworkID, long maxDelayMS) {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        String azComputerID = "";
        try {
            azComputerID = pm.getAzComputerID();
        }
        catch (PlatformManagerException e) {
            // empty catch block
        }
        String sourceRef = null;
        if (contentNetworkID != 1L) {
            ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(contentNetworkID);
            sourceRef = (String)cn.getPersistentProperty("source_ref");
        }
        if (sourceRef == null) {
            sourceRef = "unknown";
        }
        Object[] params = new Object[]{"version", "4.2.0.8", "locale", Locale.getDefault().toString(), "azCID", azComputerID, "vid", COConfigurationManager.getStringParameter("ID"), "source-ref", sourceRef};
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "login", params, maxDelayMS);
        message.setContentNetworkID(contentNetworkID);
        message.setRequiresAuthorizationNoCheck();
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                String string;
                int i;
                List listURLs;
                if (reply == null) {
                    return;
                }
                try {
                    listURLs = (List)MapUtils.getMapObject(reply, "url-whitelist", null, List.class);
                    if (listURLs != null) {
                        for (i = 0; i < listURLs.size(); ++i) {
                            string = (String)listURLs.get(i);
                            UrlFilter.getInstance().addUrlWhitelist(string);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                try {
                    listURLs = (List)MapUtils.getMapObject(reply, "url-blacklist", null, List.class);
                    if (listURLs != null) {
                        for (i = 0; i < listURLs.size(); ++i) {
                            string = (String)listURLs.get(i);
                            UrlFilter.getInstance().addUrlBlacklist(string);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                try {
                    List listDomains = (List)MapUtils.getMapObject(reply, "tracker-domains", null, List.class);
                    if (listDomains != null) {
                        for (i = 0; i < listDomains.size(); ++i) {
                            String s = (String)listDomains.get(i);
                            PlatformTorrentUtils.addPlatformHost(s);
                            PlatformMessenger.debug("v3.login: got tracker domain of " + s);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                if (message.getContentNetworkID() != ConstantsVuze.getDefaultContentNetwork().getID()) {
                    return;
                }
                try {
                    sendStats = MapUtils.getMapBoolean(reply, "send-stats", true);
                    doUrlQOS = MapUtils.getMapBoolean(reply, "do-url-qos", false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                buddySyncOnShareMinTime = MapUtils.getMapLong(reply, "buddy-sync-on-share-min-time-secs", 60000L);
                try {
                    iRPCVersion = MapUtils.getMapInt(reply, "rpc-version", 0);
                    playAfterURL = MapUtils.getMapString(reply, "play-after-url", null);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                Map mapUserInfo = MapUtils.getMapMap(reply, "user-info", null);
                if (mapUserInfo != null) {
                    LoginInfoManager.getInstance().setUserInfo(mapUserInfo);
                }
                platformLoginComplete = true;
                Object[] listeners = platformLoginCompleteListeners.toArray();
                platformLoginCompleteListeners = Collections.EMPTY_LIST;
                for (int i2 = 0; i2 < listeners.length; ++i2) {
                    try {
                        PlatformLoginCompleteListener l = (PlatformLoginCompleteListener)listeners[i2];
                        l.platformLoginComplete();
                        continue;
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.pushMessageNow(message, listener);
    }

    public static void sendUsageStats(Map stats, long timestamp, String version, PlatformMessengerListener l) {
        if (!sendStats) {
            return;
        }
        try {
            PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "send-usage-stats2", new Object[]{"stats", stats, "version", version, "timestamp", new Long(timestamp), "ago-ms", new Long(SystemTime.getCurrentTime() - timestamp)}, 5000L);
            PlatformMessenger.queueMessage(message, l);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static int getRPCVersion() {
        return iRPCVersion;
    }

    public static String getPlayAfterURL() {
        return playAfterURL;
    }

    public static boolean allowSendStats() {
        return sendStats;
    }

    public static long getBuddySyncOnShareMinTimeSecs() {
        return buddySyncOnShareMinTime;
    }

    public static void setBuddySyncOnShareMinTimeSecs(long buddySyncOnShareMinTime) {
        PlatformConfigMessenger.buddySyncOnShareMinTime = buddySyncOnShareMinTime;
    }

    public static boolean doUrlQOS() {
        return doUrlQOS;
    }

    public static void addPlatformLoginCompleteListener(PlatformLoginCompleteListener l) {
        try {
            if (l == null) {
                return;
            }
            if (platformLoginComplete) {
                l.platformLoginComplete();
                return;
            }
            if (platformLoginCompleteListeners == Collections.EMPTY_LIST) {
                platformLoginCompleteListeners = new ArrayList(1);
            }
            platformLoginCompleteListeners.add(l);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    static {
        doUrlQOS = false;
        platformLoginComplete = false;
        platformLoginCompleteListeners = Collections.EMPTY_LIST;
    }

    public static interface GetBrowseSectionsReplyListener {
        public void messageSent();

        public void replyReceived(Map[] var1);
    }

    public static interface PlatformLoginCompleteListener {
        public void platformLoginComplete();
    }
}

