/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformContentNetworkMessenger {
    private static final String LISTENER_ID = "cnetworks";
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("cnetworks", true);
    private static final String OP_LIST_CNETORKS = "list-networks";

    public static List<contentNetworkDetails> listNetworks() throws PlatformMessengerException {
        JSONObject parameters = new JSONObject();
        parameters.put("azver", "4.2.0.8");
        Map reply = dispatcher.syncInvoke(OP_LIST_CNETORKS, parameters);
        List networks = (List)reply.get("networks");
        if (networks == null) {
            throw new PlatformMessengerException("No networks returned");
        }
        ArrayList<contentNetworkDetails> result = new ArrayList<contentNetworkDetails>();
        for (Map map : networks) {
            result.add(new contentNetworkDetails(map));
        }
        return result;
    }

    public static void listNetworksAync(final listNetworksListener l, int maxDelayMS) {
        JSONObject parameters = new JSONObject();
        parameters.put("azver", "4.2.0.8");
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_LIST_CNETORKS, parameters, (long)maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                ArrayList<contentNetworkDetails> result;
                List networks = (List)reply.get("networks");
                if (networks == null) {
                    result = null;
                } else {
                    result = new ArrayList<contentNetworkDetails>();
                    for (Map map : networks) {
                        result.add(new contentNetworkDetails(map));
                    }
                }
                if (l != null) {
                    l.networkListReturned(result);
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static class contentNetworkDetails {
        private Map details;

        protected contentNetworkDetails(Map _details) {
            this.details = _details;
        }

        public long getID() {
            return (Long)this.details.get("id");
        }

        public long getVersion() {
            return (Long)this.details.get("version");
        }

        public String getName() {
            return (String)this.details.get("name");
        }

        public String getIconURL() {
            return (String)this.details.get("iconUrl");
        }

        public String getMainURL() {
            return (String)this.details.get("baseUrl");
        }

        public String getString() {
            return "id=" + this.getID() + ";version=" + this.getVersion() + ";name=" + this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface listNetworksListener {
        public void networkListReturned(List<contentNetworkDetails> var1);
    }
}

