/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class PlatformDevicesMessenger {
    public static final String CFG_SEND_QOS = "devices.sendQOS";
    public static final String LISTENER_ID = "devices";
    private static final String OP_QOS_TURN_ON = "qos-turn-on";
    private static final String OP_QOS_FOUND_DEVICE = "qos-found-device";
    private static final String OP_QOS_TRANSCODE = "qos-transcode";
    private static final String OP_QOS_PLAYBACK = "qos-playback";
    private static final String OP_GET_PROFILES = "get-profiles";
    private static final String OP_REPORT_DEVICES = "report-devices";
    private static final String OP_QOS_TRANSCODE_REQUEST = "qos-transcode-request";
    private static String plugin_xcode_version = null;
    private static String plugin_itunes_version = null;

    public static void qosTurnOn(boolean withITunes) {
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TURN_ON, new Object[]{"itunes", withITunes, "os-name", Constants.OSName}, 5000L);
        message.setSendAZID(false);
        PlatformMessenger.queueMessage(message, null);
    }

    public static void qosFoundDevice(Device device) {
        if (device == null || !COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(map);
        map.put("device-name", device.getName());
        map.put("device-type", new Integer(device.getType()));
        if (device instanceof DeviceMediaRenderer) {
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)device;
            map.put("renderer-species", renderer.getRendererSpecies());
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_FOUND_DEVICE, map, 5000L);
        message.setSendAZID(false);
        PlatformMessenger.queueMessage(message, null);
    }

    private static void addPluginVersionsToMap(Map map) {
        if (AzureusCoreFactory.isCoreRunning()) {
            PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface pi = pm.getPluginInterfaceByID("vuzexcode");
            if (pi != null) {
                map.put("xcode-plugin-version", pi.getPluginVersion());
            }
            if ((pi = pm.getPluginInterfaceByID("azitunes")) != null) {
                map.put("itunes-plugin-version", pi.getPluginVersion());
            }
        }
        map.put("os-name", Constants.OSName);
    }

    public static void qosTranscodeRequest(TranscodeTarget transcodeTarget, String sourceRef) {
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false) || transcodeTarget == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(map);
        Device device = transcodeTarget.getDevice();
        if (device != null) {
            map.put("device-name", device.getName());
            map.put("device-type", new Integer(device.getType()));
        }
        if (transcodeTarget instanceof DeviceMediaRenderer) {
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)transcodeTarget;
            map.put("renderer-species", renderer.getRendererSpecies());
        }
        map.put("source-ref", sourceRef);
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TRANSCODE_REQUEST, map, 5000L);
        message.setSendAZID(false);
        PlatformMessenger.queueMessage(message, null);
    }

    public static void qosTranscode(TranscodeJob job, int stateOveride) {
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false) || job == null) {
            return;
        }
        TranscodeFile transcodeFile = job.getTranscodeFile();
        DiskManagerFileInfo sourceFileInfo = null;
        try {
            sourceFileInfo = transcodeFile.getSourceFile();
        }
        catch (Throwable t) {
            // empty catch block
        }
        DiskManagerFileInfo targetFileInfo = null;
        try {
            targetFileInfo = transcodeFile.getTargetFile();
        }
        catch (Throwable t) {
            // empty catch block
        }
        TranscodeProfile profile = job.getProfile();
        TranscodeTarget target = job.getTarget();
        Device device = target.getDevice();
        HashMap<String, Object> map = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(map);
        map.put("job-state", stateOveride);
        if ((stateOveride & 0xFF) == 5) {
            String error = job.getError();
            if (error != null) {
                if (error.endsWith("\r\n")) {
                    error.substring(0, error.length() - 2);
                } else if (error.endsWith("\r") || error.endsWith("\n")) {
                    error.substring(0, error.length() - 1);
                }
            }
            map.put("job-error", error);
        }
        try {
            Torrent torrent = job.getFile().getDownload().getTorrent();
            if (PlatformTorrentUtils.isContent(torrent, true)) {
                map.put("asset-hash", new HashWrapper(torrent.getHash()).toBase32String());
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        map.put("transcode-mode", new Integer(job.getTranscodeRequirement()));
        map.put("transcode-required", new Boolean(transcodeFile.getTranscodeRequired()));
        map.put("transcode-video-width", new Long(transcodeFile.getVideoWidth()));
        map.put("transcode-video-height", new Long(transcodeFile.getVideoHeight()));
        map.put("transcode-video-duration-ms", new Long(transcodeFile.getDurationMillis()));
        map.put("process-time-ms", new Long(job.getProcessTime()));
        map.put("device-name", device.getName());
        map.put("device-type", new Integer(device.getType()));
        if (profile != null) {
            map.put("profile-name", profile.getName());
        }
        if (target instanceof DeviceMediaRenderer) {
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)target;
            map.put("renderer-species", renderer.getRendererSpecies());
        }
        if (sourceFileInfo != null) {
            map.put("source-file-ext", FileUtil.getExtension(sourceFileInfo.getFile().getName()));
            map.put("source-file-size", new Long(sourceFileInfo.getLength()));
        }
        if (targetFileInfo != null) {
            map.put("target-file-ext", FileUtil.getExtension(targetFileInfo.getFile().getName()));
            map.put("target-file-size", new Long(targetFileInfo.getLength()));
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TRANSCODE, map, 5000L);
        message.setSendAZID(false);
        PlatformMessenger.queueMessage(message, null);
    }

    public static void setupDeviceSender() {
        final DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
        Device[] devices = deviceManager.getDevices();
        if (devices == null || devices.length == 0) {
            deviceManager.addListener(new DeviceManagerListener(){

                public void deviceRemoved(Device device) {
                }

                public void deviceChanged(Device device) {
                }

                public void deviceAttentionRequest(Device device) {
                }

                public void deviceAdded(Device device) {
                }

                public void deviceManagerLoaded() {
                    deviceManager.removeListener(this);
                    Device[] devices = deviceManager.getDevices();
                    if (devices != null && devices.length > 0) {
                        PlatformDevicesMessenger.sendDeviceList(devices);
                    }
                }
            });
        } else {
            PlatformDevicesMessenger.sendDeviceList(devices);
        }
    }

    private static void sendDeviceList(Device[] devices) {
        ArrayList<String> listRenderers = new ArrayList<String>(devices.length);
        for (Device dev : devices) {
            if (dev.getType() != 3) continue;
            listRenderers.add(dev.getClassification());
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_REPORT_DEVICES, new Object[]{"renderers", listRenderers}, 500L);
        PlatformMessenger.queueMessage(message, null);
    }
}

