/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;

public class PlatformMessengerConfig {
    private String listener_id;
    private boolean send_azid;

    protected PlatformMessengerConfig(String _listener_id, boolean _send_azid) {
        this.listener_id = _listener_id;
        this.send_azid = _send_azid;
    }

    protected Map syncInvoke(String operationID, Map parameters) throws PlatformMessengerException {
        PlatformMessage message = new PlatformMessage("AZMSG", this.listener_id, operationID, parameters, 0L);
        if (!this.send_azid) {
            message.setSendAZID(false);
        }
        final AESemaphore sem = new AESemaphore("PlatformMessengerConfig:syncInvoke");
        final Object[] result = new Object[]{null};
        PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                try {
                    if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
                        String e_message = (String)reply.get("message");
                        if (e_message != null) {
                            result[0] = new PlatformMessengerException(e_message);
                        } else {
                            String text = (String)reply.get("text");
                            Throwable e = (Throwable)reply.get("Throwable");
                            result[0] = text == null && e == null ? new PlatformMessengerException("Unknown error") : (text == null ? new PlatformMessengerException("Failed to send RPC", e) : (e == null ? new PlatformMessengerException(text) : new PlatformMessengerException(text, e)));
                        }
                    } else {
                        result[0] = reply;
                    }
                }
                finally {
                    sem.release();
                }
            }
        });
        sem.reserve();
        if (result[0] instanceof PlatformMessengerException) {
            throw (PlatformMessengerException)result[0];
        }
        return (Map)result[0];
    }
}

