/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformMetaSearchMessenger {
    private static final int MAX_TEMPLATE_LIST = 512;
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("searchtemplate", true);
    private static final String OP_GET_TEMPLATE = "get-template";
    private static final String OP_GET_TEMPLATES = "get-templates";
    private static final String OP_LIST_POPULAR_TEMPLATES = "list-popular";
    private static final String OP_LIST_FEATURED_TEMPLATES = "list-featured";
    private static final String OP_TEMPLATE_SELECTED = "template-selected";

    public static templateDetails getTemplate(long template_id) throws PlatformMessengerException {
        int type;
        Map reply = dispatcher.syncInvoke(OP_GET_TEMPLATE, PlatformMetaSearchMessenger.getParameter(template_id));
        templateInfo info = PlatformMetaSearchMessenger.getTemplateInfo(reply);
        if (info == null) {
            throw new PlatformMessengerException("Invalid reply: " + reply);
        }
        String name = (String)reply.get("name");
        String value = (String)reply.get("value");
        String engine_type = (String)reply.get("engine_id");
        if (name == null || value == null || engine_type == null) {
            throw new PlatformMessengerException("Invalid reply; field missing: " + reply);
        }
        if (engine_type.equals("json")) {
            type = 1;
        } else if (engine_type.equals("regexp")) {
            type = 2;
        } else {
            throw new PlatformMessengerException("Invalid type '" + engine_type + ": " + reply);
        }
        return new templateDetails(info, type, name, value);
    }

    public static templateInfo[] getTemplateDetails(long[] ids) throws PlatformMessengerException {
        if (ids.length == 0) {
            return new templateInfo[0];
        }
        String str = "";
        for (int i = 0; i < ids.length; ++i) {
            str = str + (i == 0 ? "" : ",") + ids[i];
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("templateIds", str);
        Map reply = dispatcher.syncInvoke(OP_GET_TEMPLATES, parameters);
        return PlatformMetaSearchMessenger.getTemplatesInfo(reply);
    }

    public static templateInfo[] listTopPopularTemplates() throws PlatformMessengerException {
        HashMap parameters = new HashMap();
        Map reply = dispatcher.syncInvoke(OP_LIST_POPULAR_TEMPLATES, parameters);
        return PlatformMetaSearchMessenger.getTemplatesInfo(reply);
    }

    public static templateInfo[] listAllPopularTemplates() throws PlatformMessengerException {
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("page-num", new Long(1L));
        parameters.put("items-per-page", new Long(512L));
        Map reply = dispatcher.syncInvoke(OP_LIST_POPULAR_TEMPLATES, parameters);
        return PlatformMetaSearchMessenger.getTemplatesInfo(reply);
    }

    public static templateInfo[] listFeaturedTemplates() throws PlatformMessengerException {
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("page-num", new Long(1L));
        parameters.put("items-per-page", new Long(512L));
        Map reply = dispatcher.syncInvoke(OP_LIST_FEATURED_TEMPLATES, parameters);
        return PlatformMetaSearchMessenger.getTemplatesInfo(reply);
    }

    protected static templateInfo[] getTemplatesInfo(Map reply) {
        List templates = (List)reply.get("templates");
        ArrayList<templateInfo> res = new ArrayList<templateInfo>();
        for (int i = 0; i < templates.size(); ++i) {
            Map m = (Map)templates.get(i);
            templateInfo info = PlatformMetaSearchMessenger.getTemplateInfo(m);
            if (info == null) continue;
            res.add(info);
        }
        templateInfo[] res_a = new templateInfo[res.size()];
        res.toArray(res_a);
        return res_a;
    }

    protected static templateInfo getTemplateInfo(Map m) {
        Long id = (Long)m.get("id");
        Boolean show = (Boolean)m.get("show");
        Long date = (Long)m.get("modified_dt");
        if (show == null) {
            show = new Boolean(true);
        }
        if (id != null && show != null && date != null) {
            return new templateInfo(id, date, show);
        }
        PlatformMessenger.debug("field missing from template info (" + m + ")");
        return null;
    }

    public static void setTemplatetSelected(long template_id, String user_id, boolean is_selected) throws PlatformMessengerException {
        Map parameters = PlatformMetaSearchMessenger.getParameter(template_id);
        parameters.put("userId", user_id);
        parameters.put("selected", new Boolean(is_selected));
        dispatcher.syncInvoke(OP_TEMPLATE_SELECTED, parameters);
    }

    protected static Map getParameter(long template_id) {
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("templateId", new Long(template_id));
        return parameters;
    }

    public static class templateDetails {
        public static final int ENGINE_TYPE_JSON = 1;
        public static final int ENGINE_TYPE_REGEXP = 2;
        private templateInfo info;
        private int type;
        private String name;
        private String value;

        protected templateDetails(templateInfo _info, int _type, String _name, String _value) {
            this.info = _info;
            this.type = _type;
            this.name = _name;
            this.value = _value;
        }

        public int getType() {
            return this.type;
        }

        public long getId() {
            return this.info.getId();
        }

        public long getModifiedDate() {
            return this.info.getModifiedDate();
        }

        public boolean isVisible() {
            return this.info.isVisible();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class templateInfo {
        private long id;
        private long date;
        private boolean visible;

        protected templateInfo(long _id, long _date, boolean _visible) {
            this.id = _id;
            this.date = _date;
            this.visible = _visible;
        }

        public long getId() {
            return this.id;
        }

        public long getModifiedDate() {
            return this.date;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

