/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.utils;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;

public class MomentsAgoDateFormatter {
    private static final Integer ID_YEAR = new Integer(1);
    private static final Integer ID_MONTH = new Integer(2);
    private static final Integer ID_WEEK_OF_YEAR = new Integer(3);
    private static final Integer ID_DAY = new Integer(5);
    private static final Integer ID_HOUR_OF_DAY = new Integer(11);
    private static final Integer ID_MINUTE = new Integer(12);
    private static final Integer ID_SECOND = new Integer(13);
    private static final Long MS_IN_YEAR = new Long(31536000000L);
    private static final Long MS_IN_MONTH = new Long(2678400000L);
    private static final Long MS_IN_WEEK = new Long(604800000L);
    private static final Long MS_IN_DAY = new Long(86400000L);
    private static final Long MS_IN_HOUR = new Long(3600000L);
    private static final Long MS_IN_MINUTE = new Long(60000L);
    private static final Long MS_IN_SECOND = new Long(1000L);
    private static final String AGO = " ago";
    private static final String PLURAL = "s";
    private static final Map CONVERSION_MAP = new HashMap();
    private static final Map UNIT_MAP;

    public static String getMomentsAgoString(Date pastDate, DateFormat format) {
        String timeAgo = MomentsAgoDateFormatter.getMomentsAgoString(pastDate);
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        if (timeAgo.length() > 0) {
            timeAgo = timeAgo.concat(" on ");
        }
        return timeAgo.concat(format.format(pastDate));
    }

    public static String getMomentsAgoString(Date pastDate) {
        Calendar then = Calendar.getInstance();
        then.setTime(pastDate);
        Calendar now = Calendar.getInstance();
        String result = null;
        result = MomentsAgoDateFormatter.handleUnit(then, now, ID_YEAR);
        if (result == null && (result = MomentsAgoDateFormatter.handleUnit(then, now, ID_MONTH)) == null && (result = MomentsAgoDateFormatter.handleUnit(then, now, ID_WEEK_OF_YEAR)) == null && (result = MomentsAgoDateFormatter.handleUnit(then, now, ID_DAY)) == null && (result = MomentsAgoDateFormatter.handleUnit(then, now, ID_HOUR_OF_DAY)) == null && (result = MomentsAgoDateFormatter.handleUnit(then, now, ID_MINUTE)) == null && (result = MomentsAgoDateFormatter.handleUnit(then, now, ID_SECOND)) == null) {
            result = new String();
        }
        return result;
    }

    private static String handleUnit(Calendar then, Calendar now, Integer field) {
        long comparison;
        String result = null;
        long diff = now.getTimeInMillis() - then.getTimeInMillis();
        if (diff > (comparison = ((Long)CONVERSION_MAP.get(field)).longValue())) {
            long timeAgo = diff / comparison;
            result = String.valueOf(timeAgo).concat((String)UNIT_MAP.get(field));
            if (timeAgo > 1L) {
                result = result.concat(PLURAL);
            }
            result = result.concat(AGO);
        }
        return result;
    }

    static {
        CONVERSION_MAP.put(ID_YEAR, MS_IN_YEAR);
        CONVERSION_MAP.put(ID_MONTH, MS_IN_MONTH);
        CONVERSION_MAP.put(ID_WEEK_OF_YEAR, MS_IN_WEEK);
        CONVERSION_MAP.put(ID_DAY, MS_IN_DAY);
        CONVERSION_MAP.put(ID_HOUR_OF_DAY, MS_IN_HOUR);
        CONVERSION_MAP.put(ID_MINUTE, MS_IN_MINUTE);
        CONVERSION_MAP.put(ID_SECOND, MS_IN_SECOND);
        UNIT_MAP = new HashMap();
        UNIT_MAP.put(ID_YEAR, " year");
        UNIT_MAP.put(ID_MONTH, " month");
        UNIT_MAP.put(ID_WEEK_OF_YEAR, " week");
        UNIT_MAP.put(ID_DAY, " day");
        UNIT_MAP.put(ID_HOUR_OF_DAY, " hour");
        UNIT_MAP.put(ID_MINUTE, " minute");
        UNIT_MAP.put(ID_SECOND, " second");
    }
}

