/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.monitoring.thread;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class AEThreadMonitor {
    private static boolean disable_getThreadCpuTime = false;

    public static void initialise() {
        String java_version = System.getProperty("java.runtime.version");
        disable_getThreadCpuTime = Constants.isOSX && java_version.startsWith("1.5.0_06");
        AEDiagnostics.addEvidenceGenerator(new EvidenceGenerateor());
        if (!disable_getThreadCpuTime) {
            AEThread thread = new AEThread("AEThreadMonitor"){

                public void runSupport() {
                    try {
                        try {
                            Class.forName("java.lang.management.ManagementFactory");
                            AEThreadMonitor.monitor15();
                        }
                        catch (Throwable e) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            thread.setPriority(10);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static void monitor14() {
        AEDiagnosticsLogger log = AEDiagnostics.getLogger("thread");
        int num_processors = Runtime.getRuntime().availableProcessors();
        if (num_processors < 1) {
            num_processors = 1;
        }
        log.log("Monitoring starts [1.4] (processors =" + num_processors + ")");
        block4: while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (Throwable e) {
                log.log(e);
            }
            try {
                ThreadGroup group = Thread.currentThread().getThreadGroup();
                Thread[] threads = new Thread[group.activeCount()];
                group.enumerate(threads);
                int i = 0;
                while (true) {
                    if (i >= threads.length) continue block4;
                    Thread t = threads[i];
                    if (t != null && t.getName().equals("Thread-2")) {
                        t.dumpStack();
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private static void monitor15() {
        AEDiagnosticsLogger log = AEDiagnostics.getLogger("thread");
        int num_processors = Runtime.getRuntime().availableProcessors();
        if (num_processors < 1) {
            num_processors = 1;
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        log.log("Monitoring starts (processors =" + num_processors + ")");
        if (!bean.isThreadCpuTimeSupported()) {
            log.log("ThreadCpuTime not supported");
            return;
        }
        if (!bean.isThreadCpuTimeEnabled()) {
            log.log("Enabling ThreadCpuTime");
            bean.setThreadCpuTimeEnabled(true);
        }
        HashMap last_times = new HashMap();
        long time_available = 10000L;
        while (true) {
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(time_available);
            }
            catch (Throwable e) {
                log.log(e);
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            long[] ids = bean.getAllThreadIds();
            long[] diffs = new long[ids.length];
            long total_diffs = 0L;
            long biggest_diff = 0L;
            int biggest_index = 0;
            HashMap<Long, Long> new_times = new HashMap<Long, Long>();
            for (int i = 0; i < ids.length; ++i) {
                long id = ids[i];
                long time = bean.getThreadCpuTime(id) / 1000000L;
                Long old_time = (Long)last_times.get(id);
                if (old_time != null) {
                    long diff = time - old_time;
                    if (diff > biggest_diff) {
                        biggest_diff = diff;
                        biggest_index = i;
                    }
                    diffs[i] = diff;
                    total_diffs += diff;
                }
                new_times.put(id, time);
            }
            ThreadInfo info = bean.getThreadInfo(ids[biggest_index]);
            String thread_name = info == null ? "<dead>" : info.getThreadName();
            int percent = (int)(100L * biggest_diff / time_available);
            Runtime rt = Runtime.getRuntime();
            log.log("Thread state: elapsed=" + elapsed + ",cpu=" + total_diffs + ",max=" + thread_name + "(" + biggest_diff + "/" + percent + "%),mem:max=" + rt.maxMemory() / 1024L + ",tot=" + rt.totalMemory() / 1024L + ",free=" + rt.freeMemory() / 1024L);
            if (biggest_diff > time_available / 4L) {
                info = bean.getThreadInfo(ids[biggest_index], 255);
                if (info == null) {
                    log.log("    no info for max thread");
                } else {
                    StackTraceElement[] elts = info.getStackTrace();
                    StringBuilder str = new StringBuilder(elts.length * 20);
                    str.append("    ");
                    for (int i = 0; i < elts.length; ++i) {
                        if (i != 0) {
                            str.append(", ");
                        }
                        str.append(elts[i]);
                    }
                    log.log(str.toString());
                }
            }
            last_times = new_times;
        }
    }

    public static void dumpThreads() {
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter(new PrintWriter(sw));
        AEThreadMonitor.dumpThreads(iw);
        iw.close();
        Debug.out(sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpThreads(IndentWriter writer) {
        int i;
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] allThreadIds = threadBean.getAllThreadIds();
        writer.println("Threads " + allThreadIds.length);
        writer.indent();
        ThreadInfo[] threadInfos = new ThreadInfo[allThreadIds.length];
        for (i = 0; i < allThreadIds.length; ++i) {
            threadInfos[i] = threadBean.getThreadInfo(allThreadIds[i], 32);
        }
        if (!disable_getThreadCpuTime) {
            Arrays.sort(threadInfos, new Comparator<ThreadInfo>(){

                @Override
                public int compare(ThreadInfo o1, ThreadInfo o2) {
                    long diff = threadBean.getThreadCpuTime(o2.getThreadId()) - threadBean.getThreadCpuTime(o1.getThreadId());
                    if (diff == 0L) {
                        return o1.getThreadName().compareToIgnoreCase(o2.getThreadName());
                    }
                    return diff > 0L ? 1 : -1;
                }
            });
        }
        for (i = 0; i < threadInfos.length; ++i) {
            try {
                String sState;
                long lCpuTime;
                ThreadInfo threadInfo = threadInfos[i];
                long l = lCpuTime = disable_getThreadCpuTime ? -1L : threadBean.getThreadCpuTime(threadInfo.getThreadId());
                if (lCpuTime == 0L) break;
                switch (threadInfo.getThreadState()) {
                    case BLOCKED: {
                        sState = "Blocked";
                        break;
                    }
                    case RUNNABLE: {
                        sState = "Runnable";
                        break;
                    }
                    case NEW: {
                        sState = "New";
                        break;
                    }
                    case TERMINATED: {
                        sState = "Terminated";
                        break;
                    }
                    case TIMED_WAITING: {
                        sState = "Timed Waiting";
                        break;
                    }
                    case WAITING: {
                        sState = "Waiting";
                        break;
                    }
                    default: {
                        sState = "" + (Object)((Object)threadInfo.getThreadState());
                    }
                }
                String sName = threadInfo.getThreadName();
                String sLockName = threadInfo.getLockName();
                writer.println(sName + ": " + sState + ", " + lCpuTime / 1000000L + "ms CPU, " + "B/W: " + threadInfo.getBlockedCount() + "/" + threadInfo.getWaitedCount() + (sLockName == null ? "" : "; Locked by " + sLockName + "/" + threadInfo.getLockOwnerName()));
                writer.indent();
                try {
                    StackTraceElement[] stackTrace = threadInfo.getStackTrace();
                    for (int j = 0; j < stackTrace.length; ++j) {
                        writer.println(stackTrace[j].toString());
                    }
                    continue;
                }
                finally {
                    writer.exdent();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        writer.exdent();
    }

    private static class EvidenceGenerateor
    implements AEDiagnosticsEvidenceGenerator {
        private EvidenceGenerateor() {
        }

        public void generate(IndentWriter writer) {
            AEThreadMonitor.dumpThreads(writer);
        }
    }
}

