/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.nat;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.nat.NATTraversal;
import com.aelitis.azureus.core.nat.NATTraversalException;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.PluginInterface;

public class NATTraverser
implements DHTNATPuncherAdapter {
    public static final int TRAVERSE_REASON_PEER_DATA = 1;
    public static final int TRAVERSE_REASON_GENERIC_MESSAGING = 2;
    private static final int MAX_QUEUE_SIZE = 128;
    private AzureusCore core;
    private DHTNATPuncher puncher;
    private ThreadPool thread_pool = new ThreadPool("NATTraverser", 16, true);
    private Map handlers = new HashMap();

    public NATTraverser(AzureusCore _core) {
        this.core = _core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(NATTraversalHandler handler) {
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.put(new Integer(handler.getType()), handler);
        }
    }

    public NATTraversal attemptTraversal(final NATTraversalHandler handler, final InetSocketAddress target, final Map request2, boolean sync, final NATTraversalObserver listener) {
        final NATTraversal traversal = new NATTraversal(){
            private boolean cancelled;

            public void cancel() {
                this.cancelled = true;
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
        if (sync) {
            this.syncTraverse(handler, target, request2, listener);
        } else if (this.thread_pool.getQueueSize() >= 128) {
            Debug.out("NATTraversal queue full");
            listener.failed(2);
        } else {
            this.thread_pool.run(new AERunnable(){

                public void runSupport() {
                    if (traversal.isCancelled()) {
                        listener.failed(3);
                    } else {
                        NATTraverser.this.syncTraverse(handler, target, request2, listener);
                    }
                }
            });
        }
        return traversal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncTraverse(NATTraversalHandler handler, InetSocketAddress target, Map request2, NATTraversalObserver listener) {
        try {
            int type = handler.getType();
            NATTraverser nATTraverser = this;
            synchronized (nATTraverser) {
                DHTPlugin dht_plugin;
                PluginInterface dht_pi;
                if (this.puncher == null && (dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class)) != null && (dht_plugin = (DHTPlugin)dht_pi.getPlugin()).isEnabled()) {
                    DHT dht = dht_plugin.getDHT(0);
                    if (dht == null) {
                        dht = dht_plugin.getDHT(1);
                    }
                    if (dht != null) {
                        this.puncher = dht.getNATPuncher();
                    }
                }
                if (this.puncher == null) {
                    listener.disabled();
                    return;
                }
            }
            if (request2 == null) {
                request2 = new HashMap<String, Long>();
            }
            request2.put("_travreas", new Long(type));
            InetSocketAddress[] target_a = new InetSocketAddress[]{target};
            DHTTransportContact[] rendezvous_used = new DHTTransportContact[]{null};
            Map reply = this.puncher.punch(handler.getName(), target_a, rendezvous_used, request2);
            if (reply == null) {
                if (rendezvous_used[0] == null) {
                    listener.failed(1);
                } else {
                    listener.failed(new Exception("NAT traversal failed"));
                }
            } else {
                listener.succeeded(rendezvous_used[0].getAddress(), target_a[0], reply);
            }
        }
        catch (Throwable e) {
            listener.failed(e);
        }
    }

    public Map sendMessage(NATTraversalHandler handler, InetSocketAddress rendezvous, InetSocketAddress target, Map message) throws NATTraversalException {
        if (this.puncher == null) {
            throw new NATTraversalException("Puncher unavailable");
        }
        message.put("_travreas", new Long(handler.getType()));
        Map reply = this.puncher.sendMessage(rendezvous, target, message);
        if (reply == null) {
            throw new NATTraversalException("Send message failed");
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getClientData(InetSocketAddress originator, Map originator_data) {
        Long type = (Long)originator_data.get("_travreas");
        if (type != null) {
            NATTraversalHandler handler;
            Map map = this.handlers;
            synchronized (map) {
                handler = (NATTraversalHandler)this.handlers.get(new Integer(type.intValue()));
            }
            if (handler != null) {
                return handler.process(originator, originator_data);
            }
        }
        return null;
    }
}

