/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectionAttempt;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AddressUtils;

public class ConnectionEndpoint {
    private InetSocketAddress notional_address;
    private ProtocolEndpoint[] protocols;

    public ConnectionEndpoint(InetSocketAddress _notional_address) {
        this.notional_address = _notional_address;
    }

    public InetSocketAddress getNotionalAddress() {
        return this.notional_address;
    }

    public boolean matchIP(String ip) {
        if (this.matchIP(ip, this.notional_address)) {
            return true;
        }
        ProtocolEndpoint[] peps = this.getProtocols();
        for (int i = 0; i < peps.length; ++i) {
            ProtocolEndpoint tcp;
            ProtocolEndpoint pep = peps[i];
            if (!(pep.getType() == 1 ? this.matchIP(ip, ((ProtocolEndpointTCP)(tcp = (ProtocolEndpointTCP)pep)).getAddress()) : this.matchIP(ip, ((ProtocolEndpointUDP)(tcp = (ProtocolEndpointUDP)pep)).getAddress()))) continue;
            return true;
        }
        return false;
    }

    protected boolean matchIP(String ip, InetSocketAddress address) {
        return ip.equals(address.getAddress().getHostAddress());
    }

    public ProtocolEndpoint[] getProtocols() {
        if (this.protocols == null) {
            return new ProtocolEndpoint[0];
        }
        return this.protocols;
    }

    public void addProtocol(ProtocolEndpoint ep) {
        if (this.protocols == null) {
            this.protocols = new ProtocolEndpoint[]{ep};
        } else {
            for (int i = 0; i < this.protocols.length; ++i) {
                if (this.protocols[i] != ep) continue;
                return;
            }
            ProtocolEndpoint[] new_ep = new ProtocolEndpoint[this.protocols.length + 1];
            System.arraycopy(this.protocols, 0, new_ep, 0, this.protocols.length);
            new_ep[this.protocols.length] = ep;
            this.protocols = new_ep;
        }
        ep.setConnectionEndpoint(this);
    }

    public ConnectionEndpoint getLANAdjustedEndpoint() {
        ConnectionEndpoint result = new ConnectionEndpoint(this.notional_address);
        for (int i = 0; i < this.protocols.length; ++i) {
            InetSocketAddress address;
            ProtocolEndpoint ep = this.protocols[i];
            if (ep.getType() == 1) {
                ProtocolEndpointTCP tcp = (ProtocolEndpointTCP)ep;
                address = AddressUtils.adjustTCPAddress(tcp.getAddress(), true);
                new ProtocolEndpointTCP(result, address);
                continue;
            }
            if (ep.getType() == 2) {
                ProtocolEndpointUDP udp = (ProtocolEndpointUDP)ep;
                address = AddressUtils.adjustUDPAddress(udp.getAddress(), true);
                new ProtocolEndpointUDP(result, address);
                continue;
            }
            result.addProtocol(ep);
        }
        return result;
    }

    public ConnectionAttempt connectOutbound(boolean connect_with_crypto, boolean allow_fallback, byte[][] shared_secrets, ByteBuffer initial_data, int priority, Transport.ConnectListener listener) {
        ProtocolEndpoint protocol = this.protocols[0];
        final Transport transport = protocol.connectOutbound(connect_with_crypto, allow_fallback, shared_secrets, initial_data, priority, listener);
        return new ConnectionAttempt(){

            public void abandon() {
                if (transport != null) {
                    transport.close("Connection attempt abandoned");
                }
            }
        };
    }

    public String getDescription() {
        String str = "[";
        for (int i = 0; i < this.protocols.length; ++i) {
            str = str + (i == 0 ? "" : ",") + this.protocols[i].getDescription();
        }
        return str + "]";
    }
}

