/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class ByteBucketST
implements ByteBucket {
    private int rate;
    private int burst_rate;
    private long avail_bytes;
    private long prev_update_time;

    public ByteBucketST(int rate_bytes_per_sec) {
        this(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    private ByteBucketST(int rate_bytes_per_sec, int burst_rate) {
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        this.avail_bytes = 0L;
        this.prev_update_time = SystemTime.getCurrentTime();
        this.ensureByteBucketMinBurstRate();
    }

    public int getAvailableByteCount() {
        if (this.avail_bytes < 0x6400000L) {
            this.update_avail_byte_count();
        }
        return (int)this.avail_bytes;
    }

    public void setBytesUsed(int bytes_used) {
        if (this.avail_bytes >= 0x6400000L) {
            return;
        }
        this.avail_bytes -= (long)bytes_used;
        if (this.avail_bytes < 0L) {
            Debug.out("avail_bytes < 0: " + this.avail_bytes);
        }
    }

    public int getRate() {
        return this.rate;
    }

    public int getBurstRate() {
        return this.burst_rate;
    }

    public void setRate(int rate_bytes_per_sec) {
        this.setRate(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    public void setRate(int rate_bytes_per_sec, int burst_rate) {
        if (rate_bytes_per_sec < 0) {
            Debug.out("rate_bytes_per_sec [" + rate_bytes_per_sec + "] < 0");
            rate_bytes_per_sec = 0;
        }
        if (burst_rate < rate_bytes_per_sec) {
            Debug.out("burst_rate [" + burst_rate + "] < rate_bytes_per_sec [" + rate_bytes_per_sec + "]");
            burst_rate = rate_bytes_per_sec;
        }
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        if (this.avail_bytes > (long)burst_rate) {
            this.avail_bytes = burst_rate;
        }
        this.ensureByteBucketMinBurstRate();
    }

    private void update_avail_byte_count() {
        long now = SystemTime.getCurrentTime();
        if (this.prev_update_time < now) {
            this.avail_bytes += (now - this.prev_update_time) * (long)this.rate / 1000L;
            this.prev_update_time = now;
            if (this.avail_bytes > (long)this.burst_rate) {
                this.avail_bytes = this.burst_rate;
            } else if (this.avail_bytes < 0L) {
                Debug.out("ERROR: avail_bytes < 0: " + this.avail_bytes);
            }
        } else if (this.prev_update_time > now) {
            this.avail_bytes = this.burst_rate;
            this.prev_update_time = now;
        }
    }

    private void ensureByteBucketMinBurstRate() {
        int mss = NetworkManager.getMinMssSize();
        if (this.burst_rate < mss) {
            this.burst_rate = mss;
        }
    }
}

