/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.ConnectionAttempt;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionHelper;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportBase;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.IncomingMessageQueueImpl;
import com.aelitis.azureus.core.networkmanager.impl.OutgoingMessageQueueImpl;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkConnectionImpl
extends NetworkConnectionHelper
implements NetworkConnection {
    private final ConnectionEndpoint connection_endpoint;
    private boolean connect_with_crypto;
    private boolean allow_fallback;
    private byte[][] shared_secrets;
    private NetworkConnection.ConnectionListener connection_listener;
    private boolean is_connected;
    private byte is_lan_local = 0;
    private final OutgoingMessageQueueImpl outgoing_message_queue;
    private final IncomingMessageQueueImpl incoming_message_queue;
    private Transport transport;
    private volatile ConnectionAttempt connection_attempt;
    private volatile boolean closed;

    public NetworkConnectionImpl(ConnectionEndpoint _target, MessageStreamEncoder encoder, MessageStreamDecoder decoder, boolean _connect_with_crypto, boolean _allow_fallback, byte[][] _shared_secrets) {
        this.connection_endpoint = _target;
        this.connect_with_crypto = _connect_with_crypto;
        this.allow_fallback = _allow_fallback;
        this.shared_secrets = _shared_secrets;
        this.is_connected = false;
        this.outgoing_message_queue = new OutgoingMessageQueueImpl(encoder);
        this.incoming_message_queue = new IncomingMessageQueueImpl(decoder, this);
    }

    public NetworkConnectionImpl(Transport _transport, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        this.transport = _transport;
        this.connection_endpoint = this.transport.getTransportEndpoint().getProtocolEndpoint().getConnectionEndpoint();
        this.is_connected = true;
        this.outgoing_message_queue = new OutgoingMessageQueueImpl(encoder);
        this.outgoing_message_queue.setTransport(this.transport);
        this.incoming_message_queue = new IncomingMessageQueueImpl(decoder, this);
    }

    public ConnectionEndpoint getEndpoint() {
        return this.connection_endpoint;
    }

    public void connect(int priority, NetworkConnection.ConnectionListener listener) {
        this.connect(null, priority, listener);
    }

    public void connect(ByteBuffer initial_outbound_data, int priority, NetworkConnection.ConnectionListener listener) {
        ConnectionAttempt ca;
        this.connection_listener = listener;
        if (this.is_connected) {
            this.connection_listener.connectStarted();
            this.connection_listener.connectSuccess(initial_outbound_data);
            return;
        }
        if (this.connection_attempt != null) {
            Debug.out("Connection attempt already active");
            listener.connectFailure(new Throwable("Connection attempt already active"));
            return;
        }
        this.connection_attempt = this.connection_endpoint.connectOutbound(this.connect_with_crypto, this.allow_fallback, this.shared_secrets, initial_outbound_data, priority, new Transport.ConnectListener(){

            public void connectAttemptStarted() {
                NetworkConnectionImpl.this.connection_listener.connectStarted();
            }

            public void connectSuccess(Transport _transport, ByteBuffer remaining_initial_data) {
                NetworkConnectionImpl.this.is_connected = true;
                NetworkConnectionImpl.this.transport = _transport;
                NetworkConnectionImpl.this.outgoing_message_queue.setTransport(NetworkConnectionImpl.this.transport);
                NetworkConnectionImpl.this.connection_listener.connectSuccess(remaining_initial_data);
                NetworkConnectionImpl.this.connection_attempt = null;
            }

            public void connectFailure(Throwable failure_msg) {
                NetworkConnectionImpl.this.is_connected = false;
                NetworkConnectionImpl.this.connection_listener.connectFailure(failure_msg);
            }
        });
        if (this.closed && (ca = this.connection_attempt) != null) {
            ca.abandon();
        }
    }

    public Transport detachTransport() {
        Transport t = this.transport;
        this.transport = new bogusTransport(this.transport);
        this.close();
        return t;
    }

    public void close() {
        NetworkManager.getSingleton().stopTransferProcessing(this);
        this.closed = true;
        if (this.connection_attempt != null) {
            this.connection_attempt.abandon();
        }
        if (this.transport != null) {
            this.transport.close("Tidy close");
        }
        this.incoming_message_queue.destroy();
        this.outgoing_message_queue.destroy();
        this.is_connected = false;
    }

    public void notifyOfException(Throwable error) {
        if (this.connection_listener != null) {
            this.connection_listener.exceptionThrown(error);
        } else {
            Debug.out("notifyOfException():: connection_listener == null for exception: " + error.getMessage());
        }
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    public void startMessageProcessing() {
        NetworkManager.getSingleton().startTransferProcessing(this);
    }

    public void enableEnhancedMessageProcessing(boolean enable, int partition_id) {
        if (enable) {
            NetworkManager.getSingleton().upgradeTransferProcessing(this, partition_id);
        } else {
            NetworkManager.getSingleton().downgradeTransferProcessing(this);
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public TransportBase getTransportBase() {
        return this.transport;
    }

    public int getMssSize() {
        if (this.transport == null) {
            return NetworkManager.getMinMssSize();
        }
        return this.transport.getMssSize();
    }

    public String toString() {
        return this.transport == null ? this.connection_endpoint.getDescription() : this.transport.getDescription();
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    public boolean isLANLocal() {
        if (this.is_lan_local == 0) {
            this.is_lan_local = AddressUtils.isLANLocalAddress(this.connection_endpoint.getNotionalAddress());
        }
        return this.is_lan_local == 1;
    }

    public String getString() {
        return "tran=" + (this.transport == null ? "null" : this.transport.getDescription() + ",w_ready=" + this.transport.isReadyForWrite(null) + ",r_ready=" + this.transport.isReadyForRead(null)) + ",in=" + this.incoming_message_queue.getPercentDoneOfCurrentMessage() + ",out=" + (this.outgoing_message_queue == null ? 0 : this.outgoing_message_queue.getTotalSize()) + ",owner=" + (this.connection_listener == null ? "null" : this.connection_listener.getDescription());
    }

    protected static class bogusTransport
    implements Transport {
        private Transport transport;

        protected bogusTransport(Transport _transport) {
            this.transport = _transport;
        }

        public boolean isReadyForWrite(EventWaiter waiter) {
            return false;
        }

        public long isReadyForRead(EventWaiter waiter) {
            return Long.MAX_VALUE;
        }

        public boolean isTCP() {
            return this.transport.isTCP();
        }

        public String getDescription() {
            return this.transport.getDescription();
        }

        public int getMssSize() {
            return this.transport.getMssSize();
        }

        public void setAlreadyRead(ByteBuffer bytes_already_read) {
            Debug.out("Bogus Transport Operation");
        }

        public TransportEndpoint getTransportEndpoint() {
            return this.transport.getTransportEndpoint();
        }

        public boolean isEncrypted() {
            return this.transport.isEncrypted();
        }

        public String getEncryption(boolean verbose) {
            return this.transport.getEncryption(verbose);
        }

        public void setReadyForRead() {
            Debug.out("Bogus Transport Operation");
        }

        public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
            Debug.out("Bogus Transport Operation");
            throw new IOException("Bogus transport!");
        }

        public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
            Debug.out("Bogus Transport Operation");
            throw new IOException("Bogus transport!");
        }

        public void setTransportMode(int mode) {
            Debug.out("Bogus Transport Operation");
        }

        public int getTransportMode() {
            return this.transport.getTransportMode();
        }

        public void connectOutbound(ByteBuffer initial_data, Transport.ConnectListener listener, int priority) {
            Debug.out("Bogus Transport Operation");
            listener.connectFailure(new Throwable("Bogus Transport"));
        }

        public void connectedInbound() {
            Debug.out("Bogus Transport Operation");
        }

        public void close(String reason) {
        }

        public void setTrace(boolean on) {
        }
    }
}

