/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class WriteController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private static boolean AGGRESIVE_WRITE = false;
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private int aggressive_np_normal_priority_count;
    private int aggressive_np_high_priority_count;
    private long wait_count;
    private long progress_count;
    private long non_progress_count;
    private EventWaiter write_waiter = new EventWaiter();
    private int entity_count = 0;

    public WriteController() {
        AEThread write_processor_thread = new AEThread("WriteController:WriteProcessor"){

            public void runSupport() {
                WriteController.this.writeProcessorLoop();
            }
        };
        write_processor_thread.setDaemon(true);
        write_processor_thread.setPriority(9);
        write_processor_thread.start();
        HashSet<String> types = new HashSet<String>();
        types.add("net.write.control.wait.count");
        types.add("net.write.control.np.count");
        types.add("net.write.control.p.count");
        types.add("net.write.control.entity.count");
        types.add("net.write.control.con.count");
        types.add("net.write.control.ready.con.count");
        types.add("net.write.control.ready.byte.count");
        AzureusCoreStats.registerProvider(types, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter writer) {
                writer.println("Write Controller");
                try {
                    RateControlledEntity entity;
                    int i;
                    writer.indent();
                    ArrayList ref = WriteController.this.normal_priority_entities;
                    writer.println("normal - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    ref = WriteController.this.high_priority_entities;
                    writer.println("priority - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                }
                finally {
                    writer.exdent();
                }
            }
        });
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("net.write.control.wait.count")) {
            values.put("net.write.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("net.write.control.np.count")) {
            values.put("net.write.control.np.count", new Long(this.non_progress_count));
        }
        if (types.contains("net.write.control.p.count")) {
            values.put("net.write.control.p.count", new Long(this.progress_count));
        }
        if (types.contains("net.write.control.entity.count")) {
            values.put("net.write.control.entity.count", new Long(this.high_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (types.contains("net.write.control.con.count") || types.contains("net.write.control.ready.con.count") || types.contains("net.write.control.ready.byte.count")) {
            long ready_bytes = 0L;
            int ready_connections = 0;
            int connections = 0;
            ArrayList[] refs = new ArrayList[]{this.normal_priority_entities, this.high_priority_entities};
            for (int i = 0; i < refs.length; ++i) {
                ArrayList ref = refs[i];
                for (int j = 0; j < ref.size(); ++j) {
                    RateControlledEntity entity = (RateControlledEntity)ref.get(j);
                    connections += entity.getConnectionCount();
                    ready_connections += entity.getReadyConnectionCount(this.write_waiter);
                    ready_bytes += entity.getBytesReadyToWrite();
                }
            }
            values.put("net.write.control.con.count", new Long(connections));
            values.put("net.write.control.ready.con.count", new Long(ready_connections));
            values.put("net.write.control.ready.byte.count", new Long(ready_bytes));
        }
    }

    private void writeProcessorLoop() {
        boolean check_high_first = true;
        while (true) {
            try {
                while (true) {
                    if (check_high_first) {
                        check_high_first = false;
                        if (this.doHighPriorityWrite() || this.doNormalPriorityWrite() || !this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                        ++this.wait_count;
                        continue;
                    }
                    check_high_first = true;
                    if (this.doNormalPriorityWrite() || this.doHighPriorityWrite() || !this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                    ++this.wait_count;
                }
            }
            catch (Throwable t) {
                Debug.out("writeProcessorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityWrite() {
        RateControlledEntity ready_entity = this.getNextReadyNormalPriorityEntity();
        if (ready_entity != null) {
            if (ready_entity.doProcessing(this.write_waiter)) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_normal_priority_count;
                if (this.aggressive_np_normal_priority_count < this.normal_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_normal_priority_count = 0;
            }
        }
        return false;
    }

    private boolean doHighPriorityWrite() {
        RateControlledEntity ready_entity = this.getNextReadyHighPriorityEntity();
        if (ready_entity != null) {
            if (ready_entity.doProcessing(this.write_waiter)) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_high_priority_count;
                if (this.aggressive_np_high_priority_count < this.high_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_high_priority_count = 0;
            }
        }
        return false;
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList ref = this.normal_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_normal_position = this.next_normal_position >= size ? 0 : this.next_normal_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!entity.canProcess(this.write_waiter)) continue;
            return entity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.write_waiter)) continue;
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList high_new = new ArrayList(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList norm_new = new ArrayList(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
    }

    public int getEntityCount() {
        return this.entity_count;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.write.idle.time", "network.control.write.aggressive"}, new ParameterListener(){

            public void parameterChanged(String name) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.write.idle.time");
                AGGRESIVE_WRITE = COConfigurationManager.getBooleanParameter("network.control.write.aggressive");
            }
        });
    }
}

