/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportImpl
extends TransportImpl
implements Transport {
    private static final LogIDs LOGID = LogIDs.NET;
    protected ProtocolEndpointTCP protocol_endpoint;
    private TCPConnectionManager.ConnectListener connect_request_key = null;
    private String description = "<disconnected>";
    private final boolean is_inbound_connection;
    private int transport_mode = 0;
    public volatile boolean has_been_closed = false;
    private boolean connect_with_crypto;
    private byte[][] shared_secrets;
    private int fallback_count;
    private final boolean fallback_allowed;

    public TCPTransportImpl(ProtocolEndpointTCP endpoint, boolean use_crypto, boolean allow_fallback, byte[][] _shared_secrets) {
        this.protocol_endpoint = endpoint;
        this.is_inbound_connection = false;
        this.connect_with_crypto = use_crypto;
        this.shared_secrets = _shared_secrets;
        this.fallback_allowed = allow_fallback;
    }

    public TCPTransportImpl(ProtocolEndpointTCP endpoint, TransportHelperFilter filter) {
        this.protocol_endpoint = endpoint;
        this.setFilter(filter);
        this.is_inbound_connection = true;
        this.connect_with_crypto = false;
        this.fallback_allowed = false;
        this.description = (this.is_inbound_connection ? "R" : "L") + ": " + this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    public SocketChannel getSocketChannel() {
        TransportHelperFilter filter = this.getFilter();
        if (filter == null) {
            return null;
        }
        TCPTransportHelper helper = (TCPTransportHelper)filter.getHelper();
        if (helper == null) {
            return null;
        }
        return helper.getSocketChannel();
    }

    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointTCP(this.protocol_endpoint, this.getSocketChannel());
    }

    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    public boolean isTCP() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void connectOutbound(final ByteBuffer initial_data, final Transport.ConnectListener listener, final int priority) {
        TCPConnectionManager.ConnectListener connect_listener;
        if (!TCPNetworkManager.TCP_OUTGOING_ENABLED) {
            listener.connectFailure(new Throwable("Outbound TCP connections disabled"));
            return;
        }
        if (this.has_been_closed) {
            return;
        }
        if (this.getFilter() != null) {
            Debug.out("socket_channel != null");
            listener.connectSuccess(this, initial_data);
            return;
        }
        final boolean use_proxy = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable");
        final TCPTransportImpl transport_instance = this;
        final InetSocketAddress address = this.protocol_endpoint.getAddress();
        this.connect_request_key = connect_listener = new TCPConnectionManager.ConnectListener(){

            public void connectAttemptStarted() {
                listener.connectAttemptStarted();
            }

            public void connectSuccess(final SocketChannel channel2) {
                if (channel2 == null) {
                    String msg = "connectSuccess:: given channel == null";
                    Debug.out(msg);
                    listener.connectFailure(new Exception(msg));
                    return;
                }
                if (TCPTransportImpl.this.has_been_closed) {
                    TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel2);
                    return;
                }
                TCPTransportImpl.this.connect_request_key = null;
                TCPTransportImpl.this.description = (TCPTransportImpl.this.is_inbound_connection ? "R" : "L") + ": " + channel2.socket().getInetAddress().getHostAddress() + ": " + channel2.socket().getPort();
                if (use_proxy) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Socket connection established to proxy server [" + TCPTransportImpl.this.description + "], login initiated..."));
                    }
                    TCPTransportImpl.this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel2));
                    new ProxyLoginHandler(transport_instance, address, new ProxyLoginHandler.ProxyListener(){

                        public void connectSuccess() {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Proxy [" + TCPTransportImpl.this.description + "] login successful."));
                            }
                            TCPTransportImpl.this.handleCrypto(address, channel2, initial_data, priority, listener);
                        }

                        public void connectFailure(Throwable failure_msg) {
                            TCPTransportImpl.this.close("Proxy login failed");
                            listener.connectFailure(failure_msg);
                        }
                    });
                } else {
                    TCPTransportImpl.this.handleCrypto(address, channel2, initial_data, priority, listener);
                }
            }

            public void connectFailure(Throwable failure_msg) {
                TCPTransportImpl.this.connect_request_key = null;
                listener.connectFailure(failure_msg);
            }
        };
        InetSocketAddress to_connect = use_proxy ? ProxyLoginHandler.DEFAULT_SOCKS_SERVER_ADDRESS : address;
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(to_connect, connect_listener, priority);
    }

    protected void handleCrypto(InetSocketAddress address, final SocketChannel channel2, final ByteBuffer initial_data, final int priority, final Transport.ConnectListener listener) {
        if (this.connect_with_crypto) {
            final TCPTransportHelper helper = new TCPTransportHelper(channel2);
            TransportCryptoManager.getSingleton().manageCrypto(helper, this.shared_secrets, false, initial_data, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    TransportHelperFilter filter = decoder.getFilter();
                    TCPTransportImpl.this.setFilter(filter);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel2.socket().getRemoteSocketAddress() + " established, type = " + filter.getName(false)));
                    }
                    TCPTransportImpl.this.connectedOutbound(remaining_initial_data, listener);
                }

                public void handshakeFailure(Throwable failure_msg) {
                    if (TCPTransportImpl.this.fallback_allowed && NetworkManager.OUTGOING_HANDSHAKE_FALLBACK_ALLOWED && !TCPTransportImpl.this.has_been_closed) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, TCPTransportImpl.this.description + " | crypto handshake failure [" + failure_msg.getMessage() + "], attempting non-crypto fallback."));
                        }
                        TCPTransportImpl.this.connect_with_crypto = false;
                        TCPTransportImpl.this.fallback_count++;
                        TCPTransportImpl.this.close(helper, "Handshake failure and retry");
                        TCPTransportImpl.this.has_been_closed = false;
                        if (initial_data != null) {
                            initial_data.position(0);
                        }
                        TCPTransportImpl.this.connectOutbound(initial_data, listener, priority);
                    } else {
                        TCPTransportImpl.this.close(helper, "Handshake failure");
                        listener.connectFailure(failure_msg);
                    }
                }

                public void gotSecret(byte[] session_secret) {
                }

                public int getMaximumPlainHeaderLength() {
                    throw new RuntimeException();
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    throw new RuntimeException();
                }
            });
        } else {
            this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel2));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel2.socket().getRemoteSocketAddress() + " established, type = " + this.getFilter().getName(false) + ", fallback = " + (this.fallback_count == 0 ? "no" : "yes")));
            }
            this.connectedOutbound(initial_data, listener);
        }
    }

    private void setTransportBuffersSize(int size_in_bytes) {
        if (this.getFilter() == null) {
            Debug.out("socket_channel == null");
            return;
        }
        try {
            SocketChannel channel2 = this.getSocketChannel();
            channel2.socket().setSendBufferSize(size_in_bytes);
            channel2.socket().setReceiveBufferSize(size_in_bytes);
            int snd_real = channel2.socket().getSendBufferSize();
            int rcv_real = channel2.socket().getReceiveBufferSize();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Setting new transport [" + this.description + "] buffer sizes: SND=" + size_in_bytes + " [" + snd_real + "] , RCV=" + size_in_bytes + " [" + rcv_real + "]"));
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void setTransportMode(int mode) {
        if (mode == this.transport_mode) {
            return;
        }
        switch (mode) {
            case 0: {
                this.setTransportBuffersSize(8192);
                break;
            }
            case 1: {
                this.setTransportBuffersSize(65536);
                break;
            }
            case 2: {
                this.setTransportBuffersSize(524288);
                break;
            }
            default: {
                Debug.out("invalid transport mode given: " + mode);
            }
        }
        this.transport_mode = mode;
    }

    protected void connectedOutbound(ByteBuffer remaining_initial_data, Transport.ConnectListener listener) {
        if (this.has_been_closed) {
            TransportHelperFilter filter = this.getFilter();
            if (filter != null) {
                filter.getHelper().close("Connection closed");
                this.setFilter(null);
            }
            listener.connectFailure(new Throwable("Connection closed"));
        } else {
            this.connectedOutbound();
            listener.connectSuccess(this, remaining_initial_data);
        }
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    protected void close(TransportHelper helper, String reason) {
        helper.close(reason);
        this.close(reason);
    }

    public void close(String reason) {
        this.has_been_closed = true;
        if (this.connect_request_key != null) {
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().cancelRequest(this.connect_request_key);
        }
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter filter = this.getFilter();
        if (filter != null) {
            filter.getHelper().close(reason);
            this.setFilter(null);
        }
        this.setReadyForRead();
    }
}

