/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peer.cache;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.peer.cache.CacheDiscoverer;
import com.aelitis.azureus.core.peer.cache.CachePeer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.SystemTime;

public class CacheDiscovery {
    private static final IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private static final CacheDiscoverer[] discoverers = new CacheDiscoverer[0];
    private static Set<String> cache_ips = Collections.synchronizedSet(new HashSet());

    public static void initialise(final DownloadManagerEnhancer dme) {
        ip_filter.addListener(new IPFilterListener(){

            public boolean canIPBeBanned(String ip) {
                return CacheDiscovery.canBan(ip);
            }

            public void IPBanned(BannedIp ip) {
            }

            public void IPBlockedListChanged(IpFilter filter) {
            }

            public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
                EnhancedDownloadManager dm = dme.getEnhancedDownload(torrent_hash);
                if (dm == null) {
                    return true;
                }
                if (dm.isPlatform()) {
                    return CacheDiscovery.canBan(ip);
                }
                return true;
            }
        });
        new AEThread2("CacheDiscovery:ban checker", true){

            public void run() {
                BannedIp[] bans = ip_filter.getBannedIps();
                for (int i = 0; i < bans.length; ++i) {
                    String ip = bans[i].getIp();
                    if (CacheDiscovery.canBan(ip)) continue;
                    ip_filter.unban(ip);
                }
            }
        }.start();
    }

    private static boolean canBan(String ip) {
        if (cache_ips.contains(ip)) {
            return false;
        }
        try {
            InetAddress address = HostNameToIPResolver.syncResolve(ip);
            final String host_address = address.getHostAddress();
            if (cache_ips.contains(host_address)) {
                return false;
            }
            IPToHostNameResolver.addResolverRequest(ip, new IPToHostNameResolverListener(){

                public void IPResolutionComplete(String result, boolean succeeded) {
                    if (Constants.isAzureusDomain(result)) {
                        cache_ips.add(host_address);
                        ip_filter.unban(host_address, true);
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return true;
        }
    }

    public static CachePeer[] lookup(TOTorrent torrent) {
        CachePeer[] res;
        if (discoverers.length == 0) {
            res = new CachePeer[]{};
        } else if (discoverers.length == 1) {
            res = discoverers[0].lookup(torrent);
        } else {
            ArrayList<CachePeer> result = new ArrayList<CachePeer>();
            for (int i = 0; i < discoverers.length; ++i) {
                CachePeer[] peers = discoverers[i].lookup(torrent);
                for (int j = 0; j < peers.length; ++j) {
                    result.add(peers[i]);
                }
            }
            res = result.toArray(new CachePeer[result.size()]);
        }
        for (int i = 0; i < res.length; ++i) {
            String ip = res[i].getAddress().getHostAddress();
            cache_ips.add(ip);
            ip_filter.unban(ip);
        }
        return res;
    }

    public static CachePeer categorisePeer(byte[] peer_id, InetAddress ip, int port) {
        for (int i = 0; i < discoverers.length; ++i) {
            CachePeer cp = discoverers[i].lookup(peer_id, ip, port);
            if (cp == null) continue;
            return cp;
        }
        return new CachePeerImpl(1, ip, port);
    }

    public static class CachePeerImpl
    implements CachePeer {
        private int type;
        private InetAddress address;
        private int port;
        private long create_time;
        private long inject_time;
        private long speed_change_time;
        private boolean auto_reconnect = true;

        public CachePeerImpl(int _type, InetAddress _address, int _port) {
            this.type = _type;
            this.address = _address;
            this.port = _port;
            this.create_time = SystemTime.getCurrentTime();
        }

        public int getType() {
            return this.type;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public long getCreateTime(long now) {
            if (this.create_time > now) {
                this.create_time = now;
            }
            return this.create_time;
        }

        public long getInjectTime(long now) {
            if (this.inject_time > now) {
                this.inject_time = now;
            }
            return this.inject_time;
        }

        public void setInjectTime(long time) {
            this.inject_time = time;
        }

        public long getSpeedChangeTime(long now) {
            if (this.speed_change_time > now) {
                this.speed_change_time = now;
            }
            return this.speed_change_time;
        }

        public void setSpeedChangeTime(long time) {
            this.speed_change_time = time;
        }

        public boolean getAutoReconnect() {
            return this.auto_reconnect;
        }

        public void setAutoReconnect(boolean auto) {
            this.auto_reconnect = auto;
        }

        public boolean sameAs(CachePeer other) {
            return this.getType() == other.getType() && this.getAddress().getHostAddress().equals(other.getAddress().getHostAddress()) && this.getPort() == other.getPort();
        }

        public String getString() {
            return "type=" + this.getType() + ",address=" + this.getAddress() + ",port=" + this.getPort();
        }
    }
}

