/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZMessageDecoder
implements MessageStreamDecoder {
    private static final int MIN_MESSAGE_LENGTH = 6;
    private static final int MAX_MESSAGE_LENGTH = 131072;
    private static final byte SS = 11;
    private DirectByteBuffer payload_buffer = null;
    private final DirectByteBuffer length_buffer = DirectByteBufferPool.getBuffer((byte)12, 4);
    private final ByteBuffer[] decode_array = new ByteBuffer[]{null, this.length_buffer.getBuffer((byte)11)};
    private boolean reading_length_mode = true;
    private int message_length;
    private int pre_read_start_buffer;
    private int pre_read_start_position;
    private volatile boolean destroyed = false;
    private volatile boolean is_paused = false;
    private ArrayList messages_last_read = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private int percent_complete = -1;
    private byte[] msg_id_bytes = null;
    private boolean msg_id_read_complete = false;
    private boolean last_read_made_progress;
    private int maximum_message_size = 131072;

    public void setMaximumMessageSize(int max_bytes) {
        this.maximum_message_size = max_bytes;
    }

    public int performStreamDecode(Transport transport, int max_bytes) throws IOException {
        int bytes_remaining;
        int bytes_read;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (bytes_remaining = max_bytes; bytes_remaining > 0 && !this.destroyed; bytes_remaining -= bytes_read) {
            if (this.is_paused) {
                Debug.out("AZ decoder paused");
                break;
            }
            int bytes_possible = this.preReadProcess(bytes_remaining);
            if (bytes_possible < 1) {
                Debug.out("ERROR AZ: bytes_possible < 1");
                break;
            }
            long actual_read = this.reading_length_mode ? transport.read(this.decode_array, 1, 1) : transport.read(this.decode_array, 0, 2);
            this.last_read_made_progress = actual_read > 0L;
            bytes_read = this.postReadProcess();
            if (bytes_read >= bytes_possible) continue;
            break;
        }
        return max_bytes - bytes_remaining;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages_last_read.isEmpty()) {
            return null;
        }
        Message[] msgs = this.messages_last_read.toArray(new Message[this.messages_last_read.size()]);
        this.messages_last_read.clear();
        return msgs;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public boolean getLastReadMadeProgress() {
        return this.last_read_made_progress;
    }

    public ByteBuffer destroy() {
        this.is_paused = true;
        this.destroyed = true;
        this.length_buffer.returnToPool();
        if (this.payload_buffer != null) {
            this.payload_buffer.returnToPool();
            this.payload_buffer = null;
        }
        try {
            for (int i = 0; i < this.messages_last_read.size(); ++i) {
                Message msg = (Message)this.messages_last_read.get(i);
                msg.destroy();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.messages_last_read.clear();
        return null;
    }

    private int preReadProcess(int allowed) {
        if (allowed < 1) {
            Debug.out("allowed < 1");
        }
        this.decode_array[0] = this.payload_buffer == null ? null : this.payload_buffer.getBuffer((byte)11);
        int bytes_available = 0;
        boolean shrink_remaining_buffers = false;
        int start_buff = this.reading_length_mode ? 1 : 0;
        boolean marked = false;
        for (int i = start_buff; i < 2; ++i) {
            ByteBuffer bb = this.decode_array[i];
            if (bb == null) {
                Debug.out("preReadProcess:: bb[" + i + "] == null, decoder destroyed=" + this.destroyed);
            }
            if (shrink_remaining_buffers) {
                bb.limit(0);
                continue;
            }
            int remaining = bb.remaining();
            if (remaining < 1) continue;
            if (!marked) {
                this.pre_read_start_buffer = i;
                this.pre_read_start_position = bb.position();
                marked = true;
            }
            if (remaining > allowed) {
                bb.limit(bb.position() + allowed);
                bytes_available += bb.remaining();
                shrink_remaining_buffers = true;
                continue;
            }
            bytes_available += remaining;
            allowed -= remaining;
        }
        return bytes_available;
    }

    private int postReadProcess() throws IOException {
        int prot_bytes_read = 0;
        int data_bytes_read = 0;
        if (!this.reading_length_mode && !this.destroyed) {
            this.payload_buffer.limit((byte)11, this.message_length);
            this.length_buffer.limit((byte)11, 4);
            int curr_position = this.payload_buffer.position((byte)11);
            int read = curr_position - this.pre_read_start_position;
            if (this.msg_id_bytes == null && curr_position >= 4) {
                this.payload_buffer.position((byte)11, 0);
                int id_size = this.payload_buffer.getInt((byte)11);
                this.payload_buffer.position((byte)11, curr_position);
                if (id_size < 1 || id_size > 1024) {
                    throw new IOException("invalid id_size [" + id_size + "]");
                }
                this.msg_id_bytes = new byte[id_size];
            }
            if (this.msg_id_bytes != null && curr_position >= this.msg_id_bytes.length + 4) {
                Message message;
                if (!this.msg_id_read_complete) {
                    this.payload_buffer.position((byte)11, 4);
                    this.payload_buffer.get((byte)11, this.msg_id_bytes);
                    this.payload_buffer.position((byte)11, curr_position);
                    this.msg_id_read_complete = true;
                }
                if ((message = MessageManager.getSingleton().lookupMessage(this.msg_id_bytes)) == null) {
                    Debug.out("Unknown message type '" + new String(this.msg_id_bytes) + "'");
                    throw new IOException("Unknown message type");
                }
                if (message.getType() == 1) {
                    data_bytes_read += read;
                } else {
                    prot_bytes_read += read;
                }
            } else {
                prot_bytes_read += read;
            }
            if (!this.payload_buffer.hasRemaining((byte)11) && !this.is_paused) {
                this.payload_buffer.position((byte)11, 0);
                DirectByteBuffer ref_buff = this.payload_buffer;
                this.payload_buffer = null;
                try {
                    Message msg = AZMessageFactory.createAZMessage(ref_buff);
                    this.messages_last_read.add(msg);
                }
                catch (Throwable e) {
                    ref_buff.returnToPoolIfNotFree();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IOException("AZ message decode failed: " + e.getMessage());
                }
                this.reading_length_mode = true;
                this.percent_complete = -1;
                this.msg_id_bytes = null;
                this.msg_id_read_complete = false;
            } else {
                this.percent_complete = this.payload_buffer.position((byte)11) * 100 / this.message_length;
            }
        }
        if (this.reading_length_mode && !this.destroyed) {
            this.length_buffer.limit((byte)11, 4);
            prot_bytes_read += this.pre_read_start_buffer == 1 ? this.length_buffer.position((byte)11) - this.pre_read_start_position : this.length_buffer.position((byte)11);
            if (!this.length_buffer.hasRemaining((byte)11)) {
                this.reading_length_mode = false;
                this.length_buffer.position((byte)11, 0);
                this.message_length = this.length_buffer.getInt((byte)11);
                this.length_buffer.position((byte)11, 0);
                if (this.message_length < 6 || this.message_length > this.maximum_message_size) {
                    throw new IOException("Invalid message length given for AZ message decode: " + this.message_length + " (max=" + this.maximum_message_size + ")");
                }
                this.payload_buffer = DirectByteBufferPool.getBuffer((byte)24, this.message_length);
            }
        }
        this.protocol_bytes_last_read += prot_bytes_read;
        this.data_bytes_last_read += data_bytes_read;
        return prot_bytes_read + data_bytes_read;
    }

    public void pauseDecoding() {
        this.is_paused = true;
    }

    public void resumeDecoding() {
        this.is_paused = false;
    }
}

