/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.RandomUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnchokerUtil {
    public static boolean isUnchokable(PEPeer peer, boolean allow_snubbed) {
        return peer.getPeerState() == 30 && !peer.isSeed() && !peer.isRelativeSeed() && peer.isInterested() && (!peer.isSnubbed() || allow_snubbed);
    }

    public static void updateLargestValueFirstSort(long new_value, long[] values, PEPeer new_item, ArrayList items, int start_pos) {
        items.ensureCapacity(values.length);
        for (int i = start_pos; i < values.length; ++i) {
            if (new_value < values[i]) continue;
            for (int j = values.length - 2; j >= i; --j) {
                values[j + 1] = values[j];
            }
            if (items.size() == values.length) {
                items.remove(values.length - 1);
            }
            values[i] = new_value;
            items.add(i, new_item);
            return;
        }
    }

    public static PEPeer getNextOptimisticPeer(ArrayList<PEPeer> all_peers, boolean factor_reciprocated, boolean allow_snubbed) {
        ArrayList<PEPeer> peers = UnchokerUtil.getNextOptimisticPeers(all_peers, factor_reciprocated, allow_snubbed, 1);
        if (peers != null) {
            return (PEPeerTransport)peers.get(0);
        }
        return null;
    }

    public static ArrayList<PEPeer> getNextOptimisticPeers(ArrayList<PEPeer> all_peers, boolean factor_reciprocated, boolean allow_snubbed, int num_needed) {
        PEPeer peer;
        int i;
        ArrayList<PEPeer> optimistics = new ArrayList<PEPeer>();
        for (i = 0; i < all_peers.size(); ++i) {
            peer = all_peers.get(i);
            if (!UnchokerUtil.isUnchokable(peer, false) || !peer.isChokedByMe()) continue;
            optimistics.add(peer);
        }
        if (optimistics.isEmpty() && allow_snubbed) {
            for (i = 0; i < all_peers.size(); ++i) {
                peer = all_peers.get(i);
                if (!UnchokerUtil.isUnchokable(peer, true) || !peer.isChokedByMe()) continue;
                optimistics.add(peer);
            }
        }
        if (optimistics.isEmpty()) {
            return null;
        }
        ArrayList<PEPeer> result = new ArrayList<PEPeer>(optimistics.size());
        if (factor_reciprocated) {
            int i2;
            ArrayList ratioed_peers = new ArrayList(optimistics.size());
            long[] ratios = new long[optimistics.size()];
            Arrays.fill(ratios, Long.MIN_VALUE);
            for (i2 = 0; i2 < optimistics.size(); ++i2) {
                PEPeer peer2 = (PEPeer)optimistics.get(i2);
                long score = peer2.getStats().getTotalDataBytesSent() - peer2.getStats().getTotalDataBytesReceived();
                UnchokerUtil.updateLargestValueFirstSort(score, ratios, peer2, ratioed_peers, 0);
            }
            for (i2 = 0; i2 < num_needed && ratioed_peers.size() > 0; ++i2) {
                double factor = 1.0 / (0.8 + 0.2 * Math.pow(RandomUtils.nextFloat(), -1.0));
                int pos = (int)(factor * (double)ratioed_peers.size());
                result.add((PEPeer)ratioed_peers.remove(pos));
            }
        } else {
            for (int i3 = 0; i3 < num_needed && optimistics.size() > 0; ++i3) {
                int rand_pos = new Random().nextInt(optimistics.size());
                result.add((PEPeer)optimistics.remove(rand_pos));
            }
        }
        return result;
    }

    public static void performChokes(ArrayList<PEPeer> peers_to_choke, ArrayList<PEPeer> peers_to_unchoke) {
        PEPeer peer;
        int i;
        if (peers_to_choke != null) {
            for (i = 0; i < peers_to_choke.size(); ++i) {
                peer = (PEPeerTransport)peers_to_choke.get(i);
                if (peer.isChokedByMe()) continue;
                peer.sendChoke();
            }
        }
        if (peers_to_unchoke != null) {
            for (i = 0; i < peers_to_unchoke.size(); ++i) {
                peer = peers_to_unchoke.get(i);
                if (!peer.isChokedByMe()) continue;
                peer.sendUnChoke();
            }
        }
    }

    public static void performChokeUnchoke(PEPeer to_choke, PEPeer to_unchoke) {
        if (to_choke != null && !to_choke.isChokedByMe()) {
            to_choke.sendChoke();
        }
        if (to_unchoke != null && to_unchoke.isChokedByMe()) {
            to_unchoke.sendUnChoke();
        }
    }
}

