/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class ClientIdentifier {
    private static int test_count = 1;

    public static String identifyBTOnly(String peer_id_client, byte[] handshake_bytes) {
        if (peer_id_client.equals("Mainline 4.4.0") && (handshake_bytes[7] & 1) == 0) {
            return ClientIdentifier.asDiscrepancy("BitThief*", peer_id_client, "fake_client");
        }
        if (!peer_id_client.startsWith("Azureus ")) {
            return peer_id_client;
        }
        String version = peer_id_client.substring(8);
        if (version.startsWith("1") || version.startsWith("2.0") || version.startsWith("2.1") || version.startsWith("2.2")) {
            return peer_id_client;
        }
        return ClientIdentifier.asDiscrepancy(null, peer_id_client, "fake_client");
    }

    public static String identifyAZMP(String peer_id_client_name, String az_msg_client_name, String az_msg_client_version, byte[] peer_id) {
        String discrepancy_type;
        String az_client_name;
        if (az_msg_client_name.endsWith("BitTyrant")) {
            return "BitTyrant " + az_msg_client_version.replaceAll("BitTyrant", "") + " (Azureus Mod)";
        }
        String msg_client_name = az_msg_client_name + " " + az_msg_client_version;
        if (msg_client_name.equals(peer_id_client_name)) {
            return msg_client_name;
        }
        String peer_id_client = peer_id_client_name.split(" ", 2)[0];
        if (peer_id_client.equals(az_client_name = az_msg_client_name.split(" ", 2)[0])) {
            if (az_client_name.equals("Azureus") && peer_id_client.equals("Azureus") && !msg_client_name.substring(0, 15).equals(peer_id_client_name.substring(0, 15))) {
                return ClientIdentifier.asDiscrepancy("Azureus (Hacked)", peer_id_client_name, msg_client_name, "fake_client", "AZMP", peer_id);
            }
            return msg_client_name;
        }
        String res = ClientIdentifier.checkForTransmissionBasedClients(msg_client_name, peer_id_client, peer_id_client_name, msg_client_name, peer_id, "AZMP");
        if (res != null) {
            return res;
        }
        String client_displayed_name = null;
        boolean is_peer_id_azureus = peer_id_client_name.startsWith("Azureus ");
        boolean is_msg_client_azureus = az_msg_client_name.equals("Azureus");
        boolean is_fake = false;
        boolean is_mismatch = true;
        boolean is_peer_id_unknown = peer_id_client_name.startsWith(MessageText.getString("PeerSocket.unknown"));
        if (is_peer_id_azureus) {
            if (is_msg_client_azureus) {
                throw new RuntimeException("logic error in getExtendedClientName - both clients are Azureus");
            }
            is_fake = true;
            if (msg_client_name.equals("Transmission 0.7-svn")) {
                client_displayed_name = "XTorrent";
            }
        } else if (is_msg_client_azureus) {
            is_fake = true;
        } else if (is_peer_id_unknown) {
            client_displayed_name = msg_client_name;
            is_mismatch = false;
            BTPeerIDByteDecoder.logClientDiscrepancy(peer_id_client_name, msg_client_name, "unknown_client", "AZMP", peer_id);
        } else if (msg_client_name.startsWith("Ares") && peer_id_client.equals("ArcticTorrent")) {
            return msg_client_name;
        }
        if ((discrepancy_type = is_fake ? "fake_client" : (is_mismatch ? "mismatch_id" : null)) != null) {
            return ClientIdentifier.asDiscrepancy(null, peer_id_client_name, msg_client_name, discrepancy_type, "AZMP", peer_id);
        }
        return client_displayed_name;
    }

    public static String identifyLTEP(String peer_id_name, String handshake_name, byte[] peer_id) {
        if (handshake_name == null) {
            return peer_id_name;
        }
        String handshake_name_to_process = handshake_name;
        if (handshake_name.startsWith("BitTorrent ")) {
            handshake_name_to_process = handshake_name.replaceFirst("BitTorrent", "Mainline");
        }
        if (peer_id_name.startsWith("\u00b5Torrent")) {
            if (peer_id_name.equals("\u00b5Torrent 1.6.0")) {
                return peer_id_name;
            }
            if (!handshake_name.startsWith("\u00b5Torrent") && handshake_name.startsWith("Torrent", 1)) {
                handshake_name_to_process = "\u00b5" + handshake_name.substring(1);
            }
            if (peer_id_name.endsWith("Beta") && peer_id_name.startsWith(handshake_name_to_process)) {
                return peer_id_name;
            }
        }
        if (peer_id_name.startsWith("Mainline 4.") && handshake_name.startsWith("Torrent", 1)) {
            return peer_id_name;
        }
        if (peer_id_name.startsWith("Azureus") && handshake_name.startsWith("Azureus")) {
            return ClientIdentifier.asDiscrepancy(null, peer_id_name, handshake_name, "fake_client", "LTEP", peer_id);
        }
        String client_type_peer = peer_id_name.split(" ", 2)[0];
        String client_type_handshake = handshake_name_to_process.split(" ", 2)[0].split("/", 2)[0];
        String res = ClientIdentifier.checkForTransmissionBasedClients(handshake_name_to_process, client_type_peer, peer_id_name, handshake_name, peer_id, "LTEP");
        if (res != null) {
            return res;
        }
        if (client_type_peer.toLowerCase().equals(client_type_handshake.toLowerCase())) {
            return handshake_name_to_process;
        }
        if (peer_id_name.startsWith(MessageText.getString("PeerSocket.unknown"))) {
            BTPeerIDByteDecoder.logClientDiscrepancy(peer_id_name, handshake_name, "unknown_client", "LTEP", peer_id);
            return handshake_name_to_process;
        }
        if (peer_id_name.startsWith("libtorrent (Rasterbar)")) {
            if (handshake_name_to_process.toLowerCase().indexOf("libtorrent") == -1) {
                handshake_name_to_process = handshake_name_to_process + " (" + peer_id_name + ")";
            }
            return handshake_name_to_process;
        }
        if (client_type_handshake.startsWith("libtorrent") && client_type_peer.toLowerCase().indexOf("libtorrent") == -1 && client_type_handshake.toLowerCase().indexOf(client_type_peer.toLowerCase()) == -1) {
            return peer_id_name + " (" + handshake_name_to_process + ")";
        }
        return ClientIdentifier.asDiscrepancy(null, peer_id_name, handshake_name, "mismatch_id", "LTEP", peer_id);
    }

    private static String checkForTransmissionBasedClients(String handshake_name_to_process, String client_type_peer, String peer_id_name, String handshake_name, byte[] peer_id, String protocol) {
        if (handshake_name_to_process.equals("Transmission 0.7-svn") && client_type_peer.equals("Azureus")) {
            return ClientIdentifier.asDiscrepancy("XTorrent", peer_id_name, handshake_name, "fake_client", protocol, peer_id);
        }
        if (handshake_name_to_process.startsWith("Transmission") && client_type_peer.startsWith("XTorrent")) {
            return ClientIdentifier.asDiscrepancy(client_type_peer, handshake_name_to_process, "fake_client");
        }
        if (peer_id_name.equals("Transmission 0.96") && handshake_name.equals("Transmission 0.95")) {
            return peer_id_name;
        }
        return null;
    }

    private static String asDiscrepancy(String client_name, String peer_id_name, String handshake_name, String discrepancy_type, String protocol_type, byte[] peer_id) {
        if (client_name == null) {
            BTPeerIDByteDecoder.logClientDiscrepancy(peer_id_name, handshake_name, discrepancy_type, protocol_type, peer_id);
        }
        if (peer_id_name.equals(handshake_name)) {
            return ClientIdentifier.asDiscrepancy(client_name, peer_id_name, discrepancy_type);
        }
        return ClientIdentifier.asDiscrepancy(client_name, peer_id_name + "\" / \"" + handshake_name, discrepancy_type);
    }

    private static String asDiscrepancy(String real_client, String dodgy_client, String discrepancy_type) {
        if (real_client == null) {
            real_client = MessageText.getString("PeerSocket.unknown");
        }
        return real_client + " [" + MessageText.getString("PeerSocket." + discrepancy_type) + ": \"" + dodgy_client + "\"]";
    }

    private static void assertDecode(String client_name, String peer_id, String handshake_name, String handshake_version, byte[] handshake_reserved, String type) throws Exception {
        String decoded_client;
        byte[] byte_peer_id = BTPeerIDByteDecoder.peerIDStringToBytes(peer_id);
        String peer_id_client = BTPeerIDByteDecoder.decode(byte_peer_id);
        if (type.equals("AZMP")) {
            decoded_client = ClientIdentifier.identifyAZMP(peer_id_client, handshake_name, handshake_version, byte_peer_id);
        } else if (type.equals("LTEP")) {
            decoded_client = ClientIdentifier.identifyLTEP(peer_id_client, handshake_name, byte_peer_id);
        } else if (type.equals("BT")) {
            decoded_client = ClientIdentifier.identifyBTOnly(peer_id_client, handshake_reserved);
        } else {
            throw new RuntimeException("invalid extension type: " + type);
        }
        boolean passed = client_name.equals(decoded_client);
        System.out.println("  Test " + test_count++ + ": \"" + client_name + "\" - " + (passed ? "PASSED" : "FAILED"));
        if (!passed) {
            throw new Exception("\nDecoded      : " + decoded_client + "\n" + "Peer ID name : " + peer_id_client + "\n" + "Extended name: " + handshake_name + "\n");
        }
    }

    private static void assertDecodeAZMP(String client_name, String peer_id, String handshake_name, String handshake_version) throws Exception {
        ClientIdentifier.assertDecode(client_name, peer_id, handshake_name, handshake_version, null, "AZMP");
    }

    private static void assertDecodeLTEP(String client_name, String peer_id, String handshake_name) throws Exception {
        ClientIdentifier.assertDecode(client_name, peer_id, handshake_name, null, null, "LTEP");
    }

    private static void assertDecodeExtProtocol(String client_name, String peer_id, String handshake_name, String handshake_version) throws Exception {
        ClientIdentifier.assertDecodeAZMP(client_name, peer_id, handshake_name, handshake_version);
        ClientIdentifier.assertDecodeLTEP(client_name, peer_id, handshake_name + " " + handshake_version);
    }

    private static void assertDecodeBT(String client_name, String peer_id, String handshake_reserved) throws Exception {
        byte[] handshake_reserved_bytes;
        if (handshake_reserved == null) {
            handshake_reserved = "0000000000000000";
        }
        if ((handshake_reserved_bytes = ByteFormatter.decodeString(handshake_reserved = handshake_reserved.replaceAll("[ ]", ""))).length != 8) {
            throw new RuntimeException("invalid handshake reserved bytes");
        }
        ClientIdentifier.assertDecode(client_name, peer_id, null, null, handshake_reserved_bytes, "BT");
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("transitory.startup", "1");
        BTPeerIDByteDecoder.client_logging_allowed = false;
        System.out.println("Testing simple BT clients:");
        ClientIdentifier.assertDecodeBT("BitThief* [FAKE: \"Mainline 4.4.0\"]", "M4-4-0--9aa757efd5be", "0000000000000000");
        ClientIdentifier.assertDecodeBT("Mainline 4.4.0", "M4-4-0--9aa757efd5be", "0000000000000001");
        ClientIdentifier.assertDecodeBT("Unknown [FAKE: \"Azureus 3.0.3.4\"]", "-AZ3034-6wfG2wk6wWLc", "0000000000000000");
        System.out.println("");
        System.out.println("Testing AZMP clients:");
        ClientIdentifier.assertDecodeAZMP("Azureus 3.0.4.2", "-AZ3042-6ozMq5q6Q3NX", "Azureus", "3.0.4.2");
        ClientIdentifier.assertDecodeAZMP("Azureus 3.0.4.3_B02", "-AZ3043-6ozMq5q6Q3NX", "Azureus", "3.0.4.3_B02");
        ClientIdentifier.assertDecodeAZMP("BitTyrant 2.5.0.0 (Azureus Mod)", "AZ2500BTeyuzyabAfo6U", "AzureusBitTyrant", "2.5.0.0BitTyrant");
        ClientIdentifier.assertDecodeAZMP("Azureus (Hacked) [FAKE: \"Azureus 2.4.0.2\" / \"Azureus 2.3.0.6\"]", "2D415A32 3430322D 2E414794 2C57D644 4989CA58", "Azureus", "2.3.0.6");
        System.out.println("");
        System.out.println("Testing LTEP clients:");
        ClientIdentifier.assertDecodeLTEP("\u00b5Torrent 1.7.6", "2D555431 3736302D B39EC7AD F6B94610 AA4ACD4A", "\u00b5Torrent 1.7.6");
        ClientIdentifier.assertDecodeLTEP("\u00b5Torrent 1.6.1", "2D5554313631302DEA818D43F5E5EC3D67BF8D67", "\ufdffTorrent 1.6.1");
        ClientIdentifier.assertDecodeLTEP("Unknown [FAKE: \"Azureus 3.0.4.2\"]", "-AZ3042-6ozMq5q6Q3NX", "Azureus 3.0.4.2");
        ClientIdentifier.assertDecodeLTEP("Mainline 6.0", "4D362D30 2D302D2D 8B92860D 05055DF5 B01C2D94", "BitTorrent 6.0");
        ClientIdentifier.assertDecodeLTEP("\u00b5Torrent 1.8.0 Beta", "2D555431 3830422D E69C9942 D1A5A6C2 0BE2E4BD", "\u00b5Torrent 1.8");
        ClientIdentifier.assertDecodeLTEP("Miro 1.1.0.0 (libtorrent/0.13.0.0)", "-MR1100-00HS~T7*65rm", "libtorrent/0.13.0.0");
        ClientIdentifier.assertDecodeLTEP("linkage/0.1.4 libtorrent/0.12.0.0", "-LK0140-ATIV~nbEQAMr", "linkage/0.1.4 libtorrent/0.12.0.0");
        ClientIdentifier.assertDecodeLTEP("KTorrent 2.2.2", "-KT2210-347143496631", "KTorrent 2.2.2");
        ClientIdentifier.assertDecodeLTEP("Transmission 0.96", "-TR0960-6ep6svaa61r4", "Transmission 0.95");
        ClientIdentifier.assertDecodeLTEP("Opera 9.50", "O100634008270e29150a", "Opera 9.50");
        System.out.println("");
        System.out.println("Testing common clients:");
        ClientIdentifier.assertDecodeExtProtocol("XTorrent [FAKE: \"Azureus 2.5.0.4\" / \"Transmission 0.7-svn\"]", "-AZ2504-192gwethivju", "Transmission", "0.7-svn");
        System.out.println("");
        System.out.println("Done.");
    }
}

