/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingZone;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

class SpeedManagerPingMapperImpl
implements SpeedManagerPingMapper {
    static final int VARIANCE_GOOD_VALUE = 50;
    static final int VARIANCE_BAD_VALUE = 150;
    static final int VARIANCE_MAX = 1500;
    static final int RTT_BAD_MIN = 350;
    static final int RTT_BAD_MAX = 500;
    static final int RTT_MAX = 30000;
    static final int MAX_BAD_LIMIT_HISTORY = 16;
    static final int SPEED_DIVISOR = 256;
    private static final int SPEED_HISTORY_PERIOD = 180000;
    private static final int SPEED_HISTORY_COUNT = 36;
    private SpeedManagerImpl speed_manager;
    private String name;
    private boolean variance;
    private boolean trans;
    private int ping_count;
    private pingValue[] pings;
    private int max_pings;
    private pingValue prev_ping;
    private int[] x_speeds = new int[36];
    private int[] y_speeds = new int[36];
    private int speeds_next;
    private LinkedList regions;
    private int last_x;
    private int last_y;
    private int[] recent_metrics = new int[3];
    private int recent_metrics_next;
    private limitEstimate up_estimate;
    private limitEstimate down_estimate;
    private LinkedList last_bad_ups;
    private LinkedList last_bad_downs;
    private static final int BAD_PROGRESS_COUNTDOWN = 5;
    private limitEstimate last_bad_up;
    private int bad_up_in_progress_count;
    private limitEstimate last_bad_down;
    private int bad_down_in_progress_count;
    private limitEstimate best_good_up;
    private limitEstimate best_good_down;
    private limitEstimate up_capacity = this.getNullLimit();
    private limitEstimate down_capacity = this.getNullLimit();
    private File history_file;

    protected SpeedManagerPingMapperImpl(SpeedManagerImpl _speed_manager, String _name, int _entries, boolean _variance, boolean _transient) {
        this.speed_manager = _speed_manager;
        this.name = _name;
        this.max_pings = _entries;
        this.variance = _variance;
        this.trans = _transient;
        this.init();
    }

    protected void init() {
        this.pings = new pingValue[this.max_pings];
        this.ping_count = 0;
        this.regions = new LinkedList();
        this.up_estimate = this.getNullLimit();
        this.down_estimate = this.getNullLimit();
        this.last_bad_ups = new LinkedList();
        this.last_bad_downs = new LinkedList();
        this.last_bad_up = null;
        this.bad_up_in_progress_count = 0;
        this.last_bad_down = null;
        this.bad_down_in_progress_count = 0;
        this.best_good_up = null;
        this.best_good_down = null;
        this.up_capacity = this.getNullLimit();
        this.down_capacity = this.getNullLimit();
        this.prev_ping = null;
        this.recent_metrics_next = 0;
    }

    protected synchronized void loadHistory(File file) {
        try {
            if (this.history_file != null && this.history_file.equals(file)) {
                return;
            }
            if (this.history_file != null) {
                this.saveHistory();
            }
            this.history_file = file;
            this.init();
            if (this.history_file.exists()) {
                Map map = FileUtil.readResilientFile(this.history_file.getParentFile(), this.history_file.getName(), false, false);
                List p = (List)map.get("pings");
                if (p != null) {
                    for (int i = 0; i < p.size(); ++i) {
                        Map m = (Map)p.get(i);
                        int x = ((Long)m.get("x")).intValue();
                        int y = ((Long)m.get("y")).intValue();
                        int metric = ((Long)m.get("m")).intValue();
                        if (i == 0) {
                            this.last_x = 0;
                            this.last_y = 0;
                        }
                        if (this.variance) {
                            if (metric > 1500) {
                                metric = 1500;
                            }
                        } else if (metric > 30000) {
                            metric = 30000;
                        }
                        this.addPingSupport(x, y, -1, metric);
                    }
                }
                this.last_bad_ups = this.loadLimits(map, "lbus");
                this.last_bad_downs = this.loadLimits(map, "lbds");
                if (this.last_bad_ups.size() > 0) {
                    this.last_bad_up = (limitEstimate)this.last_bad_ups.get(this.last_bad_ups.size() - 1);
                }
                if (this.last_bad_downs.size() > 0) {
                    this.last_bad_down = (limitEstimate)this.last_bad_downs.get(this.last_bad_downs.size() - 1);
                }
                this.best_good_up = this.loadLimit((Map)map.get("bgu"));
                this.best_good_down = this.loadLimit((Map)map.get("bgd"));
                this.up_capacity = this.loadLimit((Map)map.get("upcap"));
                this.down_capacity = this.loadLimit((Map)map.get("downcap"));
                this.log("Loaded " + this.ping_count + " entries from " + this.history_file + ": bad_up=" + this.getLimitString(this.last_bad_ups) + ", bad_down=" + this.getLimitString(this.last_bad_downs));
            }
            this.prev_ping = null;
            this.recent_metrics_next = 0;
            this.updateLimitEstimates();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected synchronized void saveHistory() {
        try {
            if (this.history_file == null) {
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList p = new ArrayList(this.ping_count);
            map.put("pings", p);
            for (int i = 0; i < this.ping_count; ++i) {
                pingValue ping = this.pings[i];
                HashMap<String, Long> m = new HashMap<String, Long>();
                p.add(m);
                m.put("x", new Long(ping.getX()));
                m.put("y", new Long(ping.getY()));
                m.put("m", new Long(ping.getMetric()));
            }
            this.saveLimits(map, "lbus", this.last_bad_ups);
            this.saveLimits(map, "lbds", this.last_bad_downs);
            if (this.best_good_up != null) {
                map.put("bgu", this.saveLimit(this.best_good_up));
            }
            if (this.best_good_down != null) {
                map.put("bgd", this.saveLimit(this.best_good_down));
            }
            map.put("upcap", this.saveLimit(this.up_capacity));
            map.put("downcap", this.saveLimit(this.down_capacity));
            FileUtil.writeResilientFile(this.history_file, map);
            this.log("Saved " + p.size() + " entries to " + this.history_file);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected LinkedList loadLimits(Map map, String name) {
        LinkedList<limitEstimate> result = new LinkedList<limitEstimate>();
        List l = (List)map.get(name);
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                Map m = (Map)l.get(i);
                result.add(this.loadLimit(m));
            }
        }
        return result;
    }

    protected limitEstimate loadLimit(Map m) {
        if (m == null) {
            return this.getNullLimit();
        }
        int speed = ((Long)m.get("s")).intValue();
        double metric = Double.parseDouble(new String((byte[])m.get("m")));
        int hits = ((Long)m.get("h")).intValue();
        long when = (Long)m.get("w");
        byte[] t_bytes = (byte[])m.get("t");
        double type = t_bytes == null ? 0.0 : Double.parseDouble(new String(t_bytes));
        return new limitEstimate(speed, type, metric, hits, when, new int[0][]);
    }

    protected void saveLimits(Map map, String name, List limits) {
        ArrayList<Map> l = new ArrayList<Map>();
        for (int i = 0; i < limits.size(); ++i) {
            limitEstimate limit = (limitEstimate)limits.get(i);
            Map m = this.saveLimit(limit);
            l.add(m);
        }
        map.put(name, l);
    }

    protected Map saveLimit(limitEstimate limit) {
        if (limit == null) {
            limit = this.getNullLimit();
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("s", new Long(limit.getBytesPerSec()));
        m.put("m", String.valueOf(limit.getMetricRating()));
        m.put("t", String.valueOf(limit.getEstimateType()));
        m.put("h", new Long(limit.getHits()));
        m.put("w", new Long(limit.getWhen()));
        return m;
    }

    public boolean isActive() {
        return this.variance;
    }

    protected limitEstimate getNullLimit() {
        return new limitEstimate(0, -0.1f, 0.0, 0, 0L, new int[0][]);
    }

    protected String getLimitString(List limits) {
        String str = "";
        for (int i = 0; i < limits.size(); ++i) {
            str = str + (i == 0 ? "" : ",") + ((limitEstimate)limits.get(i)).getString();
        }
        return str;
    }

    protected void log(String str) {
        if (this.speed_manager != null) {
            this.speed_manager.log(str);
        }
    }

    public String getName() {
        return this.name;
    }

    protected synchronized void addSpeed(int x, int y) {
        y /= 256;
        if ((x /= 256) > 65535) {
            x = 65535;
        }
        if (y > 65535) {
            y = 65535;
        }
        this.addSpeedSupport(x, y);
    }

    protected synchronized void addSpeedSupport(int x, int y) {
        this.x_speeds[this.speeds_next] = x;
        this.y_speeds[this.speeds_next] = y;
        this.speeds_next = (this.speeds_next + 1) % 36;
        int min_x = Integer.MAX_VALUE;
        int min_y = Integer.MAX_VALUE;
        for (int i = 0; i < 36; ++i) {
            min_x = Math.min(min_x, this.x_speeds[i]);
            min_y = Math.min(min_y, this.y_speeds[i]);
        }
        min_y *= 256;
        if (this.up_capacity.getEstimateType() != 1.0f && (min_x *= 256) > this.up_capacity.getBytesPerSec()) {
            this.up_capacity.setBytesPerSec(min_x);
            this.up_capacity.setMetricRating(0.0f);
            this.up_capacity.setEstimateType(0.0f);
            this.speed_manager.informUpCapChanged();
        }
        if (this.down_capacity.getEstimateType() != 1.0f && min_y > this.down_capacity.getBytesPerSec()) {
            this.down_capacity.setBytesPerSec(min_y);
            this.down_capacity.setMetricRating(0.0f);
            this.down_capacity.setEstimateType(0.0f);
            this.speed_manager.informDownCapChanged();
        }
    }

    protected synchronized void addPing(int x, int y, int rtt, boolean re_base) {
        int metric;
        y /= 256;
        if ((x /= 256) > 65535) {
            x = 65535;
        }
        if (y > 65535) {
            y = 65535;
        }
        if (rtt > 65535) {
            int n = rtt = this.variance ? 1500 : 30000;
        }
        if (rtt == 0) {
            rtt = 1;
        }
        int average_x = (x + this.last_x) / 2;
        int average_y = (y + this.last_y) / 2;
        this.last_x = x;
        this.last_y = y;
        x = average_x;
        y = average_y;
        if (this.variance) {
            if (re_base) {
                this.log("Re-based variance");
                this.recent_metrics_next = 0;
            }
            this.recent_metrics[this.recent_metrics_next++ % this.recent_metrics.length] = rtt;
            int var_metric = 0;
            int rtt_metric = 0;
            if (this.recent_metrics_next > 1) {
                int entries = Math.min(this.recent_metrics_next, this.recent_metrics.length);
                int total = 0;
                for (int i = 0; i < entries; ++i) {
                    total += this.recent_metrics[i];
                }
                int average = total / entries;
                int total_deviation = 0;
                for (int i = 0; i < entries; ++i) {
                    int deviation = this.recent_metrics[i] - average;
                    total_deviation += deviation * deviation;
                }
                var_metric = (int)Math.sqrt(total_deviation);
                if (entries == this.recent_metrics.length) {
                    int total_rtt = 0;
                    for (int i = 0; i < entries; ++i) {
                        total_rtt += this.recent_metrics[i];
                    }
                    int average_rtt = total_rtt / this.recent_metrics.length;
                    if (average_rtt >= 500) {
                        rtt_metric = 150;
                    } else if (average_rtt > 350) {
                        int rtt_diff = 150;
                        int rtt_base = average_rtt - 350;
                        rtt_metric = 50 + 100 * rtt_base / rtt_diff;
                    }
                }
            }
            if ((metric = Math.max(var_metric, rtt_metric)) < 150) {
                this.addSpeedSupport(x, y);
            } else {
                this.addSpeedSupport(0, 0);
            }
        } else {
            metric = rtt;
        }
        region new_region = this.addPingSupport(x, y, rtt, metric);
        this.updateLimitEstimates();
        if (this.variance) {
            String up_e = this.getShortString(this.getEstimatedUploadLimit(false)) + "," + this.getShortString(this.getEstimatedUploadLimit(true)) + "," + this.getShortString(this.getEstimatedUploadCapacityBytesPerSec());
            String down_e = this.getShortString(this.getEstimatedDownloadLimit(false)) + "," + this.getShortString(this.getEstimatedDownloadLimit(true)) + "," + this.getShortString(this.getEstimatedDownloadCapacityBytesPerSec());
            this.log("Ping: rtt=" + rtt + ",x=" + x + ",y=" + y + ",m=" + metric + (new_region == null ? "" : ",region=" + new_region.getString()) + ",mr=" + this.getCurrentMetricRating() + ",up=[" + up_e + (this.best_good_up == null ? "" : ":" + this.getShortString(this.best_good_up)) + "],down=[" + down_e + (this.best_good_down == null ? "" : ":" + this.getShortString(this.best_good_down)) + "]" + ",bu=" + this.getLimitStr(this.last_bad_ups, true) + ",bd=" + this.getLimitStr(this.last_bad_downs, true));
        }
    }

    protected region addPingSupport(int x, int y, int rtt, int metric) {
        if (this.ping_count == this.pings.length) {
            int to_discard = this.pings.length / 10;
            if (to_discard < 3) {
                to_discard = 3;
            }
            this.ping_count = this.pings.length - to_discard;
            System.arraycopy(this.pings, to_discard, this.pings, 0, this.ping_count);
            for (int i = 0; i < to_discard; ++i) {
                this.regions.removeFirst();
            }
        }
        pingValue ping = new pingValue(x, y, metric);
        this.pings[this.ping_count++] = ping;
        region new_region = null;
        if (this.prev_ping != null) {
            new_region = new region(this.prev_ping, ping);
            this.regions.add(new_region);
        }
        this.prev_ping = ping;
        return new_region;
    }

    public synchronized int[][] getHistory() {
        int[][] result = new int[this.ping_count][];
        for (int i = 0; i < this.ping_count; ++i) {
            pingValue ping = this.pings[i];
            result[i] = new int[]{256 * ping.getX(), 256 * ping.getY(), ping.getMetric()};
        }
        return result;
    }

    public synchronized SpeedManagerPingZone[] getZones() {
        return this.regions.toArray(new SpeedManagerPingZone[this.regions.size()]);
    }

    public synchronized SpeedManagerLimitEstimate getEstimatedUploadLimit(boolean persistent) {
        return this.adjustForPersistence(this.up_estimate, this.best_good_up, this.last_bad_up, persistent);
    }

    public synchronized SpeedManagerLimitEstimate getEstimatedDownloadLimit(boolean persistent) {
        return this.adjustForPersistence(this.down_estimate, this.best_good_down, this.last_bad_down, persistent);
    }

    public SpeedManagerLimitEstimate getLastBadUploadLimit() {
        return this.last_bad_up;
    }

    public SpeedManagerLimitEstimate getLastBadDownloadLimit() {
        return this.last_bad_down;
    }

    public synchronized SpeedManagerLimitEstimate[] getBadUploadHistory() {
        return this.last_bad_ups.toArray(new SpeedManagerLimitEstimate[this.last_bad_ups.size()]);
    }

    public synchronized SpeedManagerLimitEstimate[] getBadDownloadHistory() {
        return this.last_bad_downs.toArray(new SpeedManagerLimitEstimate[this.last_bad_downs.size()]);
    }

    protected SpeedManagerLimitEstimate adjustForPersistence(limitEstimate estimate, limitEstimate best_good, limitEstimate last_bad, boolean persistent) {
        if (estimate == null) {
            return null;
        }
        if (persistent) {
            if (estimate.getMetricRating() == -1.0f) {
                return estimate;
            }
            limitEstimate persistent_limit = null;
            if (best_good != null && last_bad != null) {
                persistent_limit = last_bad.getWhen() > best_good.getWhen() ? last_bad : (best_good.getBytesPerSec() > last_bad.getBytesPerSec() ? best_good : last_bad);
            } else if (best_good != null) {
                persistent_limit = best_good;
            } else if (last_bad != null) {
                persistent_limit = last_bad;
            }
            if (persistent_limit == null) {
                return estimate;
            }
            if (estimate.getBytesPerSec() > persistent_limit.getBytesPerSec()) {
                return estimate;
            }
            limitEstimate res = estimate.getClone();
            res.setBytesPerSec(persistent_limit.getBytesPerSec());
            return res;
        }
        return estimate;
    }

    protected void updateLimitEstimates() {
        double metric;
        double cm = this.getCurrentMetricRating();
        this.up_estimate = this.getEstimatedLimit(true);
        if (this.up_estimate != null) {
            metric = this.up_estimate.getMetricRating();
            if (metric == -1.0) {
                if (this.bad_up_in_progress_count == 0 && (this.last_bad_up == null || this.last_bad_up.getBytesPerSec() != this.up_estimate.getBytesPerSec())) {
                    this.bad_up_in_progress_count = 5;
                    this.last_bad_ups.addLast(this.up_estimate);
                    if (this.last_bad_ups.size() > 16) {
                        this.last_bad_ups.removeFirst();
                    }
                    this.checkCapacityDecrease(true, this.up_capacity, this.last_bad_ups);
                }
                this.last_bad_up = this.up_estimate;
            } else if (metric == 1.0) {
                if (this.best_good_up == null) {
                    this.best_good_up = this.up_estimate;
                } else if (this.best_good_up.getBytesPerSec() < this.up_estimate.getBytesPerSec()) {
                    this.best_good_up = this.up_estimate;
                }
            }
            if (this.bad_up_in_progress_count > 0) {
                if (cm == -1.0) {
                    this.bad_up_in_progress_count = 5;
                } else if (cm == 1.0) {
                    --this.bad_up_in_progress_count;
                }
            }
        }
        this.down_estimate = this.getEstimatedLimit(false);
        if (this.down_estimate != null) {
            metric = this.down_estimate.getMetricRating();
            if (metric == -1.0) {
                if (this.bad_down_in_progress_count == 0 && (this.last_bad_down == null || this.last_bad_down.getBytesPerSec() != this.down_estimate.getBytesPerSec())) {
                    this.bad_down_in_progress_count = 5;
                    this.last_bad_downs.addLast(this.down_estimate);
                    if (this.last_bad_downs.size() > 16) {
                        this.last_bad_downs.removeFirst();
                    }
                    this.checkCapacityDecrease(false, this.down_capacity, this.last_bad_downs);
                }
                this.last_bad_down = this.down_estimate;
            } else if (metric == 1.0) {
                if (this.best_good_down == null) {
                    this.best_good_down = this.down_estimate;
                } else if (this.best_good_down.getBytesPerSec() < this.down_estimate.getBytesPerSec()) {
                    this.best_good_down = this.down_estimate;
                }
            }
            if (this.bad_down_in_progress_count > 0) {
                if (cm == -1.0) {
                    this.bad_down_in_progress_count = 5;
                } else if (cm == 1.0) {
                    --this.bad_down_in_progress_count;
                }
            }
        }
    }

    protected void checkCapacityDecrease(boolean is_up, limitEstimate capacity, LinkedList bads) {
        if (capacity.getEstimateType() == 1.0f) {
            return;
        }
        if (bads.size() < 16) {
            return;
        }
        int cap = capacity.getBytesPerSec();
        if (cap > 0 && cap < 10240) {
            return;
        }
        ArrayList b = new ArrayList(bads);
        Collections.sort(b, new Comparator(){

            public int compare(Object o1, Object o2) {
                limitEstimate l1 = (limitEstimate)o1;
                limitEstimate l2 = (limitEstimate)o2;
                return l1.getBytesPerSec() - l2.getBytesPerSec();
            }
        });
        int start = 4;
        int end = 16 - start;
        int total = 0;
        int num = 0;
        for (int i = start; i < end; ++i) {
            int s = ((limitEstimate)b.get(i)).getBytesPerSec();
            total += s;
            ++num;
        }
        int average = total / num;
        if (cap > 0 && average >= cap) {
            this.log("Not reducing " + (is_up ? "up" : "down") + " capacity - average=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(average) + ",capacity=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(cap));
            return;
        }
        int total_deviation = 0;
        for (int i = start; i < end; ++i) {
            int s = ((limitEstimate)b.get(i)).getBytesPerSec();
            int deviation = s - average;
            total_deviation += deviation * deviation;
        }
        int deviation = (int)Math.sqrt(total_deviation / num);
        if (cap <= 0 || deviation < cap / 2 && average < cap) {
            this.log("Reducing " + (is_up ? "up" : "down") + " capacity from " + cap + " to " + average + " due to frequent lower chokes (deviation=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(deviation) + ")");
            capacity.setBytesPerSec(average);
            capacity.setEstimateType(0.5f);
            for (int i = 0; i < start; ++i) {
                bads.removeFirst();
            }
        } else {
            this.log("Not reducing " + (is_up ? "up" : "down") + " capacity - deviation=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(deviation) + ",capacity=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(cap));
        }
    }

    protected synchronized limitEstimate getEstimatedLimit(boolean up) {
        int estimate_hits;
        int estimate_speed;
        int var;
        int i;
        if (!this.variance) {
            return this.getNullLimit();
        }
        int num_samples = this.regions.size();
        if (num_samples == 0) {
            return this.getNullLimit();
        }
        Iterator it = this.regions.iterator();
        int max_end = 0;
        while (it.hasNext()) {
            region r = (region)it.next();
            int end = (up ? r.getUploadEndBytesPerSec() : r.getDownloadEndBytesPerSec()) / 256;
            if (end <= max_end) continue;
            max_end = end;
        }
        int sample_end = max_end + 1;
        int[] totals = new int[sample_end];
        short[] hits = new short[sample_end];
        short[] worst_var_type = new short[sample_end];
        ListIterator sample_it = this.regions.listIterator(0);
        while (sample_it.hasNext()) {
            short this_var_type;
            int weighted_end;
            int weighted_start;
            region r = (region)sample_it.next();
            int start = (up ? r.getUploadStartBytesPerSec() : r.getDownloadStartBytesPerSec()) / 256;
            int end = (up ? r.getUploadEndBytesPerSec() : r.getDownloadEndBytesPerSec()) / 256;
            int metric = r.getMetric();
            if (metric < 50) {
                weighted_start = 0;
                weighted_end = end;
                this_var_type = 0;
            } else if (metric < 150) {
                weighted_start = start;
                weighted_end = end;
                this_var_type = 50;
            } else {
                weighted_start = start;
                weighted_end = max_end;
                this_var_type = 150;
            }
            int j = weighted_start;
            while (j <= weighted_end) {
                if (this_var_type == 150 && worst_var_type[j] <= this_var_type) {
                    totals[j] = 0;
                    hits[j] = 0;
                    worst_var_type[j] = this_var_type;
                }
                int n = j;
                totals[n] = totals[n] + metric;
                int n2 = j++;
                hits[n2] = (short)(hits[n2] + 1);
            }
        }
        for (int i2 = 0; i2 < sample_end; ++i2) {
            int average;
            short hit = hits[i2];
            if (hit <= 0) continue;
            totals[i2] = average = totals[i2] / hit;
            worst_var_type[i2] = average < 50 ? 0 : (average < 150 ? 50 : 150);
        }
        int last_average = -1;
        int last_average_change = 0;
        int last_average_worst_var = 0;
        int last_max_hits = 0;
        int worst_var = 0;
        ArrayList<int[]> segments = new ArrayList<int[]>(totals.length);
        for (int i3 = 0; i3 < sample_end; ++i3) {
            int var2 = worst_var_type[i3];
            int hit = hits[i3];
            if (var2 > worst_var) {
                worst_var = var2;
            }
            int average = totals[i3];
            if (i3 == 0) {
                last_average = average;
                continue;
            }
            if (last_average != average) {
                segments.add(new int[]{last_average, last_average_change * 256, (i3 - 1) * 256, last_average_worst_var, last_max_hits});
                last_average = average;
                last_average_change = i3;
                last_average_worst_var = var2;
                last_max_hits = hit;
                continue;
            }
            last_average_worst_var = Math.max(var2, last_average_worst_var);
            last_max_hits = Math.max(hit, last_max_hits);
        }
        if (last_average_change != sample_end - 1) {
            segments.add(new int[]{last_average, last_average_change * 256, (sample_end - 1) * 256, last_average_worst_var, last_max_hits});
        }
        int[] estimate_seg = null;
        int estimate_var = 0;
        if (worst_var == 150) {
            for (i = segments.size() - 1; i >= 0; --i) {
                int[] seg = (int[])segments.get(i);
                var = seg[3];
                if (var < worst_var) continue;
                estimate_seg = seg;
                estimate_var = var;
            }
        } else {
            for (i = 0; i < segments.size(); ++i) {
                int[] seg = (int[])segments.get(i);
                var = seg[3];
                if (var < worst_var) continue;
                estimate_seg = seg;
                estimate_var = var;
            }
        }
        if (estimate_seg == null) {
            estimate_speed = -1;
            estimate_hits = 0;
        } else {
            estimate_speed = -1;
            estimate_speed = worst_var == 0 ? estimate_seg[2] : (worst_var == 50 ? (estimate_seg[1] + estimate_seg[2]) / 2 : estimate_seg[1]);
            estimate_hits = estimate_seg[4];
        }
        if (estimate_speed < 5120) {
            estimate_var = 50;
            if (estimate_speed <= 0) {
                estimate_speed = 1;
            }
        }
        limitEstimate result = new limitEstimate(estimate_speed, 0.0, this.convertMetricToRating(estimate_var), estimate_hits, SystemTime.getCurrentTime(), (int[][])segments.toArray((T[])new int[segments.size()][]));
        return result;
    }

    public synchronized double getCurrentMetricRating() {
        if (this.ping_count == 0) {
            return 0.0;
        }
        int latest_metric = this.pings[this.ping_count - 1].getMetric();
        if (this.variance) {
            return this.convertMetricToRating(latest_metric);
        }
        return 0.0;
    }

    public SpeedManagerLimitEstimate getEstimatedUploadCapacityBytesPerSec() {
        return this.up_capacity;
    }

    public void setEstimatedDownloadCapacityBytesPerSec(int bytes_per_sec, float estimate_type) {
        if (this.down_capacity.getBytesPerSec() != bytes_per_sec || this.down_capacity.getEstimateType() != estimate_type) {
            this.down_capacity.setBytesPerSec(bytes_per_sec);
            this.down_capacity.setEstimateType(estimate_type);
            this.speed_manager.informDownCapChanged();
        }
    }

    public SpeedManagerLimitEstimate getEstimatedDownloadCapacityBytesPerSec() {
        return this.down_capacity;
    }

    public void setEstimatedUploadCapacityBytesPerSec(int bytes_per_sec, float estimate_type) {
        if (this.up_capacity.getBytesPerSec() != bytes_per_sec || this.up_capacity.getEstimateType() != estimate_type) {
            this.up_capacity.setBytesPerSec(bytes_per_sec);
            this.up_capacity.setEstimateType(estimate_type);
            this.speed_manager.informUpCapChanged();
        }
    }

    protected synchronized void reset() {
        this.setEstimatedDownloadCapacityBytesPerSec(0, -0.1f);
        this.setEstimatedUploadCapacityBytesPerSec(0, -0.1f);
        this.ping_count = 0;
        this.regions.clear();
        this.last_bad_down = null;
        this.last_bad_downs.clear();
        this.last_bad_up = null;
        this.last_bad_ups.clear();
        this.saveHistory();
    }

    protected double convertMetricToRating(int metric) {
        if (metric < 50) {
            return 1.0;
        }
        if (metric >= 150) {
            return -1.0;
        }
        double val = 1.0 - ((double)metric - 50.0) / 50.0;
        if (val < -1.0) {
            val = -1.0;
        } else if (val > 1.0) {
            val = 1.0;
        }
        return val;
    }

    protected String getLimitStr(List limits, boolean short_form) {
        String str = "";
        if (limits != null) {
            Iterator it = limits.iterator();
            while (it.hasNext()) {
                str = str + (str.length() == 0 ? "" : ",");
                limitEstimate l = (limitEstimate)it.next();
                if (short_form) {
                    str = str + this.getShortString(l);
                    continue;
                }
                str = str + l.getString();
            }
        }
        return str;
    }

    protected String getShortString(SpeedManagerLimitEstimate l) {
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(l.getBytesPerSec());
    }

    protected void generateEvidence(IndentWriter writer) {
        writer.println("up_cap=" + this.up_capacity.getString());
        writer.println("down_cap=" + this.down_capacity.getString());
        writer.println("bad_up=" + this.getLimitStr(this.last_bad_ups, false));
        writer.println("bad_down=" + this.getLimitStr(this.last_bad_downs, false));
        if (this.best_good_up != null) {
            writer.println("best_up=" + this.best_good_up.getString());
        }
        if (this.best_good_down != null) {
            writer.println("best_down=" + this.best_good_down.getString());
        }
    }

    public void destroy() {
        if (this.trans) {
            this.speed_manager.destroy(this);
        } else {
            Debug.out("Attempt to destroy non-transient mapper!");
        }
    }

    public static void main(String[] args) {
        SpeedManagerPingMapperImpl pm = new SpeedManagerPingMapperImpl(null, "test", 100, true, false);
        Random rand = new Random();
        int[][] phases = new int[][]{{50, 0, 100000, 50}, {50, 100000, 200000, 200}, {50, 50000, 50000, 200}, {50, 0, 100000, 50}};
        for (int i = 0; i < phases.length; ++i) {
            int[] phase = phases[i];
            System.out.println("**** phase " + i);
            for (int j = 0; j < phase[0]; ++j) {
                int x_base = phase[1];
                int x_var = phase[2];
                int r = phase[3];
                pm.addPing(x_base + rand.nextInt(x_var), x_base + rand.nextInt(x_var), rand.nextInt(r), false);
                SpeedManagerLimitEstimate up = pm.getEstimatedUploadLimit(false);
                SpeedManagerLimitEstimate down = pm.getEstimatedDownloadLimit(false);
                if (up == null || down == null) continue;
                System.out.println(up.getString() + "," + down.getString());
            }
        }
    }

    class limitEstimate
    implements SpeedManagerLimitEstimate,
    Cloneable {
        private int speed;
        private float estimate_type;
        private float metric_rating;
        private long when;
        private int hits;
        private int[][] segs;

        protected limitEstimate(int _speed, double _estimate_type, double _metric_rating, int _hits, long _when, int[][] _segs) {
            this.speed = _speed;
            this.estimate_type = (float)_estimate_type;
            this.metric_rating = (float)_metric_rating;
            this.hits = _hits;
            this.when = _when;
            this.segs = _segs;
            if (this.metric_rating < -1.0f) {
                this.metric_rating = -1.0f;
            } else if (this.metric_rating > 1.0f) {
                this.metric_rating = 1.0f;
            }
        }

        public int getBytesPerSec() {
            return this.speed;
        }

        protected void setBytesPerSec(int s) {
            this.speed = s;
        }

        public float getEstimateType() {
            return this.estimate_type;
        }

        public void setEstimateType(float et) {
            this.estimate_type = et;
        }

        public float getMetricRating() {
            return this.metric_rating;
        }

        protected void setMetricRating(float mr) {
            this.metric_rating = mr;
        }

        public int[][] getSegments() {
            return this.segs;
        }

        protected int getHits() {
            return this.hits;
        }

        protected long getWhen() {
            return this.when;
        }

        public limitEstimate getClone() {
            try {
                return (limitEstimate)this.clone();
            }
            catch (Throwable e) {
                return null;
            }
        }

        public String getString() {
            return "speed=" + DisplayFormatters.formatByteCountToKiBEtc(this.speed) + ",metric=" + this.metric_rating + ",segs=" + this.segs.length + ",hits=" + this.hits + ",when=" + this.when;
        }
    }

    class pingValue {
        private short x;
        private short y;
        private short metric;

        protected pingValue(int _x, int _y, int _m) {
            this.x = (short)_x;
            this.y = (short)_y;
            this.metric = (short)_m;
        }

        protected int getX() {
            return this.x & 0xFFFF;
        }

        protected int getY() {
            return this.y & 0xFFFF;
        }

        protected int getMetric() {
            return this.metric & 0xFFFF;
        }

        protected String getString() {
            return "x=" + this.getX() + ",y=" + this.getY() + ",m=" + this.getMetric();
        }
    }

    class region
    implements SpeedManagerPingZone {
        private short x1;
        private short y1;
        private short x2;
        private short y2;
        private short metric;

        protected region(pingValue p1, pingValue p2) {
            short t;
            this.x1 = (short)p1.getX();
            this.y1 = (short)p1.getY();
            this.x2 = (short)p2.getX();
            this.y2 = (short)p2.getY();
            if (this.x2 < this.x1) {
                t = this.x1;
                this.x1 = this.x2;
                this.x2 = t;
            }
            if (this.y2 < this.y1) {
                t = this.y1;
                this.y1 = this.y2;
                this.y2 = t;
            }
            this.metric = (short)((p1.getMetric() + p2.getMetric()) / 2);
        }

        public int getX1() {
            return this.x1 & 0xFFFF;
        }

        public int getY1() {
            return this.y1 & 0xFFFF;
        }

        public int getX2() {
            return this.x2 & 0xFFFF;
        }

        public int getY2() {
            return this.y2 & 0xFFFF;
        }

        public int getUploadStartBytesPerSec() {
            return this.getX1() * 256;
        }

        public int getUploadEndBytesPerSec() {
            return this.getX2() * 256 + 255;
        }

        public int getDownloadStartBytesPerSec() {
            return this.getY1() * 256;
        }

        public int getDownloadEndBytesPerSec() {
            return this.getY2() * 256 + 255;
        }

        public int getMetric() {
            return this.metric & 0xFFFF;
        }

        public String getString() {
            return "x=" + this.getX1() + ",y=" + this.getY1() + ",w=" + (this.getX2() - this.getX1() + 1) + ",h=" + (this.getY2() - this.getY1() + 1);
        }
    }
}

