/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConfigurationAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitConfidence;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class SMConfigurationAdapterImpl
implements SMConfigurationAdapter {
    public SpeedManagerLimitEstimate getUploadLimit() {
        int upMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        SpeedLimitConfidence upConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter("SpeedLimitMonitor.setting.upload.limit.conf"));
        return new SMConfigLimitEstimate(upMax, upConf);
    }

    public SpeedManagerLimitEstimate getDownloadLimit() {
        int upMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        SpeedLimitConfidence upConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter("SpeedLimitMonitor.setting.download.limit.conf"));
        return new SMConfigLimitEstimate(upMax, upConf);
    }

    public void setUploadLimit(SpeedManagerLimitEstimate est) {
    }

    public void setDownloadLimit(SpeedManagerLimitEstimate est) {
    }

    static class SMConfigLimitEstimate
    implements SpeedManagerLimitEstimate {
        final int bytesPerSec;
        final float limitEstimateType;

        public SMConfigLimitEstimate(int rateInBytesPerSec, SpeedLimitConfidence conf) {
            this.bytesPerSec = rateInBytesPerSec;
            this.limitEstimateType = conf.asEstimateType();
        }

        public int getBytesPerSec() {
            return this.bytesPerSec;
        }

        public float getEstimateType() {
            return this.limitEstimateType;
        }

        public float getMetricRating() {
            return 0.0f;
        }

        public int[][] getSegments() {
            return new int[0][];
        }

        public String getString() {
            StringBuffer sb = new StringBuffer("estiamte: ");
            sb.append(this.bytesPerSec);
            sb.append(" (").append(this.limitEstimateType).append(") ");
            return sb.toString();
        }
    }
}

