/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.torrent;

import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class GlobalRatingUtils {
    private static final String TOR_AZ_PROP_GLOBAL_RATING = "GlobalRating";
    private static final String GLOBAL_RATING_STRING = "String";
    private static final String GLOBAL_RATING_COLOR = "Color";
    private static final String GLOBAL_RATING_COUNT = "Count";
    private static final String GLOBAL_RATING_REFRESH_ON = "Refresh On";
    public static final int RATING_WAITING = -2;
    public static final int RATING_NONE = -1;
    public static final int RATING_THUMBDOWN = 0;
    public static final int RATING_THUMBUP = 1;

    private static Map getTempGlobalRatingContentMap(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        Object o = mapContent.get(TOR_AZ_PROP_GLOBAL_RATING);
        if (o instanceof Map) {
            return (Map)o;
        }
        HashMap map = new HashMap();
        mapContent.put(TOR_AZ_PROP_GLOBAL_RATING, map);
        return map;
    }

    public static String getRatingString(TOTorrent torrent) {
        Map mapContent = GlobalRatingUtils.getTempGlobalRatingContentMap(torrent);
        Object o = mapContent.get(GLOBAL_RATING_STRING);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o != null) {
            Debug.out("String is not String - " + o.getClass() + "(" + o + ")");
        }
        return null;
    }

    public static void setRating(final TOTorrent torrent, String rating, String color, long count, long refreshOn) {
        if (torrent == null) {
            return;
        }
        Map mapContent = GlobalRatingUtils.getTempGlobalRatingContentMap(torrent);
        if (rating == null) {
            mapContent.remove(GLOBAL_RATING_STRING);
        } else {
            mapContent.put(GLOBAL_RATING_STRING, rating);
        }
        if (color == null) {
            mapContent.remove(GLOBAL_RATING_COLOR);
        } else {
            mapContent.put(GLOBAL_RATING_COLOR, color);
        }
        mapContent.put(GLOBAL_RATING_REFRESH_ON, new Long(refreshOn));
        mapContent.put(GLOBAL_RATING_COUNT, new Long(count));
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
        if (PlatformTorrentUtils.DEBUG_CACHING) {
            try {
                PlatformTorrentUtils.log("v3.GR.caching: setRating to " + rating + " for " + torrent.getHashWrapper().toBase32String() + ".  Next refresh in " + (refreshOn - SystemTime.getCurrentTime()));
            }
            catch (TOTorrentException e) {
                // empty catch block
            }
        }
        SimpleTimer.addEvent("Update G.Rating", refreshOn, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (PlatformTorrentUtils.DEBUG_CACHING) {
                    PlatformTorrentUtils.log("v3.GR.caching: refresh timer calling updateFromPlatform");
                }
                PlatformRatingMessenger.updateGlobalRating(torrent, 15000L);
            }
        });
    }

    public static String getColor(TOTorrent torrent) {
        Map mapContent = GlobalRatingUtils.getTempGlobalRatingContentMap(torrent);
        Object o = mapContent.get(GLOBAL_RATING_COLOR);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o != null) {
            Debug.out("Color is not String - " + o.getClass() + "(" + o + ")");
        }
        return null;
    }

    public static long getRefreshOn(TOTorrent torrent) {
        Map mapContent = GlobalRatingUtils.getTempGlobalRatingContentMap(torrent);
        Long l = (Long)mapContent.get(GLOBAL_RATING_REFRESH_ON);
        if (l == null) {
            return SystemTime.getCurrentTime();
        }
        return l;
    }

    public static long getCount(TOTorrent torrent) {
        Map mapContent = GlobalRatingUtils.getTempGlobalRatingContentMap(torrent);
        Long l = (Long)mapContent.get(GLOBAL_RATING_COUNT);
        if (l == null) {
            return 0L;
        }
        return l;
    }
}

