/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.torrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformTorrentMessenger;
import com.aelitis.azureus.core.torrent.HasBeenOpenedListener;
import com.aelitis.azureus.core.torrent.MetaDataUpdateListener;
import com.aelitis.azureus.core.torrent.SingleUserRatingInfo;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class PlatformTorrentUtils {
    private static final long RETRY_METADATA = 600000L;
    private static final long MIN_SPEED_DEFAULT = 102400L;
    private static final long MIN_MD_REFRESH_MS = 60000L;
    private static final long MAX_MD_REFRESH_MS = 2592000000L;
    public static final String AELITIS_HOST_CORE = "aelitis.com";
    public static final boolean DEBUG_CACHING = System.getProperty("az3.debug.caching", "0").equals("1");
    private static final String TOR_AZ_PROP_MAP = "Content";
    private static final String TOR_AZ_PROP_HASH = "Content Hash";
    private static final String TOR_AZ_PROP_TITLE = "Title";
    private static final String TOR_AZ_PROP_DESCRIPTION = "Description";
    private static final String TOR_AZ_PROP_CONTENT_TYPE = "Content Type";
    private static final String TOR_AZ_PROP_AUTHOR = "Author";
    private static final String TOR_AZ_PROP_PUBLISHER = "Publisher";
    private static final String TOR_AZ_PROP_URL = "URL";
    private static final String TOR_AZ_PROP_THUMBNAIL = "Thumbnail";
    private static final String TOR_AZ_PROP_THUMBNAIL_URL = "Thumbnail.url";
    private static final String TOR_AZ_PROP_QUALITY = "Quality";
    private static final String TOR_AZ_PROP_USER_RATING = "UserRating";
    private static final String TOR_AZ_PROP_LASTUPDATED = "Revision Date";
    private static final String TOR_AZ_PROP_CREATIONDATE = "Creation Date";
    private static final String TOR_AZ_PROP_METADATA_REFRESHON = "Refresh On";
    private static final String TOR_AZ_PROP_PROGRESSIVE = "Progressive";
    private static final String TOR_AZ_PROP_SPEED = "Speed Bps";
    private static final String TOR_AZ_PROP_MIN_SPEED = "Min Speed Bps";
    private static final String TOR_AZ_PROP_DRM = "DRM";
    private static final String TOR_AZ_PROP_PURCHASED = "Purchased";
    private static final String TOR_AZ_PROP_QOS_CLASS = "QOS Class";
    private static final String TOR_AZ_PROP_CONTENT_NETWORK = "Content Network";
    private static final String TOR_AZ_PROP_AD_ID = "Ad ID";
    private static final String TOR_AZ_PROP_AD_ENABLED = "Ad Enabled";
    private static final String TOR_AZ_PROP_EXPIRESON = "Expires On";
    private static final String TOR_AZ_PROP_PRIMARY_FILE = "Primary File Index";
    private static final ArrayList metaDataListeners = new ArrayList(1);
    private static final ArrayList hasBeenOpenedListeners = new ArrayList(1);
    private static final String TOR_AZ_PROP_USE_EMP = "useEMP";
    private static final String TOR_AZ_PROP_FILE_METADATA = "File MetaData";
    private static final String TOR_AZ_PROP_WEB_AD_ENABLED = "Web Ad Enabled";
    private static final String TOR_AZ_PROP_VIDEO_WIDTH = "Video Width";
    private static final String TOR_AZ_PROP_VIDEO_HEIGHT = "Video Height";
    private static final String TOR_AZ_PROP_VIDEO_RUNNINGTIME = "Running Time";
    private static final String TOR_AZ_PROP_OPENED = "Opened";
    private static ArrayList listPlatformHosts = null;
    private static final Map mapPlatformTrackerTorrents = new WeakHashMap();
    private static boolean embeddedPlayerAvail = false;

    public static Map getContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("azureus_properties");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    static Map getTempContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return new HashMap();
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("attributes");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("attributes", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    private static String getContentMapString(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void setContentMapString(TOTorrent torrent, String key, String value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, value);
    }

    private static long getContentMapLong(TOTorrent torrent, String key, long def) {
        if (torrent == null) {
            return def;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        try {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            if (obj instanceof byte[]) {
                return Long.parseLong(new String((byte[])obj));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return def;
    }

    public static Map getContentMapMap(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    private static void setContentMapLong(TOTorrent torrent, String key, long value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, new Long(value));
    }

    public static void setContentMapMap(TOTorrent torrent, String key, Map value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, value);
    }

    public static String getContentHash(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_HASH);
    }

    public static String getContentTitle(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_TITLE);
    }

    public static void setContentTitle(TOTorrent torrent, String title) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_TITLE, title);
    }

    public static String getContentDescription(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_DESCRIPTION);
    }

    public static String getContentType(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_CONTENT_TYPE);
    }

    public static String getContentAuthor(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_AUTHOR);
    }

    public static String getContentPublisher(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_PUBLISHER);
    }

    public static String getContentURL(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_URL);
    }

    public static String getContentQuality(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_QUALITY);
    }

    public static boolean isContentDRM(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_DRM, -1L) >= 0L;
    }

    public static boolean isContentPurchased(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PURCHASED, 0L) == 1L;
    }

    public static long getQOSClass(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_QOS_CLASS, 0L);
    }

    public static void setQOSClass(TOTorrent torrent, long cla) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_QOS_CLASS, cla);
    }

    public static long getContentNetworkID(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentNetworkID(torrent, -1L);
    }

    public static long getContentNetworkID(TOTorrent torrent, long def) {
        long id = PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_CONTENT_NETWORK, -1L);
        if (id == -1L) {
            return PlatformTorrentUtils.isContent(torrent, false) ? 1L : def;
        }
        return id;
    }

    public static void setContentNetworkID(TOTorrent torrent, long cnet) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_CONTENT_NETWORK, cnet);
    }

    private static void putOrRemove(Map map, String key, Object obj) {
        if (obj == null || obj.equals(null)) {
            map.remove(key);
        } else {
            map.put(key, obj);
        }
    }

    public static void setContentQuality(TOTorrent torrent, String sQualityID) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_QUALITY, sQualityID);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    private static void writeTorrentIfExists(TOTorrent torrent) {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (core == null || !core.isStarted()) {
            return;
        }
        GlobalManager gm = core.getGlobalManager();
        if (gm == null || gm.getDownloadManager(torrent) == null) {
            return;
        }
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static byte[] getContentThumbnail(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(TOR_AZ_PROP_THUMBNAIL);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public static String getContentThumbnailUrl(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_URL);
    }

    public static void setContentThumbnail(TOTorrent torrent, byte[] thumbnail) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_THUMBNAIL, thumbnail);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static void setUserRating(TOTorrent torrent, int rating) {
        if (torrent == null || PlatformTorrentUtils.getUserRating(torrent) == rating) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        mapContent.put(TOR_AZ_PROP_USER_RATING, new Long(rating));
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
        SingleUserRatingInfo ratingReply = new SingleUserRatingInfo(torrent);
        PlatformRatingMessenger.invokeUpdateListeners(ratingReply);
    }

    public static void removeUserRating(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        if (mapContent.remove(TOR_AZ_PROP_USER_RATING) != null) {
            PlatformTorrentUtils.writeTorrentIfExists(torrent);
            SingleUserRatingInfo ratingReply = new SingleUserRatingInfo(torrent);
            PlatformRatingMessenger.invokeUpdateListeners(ratingReply);
        }
    }

    public static int getUserRating(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        Long l = (Long)mapContent.get(TOR_AZ_PROP_USER_RATING);
        if (l == null) {
            return -1;
        }
        return l.intValue();
    }

    public static long getMetaDataRefreshOn(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        Long l = (Long)mapContent.get(TOR_AZ_PROP_METADATA_REFRESHON);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static void setMetaDataRefreshOn(TOTorrent torrent, long refreshOn) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        mapContent.put(TOR_AZ_PROP_METADATA_REFRESHON, new Long(refreshOn));
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static boolean isContent(TOTorrent torrent, boolean requirePlatformTracker) {
        boolean bContent;
        if (torrent == null) {
            return false;
        }
        boolean bl = bContent = PlatformTorrentUtils.getContentHash(torrent) != null;
        if (!bContent || bContent && !requirePlatformTracker) {
            return bContent;
        }
        return PlatformTorrentUtils.isPlatformTracker(torrent);
    }

    public static boolean isContent(Torrent torrent, boolean requirePlatformTracker) {
        if (torrent instanceof TorrentImpl) {
            return PlatformTorrentUtils.isContent(((TorrentImpl)torrent).getTorrent(), requirePlatformTracker);
        }
        return false;
    }

    public static List getPlatformHosts() {
        if (listPlatformHosts == null) {
            listPlatformHosts = new ArrayList();
            for (int i = 0; i < Constants.AZUREUS_DOMAINS.length; ++i) {
                listPlatformHosts.add(Constants.AZUREUS_DOMAINS[i].toLowerCase());
            }
        }
        return listPlatformHosts;
    }

    public static void addPlatformHost(String host) {
        List platformHosts = PlatformTorrentUtils.getPlatformHosts();
        if (!platformHosts.contains(host = host.toLowerCase())) {
            platformHosts.add(host);
            mapPlatformTrackerTorrents.clear();
        }
    }

    public static boolean isPlatformHost(String host) {
        Object[] domains = PlatformTorrentUtils.getPlatformHosts().toArray();
        host = host.toLowerCase();
        for (int i = 0; i < domains.length; ++i) {
            String domain = (String)domains[i];
            if (domain.equals(host)) {
                return true;
            }
            if (!host.endsWith("." + domain)) continue;
            return true;
        }
        if (Constants.isCVSVersion()) {
            try {
                InetAddress ia = InetAddress.getByName(host);
                return ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPlatformTracker(TOTorrent torrent) {
        try {
            if (torrent == null) {
                return false;
            }
            Object oCache = mapPlatformTrackerTorrents.get(torrent);
            if (oCache instanceof Boolean) {
                return (Boolean)oCache;
            }
            URL announceURL = torrent.getAnnounceURL();
            if (announceURL != null && !PlatformTorrentUtils.isPlatformHost(announceURL.getHost())) {
                mapPlatformTrackerTorrents.put(torrent, new Boolean(false));
                return false;
            }
            TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
            for (int i = 0; i < sets.length; ++i) {
                URL[] urls = sets[i].getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    if (PlatformTorrentUtils.isPlatformHost(urls[j].getHost())) continue;
                    mapPlatformTrackerTorrents.put(torrent, new Boolean(false));
                    return false;
                }
            }
            boolean b = announceURL != null;
            mapPlatformTrackerTorrents.put(torrent, new Boolean(b));
            return b;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            mapPlatformTrackerTorrents.put(torrent, new Boolean(false));
            return false;
        }
    }

    public static boolean isPlatformTracker(Torrent torrent) {
        if (torrent instanceof TorrentImpl) {
            return PlatformTorrentUtils.isPlatformTracker(((TorrentImpl)torrent).getTorrent());
        }
        return false;
    }

    public static boolean isUpdateDM(DownloadManager dm) {
        Boolean oisUpdate = (Boolean)dm.getUserData("isUpdate");
        if (oisUpdate != null) {
            return oisUpdate;
        }
        boolean isUpdate = true;
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            isUpdate = false;
        } else {
            URL announceURL = torrent.getAnnounceURL();
            if (announceURL != null && announceURL.getHost().indexOf(AELITIS_HOST_CORE) == -1) {
                isUpdate = false;
            }
            if (isUpdate) {
                TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
                block0: for (int i = 0; i < sets.length; ++i) {
                    URL[] urls = sets[i].getAnnounceURLs();
                    for (int j = 0; j < urls.length; ++j) {
                        if (urls[j].getHost().indexOf(AELITIS_HOST_CORE) != -1) continue;
                        isUpdate = false;
                        continue block0;
                    }
                }
            }
        }
        dm.setUserData("isUpdate", new Boolean(isUpdate));
        return isUpdate;
    }

    public static String getAdId(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_AD_ID);
    }

    public static void setAdId(TOTorrent torrent, String sID) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_AD_ID, sID);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static void updateMetaData(final TOTorrent torrent, long maxDelayMS) {
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            PlatformTorrentUtils.log(torrent, "torrent " + new String(torrent.getName()) + " not az content");
            return;
        }
        PlatformTorrentUtils.log(torrent, "updateMD");
        PlatformTorrentMessenger.getMetaData(PlatformTorrentUtils.getContentNetworkID(torrent), new TOTorrent[]{torrent}, maxDelayMS, new PlatformTorrentMessenger.GetMetaDataReplyListener(){

            public void messageSent() {
            }

            public void replyReceived(String replyType, Map mapHashes) {
                PlatformTorrentUtils.updateMetaData_handleReply(torrent, null, replyType, mapHashes);
            }
        });
    }

    private static void updateMetaData_handleReply(TOTorrent torrent, String hash, String replyType, Map mapHashes) {
        if (hash == null && torrent != null) {
            try {
                hash = torrent.getHashWrapper().toBase32String();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
        if (torrent == null && dm != null) {
            torrent = dm.getTorrent();
        }
        Map contentMap = PlatformTorrentUtils.getContentMap(torrent);
        final TOTorrent torrentFinal = torrent;
        if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
            if (torrent != null) {
                PlatformTorrentUtils.log(torrent, "Exception, retrying later (~600000ms)");
                SimpleTimer.addEvent("Update MD Retry", SystemTime.getCurrentTime() + 600000L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        PlatformTorrentUtils.log(torrentFinal, "retry time");
                        PlatformTorrentUtils.updateMetaData(torrentFinal, 15000L);
                    }
                });
            }
        } else {
            Map jsonMapMetaData;
            Map map = jsonMapMetaData = hash == null ? null : (Map)mapHashes.get(hash);
            if (jsonMapMetaData != null && !jsonMapMetaData.isEmpty()) {
                String title;
                long oldLastUpdated = PlatformTorrentUtils.getContentLastUpdated(torrent);
                long expireyMins = 0L;
                for (String key : jsonMapMetaData.keySet()) {
                    Object value = jsonMapMetaData.get(key);
                    if (value == null || value.equals(null)) {
                        contentMap.remove(key);
                    } else if ((key.equals(TOR_AZ_PROP_THUMBNAIL) || key.endsWith(".B64")) && value instanceof String) {
                        contentMap.put(key, Base64.decode((String)value));
                    } else if (key.equals("expires-in-mins") && value instanceof Long) {
                        expireyMins = (Long)value;
                    } else {
                        contentMap.put(key, value);
                    }
                    PlatformTorrentUtils.writeTorrentIfExists(torrent);
                }
                if (dm != null && (title = PlatformTorrentUtils.getContentTitle(torrent)) != null && title.length() > 0 && dm.getDownloadState().getDisplayName() == null) {
                    dm.getDownloadState().setDisplayName(title);
                }
                PlatformTorrentUtils.triggerMetaDataUpdateListeners(torrent);
                if (torrent != null) {
                    long refreshOn;
                    if (expireyMins > 0L) {
                        refreshOn = SystemTime.getCurrentTime() + expireyMins * 60L * 1000L;
                    } else {
                        long newLastUpdated = PlatformTorrentUtils.getContentLastUpdated(torrent);
                        long diff = newLastUpdated - oldLastUpdated;
                        PlatformTorrentUtils.log(torrent, "Last Updated: new " + new Date(newLastUpdated) + ";old " + new Date(oldLastUpdated) + ";diff=" + diff);
                        if (diff > 0L && oldLastUpdated != 0L) {
                            if ((diff *= 2L) < 60000L) {
                                diff = 60000L;
                            } else if (diff > 2592000000L) {
                                diff = 2592000000L;
                            }
                            refreshOn = SystemTime.getOffsetTime(diff);
                        } else {
                            refreshOn = SystemTime.getCurrentTime() + 604800000L;
                        }
                    }
                    PlatformTorrentUtils.log(torrent, "got MD. Next refresh in " + (refreshOn - SystemTime.getCurrentTime()));
                    PlatformTorrentUtils.setMetaDataRefreshOn(torrent, refreshOn);
                    SimpleTimer.addEvent("Update MD", refreshOn, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            PlatformTorrentUtils.updateMetaData(torrentFinal, 15000L);
                        }
                    });
                }
            } else if (torrent != null) {
                long refreshOn = SystemTime.getCurrentTime() + 2592000000L;
                PlatformTorrentUtils.setMetaDataRefreshOn(torrent, refreshOn);
                PlatformTorrentUtils.log(torrent, "no hash in reply. Next refresh on " + new Date(refreshOn));
            }
        }
    }

    public static void addListener(MetaDataUpdateListener l) {
        if (metaDataListeners.indexOf(l) < 0) {
            metaDataListeners.add(l);
        }
    }

    public static void removeListener(MetaDataUpdateListener l) {
        metaDataListeners.remove(l);
    }

    public static void triggerMetaDataUpdateListeners(TOTorrent torrent) {
        if (torrent == null) {
            return;
        }
        MetaDataUpdateListener[] listeners = metaDataListeners.toArray(new MetaDataUpdateListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            MetaDataUpdateListener listener = listeners[i];
            try {
                listener.metaDataUpdated(torrent);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public static long getContentLastUpdated(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_LASTUPDATED, 0L);
    }

    public static void setContentLastUpdated(TOTorrent torrent, long lastUpdate) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_LASTUPDATED, lastUpdate);
    }

    public static boolean isContentProgressive(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PROGRESSIVE, 0L) == 1L;
    }

    public static long getContentStreamSpeedBps(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_SPEED, 0L);
    }

    public static long getContentMinimumSpeedBps(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_MIN_SPEED, 102400L);
    }

    public static boolean isContentAdEnabled(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_AD_ENABLED, 0L) == 1L || PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_WEB_AD_ENABLED, 0L) == 1L;
    }

    public static boolean isContentUnitAdEnabled(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_WEB_AD_ENABLED, 0L) == 1L;
    }

    public static boolean isContentWebAdEnabled(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_WEB_AD_ENABLED, 0L) == 1L;
    }

    public static boolean useEMP(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_USE_EMP, 0L) == 1L;
    }

    public static void setUseEMP(TOTorrent torrent, boolean useEMP) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_USE_EMP, useEMP ? 1L : 0L);
    }

    public static void setFileMetaData(TOTorrent torrent, Map map) {
        PlatformTorrentUtils.setContentMapMap(torrent, TOR_AZ_PROP_FILE_METADATA, map);
    }

    public static Map getFileMetaData(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapMap(torrent, TOR_AZ_PROP_FILE_METADATA);
    }

    public static long getExpiresOn(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Long l = (Long)mapContent.get(TOR_AZ_PROP_EXPIRESON);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static void setExpiresOn(TOTorrent torrent, long expiresOn) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(TOR_AZ_PROP_EXPIRESON, new Long(expiresOn));
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static int getContentPrimaryFileIndex(TOTorrent torrent) {
        return (int)PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PRIMARY_FILE, -1L);
    }

    private static long getContentVideoWidth(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_VIDEO_WIDTH, -1L);
    }

    private static long getContentVideoHeight(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_VIDEO_HEIGHT, -1L);
    }

    public static long getContentVideoRunningTime(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_VIDEO_RUNNINGTIME, -1L);
    }

    public static int[] getContentVideoResolution(TOTorrent torrent) {
        long width = PlatformTorrentUtils.getContentVideoWidth(torrent);
        if (width <= 0L) {
            return null;
        }
        long height = PlatformTorrentUtils.getContentVideoHeight(torrent);
        if (height <= 0L) {
            return null;
        }
        return new int[]{(int)width, (int)height};
    }

    public static void log(String str) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.MD");
        diag_logger.log(str);
        if (DEBUG_CACHING) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + str);
        }
    }

    public static void log(TOTorrent torrent, String string) {
        String hash = "";
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformTorrentUtils.log(hash + "] " + string);
    }

    public static boolean embeddedPlayerAvail() {
        if (embeddedPlayerAvail) {
            return true;
        }
        try {
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", true);
            if (pi != null) {
                embeddedPlayerAvail = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return embeddedPlayerAvail;
    }

    public static String getContentTitle2(DownloadManager dm) {
        if (dm == null) {
            return null;
        }
        String name = dm.getDownloadState().getDisplayName();
        if ((name == null || name.length() == 0) && (name = PlatformTorrentUtils.getContentTitle(dm.getTorrent())) == null) {
            name = dm.getDisplayName();
        }
        return name;
    }

    public static void setHasBeenOpened(DownloadManager dm, boolean opened) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        if (opened == PlatformTorrentUtils.getHasBeenOpened(dm)) {
            return;
        }
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_OPENED, opened ? 1L : 0L);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
        Object[] array = hasBeenOpenedListeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                HasBeenOpenedListener l = (HasBeenOpenedListener)array[i];
                l.hasBeenOpenedChanged(dm, opened);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public static boolean getHasBeenOpened(DownloadManager dm) {
        boolean opened;
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return true;
        }
        boolean bl = opened = PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_OPENED, -1L) > 0L;
        return opened || PlatformTorrentUtils.getAdId(torrent) != null || PlatformTorrentUtils.isUpdateDM(dm);
    }

    public static void addHasBeenOpenedListener(HasBeenOpenedListener l) {
        hasBeenOpenedListeners.add(l);
    }
}

