/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteList<T>
implements Iterable<T> {
    private static final boolean LOG_STATS = false;
    private List<T> list = Collections.emptyList();
    private boolean visible = false;
    private int initialCapacity;
    private static CopyOnWriteList stats;

    public CopyOnWriteList(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        if (stats != null) {
            stats.add(new WeakReference<CopyOnWriteList>(this));
        }
    }

    public CopyOnWriteList() {
        this.initialCapacity = 1;
        if (stats != null) {
            stats.add(new WeakReference<CopyOnWriteList>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                ArrayList<T> new_list = new ArrayList<T>(this.list);
                new_list.add(obj);
                this.list = new_list;
                this.visible = false;
            } else {
                if (this.list == Collections.emptyList()) {
                    this.list = new ArrayList<T>(this.initialCapacity);
                }
                this.list.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                ArrayList<T> new_list = new ArrayList<T>(this.list);
                boolean result = new_list.remove(obj);
                this.list = new_list;
                this.visible = false;
                return result;
            }
            return this.list.remove(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.list = Collections.emptyList();
            this.visible = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.contains(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            return new CopyOnWriteListIterator(this.list.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getList() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            return this.list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] toArray(T[] x) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.toArray(x);
        }
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyOnWriteListIterator
    implements Iterator<T> {
        private Iterator<T> it;
        private T last;

        protected CopyOnWriteListIterator(Iterator<T> _it) {
            this.it = _it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteList.this.remove(this.last);
        }
    }
}

