/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;

public class BloomFilterAddRemove4Bit
extends BloomFilterImpl {
    private byte[] map = new byte[(this.getMaxEntries() + 1) / 2];

    public BloomFilterAddRemove4Bit(int _max_entries) {
        super(_max_entries);
    }

    public BloomFilter getReplica() {
        return new BloomFilterAddRemove4Bit(this.getMaxEntries());
    }

    protected int trimValue(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 15) {
            return 15;
        }
        return value;
    }

    protected int getValue(int index) {
        byte b = this.map[index / 2];
        if (index % 2 == 0) {
            return b & 0xF & 0xFF;
        }
        return b >> 4 & 0xF & 0xFF;
    }

    protected int incValue(int index) {
        int original_value = this.getValue(index);
        if (original_value >= 15) {
            return 15;
        }
        this.setValue(index, (byte)(original_value + 1));
        return original_value;
    }

    protected int decValue(int index) {
        int original_value = this.getValue(index);
        if (original_value <= 0) {
            return 0;
        }
        this.setValue(index, (byte)(original_value - 1));
        return original_value;
    }

    private void setValue(int index, byte value) {
        byte b = this.map[index / 2];
        b = index % 2 == 0 ? (byte)(b & 0xF0 | value) : (byte)(b & 0xF | value << 4 & 0xF0);
        this.map[index / 2] = b;
    }
}

