/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;

public class BloomFilterAddRemove8Bit
extends BloomFilterImpl {
    private byte[] map = new byte[this.getMaxEntries()];

    public BloomFilterAddRemove8Bit(int _max_entries) {
        super(_max_entries);
    }

    public BloomFilter getReplica() {
        return new BloomFilterAddRemove8Bit(this.getMaxEntries());
    }

    protected int trimValue(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    protected int getValue(int index) {
        return this.map[index] & 0xFF;
    }

    protected int incValue(int index) {
        int original_value = this.getValue(index);
        if (original_value >= 255) {
            return 255;
        }
        this.setValue(index, (byte)(original_value + 1));
        return original_value;
    }

    protected int decValue(int index) {
        int original_value = this.getValue(index);
        if (original_value <= 0) {
            return 0;
        }
        this.setValue(index, (byte)(original_value - 1));
        return original_value;
    }

    private void setValue(int index, byte value) {
        this.map[index] = value;
    }
}

