/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class ExternalSeedPeer
implements Peer,
ExternalSeedReaderListener {
    private ExternalSeedPlugin plugin;
    private Download download;
    private PeerManager manager;
    private PeerStats stats;
    private Map user_data;
    private ExternalSeedReader reader;
    private int state;
    private byte[] peer_id;
    private boolean[] available;
    private boolean availabilityAdded;
    private long snubbed;
    private boolean is_optimistic;
    private Monitor connection_mon;
    private boolean peer_added;
    private List request_list = new ArrayList();
    private CopyOnWriteList listeners;
    private Monitor listeners_mon;
    private boolean doing_allocations;

    protected ExternalSeedPeer(ExternalSeedPlugin _plugin, Download _download, ExternalSeedReader _reader) {
        this.plugin = _plugin;
        this.download = _download;
        this.reader = _reader;
        this.connection_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        Torrent torrent = this.reader.getTorrent();
        this.available = new boolean[(int)torrent.getPieceCount()];
        Arrays.fill(this.available, true);
        this.peer_id = new byte[20];
        new Random().nextBytes(this.peer_id);
        this.peer_id[0] = 69;
        this.peer_id[1] = 120;
        this.peer_id[2] = 116;
        this.peer_id[3] = 32;
        this.listeners = new CopyOnWriteList();
        this.listeners_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        _reader.addListener(this);
    }

    protected boolean sameAs(ExternalSeedPeer other) {
        return this.reader.sameAs(other.reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setManager(PeerManager _manager) {
        this.setState(10);
        try {
            this.connection_mon.enter();
            this.manager = _manager;
            this.stats = this.manager == null ? null : this.manager.createPeerStats(this);
            this.checkConnection();
        }
        finally {
            this.connection_mon.exit();
        }
    }

    public PeerManager getManager() {
        return this.manager;
    }

    protected Download getDownload() {
        return this.download;
    }

    protected ExternalSeedReader getReader() {
        return this.reader;
    }

    protected void setState(int newState) {
        this.state = newState;
        this.fireEvent(1, new Integer(newState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() {
        boolean state_changed = false;
        try {
            this.connection_mon.enter();
            boolean active = this.reader.checkActivation(this.manager, this);
            if (this.manager != null && active != this.peer_added) {
                state_changed = true;
                boolean peer_was_added = this.peer_added;
                this.peer_added = active;
                if (active) {
                    this.addPeer();
                } else if (peer_was_added) {
                    this.removePeer();
                }
            }
        }
        finally {
            this.connection_mon.exit();
        }
        return state_changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer() {
        this.setState(20);
        this.manager.addPeer(this);
        if (this.peer_added) {
            this.setState(30);
            try {
                this.listeners_mon.enter();
                if (this.availabilityAdded) {
                    Debug.out("availabililty already added");
                } else {
                    this.availabilityAdded = true;
                    this.fireEvent(3, this.getAvailable());
                }
            }
            finally {
                this.listeners_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer() {
        this.setState(40);
        try {
            this.listeners_mon.enter();
            if (this.availabilityAdded) {
                this.availabilityAdded = false;
                this.fireEvent(4, this.getAvailable());
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        this.manager.removePeer(this);
        this.setState(50);
    }

    public void requestComplete(PeerReadRequest request2, PooledByteBuffer data) {
        PeerManager man = this.manager;
        if (request2.isCancelled() || man == null) {
            data.returnToPool();
        } else {
            try {
                man.requestComplete(request2, data, this);
            }
            catch (Throwable e) {
                data.returnToPool();
                e.printStackTrace();
            }
        }
    }

    public void requestCancelled(PeerReadRequest request2) {
        PeerManager man = this.manager;
        if (man != null) {
            man.requestCancelled(request2, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFailed(PeerReadRequest request2) {
        PeerManager man = this.manager;
        if (man != null) {
            man.requestCancelled(request2, this);
            try {
                this.connection_mon.enter();
                if (this.peer_added) {
                    this.plugin.log(this.reader.getName() + " failed - " + this.reader.getStatus() + ", permanent = " + this.reader.isPermanentlyUnavailable());
                    this.peer_added = false;
                    this.removePeer();
                }
            }
            finally {
                this.connection_mon.exit();
            }
            if (this.reader.isTransient() && this.reader.isPermanentlyUnavailable()) {
                this.plugin.removePeer(this);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public byte[] getId() {
        return this.peer_id;
    }

    public String getIp() {
        return this.reader.getIP();
    }

    public int getTCPListenPort() {
        return 0;
    }

    public int getUDPListenPort() {
        return 0;
    }

    public int getUDPNonDataListenPort() {
        return 0;
    }

    public int getPort() {
        return this.reader.getPort();
    }

    public final boolean[] getAvailable() {
        return this.available;
    }

    public final boolean isPieceAvailable(int pieceNumber) {
        return true;
    }

    public boolean isTransferAvailable() {
        return this.reader.isActive();
    }

    public boolean isDownloadPossible() {
        return this.peer_added && this.reader.isActive();
    }

    public boolean isChoked() {
        return false;
    }

    public boolean isChoking() {
        return false;
    }

    public boolean isInterested() {
        return false;
    }

    public boolean isInteresting() {
        return true;
    }

    public boolean isSeed() {
        return true;
    }

    public boolean isSnubbed() {
        if (this.snubbed != 0L && this.reader.getRequestCount() == 0) {
            this.snubbed = 0L;
        }
        return this.snubbed != 0L;
    }

    public long getSnubbedTime() {
        if (!this.isSnubbed()) {
            return 0L;
        }
        long now = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        if (now < this.snubbed) {
            this.snubbed = now - 26L;
        }
        return now - this.snubbed;
    }

    public void setSnubbed(boolean b) {
        if (!b) {
            this.snubbed = 0L;
        } else if (this.snubbed == 0L) {
            this.snubbed = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        }
    }

    public boolean isOptimisticUnchoke() {
        return this.is_optimistic;
    }

    public void setOptimisticUnchoke(boolean _is_optimistic) {
        this.is_optimistic = _is_optimistic;
    }

    public PeerStats getStats() {
        return this.stats;
    }

    public boolean isIncoming() {
        return false;
    }

    public int getPercentDone() {
        return 1000;
    }

    public int getPercentDoneInThousandNotation() {
        return 1000;
    }

    public String getClient() {
        return this.reader.getName();
    }

    public List getExpiredRequests() {
        return this.reader.getExpiredRequests();
    }

    public List getRequests() {
        return this.reader.getRequests();
    }

    public int getMaximumNumberOfRequests() {
        return this.reader.getMaximumNumberOfRequests();
    }

    public int getNumberOfRequests() {
        return this.reader.getRequestCount() + this.request_list.size();
    }

    public int[] getPriorityOffsets() {
        return this.reader.getPriorityOffsets();
    }

    public boolean requestAllocationStarts(int[] base_priorities) {
        PeerManager pm;
        if (this.doing_allocations) {
            Debug.out("recursive allocations");
        }
        this.doing_allocations = true;
        if (this.request_list.size() != 0) {
            Debug.out("req list must be empty");
        }
        if ((pm = this.manager) != null) {
            this.reader.calculatePriorityOffsets(pm, base_priorities);
        }
        return true;
    }

    public void requestAllocationComplete() {
        this.reader.addRequests(this.request_list);
        this.request_list.clear();
        this.doing_allocations = false;
    }

    public boolean addRequest(PeerReadRequest request2) {
        if (!this.doing_allocations) {
            Debug.out("request added when not in allocation phase");
        }
        this.request_list.add(request2);
        this.snubbed = 0L;
        return true;
    }

    public void cancelRequest(PeerReadRequest request2) {
        this.reader.cancelRequest(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean closedOnError, boolean attemptReconnect) {
        boolean peer_was_added;
        try {
            this.connection_mon.enter();
            peer_was_added = this.peer_added;
            this.reader.cancelAllRequests();
            this.reader.deactivate(reason);
            this.peer_added = false;
            try {
                this.listeners_mon.enter();
                if (this.availabilityAdded) {
                    this.availabilityAdded = false;
                    this.fireEvent(4, this.getAvailable());
                }
            }
            finally {
                this.listeners_mon.exit();
            }
        }
        finally {
            this.connection_mon.exit();
        }
        if (peer_was_added) {
            this.manager.removePeer(this);
        }
        this.setState(50);
        if (this.reader.isTransient()) {
            this.plugin.removePeer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerListener2 listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerListener2 listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(final int type, final Object data) {
        try {
            this.listeners_mon.enter();
            List ref = this.listeners.getList();
            for (int i = 0; i < ref.size(); ++i) {
                try {
                    Object listener;
                    Object _listener = ref.get(i);
                    if (_listener instanceof PeerListener) {
                        listener = (PeerListener)_listener;
                        if (type == 1) {
                            listener.stateChanged((Integer)data);
                            continue;
                        }
                        if (type != 2) continue;
                        Integer[] d = (Integer[])data;
                        listener.sentBadChunk(d[0], d[1]);
                        continue;
                    }
                    listener = (PeerListener2)_listener;
                    listener.eventOccurred(new PeerEvent(){

                        public int getType() {
                            return type;
                        }

                        public Object getData() {
                            return data;
                        }
                    });
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public Connection getConnection() {
        return null;
    }

    public boolean supportsMessaging() {
        return false;
    }

    public Message[] getSupportedMessages() {
        return new Message[0];
    }

    public int readBytes(int max) {
        int res = this.reader.readBytes(max);
        if (res > 0) {
            this.stats.received(res);
        }
        return res;
    }

    public int writeBytes(int max) {
        throw new RuntimeException("Not supported");
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.reader.getPercentDoneOfCurrentIncomingRequest();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return 0;
    }

    public Map getProperties() {
        return new HashMap();
    }

    public String getName() {
        return this.reader.getName();
    }

    public void setUserData(Object key, Object value) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(key, value);
    }

    public Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(key);
    }

    public byte[] getHandshakeReservedBytes() {
        return null;
    }

    public boolean isPriorityConnection() {
        return false;
    }

    public void setPriorityConnection(boolean is_priority) {
    }
}

