/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloader
implements SEPasswordListener {
    public static final String NL = "\r\n";
    private URL url;
    private String user_agent;
    private int last_response;
    private int last_response_retry_after_secs;

    public ExternalSeedHTTPDownloader(URL _url, String _user_agent) {
        this.url = _url;
        this.user_agent = _user_agent;
    }

    public URL getURL() {
        return this.url;
    }

    public void download(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.download(new String[0], new String[0], length, listener, con_fail_is_perm_fail);
    }

    public void downloadRange(long offset, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.download(new String[]{"Range"}, new String[]{"bytes=" + offset + "-" + (offset + (long)length - 1L)}, length, listener, con_fail_is_perm_fail);
    }

    public void download(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        block30: {
            boolean connected = false;
            InputStream is = null;
            String outcome = "";
            try {
                int response;
                SESecurityManager.setThreadPasswordHandler(this);
                HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                connection.setRequestProperty("Connection", "Keep-Alive");
                connection.setRequestProperty("User-Agent", this.user_agent);
                for (int i = 0; i < prop_names.length; ++i) {
                    connection.setRequestProperty(prop_names[i], prop_values[i]);
                }
                int time_remaining = listener.getPermittedTime();
                if (time_remaining > 0) {
                    Java15Utils.setConnectTimeout(connection, time_remaining);
                }
                connection.connect();
                time_remaining = listener.getPermittedTime();
                if (time_remaining < 0) {
                    throw new IOException("Timeout during connect");
                }
                Java15Utils.setReadTimeout(connection, time_remaining);
                connected = true;
                this.last_response = response = connection.getResponseCode();
                this.last_response_retry_after_secs = -1;
                if (response == 503) {
                    long retry_after_date = new Long(connection.getHeaderFieldDate("Retry-After", -1L));
                    if (retry_after_date <= -1L) {
                        this.last_response_retry_after_secs = connection.getHeaderFieldInt("Retry-After", -1);
                    } else {
                        this.last_response_retry_after_secs = (int)((retry_after_date - System.currentTimeMillis()) / 1000L);
                        if (this.last_response_retry_after_secs < 0) {
                            this.last_response_retry_after_secs = -1;
                        }
                    }
                }
                is = connection.getInputStream();
                if (response == 202 || response == 200 || response == 206) {
                    int pos;
                    int len;
                    byte[] buffer = null;
                    int buffer_pos = 0;
                    int buffer_len = 0;
                    for (pos = 0; pos < length; pos += len) {
                        if (buffer == null) {
                            buffer = listener.getBuffer();
                            buffer_pos = listener.getBufferPosition();
                            buffer_len = listener.getBufferLength();
                        }
                        listener.setBufferPosition(buffer_pos);
                        int to_read = buffer_len - buffer_pos;
                        int permitted = listener.getPermittedBytes();
                        if (permitted < to_read) {
                            to_read = permitted;
                        }
                        if ((len = is.read(buffer, buffer_pos, to_read)) < 0) break;
                        listener.reportBytesRead(len);
                        if ((buffer_pos += len) != buffer_len) continue;
                        listener.done();
                        buffer = null;
                        buffer_pos = 0;
                    }
                    if (pos != length) {
                        String log_str;
                        if (buffer == null) {
                            log_str = "No buffer assigned";
                        } else {
                            log_str = new String(buffer, 0, length);
                            if (log_str.length() > 64) {
                                log_str = log_str.substring(0, 64);
                            }
                        }
                        outcome = "Connection failed: data too short - " + length + "/" + pos + " [" + log_str + "]";
                        throw new ExternalSeedException(outcome);
                    }
                    outcome = "read " + pos + " bytes";
                    break block30;
                }
                outcome = "Connection failed: " + connection.getResponseMessage();
                ExternalSeedException error = new ExternalSeedException(outcome);
                error.setPermanentFailure(true);
                throw error;
            }
            catch (IOException e) {
                if (con_fail_is_perm_fail && !connected) {
                    outcome = "Connection failed: " + e.getMessage();
                    ExternalSeedException error = new ExternalSeedException(outcome);
                    error.setPermanentFailure(true);
                    throw error;
                }
                outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                if (this.last_response_retry_after_secs >= 0) {
                    outcome = outcome + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                }
                ExternalSeedException excep = new ExternalSeedException(outcome, e);
                if (e instanceof FileNotFoundException) {
                    excep.setPermanentFailure(true);
                }
                throw excep;
            }
            catch (Throwable e) {
                if (e instanceof ExternalSeedException) {
                    throw (ExternalSeedException)e;
                }
                outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                throw new ExternalSeedException("Connection failed", e);
            }
            finally {
                SESecurityManager.unsetThreadPasswordHandler();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    public void downloadSocket(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.downloadSocket(new String[0], new String[0], length, listener, con_fail_is_perm_fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadSocket(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        block31: {
            Socket socket = null;
            boolean connected = false;
            try {
                String output_header = "GET " + this.url.getPath() + "?" + this.url.getQuery() + " HTTP/1.1" + NL + "Host: " + this.url.getHost() + (this.url.getPort() == -1 ? "" : ":" + this.url.getPort()) + NL + "Accept: */*" + NL + "Connection: Close" + NL + "User-Agent: " + this.user_agent + NL;
                for (int i = 0; i < prop_names.length; ++i) {
                    output_header = output_header + prop_names[i] + ":" + prop_values[i] + NL;
                }
                output_header = output_header + NL;
                int time_remaining = listener.getPermittedTime();
                if (time_remaining > 0) {
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(this.url.getHost(), this.url.getPort() == -1 ? this.url.getDefaultPort() : this.url.getPort()), time_remaining);
                } else {
                    socket = new Socket(this.url.getHost(), this.url.getPort() == -1 ? this.url.getDefaultPort() : this.url.getPort());
                }
                connected = true;
                time_remaining = listener.getPermittedTime();
                if (time_remaining < 0) {
                    throw new IOException("Timeout during connect");
                }
                if (time_remaining > 0) {
                    socket.setSoTimeout(time_remaining);
                }
                OutputStream os = socket.getOutputStream();
                os.write(output_header.getBytes("ISO-8859-1"));
                os.flush();
                InputStream is = socket.getInputStream();
                try {
                    int response;
                    byte[] buffer;
                    String input_header = "";
                    do {
                        int len;
                        if ((len = is.read(buffer = new byte[1])) >= 0) continue;
                        throw new IOException("input too short reading header");
                    } while (!(input_header = input_header + (char)buffer[0]).endsWith("\r\n\r\n"));
                    int line_end = input_header.indexOf(NL);
                    if (line_end == -1) {
                        throw new IOException("header too short");
                    }
                    String first_line = input_header.substring(0, line_end);
                    StringTokenizer tok = new StringTokenizer(first_line, " ");
                    tok.nextToken();
                    this.last_response = response = Integer.parseInt(tok.nextToken());
                    this.last_response_retry_after_secs = -1;
                    String response_str = tok.nextToken();
                    if (response == 202 || response == 200 || response == 206) {
                        int pos;
                        int len;
                        byte[] buffer2 = null;
                        int buffer_pos = 0;
                        int buffer_len = 0;
                        for (pos = 0; pos < length; pos += len) {
                            if (buffer2 == null) {
                                buffer2 = listener.getBuffer();
                                buffer_pos = listener.getBufferPosition();
                                buffer_len = listener.getBufferLength();
                            }
                            int to_read = buffer_len - buffer_pos;
                            int permitted = listener.getPermittedBytes();
                            if (permitted < to_read) {
                                to_read = permitted;
                            }
                            if ((len = is.read(buffer2, buffer_pos, to_read)) < 0) break;
                            listener.reportBytesRead(len);
                            if ((buffer_pos += len) != buffer_len) continue;
                            listener.done();
                            buffer2 = null;
                            buffer_pos = 0;
                        }
                        if (pos != length) {
                            String log_str = buffer2 == null ? "No buffer assigned" : new String(buffer2, 0, buffer_pos > 64 ? 64 : buffer_pos);
                            throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [last=" + log_str + "]");
                        }
                        break block31;
                    }
                    if (response == 503) {
                        byte[] buffer3;
                        int len;
                        String data_str = "";
                        while ((len = is.read(buffer3 = new byte[1])) >= 0) {
                            data_str = data_str + (char)buffer3[0];
                        }
                        this.last_response_retry_after_secs = Integer.parseInt(data_str);
                        throw new IOException("Server overloaded");
                    }
                    ExternalSeedException error = new ExternalSeedException("Connection failed: " + response_str);
                    error.setPermanentFailure(true);
                    throw error;
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                if (con_fail_is_perm_fail && !connected) {
                    ExternalSeedException error = new ExternalSeedException("Connection failed: " + e.getMessage());
                    error.setPermanentFailure(true);
                    throw error;
                }
                String outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                if (this.last_response_retry_after_secs >= 0) {
                    outcome = outcome + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                }
                throw new ExternalSeedException(outcome, e);
            }
            catch (Throwable e) {
                if (e instanceof ExternalSeedException) {
                    throw (ExternalSeedException)e;
                }
                throw new ExternalSeedException("Connection failed", e);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        return null;
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    public void clearPasswords() {
    }

    public int getLastResponse() {
        return this.last_response;
    }

    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }
}

