/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessageListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyRequestListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class BuddyPluginViewInstance
implements BuddyPluginListener,
BuddyPluginBuddyRequestListener {
    private static final int LOG_NORMAL = 1;
    private static final int LOG_SUCCESS = 2;
    private static final int LOG_ERROR = 3;
    private BuddyPlugin plugin;
    private UIInstance ui_instance;
    private Composite composite;
    private Table buddy_table;
    private StyledText log;
    private List buddies = new ArrayList();
    private boolean init_complete;

    protected BuddyPluginViewInstance(BuddyPlugin _plugin, UIInstance _ui_instance, Composite _composite) {
        MenuItem send_msg_item;
        this.plugin = _plugin;
        this.ui_instance = _ui_instance;
        this.composite = _composite;
        final LocaleUtilities lu = this.plugin.getPluginInterface().getUtilities().getLocaleUtilities();
        Composite main = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        GridData grid_data = new GridData(1808);
        main.setLayoutData((Object)grid_data);
        if (!this.plugin.isEnabled()) {
            Label control_label = new Label(main, 0);
            control_label.setText(lu.getLocalisedMessageText("azbuddy.disabled"));
            return;
        }
        final Composite controls = new Composite(main, 0);
        layout = new GridLayout();
        layout.numColumns = 6;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controls.setLayout((Layout)layout);
        grid_data = new GridData(768);
        controls.setLayoutData((Object)grid_data);
        Label control_label = new Label(controls, 0);
        control_label.setText(lu.getLocalisedMessageText("azbuddy.ui.new_buddy") + " ");
        final Text control_text = new Text(controls, 2048);
        GridData gridData = new GridData(768);
        control_text.setLayoutData((Object)gridData);
        final Button control_button = new Button(controls, 0);
        control_button.setText(lu.getLocalisedMessageText("azbuddy.ui.add"));
        control_button.setEnabled(false);
        control_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                control_button.setEnabled(BuddyPluginViewInstance.this.plugin.verifyPublicKey(control_text.getText().trim()));
            }
        });
        control_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuddyPluginViewInstance.this.plugin.addBuddy(control_text.getText().trim(), 1);
                control_text.setText("");
            }
        });
        Label control_lab_pk = new Label(controls, 0);
        control_lab_pk.setText(lu.getLocalisedMessageText("azbuddy.ui.mykey") + " ");
        final Text control_val_pk = new Text(controls, 0);
        gridData = new GridData();
        gridData.widthHint = 400;
        control_val_pk.setLayoutData((Object)gridData);
        control_val_pk.setEditable(false);
        control_val_pk.setBackground(control_lab_pk.getBackground());
        control_val_pk.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event2) {
                int key = event2.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (event2.stateMask == SWT.MOD1 && key == 97) {
                    control_val_pk.setSelection(0, control_val_pk.getText().length());
                }
            }

            public void keyReleased(KeyEvent event2) {
            }
        });
        final CryptoManager crypt_man = CryptoManagerFactory.getSingleton();
        byte[] public_key = crypt_man.getECCHandler().peekPublicKey();
        if (public_key == null) {
            Messages.setLanguageText((Widget)control_val_pk, "ConfigView.section.security.publickey.undef");
        } else {
            control_val_pk.setText(Base32.encode(public_key));
        }
        Messages.setLanguageText((Widget)control_val_pk, "ConfigView.copy.to.clipboard.tooltip", true);
        control_val_pk.setCursor(Cursors.handCursor);
        control_val_pk.setForeground(Colors.blue);
        control_val_pk.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                this.copyToClipboard();
            }

            public void mouseDown(MouseEvent arg0) {
                this.copyToClipboard();
            }

            protected void copyToClipboard() {
                new Clipboard(control_val_pk.getDisplay()).setContents(new Object[]{control_val_pk.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        crypt_man.addKeyListener(new CryptoManagerKeyListener(){

            public void keyChanged(final CryptoHandler handler) {
                if (control_val_pk.isDisposed()) {
                    crypt_man.removeKeyListener(this);
                } else if (handler.getType() == 1) {
                    control_val_pk.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            byte[] public_key = handler.peekPublicKey();
                            if (public_key == null) {
                                Messages.setLanguageText((Widget)control_val_pk, "ConfigView.section.security.publickey.undef");
                            } else {
                                control_val_pk.setText(Base32.encode(public_key));
                            }
                            controls.layout();
                        }
                    });
                }
            }

            public void keyLockStatusChanged(CryptoHandler handler) {
            }
        });
        Button config_button = new Button(controls, 0);
        config_button.setText(lu.getLocalisedMessageText("plugins.basicview.config"));
        config_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuddyPluginViewInstance.this.plugin.showConfig();
            }
        });
        final Composite form = new Composite(main, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout((Layout)flayout);
        gridData = new GridData(1808);
        form.setLayoutData((Object)gridData);
        final Composite child1 = new Composite(form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        child1.setLayout((Layout)layout);
        final Sash sash = new Sash(form, 256);
        Composite child2 = new Composite(form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        child2.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        child1.setLayoutData((Object)formData);
        final FormData child1Data = formData;
        int SASH_WIDTH = 4;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)child1);
        formData.height = 4;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)sash);
        child2.setLayoutData((Object)formData);
        final PluginConfig pc = this.plugin.getPluginInterface().getPluginconfig();
        sash.setData("PCT", (Object)new Float(pc.getPluginFloatParameter("swt.sash.position", 0.7f)));
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 1) {
                    return;
                }
                child1Data.height = e.y + e.height - 4;
                form.layout();
                Float l = new Float((double)child1.getBounds().height / (double)form.getBounds().height);
                sash.setData("PCT", (Object)l);
                pc.setPluginParameter("swt.sash.position", l.floatValue());
            }
        });
        form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Float l = (Float)sash.getData("PCT");
                if (l != null) {
                    child1Data.height = (int)((double)form.getBounds().height * l.doubleValue());
                    form.layout();
                }
            }
        });
        this.buddy_table = new Table(child1, 268503042);
        final String[] headers = new String[]{"azbuddy.ui.table.name", "azbuddy.ui.table.online", "azbuddy.ui.table.lastseen", "azbuddy.ui.table.last_ygm", "azbuddy.ui.table.last_msg", "azbuddy.ui.table.loc_cat", "azbuddy.ui.table.rem_cat", "azbuddy.ui.table.read_cat", "azbuddy.ui.table.con", "azbuddy.ui.table.msg_in", "azbuddy.ui.table.msg_out", "azbuddy.ui.table.msg_queued", "MyTrackerView.bytesin", "MyTrackerView.bytesout", "azbuddy.ui.table.ss"};
        int[] sizes = new int[]{250, 100, 100, 100, 200, 100, 100, 100, 75, 75, 75, 75, 75, 75, 40};
        int[] aligns = new int[]{16384, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 16384, 16384, 16384, 16384, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        for (int i = 0; i < headers.length; ++i) {
            TableColumn tc = new TableColumn(this.buddy_table, aligns[i]);
            tc.setWidth(sizes[i]);
            Messages.setLanguageText((Widget)tc, headers[i]);
        }
        this.buddy_table.setHeaderVisible(true);
        TableColumn[] columns = this.buddy_table.getColumns();
        columns[0].setData((Object)new Integer(0));
        columns[1].setData((Object)new Integer(1));
        columns[2].setData((Object)new Integer(2));
        columns[3].setData((Object)new Integer(3));
        columns[4].setData((Object)new Integer(4));
        columns[5].setData((Object)new Integer(5));
        columns[6].setData((Object)new Integer(6));
        columns[7].setData((Object)new Integer(7));
        columns[8].setData((Object)new Integer(8));
        columns[9].setData((Object)new Integer(9));
        columns[10].setData((Object)new Integer(10));
        columns[11].setData((Object)new Integer(11));
        columns[12].setData((Object)new Integer(12));
        columns[13].setData((Object)new Integer(13));
        columns[14].setData((Object)new Integer(14));
        final FilterComparator comparator = new FilterComparator();
        Listener sort_listener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn tc = (TableColumn)e.widget;
                int field = (Integer)tc.getData();
                comparator.setField(field);
                Collections.sort(BuddyPluginViewInstance.this.buddies, comparator);
                BuddyPluginViewInstance.this.updateTable();
            }
        };
        for (int i = 0; i < columns.length; ++i) {
            columns[i].addListener(13, sort_listener);
        }
        gridData = new GridData(1808);
        gridData.heightHint = this.buddy_table.getHeaderHeight() * 3;
        this.buddy_table.setLayoutData((Object)gridData);
        this.buddy_table.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = BuddyPluginViewInstance.this.buddy_table.indexOf(item);
                if (index < 0 || index >= BuddyPluginViewInstance.this.buddies.size()) {
                    return;
                }
                BuddyPluginBuddy buddy = (BuddyPluginBuddy)BuddyPluginViewInstance.this.buddies.get(index);
                item.setText(0, buddy.getName());
                int os = buddy.isOnline(false) ? buddy.getOnlineStatus() : 4;
                if (os == 4) {
                    item.setText(1, "");
                } else {
                    item.setText(1, BuddyPluginViewInstance.this.plugin.getOnlineStatus(os));
                }
                long lo = buddy.getLastTimeOnline();
                item.setText(2, lo == 0L ? "" : new SimpleDateFormat().format(new Date(lo)));
                long last_ygm = buddy.getLastMessagePending();
                item.setText(3, last_ygm == 0L ? "" : new SimpleDateFormat().format(new Date(last_ygm)));
                String lm = buddy.getLastMessageReceived();
                item.setText(4, lm == null ? "" : lm);
                String loc_cat = buddy.getLocalAuthorisedRSSCategoriesAsString();
                if (loc_cat == null) {
                    loc_cat = "";
                }
                item.setText(5, "" + loc_cat);
                String rem_cat = buddy.getRemoteAuthorisedRSSCategoriesAsString();
                if (rem_cat == null) {
                    rem_cat = "";
                }
                item.setText(6, "" + rem_cat);
                String read_cat = buddy.getLocalReadCategoriesAsString();
                if (read_cat == null) {
                    read_cat = "";
                }
                item.setText(7, "" + read_cat);
                item.setText(8, "" + buddy.getConnectionsString());
                String in_frag = buddy.getMessageInFragmentDetails();
                item.setText(9, "" + buddy.getMessageInCount() + (in_frag.length() == 0 ? "" : "+" + in_frag));
                item.setText(10, "" + buddy.getMessageOutCount());
                item.setText(11, "" + buddy.getMessageHandler().getMessageCount());
                item.setText(12, "" + DisplayFormatters.formatByteCountToKiBEtc(buddy.getBytesInCount()));
                item.setText(13, "" + DisplayFormatters.formatByteCountToKiBEtc(buddy.getBytesOutCount()));
                item.setText(14, "" + buddy.getSubsystem() + " v" + buddy.getVersion());
                item.setData((Object)buddy);
            }
        });
        final Listener tt_label_listener = new Listener(){

            public void handleEvent(Event event2) {
                Label label = (Label)event2.widget;
                Shell shell = label.getShell();
                switch (event2.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        BuddyPluginViewInstance.this.buddy_table.setSelection(new TableItem[]{(TableItem)e.item});
                        BuddyPluginViewInstance.this.buddy_table.notifyListeners(13, e);
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tt_table_listener = new Listener(){
            private Shell tip = null;
            private Label label = null;

            public void handleEvent(Event event2) {
                switch (event2.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        int index;
                        Point mouse_position = new Point(event2.x, event2.y);
                        TableItem item = BuddyPluginViewInstance.this.buddy_table.getItem(mouse_position);
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                            this.tip = null;
                        }
                        if ((index = BuddyPluginViewInstance.this.buddy_table.indexOf(item)) < 0 || index >= BuddyPluginViewInstance.this.buddies.size()) {
                            return;
                        }
                        BuddyPluginBuddy buddy = (BuddyPluginBuddy)BuddyPluginViewInstance.this.buddies.get(index);
                        int item_index = 0;
                        for (int i = 0; i < headers.length; ++i) {
                            Rectangle bounds = item.getBounds(i);
                            if (!bounds.contains(mouse_position)) continue;
                            item_index = i;
                            break;
                        }
                        if (item_index != 0) {
                            return;
                        }
                        this.tip = new Shell(BuddyPluginViewInstance.this.buddy_table.getShell(), 16388);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(BuddyPluginViewInstance.this.buddy_table.getDisplay().getSystemColor(28));
                        this.label.setBackground(BuddyPluginViewInstance.this.buddy_table.getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(this.getToolTip(buddy));
                        this.label.addListener(7, tt_label_listener);
                        this.label.addListener(3, tt_label_listener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(item_index);
                        Point pt = BuddyPluginViewInstance.this.buddy_table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }

            protected String getToolTip(BuddyPluginBuddy buddy) {
                List addresses = buddy.getAdjustedIPs();
                InetAddress ip = buddy.getIP();
                InetAddress adj = buddy.getAdjustedIP();
                String str = "";
                if (ip == null) {
                    str = "<none>";
                } else if (ip == adj) {
                    str = ip.getHostAddress();
                } else {
                    str = ip.getHostAddress() + "{";
                    for (int i = 0; i < addresses.size(); ++i) {
                        str = str + (i == 0 ? "" : "/") + ((InetAddress)addresses.get(i)).getHostAddress();
                    }
                    str = str + "}";
                }
                return "ip=" + str + ",tcp=" + buddy.getTCPPort() + ",udp=" + buddy.getUDPPort();
            }
        };
        this.buddy_table.addListener(12, tt_table_listener);
        this.buddy_table.addListener(1, tt_table_listener);
        this.buddy_table.addListener(5, tt_table_listener);
        this.buddy_table.addListener(32, tt_table_listener);
        Menu menu = new Menu((Control)this.buddy_table);
        final MenuItem remove_item = new MenuItem(menu, 8);
        remove_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.remove"));
        remove_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                for (int i = 0; i < selection.length; ++i) {
                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                    buddy.remove();
                }
            }
        });
        final MenuItem get_pk_item = new MenuItem(menu, 8);
        get_pk_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.copypk"));
        get_pk_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < selection.length; ++i) {
                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                    sb.append(buddy.getPublicKey() + "\r\n");
                }
                if (sb.length() > 0) {
                    BuddyPluginViewInstance.this.writeToClipboard(sb.toString());
                }
            }
        });
        if (Constants.isCVSVersion()) {
            send_msg_item = new MenuItem(menu, 8);
            send_msg_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.disconnect"));
            send_msg_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event2) {
                    TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                    for (int i = 0; i < selection.length; ++i) {
                        BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                        buddy.disconnect();
                    }
                }
            });
        }
        send_msg_item = new MenuItem(menu, 8);
        send_msg_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.send"));
        send_msg_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                UIInputReceiver prompter = BuddyPluginViewInstance.this.ui_instance.getInputReceiver();
                prompter.setLocalisedTitle(lu.getLocalisedMessageText("azbuddy.ui.menu.send"));
                prompter.setLocalisedMessage(lu.getLocalisedMessageText("azbuddy.ui.menu.send_msg"));
                try {
                    prompter.prompt();
                    String text = prompter.getSubmittedInput();
                    if (text != null) {
                        for (int i = 0; i < selection.length; ++i) {
                            BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                            BuddyPluginViewInstance.this.plugin.getAZ2Handler().sendAZ2Message(buddy, text);
                        }
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        });
        final MenuItem chat_item = new MenuItem(menu, 8);
        chat_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.chat"));
        chat_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                BuddyPluginBuddy[] buddies = new BuddyPluginBuddy[selection.length];
                for (int i = 0; i < selection.length; ++i) {
                    BuddyPluginBuddy buddy;
                    buddies[i] = buddy = (BuddyPluginBuddy)selection[i].getData();
                }
                BuddyPluginViewInstance.this.plugin.getAZ2Handler().createChat(buddies);
            }
        });
        final MenuItem ping_item = new MenuItem(menu, 8);
        ping_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.ping"));
        ping_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                for (int i = 0; i < selection.length; ++i) {
                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                    try {
                        buddy.ping();
                        continue;
                    }
                    catch (Throwable e) {
                        BuddyPluginViewInstance.this.print("Ping failed", e);
                    }
                }
            }
        });
        final MenuItem ygm_item = new MenuItem(menu, 8);
        ygm_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.ygm"));
        ygm_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                for (int i = 0; i < selection.length; ++i) {
                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                    try {
                        buddy.setMessagePending();
                        continue;
                    }
                    catch (Throwable e) {
                        BuddyPluginViewInstance.this.print("YGM failed", e);
                    }
                }
            }
        });
        final MenuItem encrypt_item = new MenuItem(menu, 8);
        encrypt_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.enc"));
        encrypt_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                String str = BuddyPluginViewInstance.this.readFromClipboard();
                if (str != null) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < selection.length; ++i) {
                        BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                        try {
                            byte[] contents = str.getBytes("UTF-8");
                            BuddyPlugin.cryptoResult result = buddy.encrypt(contents);
                            sb.append("key: ");
                            sb.append(BuddyPluginViewInstance.this.plugin.getPublicKey());
                            sb.append("\r\n");
                            sb.append("hash: ");
                            sb.append(Base32.encode(result.getChallenge()));
                            sb.append("\r\n");
                            sb.append("payload: ");
                            sb.append(Base32.encode(result.getPayload()));
                            sb.append("\r\n\r\n");
                            continue;
                        }
                        catch (Throwable e) {
                            BuddyPluginViewInstance.this.print("YGM failed", e);
                        }
                    }
                    BuddyPluginViewInstance.this.writeToClipboard(sb.toString());
                }
            }
        });
        final MenuItem decrypt_item = new MenuItem(menu, 8);
        decrypt_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.dec"));
        decrypt_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                String str = BuddyPluginViewInstance.this.readFromClipboard();
                if (str != null) {
                    String[] bits = str.split("\n");
                    StringBuffer sb = new StringBuffer();
                    BuddyPluginBuddy buddy = null;
                    byte[] hash = null;
                    for (int i = 0; i < bits.length; ++i) {
                        int pos;
                        String bit = bits[i].trim();
                        if (bit.length() <= 0 || (pos = bit.indexOf(58)) == -1) continue;
                        String lhs = bit.substring(0, pos).trim();
                        String rhs = bit.substring(pos + 1).trim();
                        if (lhs.equals("key")) {
                            buddy = BuddyPluginViewInstance.this.plugin.getBuddyFromPublicKey(rhs);
                            continue;
                        }
                        if (lhs.equals("hash")) {
                            hash = Base32.decode(rhs);
                            continue;
                        }
                        if (!lhs.equals("payload")) continue;
                        byte[] payload = Base32.decode(rhs);
                        if (buddy == null) continue;
                        try {
                            BuddyPlugin.cryptoResult result = buddy.decrypt(payload);
                            byte[] sha1 = new SHA1Simple().calculateHash(result.getChallenge());
                            sb.append("key: ");
                            sb.append(buddy.getPublicKey());
                            sb.append("\r\n");
                            sb.append("hash_ok: " + Arrays.equals(hash, sha1));
                            sb.append("\r\n");
                            sb.append("payload: ");
                            sb.append(new String(result.getPayload(), "UTF-8"));
                            sb.append("\r\n\r\n");
                            continue;
                        }
                        catch (Throwable e) {
                            BuddyPluginViewInstance.this.print("decrypt failed", e);
                        }
                    }
                    if (sb.length() > 0) {
                        BuddyPluginViewInstance.this.writeToClipboard(sb.toString());
                    }
                }
            }
        });
        final MenuItem sign_item = new MenuItem(menu, 8);
        sign_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.sign"));
        sign_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                String str = BuddyPluginViewInstance.this.readFromClipboard();
                if (str != null) {
                    StringBuffer sb = new StringBuffer();
                    try {
                        sb.append("key: ");
                        sb.append(BuddyPluginViewInstance.this.plugin.getPublicKey());
                        sb.append("\r\n");
                        byte[] payload = str.getBytes("UTF-8");
                        sb.append("data: ");
                        sb.append(Base32.encode(payload));
                        sb.append("\r\n");
                        byte[] sig = BuddyPluginViewInstance.this.plugin.sign(payload);
                        sb.append("sig: ");
                        sb.append(Base32.encode(sig));
                        sb.append("\r\n");
                    }
                    catch (Throwable e) {
                        BuddyPluginViewInstance.this.print("sign failed", e);
                    }
                    if (sb.length() > 0) {
                        BuddyPluginViewInstance.this.writeToClipboard(sb.toString());
                    }
                }
            }
        });
        final MenuItem verify_item = new MenuItem(menu, 8);
        verify_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.verify"));
        verify_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                String str = BuddyPluginViewInstance.this.readFromClipboard();
                if (str != null) {
                    String[] bits = str.split("\n");
                    StringBuffer sb = new StringBuffer();
                    String pk = null;
                    byte[] data = null;
                    for (int i = 0; i < bits.length; ++i) {
                        int pos;
                        String bit = bits[i].trim();
                        if (bit.length() <= 0 || (pos = bit.indexOf(58)) == -1) continue;
                        String lhs = bit.substring(0, pos).trim();
                        String rhs = bit.substring(pos + 1).trim();
                        if (lhs.equals("key")) {
                            pk = rhs;
                            continue;
                        }
                        if (lhs.equals("data")) {
                            data = Base32.decode(rhs);
                            continue;
                        }
                        if (!lhs.equals("sig")) continue;
                        byte[] sig = Base32.decode(rhs);
                        if (pk == null || data == null) continue;
                        try {
                            sb.append("key: ");
                            sb.append(pk);
                            sb.append("\r\n");
                            boolean ok = BuddyPluginViewInstance.this.plugin.verify(pk, data, sig);
                            sb.append("sig_ok: " + ok);
                            sb.append("\r\n");
                            sb.append("data: ");
                            sb.append(new String(data, "UTF-8"));
                            sb.append("\r\n\r\n");
                            continue;
                        }
                        catch (Throwable e) {
                            BuddyPluginViewInstance.this.print("decrypt failed", e);
                        }
                    }
                    if (sb.length() > 0) {
                        BuddyPluginViewInstance.this.writeToClipboard(sb.toString());
                    }
                }
            }
        });
        Menu cat_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem cat_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)cat_item, "azbuddy.ui.menu.cat");
        cat_item.setMenu(cat_menu);
        MenuItem cat_share_item = new MenuItem(cat_menu, 8);
        cat_share_item.setText(lu.getLocalisedMessageText("azbuddy.ui.menu.cat.share"));
        cat_share_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                UIInputReceiver prompter = BuddyPluginViewInstance.this.ui_instance.getInputReceiver();
                prompter.setLocalisedTitle(lu.getLocalisedMessageText("azbuddy.ui.menu.cat.set"));
                prompter.setLocalisedMessage(lu.getLocalisedMessageText("azbuddy.ui.menu.cat.set_msg"));
                prompter.prompt();
                String cats = prompter.getSubmittedInput();
                if (cats != null) {
                    if ((cats = cats.trim()).equalsIgnoreCase("None")) {
                        cats = "";
                    }
                    TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                    for (int i = 0; i < selection.length; ++i) {
                        BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                        buddy.setLocalAuthorisedRSSCategories(cats);
                    }
                }
            }
        });
        final Menu cat_subs_menu = new Menu((Decorations)cat_menu.getShell(), 4);
        MenuItem cat_subs_item = new MenuItem(cat_menu, 64);
        Messages.setLanguageText((Widget)cat_subs_item, "azbuddy.ui.menu.cat_subs");
        cat_subs_item.setMenu(cat_subs_menu);
        cat_subs_menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent arg0) {
                MenuItem[] items = cat_subs_menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                AZ3Functions.provider az3 = AZ3Functions.getProvider();
                if (az3 != null) {
                    final TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                    TreeSet<String> avail_cats = new TreeSet<String>();
                    for (int i = 0; i < selection.length; ++i) {
                        BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                        Set<String> cats = buddy.getRemoteAuthorisedRSSCategories();
                        if (cats == null) continue;
                        avail_cats.addAll(cats);
                    }
                    for (final String cat : avail_cats) {
                        MenuItem subs_item = new MenuItem(cat_subs_menu, 8);
                        subs_item.setText(cat);
                        subs_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event2) {
                                for (int i = 0; i < selection.length; ++i) {
                                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)selection[i].getData();
                                    if (!buddy.isRemoteRSSCategoryAuthorised(cat)) continue;
                                    try {
                                        buddy.subscribeToCategory(cat);
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        BuddyPluginViewInstance.this.print("Failed", e);
                                    }
                                }
                            }
                        });
                    }
                }
            }

            public void menuHidden(MenuEvent arg0) {
            }
        });
        this.buddy_table.setMenu(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent arg0) {
                boolean available = BuddyPluginViewInstance.this.plugin.isAvailable();
                TableItem[] selection = BuddyPluginViewInstance.this.buddy_table.getSelection();
                remove_item.setEnabled(selection.length > 0);
                get_pk_item.setEnabled(available && selection.length > 0);
                send_msg_item.setEnabled(available && selection.length > 0);
                chat_item.setEnabled(available && selection.length > 0);
                ping_item.setEnabled(available && selection.length > 0);
                ygm_item.setEnabled(available && selection.length > 0);
                encrypt_item.setEnabled(selection.length > 0);
                decrypt_item.setEnabled(true);
                sign_item.setEnabled(true);
                verify_item.setEnabled(true);
            }

            public void menuHidden(MenuEvent arg0) {
            }
        });
        this.log = new StyledText(child2, 2824);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.horizontalIndent = 4;
        this.log.setLayoutData((Object)grid_data);
        this.log.setIndent(4);
        this.buddies = this.plugin.getBuddies();
        for (int i = 0; i < this.buddies.size(); ++i) {
            this.buddyAdded((BuddyPluginBuddy)this.buddies.get(i));
        }
        Collections.sort(this.buddies, comparator);
        this.plugin.addListener(this);
        this.plugin.addRequestListener(this);
        this.init_complete = true;
        this.updateTable();
    }

    protected String readFromClipboard() {
        Object o = new Clipboard(SWTThread.getInstance().getDisplay()).getContents((Transfer)TextTransfer.getInstance());
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    protected void writeToClipboard(String str) {
        new Clipboard(SWTThread.getInstance().getDisplay()).setContents(new Object[]{str}, new Transfer[]{TextTransfer.getInstance()});
    }

    protected void updateTable() {
        if (this.init_complete) {
            this.buddy_table.setItemCount(this.buddies.size());
            this.buddy_table.clearAll();
            this.buddy_table.redraw();
        }
    }

    public void initialised(boolean available) {
        this.print("Initialisation complete: available=" + available);
    }

    public void buddyAdded(final BuddyPluginBuddy buddy) {
        if (this.buddy_table.isDisposed()) {
            return;
        }
        buddy.getMessageHandler().addListener(new BuddyPluginBuddyMessageListener(){

            public void messageQueued(BuddyPluginBuddyMessage message) {
                BuddyPluginViewInstance.this.print(message.getBuddy().getName() + ": message queued, id=" + message.getID());
                this.update();
            }

            public void messageDeleted(BuddyPluginBuddyMessage message) {
                BuddyPluginViewInstance.this.print(message.getBuddy().getName() + ": message deleted, id=" + message.getID());
                this.update();
            }

            public boolean deliverySucceeded(BuddyPluginBuddyMessage message, Map reply) {
                BuddyPluginViewInstance.this.print(message.getBuddy().getName() + ": message delivered, id=" + message.getID() + ", reply=" + reply);
                this.update();
                return true;
            }

            public void deliveryFailed(BuddyPluginBuddyMessage message, BuddyPluginException cause) {
                BuddyPluginViewInstance.this.print(message.getBuddy().getName() + ": message failed, id=" + message.getID(), cause);
                this.update();
            }

            protected void update() {
                if (!BuddyPluginViewInstance.this.buddy_table.isDisposed()) {
                    BuddyPluginViewInstance.this.buddy_table.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!BuddyPluginViewInstance.this.buddy_table.isDisposed()) {
                                BuddyPluginViewInstance.this.updateTable();
                            }
                        }
                    });
                }
            }
        });
        if (!this.buddies.contains(buddy)) {
            this.buddy_table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BuddyPluginViewInstance.this.buddy_table.isDisposed() && !BuddyPluginViewInstance.this.buddies.contains(buddy)) {
                        BuddyPluginViewInstance.this.buddies.add(buddy);
                        BuddyPluginViewInstance.this.updateTable();
                    }
                }
            });
        }
    }

    public void buddyRemoved(final BuddyPluginBuddy buddy) {
        if (!this.buddy_table.isDisposed()) {
            this.buddy_table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BuddyPluginViewInstance.this.buddy_table.isDisposed() && BuddyPluginViewInstance.this.buddies.remove(buddy)) {
                        BuddyPluginViewInstance.this.updateTable();
                    }
                }
            });
        }
    }

    public void buddyChanged(BuddyPluginBuddy buddy) {
        if (!this.buddy_table.isDisposed()) {
            this.buddy_table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BuddyPluginViewInstance.this.buddy_table.isDisposed()) {
                        BuddyPluginViewInstance.this.updateTable();
                    }
                }
            });
        }
    }

    public void messageLogged(String str, boolean error) {
        this.print(str, error ? 3 : 1, false, false);
    }

    public void enabledStateChanged(boolean enabled) {
    }

    public Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map request2) throws BuddyPluginException {
        return null;
    }

    public void pendingMessages(BuddyPluginBuddy[] from_buddies) {
        String str = "";
        for (int i = 0; i < from_buddies.length; ++i) {
            str = str + (str.length() == 0 ? "" : ",") + from_buddies[i].getName();
        }
        this.print("YGM received: " + str);
    }

    protected void print(String str, Throwable e) {
        this.print(str + ": " + Debug.getNestedExceptionMessage(e));
    }

    protected void print(String str) {
        this.print(str, 1, false, true);
    }

    protected void print(final String str, int log_type, final boolean clear_first, boolean log_to_plugin) {
        if (log_to_plugin) {
            this.plugin.log(str);
        }
        if (!this.log.isDisposed()) {
            final int f_log_type = log_type;
            this.log.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int start;
                    if (BuddyPluginViewInstance.this.log.isDisposed()) {
                        return;
                    }
                    if (clear_first) {
                        start = 0;
                        BuddyPluginViewInstance.this.log.setText(str + "\n");
                    } else {
                        String text = BuddyPluginViewInstance.this.log.getText();
                        start = text.length();
                        if (start > 32000) {
                            BuddyPluginViewInstance.this.log.replaceTextRange(0, 1024, "");
                            start = BuddyPluginViewInstance.this.log.getText().length();
                        }
                        BuddyPluginViewInstance.this.log.append(str + "\n");
                    }
                    Color color = f_log_type == 1 ? Colors.black : (f_log_type == 2 ? Colors.green : Colors.red);
                    if (color != Colors.black) {
                        StyleRange styleRange = new StyleRange();
                        styleRange.start = start;
                        styleRange.length = str.length();
                        styleRange.foreground = color;
                        BuddyPluginViewInstance.this.log.setStyleRange(styleRange);
                    }
                    BuddyPluginViewInstance.this.log.setSelection(BuddyPluginViewInstance.this.log.getText().length());
                }
            });
        }
    }

    protected void destroy() {
        this.composite = null;
        this.plugin.removeListener(this);
        this.plugin.removeRequestListener(this);
    }

    protected class FilterComparator
    implements Comparator {
        boolean ascending = false;
        static final int FIELD_NAME = 0;
        static final int FIELD_ONLINE = 1;
        static final int FIELD_LAST_SEEN = 2;
        static final int FIELD_YGM = 3;
        static final int FIELD_LAST_MSG = 4;
        static final int FIELD_LOC_CAT = 5;
        static final int FIELD_REM_CAT = 6;
        static final int FIELD_READ_CAT = 7;
        static final int FIELD_CON = 8;
        static final int FIELD_MSG_IN = 9;
        static final int FIELD_MSG_OUT = 10;
        static final int FIELD_QUEUED = 11;
        static final int FIELD_BYTES_IN = 12;
        static final int FIELD_BYTES_OUT = 13;
        static final int FIELD_SS = 14;
        int field = 0;

        protected FilterComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            BuddyPluginBuddy b1 = (BuddyPluginBuddy)arg0;
            BuddyPluginBuddy b2 = (BuddyPluginBuddy)arg1;
            int res = 0;
            if (this.field == 0) {
                res = b1.getName().compareTo(b2.getName());
            } else if (this.field == 1) {
                res = (b1.isOnline(false) ? 1 : 0) - (b2.isOnline(false) ? 1 : 0);
            } else if (this.field == 2) {
                res = this.sortInt(b1.getLastTimeOnline() - b2.getLastTimeOnline());
            } else if (this.field == 3) {
                res = this.sortInt(b1.getLastMessagePending() - b2.getLastMessagePending());
            } else if (this.field == 4) {
                res = b1.getLastMessageReceived().compareTo(b2.getLastMessageReceived());
            } else if (this.field == 5) {
                res = this.compareStrings(b1.getLocalAuthorisedRSSCategoriesAsString(), b2.getLocalAuthorisedRSSCategoriesAsString());
            } else if (this.field == 6) {
                res = this.compareStrings(b1.getRemoteAuthorisedRSSCategoriesAsString(), b2.getRemoteAuthorisedRSSCategoriesAsString());
            } else if (this.field == 7) {
                res = this.compareStrings(b1.getLocalReadCategoriesAsString(), b2.getLocalReadCategoriesAsString());
            } else if (this.field == 8) {
                res = b1.getConnectionsString().compareTo(b2.getConnectionsString());
            } else if (this.field == 9) {
                res = b1.getMessageInCount() - b2.getMessageInCount();
            } else if (this.field == 10) {
                res = b1.getMessageOutCount() - b2.getMessageOutCount();
            } else if (this.field == 11) {
                res = b1.getMessageHandler().getMessageCount() - b2.getMessageHandler().getMessageCount();
            } else if (this.field == 12) {
                res = b1.getBytesInCount() - b2.getBytesInCount();
            } else if (this.field == 13) {
                res = b1.getBytesOutCount() - b2.getBytesOutCount();
            } else if (this.field == 14) {
                res = b1.getSubsystem() - b2.getSubsystem();
            }
            return (this.ascending ? 1 : -1) * res;
        }

        protected int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }

        protected int sortInt(long l) {
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }

        public void setField(int newField) {
            if (this.field == newField) {
                this.ascending = !this.ascending;
            }
            this.field = newField;
        }
    }
}

