/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.tracker;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteSet;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2TrackerListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTrackerListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SHA1;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class BuddyPluginTracker
implements BuddyPluginListener,
DownloadManagerListener,
BuddyPluginAZ2TrackerListener,
DownloadPeerListener {
    private static final Object PEER_KEY = new Object();
    private static final Object PEER_STATS_KEY = new Object();
    public static final int BUDDY_NETWORK_IDLE = 1;
    public static final int BUDDY_NETWORK_OUTBOUND = 2;
    public static final int BUDDY_NETWORK_INBOUND = 3;
    private static final int TRACK_CHECK_PERIOD = 15000;
    private static final int TRACK_CHECK_TICKS = 1;
    private static final int PEER_CHECK_PERIOD = 60000;
    private static final int PEER_CHECK_TICKS = 6;
    private static final int PEER_RECHECK_PERIOD = 120000;
    private static final int PEER_RECHECK_TICKS = 12;
    private static final int TRACK_INTERVAL = 600000;
    private static final int SHORT_ID_SIZE = 4;
    private static final int FULL_ID_SIZE = 20;
    private static final int REQUEST_TRACKER_SUMMARY = 1;
    private static final int REPLY_TRACKER_SUMMARY = 2;
    private static final int REQUEST_TRACKER_STATUS = 3;
    private static final int REPLY_TRACKER_STATUS = 4;
    private static final int REQUEST_TRACKER_CHANGE = 5;
    private static final int REPLY_TRACKER_CHANGE = 6;
    private static final int REQUEST_TRACKER_ADD = 7;
    private static final int REPLY_TRACKER_ADD = 8;
    private static final int RETRY_SEND_MIN = 300000;
    private static final int RETRY_SEND_MAX = 3600000;
    private static final int BUDDY_NO = 0;
    private static final int BUDDY_MAYBE = 1;
    private static final int BUDDY_YES = 2;
    private BuddyPlugin plugin;
    private boolean plugin_enabled;
    private boolean tracker_enabled;
    private boolean seeding_only;
    private boolean old_plugin_enabled;
    private boolean old_tracker_enabled;
    private boolean old_seeding_only;
    private int network_status = 1;
    private Set online_buddies = new HashSet();
    private Map online_buddy_ips = new HashMap();
    private Set tracked_downloads = new HashSet();
    private int download_set_id;
    private Set last_processed_download_set;
    private int last_processed_download_set_id;
    private Map short_id_map = new HashMap();
    private Map full_id_map = new HashMap();
    private Set actively_tracking = new HashSet();
    private CopyOnWriteSet buddy_peers = new CopyOnWriteSet();
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private TimerEventPeriodic buddy_stats_timer;
    private Average buddy_receive_speed = Average.getInstance(1000, 10);
    private Average buddy_send_speed = Average.getInstance(1000, 10);

    public BuddyPluginTracker(BuddyPlugin _plugin, BasicPluginConfigModel _config) {
        this.plugin = _plugin;
        final BooleanParameter te = _config.addBooleanParameter2("azbuddy.tracker.enabled", "azbuddy.tracker.enabled", true);
        this.tracker_enabled = te.getValue();
        te.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                BuddyPluginTracker.this.tracker_enabled = te.getValue();
                BuddyPluginTracker.this.checkEnabledState();
            }
        });
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        gm.addListener(new GlobalManagerAdapter(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean potentially_seeding_only) {
                BuddyPluginTracker.this.seeding_only = potentially_seeding_only;
                BuddyPluginTracker.this.checkEnabledState();
            }
        }, false);
        this.seeding_only = gm.isPotentiallySeedingOnly();
        this.checkEnabledState();
    }

    public void initialise() {
        this.plugin_enabled = this.plugin.isEnabled();
        this.checkEnabledState();
        List<BuddyPluginBuddy> buddies = this.plugin.getBuddies();
        for (int i = 0; i < buddies.size(); ++i) {
            this.buddyAdded(buddies.get(i));
        }
        this.plugin.addListener(this);
        this.plugin.getAZ2Handler().addTrackerListener(this);
        this.plugin.getPluginInterface().getDownloadManager().addListener(this, true);
    }

    public void tick(int tick_count) {
        if (tick_count % 1 == 0) {
            this.checkTracking();
        }
        if ((tick_count - 1) % 1 == 0) {
            this.doTracking();
        }
        if (tick_count % 6 == 0) {
            this.checkPeers();
        }
        if (tick_count % 12 == 0) {
            this.recheckPeers();
        }
    }

    public int getNetworkStatus() {
        return this.network_status;
    }

    public long getNetworkReceiveBytesPerSecond() {
        return this.buddy_receive_speed.getAverage();
    }

    public long getNetworkSendBytesPerSecond() {
        return this.buddy_send_speed.getAverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTracking() {
        if (!this.plugin_enabled || !this.tracker_enabled) {
            return;
        }
        HashMap to_do = new HashMap();
        HashSet<Download> active_set = new HashSet<Download>();
        Set set = this.online_buddies;
        synchronized (set) {
            for (BuddyPluginBuddy buddy : this.online_buddies) {
                buddyData buddy_data = this.getBuddyData(buddy);
                Map active = buddy_data.getDownloadsToTrack();
                if (active.size() <= 0) continue;
                Iterator it2 = active.entrySet().iterator();
                ArrayList<Download> track_now = new ArrayList<Download>();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    Download dl = (Download)entry.getKey();
                    boolean now = (Boolean)entry.getValue();
                    if (now) {
                        track_now.add(dl);
                    }
                    active_set.add(dl);
                }
                if (track_now.size() <= 0) continue;
                to_do.put(buddy, track_now);
            }
        }
        set = this.actively_tracking;
        synchronized (set) {
            for (Download dl : active_set) {
                if (this.actively_tracking.contains(dl)) continue;
                this.actively_tracking.add(dl);
                this.trackPeers(dl);
            }
            Iterator it = this.actively_tracking.iterator();
            while (it.hasNext()) {
                Download dl;
                dl = (Download)it.next();
                if (active_set.contains(dl)) continue;
                it.remove();
                this.untrackPeers(dl);
            }
        }
        for (Map.Entry entry : to_do.entrySet()) {
            InetAddress ip;
            BuddyPluginBuddy buddy;
            buddy = (BuddyPluginBuddy)entry.getKey();
            if (!buddy.isOnline(false) || (ip = buddy.getAdjustedIP()) == null) continue;
            int tcp_port = buddy.getTCPPort();
            int udp_port = buddy.getUDPPort();
            List downloads = (List)entry.getValue();
            for (int i = 0; i < downloads.size(); ++i) {
                Download download = (Download)downloads.get(i);
                PeerManager pm = download.getPeerManager();
                if (pm == null) continue;
                Peer[] existing_peers = pm.getPeers(ip.getHostAddress());
                boolean connected = false;
                for (int j = 0; j < existing_peers.length; ++j) {
                    Peer peer = existing_peers[j];
                    if (peer.getTCPListenPort() != tcp_port && peer.getUDPListenPort() != udp_port) continue;
                    connected = true;
                    break;
                }
                if (connected) {
                    this.log(download.getName() + " - peer " + ip.getHostAddress() + " already connected");
                    continue;
                }
                this.log(download.getName() + " - connecting to peer " + ip.getHostAddress());
                PEPeerManager c_pm = PluginCoreUtils.unwrap(pm);
                LightHashMap user_data = new LightHashMap();
                user_data.put(PEER_KEY, download);
                user_data.put(Peer.PR_PRIORITY_CONNECTION, new Boolean(true));
                c_pm.addPeer(ip.getHostAddress(), tcp_port, udp_port, true, user_data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTracking() {
        int downloads_id;
        Set downloads;
        ArrayList online;
        if (!this.plugin_enabled || !this.tracker_enabled) {
            return;
        }
        Set set = this.online_buddies;
        synchronized (set) {
            online = new ArrayList(this.online_buddies);
        }
        Set set2 = this.tracked_downloads;
        synchronized (set2) {
            boolean downloads_changed;
            boolean bl = downloads_changed = this.last_processed_download_set_id != this.download_set_id;
            if (downloads_changed) {
                this.last_processed_download_set = new HashSet(this.tracked_downloads);
                this.last_processed_download_set_id = this.download_set_id;
            }
            downloads = this.last_processed_download_set;
            downloads_id = this.last_processed_download_set_id;
        }
        HashMap diff_map = new HashMap();
        for (int i = 0; i < online.size(); ++i) {
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)online.get(i);
            buddyData buddy_data = this.getBuddyData(buddy);
            buddy_data.updateLocal(downloads, downloads_id, diff_map);
        }
    }

    public void initialised(boolean available) {
    }

    public void buddyAdded(BuddyPluginBuddy buddy) {
        this.buddyChanged(buddy);
    }

    public void buddyRemoved(BuddyPluginBuddy buddy) {
        this.buddyChanged(buddy);
    }

    public void buddyChanged(BuddyPluginBuddy buddy) {
        if (buddy.isOnline(false)) {
            this.addBuddy(buddy);
        } else {
            this.removeBuddy(buddy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected buddyData getBuddyData(BuddyPluginBuddy buddy) {
        Set set = this.online_buddies;
        synchronized (set) {
            buddyData buddy_data = (buddyData)buddy.getUserData(BuddyPluginTracker.class);
            if (buddy_data == null) {
                buddy_data = new buddyData(buddy);
                buddy.setUserData(BuddyPluginTracker.class, buddy_data);
            }
            return buddy_data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected buddyData addBuddy(BuddyPluginBuddy buddy) {
        Set set = this.online_buddies;
        synchronized (set) {
            buddyData bd;
            if (!this.online_buddies.contains(buddy)) {
                this.online_buddies.add(buddy);
            }
            if ((bd = this.getBuddyData(buddy)).hasIPChanged()) {
                List<BuddyPluginBuddy> l;
                String ip = bd.getIP();
                if (ip != null && (l = (ArrayList<BuddyPluginBuddy>)this.online_buddy_ips.get(ip)) != null) {
                    l.remove(buddy);
                    if (l.size() == 0) {
                        this.online_buddy_ips.remove(ip);
                    }
                }
                bd.updateIP();
                ip = bd.getIP();
                if (ip != null) {
                    l = (List)this.online_buddy_ips.get(ip);
                    if (l == null) {
                        l = new ArrayList<BuddyPluginBuddy>();
                        this.online_buddy_ips.put(ip, l);
                    }
                    l.add(buddy);
                }
            }
            return bd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuddy(BuddyPluginBuddy buddy) {
        Set set = this.online_buddies;
        synchronized (set) {
            if (this.online_buddies.contains(buddy)) {
                List l;
                buddyData bd = this.getBuddyData(buddy);
                this.online_buddies.remove(buddy);
                String ip = bd.getIP();
                if (ip != null && (l = (List)this.online_buddy_ips.get(ip)) != null) {
                    l.remove(buddy);
                    if (l.size() == 0) {
                        this.online_buddy_ips.remove(ip);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int isBuddy(Peer peer) {
        String peer_ip = peer.getIp();
        List ips = AddressUtils.getLANAddresses(peer_ip);
        Set set = this.online_buddies;
        synchronized (set) {
            int result = 0;
            String tested = "";
            block3: for (int i = 0; i < ips.size(); ++i) {
                String ip = (String)ips.get(i);
                tested = tested + ip;
                List buddies = (List)this.online_buddy_ips.get(ip);
                if (buddies == null) continue;
                if (peer.getTCPListenPort() == 0 && peer.getUDPListenPort() == 0) {
                    result = 1;
                    continue;
                }
                for (int j = 0; j < buddies.size(); ++j) {
                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies.get(j);
                    if (buddy.getTCPPort() == peer.getTCPListenPort() && buddy.getTCPPort() != 0) {
                        result = 2;
                        break block3;
                    }
                    if (buddy.getUDPPort() != peer.getUDPListenPort() || buddy.getUDPPort() == 0) continue;
                    result = 2;
                    break block3;
                }
            }
            return result;
        }
    }

    public void messageLogged(String str, boolean error) {
    }

    public void enabledStateChanged(boolean _enabled) {
        this.plugin_enabled = _enabled;
        this.checkEnabledState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        BuddyPluginTracker buddyPluginTracker = this;
        synchronized (buddyPluginTracker) {
            return this.plugin_enabled && this.tracker_enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEnabledState() {
        boolean seeding_change = false;
        boolean enabled_change = false;
        BuddyPluginTracker buddyPluginTracker = this;
        synchronized (buddyPluginTracker) {
            boolean old_enabled;
            boolean bl = old_enabled = this.old_plugin_enabled && this.old_tracker_enabled;
            if (this.plugin_enabled != this.old_plugin_enabled) {
                this.log("Plugin enabled state changed to " + this.plugin_enabled);
                this.old_plugin_enabled = this.plugin_enabled;
            }
            if (this.tracker_enabled != this.old_tracker_enabled) {
                this.log("Tracker enabled state changed to " + this.tracker_enabled);
                this.old_tracker_enabled = this.tracker_enabled;
            }
            if (this.seeding_only != this.old_seeding_only) {
                this.log("Seeding-only state changed to " + this.seeding_only);
                this.old_seeding_only = this.seeding_only;
                seeding_change = true;
            }
            enabled_change = old_enabled != (this.plugin_enabled && this.tracker_enabled);
        }
        if (seeding_change) {
            this.updateSeedingMode();
        }
        if (enabled_change) {
            this.fireEnabledChanged(this.isEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSeedingMode() {
        ArrayList online;
        this.updateNetworkStatus();
        Set set = this.online_buddies;
        synchronized (set) {
            online = new ArrayList(this.online_buddies);
        }
        for (int i = 0; i < online.size(); ++i) {
            buddyData buddy_data = this.getBuddyData((BuddyPluginBuddy)online.get(i));
            if (!buddy_data.hasDownloadsInCommon()) continue;
            buddy_data.updateStatus();
        }
    }

    public void downloadAdded(final Download download) {
        Torrent t = download.getTorrent();
        if (t == null) {
            return;
        }
        if (t.isPrivate()) {
            download.addTrackerListener(new DownloadTrackerListener(){

                public void scrapeResult(DownloadScrapeResult result) {
                }

                public void announceResult(DownloadAnnounceResult result) {
                    if (BuddyPluginTracker.this.okToTrack(download)) {
                        BuddyPluginTracker.this.trackDownload(download);
                    } else {
                        BuddyPluginTracker.this.untrackDownload(download);
                    }
                }
            }, false);
        }
        if (this.okToTrack(download)) {
            this.trackDownload(download);
        }
        download.addListener(new DownloadListener(){

            public void stateChanged(Download download, int old_state, int new_state) {
                if (BuddyPluginTracker.this.okToTrack(download)) {
                    BuddyPluginTracker.this.trackDownload(download);
                } else {
                    BuddyPluginTracker.this.untrackDownload(download);
                }
            }

            public void positionChanged(Download download, int oldPosition, int newPosition) {
            }
        });
    }

    public void downloadRemoved(Download download) {
        this.untrackDownload(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackDownload(Download download) {
        Set set = this.tracked_downloads;
        synchronized (set) {
            if (this.tracked_downloads.contains(download)) {
                return;
            }
            downloadData download_data = new downloadData(download);
            download.setUserData(BuddyPluginTracker.class, download_data);
            HashWrapper full_id = download_data.getID();
            HashWrapper short_id = new HashWrapper(full_id.getHash(), 0, 4);
            this.full_id_map.put(full_id, download);
            ArrayList<Download> dls = (ArrayList<Download>)this.short_id_map.get(short_id);
            if (dls == null) {
                dls = new ArrayList<Download>();
                this.short_id_map.put(short_id, dls);
            }
            dls.add(download);
            this.tracked_downloads.add(download);
            ++this.download_set_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrackDownload(Download download) {
        Set set = this.tracked_downloads;
        synchronized (set) {
            if (this.tracked_downloads.remove(download)) {
                ++this.download_set_id;
                downloadData download_data = (downloadData)download.getUserData(BuddyPluginTracker.class);
                download.setUserData(BuddyPluginTracker.class, null);
                HashWrapper full_id = download_data.getID();
                this.full_id_map.remove(full_id);
                HashWrapper short_id = new HashWrapper(full_id.getHash(), 0, 4);
                List dls = (List)this.short_id_map.get(short_id);
                if (dls != null) {
                    dls.remove(download);
                    if (dls.size() == 0) {
                        this.short_id_map.remove(short_id);
                    }
                }
            }
        }
        set = this.online_buddies;
        synchronized (set) {
            for (BuddyPluginBuddy buddy : this.online_buddies) {
                buddyData buddy_data = this.getBuddyData(buddy);
                buddy_data.resetTracking(download);
            }
        }
        set = this.actively_tracking;
        synchronized (set) {
            this.actively_tracking.remove(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackPeers(Download download) {
        PeerManager pm = download.getPeerManager();
        if (pm == null) {
            Set set = this.actively_tracking;
            synchronized (set) {
                this.actively_tracking.remove(download);
            }
        } else {
            this.log("Tracking peers for " + download.getName());
            download.addPeerListener(this);
        }
    }

    public void peerManagerAdded(Download download, PeerManager peer_manager) {
        this.trackPeers(download, peer_manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
        Set set = this.actively_tracking;
        synchronized (set) {
            this.actively_tracking.remove(download);
        }
        download.removePeerListener(this);
    }

    protected void trackPeers(final Download download, PeerManager pm) {
        pm.addListener(new PeerManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerAdded(PeerManager manager, Peer peer) {
                Set set = BuddyPluginTracker.this.actively_tracking;
                synchronized (set) {
                    if (!BuddyPluginTracker.this.actively_tracking.contains(download)) {
                        manager.removeListener(this);
                        return;
                    }
                }
                BuddyPluginTracker.this.trackPeer(download, peer);
            }

            public void peerRemoved(PeerManager manager, Peer peer) {
            }
        });
        Peer[] peers = pm.getPeers();
        for (int i = 0; i < peers.length; ++i) {
            this.trackPeer(download, peers[i]);
        }
    }

    protected void trackPeer(Download download, final Peer peer) {
        int type = this.isBuddy(peer);
        if (type == 2) {
            this.markBuddyPeer(download, peer);
        } else if (type == 1) {
            this.markBuddyPeer(download, peer);
            PeerListener2 listener = new PeerListener2(){

                public void eventOccurred(PeerEvent event2) {
                    if (event2.getType() == 1 && (Integer)event2.getData() == 30) {
                        peer.removeListener(this);
                        if (BuddyPluginTracker.this.isBuddy(peer) != 2) {
                            BuddyPluginTracker.this.unmarkBuddyPeer(peer);
                        }
                    }
                }
            };
            peer.addListener(listener);
            if (peer.getState() == 30) {
                peer.removeListener(listener);
                if (this.isBuddy(peer) != 2) {
                    this.unmarkBuddyPeer(peer);
                }
            }
        }
    }

    protected void untrackPeers(Download download) {
        this.log("Not tracking peers for " + download.getName());
        download.removePeerListener(this);
        PeerManager pm = download.getPeerManager();
        if (pm != null) {
            Peer[] peers = pm.getPeers();
            for (int i = 0; i < peers.length; ++i) {
                Peer peer = peers[i];
                this.unmarkBuddyPeer(peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markBuddyPeer(Download download, final Peer peer) {
        boolean state_changed = false;
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            if (!this.buddy_peers.contains(peer)) {
                this.log("Adding buddy peer " + peer.getIp());
                if (this.buddy_peers.size() == 0) {
                    if (this.buddy_stats_timer == null) {
                        this.buddy_stats_timer = SimpleTimer.addPeriodicEvent("BuddyTracker:stats", 1000L, new TimerEventPerformer(){

                            public void perform(TimerEvent event2) {
                                Iterator it = BuddyPluginTracker.this.buddy_peers.iterator();
                                long total_sent = 0L;
                                long total_received = 0L;
                                while (it.hasNext()) {
                                    Peer p = (Peer)it.next();
                                    PeerStats ps = p.getStats();
                                    long sent = ps.getTotalSent();
                                    long received = ps.getTotalReceived();
                                    long[] last = (long[])p.getUserData(PEER_STATS_KEY);
                                    if (last != null) {
                                        total_sent += sent - last[0];
                                        total_received += received - last[1];
                                    }
                                    p.setUserData(PEER_STATS_KEY, new long[]{sent, received});
                                }
                                BuddyPluginTracker.this.buddy_receive_speed.addValue(total_received);
                                BuddyPluginTracker.this.buddy_send_speed.addValue(total_sent);
                            }
                        });
                    }
                    state_changed = true;
                }
                this.buddy_peers.add(peer);
                peer.setUserData(PEER_KEY, download);
                peer.setPriorityConnection(true);
                this.log(download.getName() + ": adding buddy peer " + peer.getIp());
                peer.addListener(new PeerListener2(){

                    public void eventOccurred(PeerEvent event2) {
                        int state;
                        if (event2.getType() == 1 && ((state = ((Integer)event2.getData()).intValue()) == 40 || state == 50)) {
                            peer.removeListener(this);
                            BuddyPluginTracker.this.unmarkBuddyPeer(peer);
                        }
                    }
                });
            }
        }
        if (peer.getState() == 40 || peer.getState() == 50) {
            this.unmarkBuddyPeer(peer);
        }
        if (state_changed) {
            this.updateNetworkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmarkBuddyPeer(Peer peer) {
        boolean state_changed = false;
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            Download download = (Download)peer.getUserData(PEER_KEY);
            if (download == null) {
                return;
            }
            if (this.buddy_peers.remove(peer)) {
                if (this.buddy_peers.size() == 0) {
                    state_changed = true;
                    if (this.buddy_stats_timer != null) {
                        this.buddy_stats_timer.cancel();
                        this.buddy_stats_timer = null;
                    }
                }
                this.log(download.getName() + ": removing buddy peer " + peer.getIp());
            }
            peer.setUserData(PEER_KEY, null);
            peer.setPriorityConnection(false);
        }
        if (state_changed) {
            this.updateNetworkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPeers() {
        ArrayList<Peer> to_unmark = new ArrayList<Peer>();
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            Iterator it = this.buddy_peers.iterator();
            while (it.hasNext()) {
                Peer peer = (Peer)it.next();
                if (peer.getState() != 40 && peer.getState() != 50) continue;
                to_unmark.add(peer);
            }
        }
        for (int i = 0; i < to_unmark.size(); ++i) {
            this.unmarkBuddyPeer((Peer)to_unmark.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recheckPeers() {
        Set set = this.actively_tracking;
        synchronized (set) {
            for (Download download : this.actively_tracking) {
                PeerManager pm = download.getPeerManager();
                if (pm == null) continue;
                Peer[] peers = pm.getPeers();
                for (int i = 0; i < peers.length; ++i) {
                    this.trackPeer(download, peers[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNetworkStatus() {
        int new_status;
        boolean changed = false;
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            if (this.buddy_peers.size() == 0) {
                new_status = 1;
            } else {
                int n = new_status = this.seeding_only ? 2 : 3;
            }
            if (new_status != this.network_status) {
                this.network_status = new_status;
                changed = true;
            }
        }
        if (changed) {
            this.fireStateChange(new_status);
        }
    }

    public void addListener(BuddyPluginTrackerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(BuddyPluginTrackerListener l) {
        this.listeners.remove(l);
    }

    protected void fireStateChange(int state) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginTrackerListener)it.next()).networkStatusChanged(this, state);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void fireEnabledChanged(boolean enabled) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginTrackerListener)it.next()).enabledStateChanged(this, enabled);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void sendMessage(BuddyPluginBuddy buddy, int type, Map body) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("type", new Long(type));
        msg.put("msg", body);
        this.plugin.getAZ2Handler().sendAZ2TrackerMessage(buddy, msg, this);
    }

    public Map messageReceived(BuddyPluginBuddy buddy, Map message) {
        buddyData buddy_data = this.buddyAlive(buddy);
        int type = ((Long)message.get("type")).intValue();
        Map msg = (Map)message.get("msg");
        return buddy_data.receiveMessage(type, msg);
    }

    public void messageFailed(BuddyPluginBuddy buddy, Throwable cause) {
        this.log("Failed to send message to " + buddy.getName(), cause);
        this.buddyDead(buddy);
    }

    protected buddyData buddyAlive(BuddyPluginBuddy buddy) {
        buddyData buddy_data = this.addBuddy(buddy);
        buddy_data.setAlive(true);
        return buddy_data;
    }

    protected void buddyDead(BuddyPluginBuddy buddy) {
        buddyData buddy_data = this.getBuddyData(buddy);
        if (buddy_data != null) {
            buddy_data.setAlive(false);
        }
    }

    protected boolean okToTrack(Download d) {
        DownloadAnnounceResult announce;
        Torrent t = d.getTorrent();
        if (t == null) {
            return false;
        }
        if (t.isPrivate() && ((announce = d.getLastAnnounceResult()) == null || announce.getResponseType() != 1 || announce.getPeers().length < 2)) {
            return false;
        }
        int state = d.getState();
        return state != 8 && state != 6 && state != 7;
    }

    protected void log(String str) {
        this.plugin.log("Tracker: " + str);
    }

    protected void log(String str, boolean verbose) {
        if (verbose) {
            if (Constants.isCVSVersion()) {
                this.log(str);
            }
        } else {
            this.log(str);
        }
    }

    protected void log(String str, Throwable e) {
        this.plugin.log("Tracker: " + str, e);
    }

    private class buddyData {
        private BuddyPluginBuddy buddy;
        private Set downloads_sent;
        private int downloads_sent_id;
        private Map downloads_in_common;
        private boolean buddy_seeding_only;
        private int consecutive_fails;
        private long last_fail;
        private String current_ip;

        protected buddyData(BuddyPluginBuddy _buddy) {
            this.buddy = _buddy;
        }

        protected void updateIP() {
            this.current_ip = this.buddy.getAdjustedIP().getHostAddress();
            this.log("IP set to " + this.current_ip);
        }

        protected boolean hasIPChanged() {
            InetAddress latest_ip = this.buddy.getAdjustedIP();
            if (latest_ip == null && this.current_ip == null) {
                return false;
            }
            if (latest_ip == null || this.current_ip == null) {
                return true;
            }
            return !this.current_ip.equals(latest_ip.getHostAddress());
        }

        protected String getIP() {
            return this.current_ip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasDownloadsInCommon() {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                return this.downloads_in_common != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAlive(boolean alive) {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (alive) {
                    this.consecutive_fails = 0;
                    this.last_fail = 0L;
                } else {
                    ++this.consecutive_fails;
                    this.last_fail = SystemTime.getMonotonousTime();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateLocal(Set downloads, int id, Map diff_map) {
            byte[] removed_bytes;
            byte[] added_bytes;
            boolean incremental;
            byte[][] change_details;
            if (this.consecutive_fails > 0) {
                long now;
                long retry_millis = 300000L;
                for (int i = 0; i < this.consecutive_fails - 1; ++i) {
                    if ((retry_millis <<= 2) <= 3600000L) continue;
                    retry_millis = 3600000L;
                    break;
                }
                if ((now = SystemTime.getMonotonousTime()) - this.last_fail >= retry_millis) {
                    this.last_fail = now;
                    this.downloads_sent = null;
                    this.downloads_sent_id = 0;
                }
            }
            ArrayList<Download> comp_changed = new ArrayList<Download>();
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common != null) {
                    for (Map.Entry entry : this.downloads_in_common.entrySet()) {
                        Download d = (Download)entry.getKey();
                        buddyDownloadData bdd = (buddyDownloadData)entry.getValue();
                        boolean local_complete = d.isComplete(false);
                        if (local_complete == bdd.isLocalComplete()) continue;
                        bdd.setLocalComplete(local_complete);
                        comp_changed.add(d);
                    }
                }
            }
            if (comp_changed.size() > 0 && (change_details = this.exportFullIDs(comp_changed))[0].length > 0) {
                HashMap<String, Object> msg = new HashMap<String, Object>();
                msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
                msg.put("change", change_details[0]);
                msg.put("change_s", change_details[1]);
                BuddyPluginTracker.this.sendMessage(this.buddy, 5, msg);
            }
            if (id == this.downloads_sent_id) {
                return;
            }
            Long key = new Long((long)id << 32 | (long)this.downloads_sent_id);
            Object[] diffs = (Object[])diff_map.get(key);
            boolean bl = incremental = this.downloads_sent != null;
            if (diffs == null) {
                ArrayList<Download> added;
                ArrayList<Download> removed = new ArrayList<Download>();
                if (this.downloads_sent == null) {
                    added = new ArrayList(downloads);
                } else {
                    added = new ArrayList<Download>();
                    for (Download download : downloads) {
                        if (!BuddyPluginTracker.this.okToTrack(download) || this.downloads_sent.contains(download)) continue;
                        added.add(download);
                    }
                    for (Download download : this.downloads_sent) {
                        if (downloads.contains(download)) continue;
                        removed.add(download);
                    }
                }
                added_bytes = this.exportShortIDs(added);
                removed_bytes = this.exportFullIDs(removed)[0];
                diff_map.put(key, new Object[]{added_bytes, removed_bytes});
            } else {
                added_bytes = (byte[])diffs[0];
                removed_bytes = (byte[])diffs[1];
            }
            this.downloads_sent = downloads;
            this.downloads_sent_id = id;
            if (added_bytes.length == 0 && removed_bytes.length == 0) {
                return;
            }
            HashMap<String, Object> msg = new HashMap<String, Object>();
            if (added_bytes.length > 0) {
                msg.put("added", added_bytes);
            }
            if (removed_bytes.length > 0) {
                msg.put("removed", removed_bytes);
            }
            msg.put("inc", new Long(incremental ? 1L : 0L));
            msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
            BuddyPluginTracker.this.sendMessage(this.buddy, 1, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map updateRemote(Map msg) {
            List added = this.importShortIDs((byte[])msg.get("added"));
            HashMap<String, byte[]> reply = new HashMap<String, byte[]>();
            byte[][] add_details = this.exportFullIDs(added);
            if (add_details[0].length > 0) {
                reply.put("added", add_details[0]);
                reply.put("added_s", add_details[1]);
            }
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common != null) {
                    Map removed = this.importFullIDs((byte[])msg.get("removed"), null);
                    for (Download d : removed.keySet()) {
                        if (this.downloads_in_common.remove(d) == null) continue;
                        this.log("Removed " + d.getName() + " common download", false, true);
                    }
                    if (this.downloads_in_common.size() == 0) {
                        this.downloads_in_common = null;
                    }
                }
            }
            return reply;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateCommonDownloads(Map downloads, boolean incremental) {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common == null) {
                    this.downloads_in_common = new HashMap();
                } else if (!incremental) {
                    Iterator it = this.downloads_in_common.keySet().iterator();
                    while (it.hasNext()) {
                        Download download = (Download)((Object)it.next());
                        if (downloads.containsKey(download)) continue;
                        this.log("Removing " + download.getName() + " from common downloads", false, true);
                        it.remove();
                    }
                }
                for (Map.Entry entry : downloads.entrySet()) {
                    boolean new_rc;
                    Download d = (Download)entry.getKey();
                    buddyDownloadData bdd = (buddyDownloadData)entry.getValue();
                    buddyDownloadData existing = (buddyDownloadData)this.downloads_in_common.get(d);
                    if (existing == null) {
                        this.log("Adding " + d.getName() + " to common downloads (bdd=" + bdd.getString() + ")", false, true);
                        this.downloads_in_common.put(d, bdd);
                        continue;
                    }
                    boolean old_rc = existing.isRemoteComplete();
                    if (old_rc == (new_rc = bdd.isRemoteComplete())) continue;
                    existing.setRemoteComplete(new_rc);
                    this.log("Changing " + d.getName() + " common downloads (bdd=" + existing.getString() + ")", false, true);
                }
                if (this.downloads_in_common.size() == 0) {
                    this.downloads_in_common = null;
                }
            }
        }

        protected void updateStatus() {
            HashMap<String, Long> msg = new HashMap<String, Long>();
            msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
            BuddyPluginTracker.this.sendMessage(this.buddy, 3, msg);
        }

        protected Map receiveMessage(int type, Map msg_in) {
            int reply_type = -1;
            HashMap msg_out = null;
            Long l_seeding = (Long)msg_in.get("seeding");
            if (l_seeding != null) {
                boolean old = this.buddy_seeding_only;
                boolean bl = this.buddy_seeding_only = l_seeding.intValue() == 1;
                if (old != this.buddy_seeding_only) {
                    this.log("Seeding only changed to " + this.buddy_seeding_only);
                }
            }
            if (type == 1) {
                reply_type = 2;
                msg_out = this.updateRemote(msg_in);
                msg_out.put("inc", msg_in.get("inc"));
            } else if (type == 3) {
                reply_type = 4;
            } else if (type == 5) {
                reply_type = 4;
                Map downloads = this.importFullIDs((byte[])msg_in.get("changed"), (byte[])msg_in.get("changed_s"));
                this.updateCommonDownloads(downloads, true);
            } else if (type == 7) {
                reply_type = 8;
                Map downloads = this.importFullIDs((byte[])msg_in.get("added"), (byte[])msg_in.get("added_s"));
                this.updateCommonDownloads(downloads, true);
            } else if (type == 2) {
                Map downloads;
                boolean incremental;
                byte[] possible_matches = (byte[])msg_in.get("added");
                byte[] possible_match_states = (byte[])msg_in.get("added_s");
                boolean bl = incremental = ((Long)msg_in.get("inc")).intValue() == 1;
                if (possible_matches != null && possible_match_states != null && (downloads = this.importFullIDs(possible_matches, possible_match_states)).size() > 0) {
                    this.updateCommonDownloads(downloads, incremental);
                    byte[][] common_details = this.exportFullIDs(new ArrayList(downloads.keySet()));
                    if (common_details[0].length > 0) {
                        HashMap<String, Object> msg = new HashMap<String, Object>();
                        msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
                        msg.put("added", common_details[0]);
                        msg.put("added_s", common_details[1]);
                        BuddyPluginTracker.this.sendMessage(this.buddy, 7, msg);
                    }
                }
            } else if (type != 6 && type != 4 && type != 8) {
                this.log("Unrecognised type " + type);
            }
            if (reply_type != -1) {
                HashMap<String, Serializable> reply = new HashMap<String, Serializable>();
                reply.put("type", new Long(reply_type));
                if (msg_out == null) {
                    msg_out = new HashMap();
                }
                msg_out.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
                reply.put("msg", msg_out);
                return reply;
            }
            return null;
        }

        protected byte[] exportShortIDs(List downloads) {
            byte[] res = new byte[4 * downloads.size()];
            for (int i = 0; i < downloads.size(); ++i) {
                Download download = (Download)downloads.get(i);
                downloadData download_data = (downloadData)download.getUserData(BuddyPluginTracker.class);
                if (download_data == null) continue;
                System.arraycopy(download_data.getID().getBytes(), 0, res, i * 4, 4);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List importShortIDs(byte[] ids) {
            ArrayList res = new ArrayList();
            if (ids != null) {
                Set set = BuddyPluginTracker.this.tracked_downloads;
                synchronized (set) {
                    for (int i = 0; i < ids.length; i += 4) {
                        List dls = (List)BuddyPluginTracker.this.short_id_map.get(new HashWrapper(ids, i, 4));
                        if (dls == null) continue;
                        res.addAll(dls);
                    }
                }
            }
            return res;
        }

        protected byte[][] exportFullIDs(List downloads) {
            byte[] hashes = new byte[20 * downloads.size()];
            byte[] states = new byte[downloads.size()];
            for (int i = 0; i < downloads.size(); ++i) {
                Download download = (Download)downloads.get(i);
                downloadData download_data = (downloadData)download.getUserData(BuddyPluginTracker.class);
                if (download_data == null) continue;
                System.arraycopy(download_data.getID().getBytes(), 0, hashes, i * 20, 20);
                states[i] = download.isComplete(false) ? (byte)1 : 0;
            }
            return new byte[][]{hashes, states};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map importFullIDs(byte[] ids, byte[] states) {
            HashMap<Download, buddyDownloadData> res = new HashMap<Download, buddyDownloadData>();
            if (ids != null) {
                Set set = BuddyPluginTracker.this.tracked_downloads;
                synchronized (set) {
                    for (int i = 0; i < ids.length; i += 20) {
                        Download dl = (Download)BuddyPluginTracker.this.full_id_map.get(new HashWrapper(ids, i, 20));
                        if (dl == null) continue;
                        buddyDownloadData bdd = new buddyDownloadData(dl);
                        if (states != null) {
                            bdd.setRemoteComplete((states[i / 20] & 1) != 0);
                        }
                        res.put(dl, bdd);
                    }
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map getDownloadsToTrack() {
            HashMap<Download, Boolean> res = new HashMap<Download, Boolean>();
            if (BuddyPluginTracker.this.seeding_only == this.buddy_seeding_only) {
                this.log("Not tracking, buddy and me both " + (BuddyPluginTracker.this.seeding_only ? "seeding" : "downloading"), true, false);
                return res;
            }
            long now = SystemTime.getMonotonousTime();
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common == null) {
                    this.log("Not tracking, buddy has nothing in common", true, false);
                    return res;
                }
                for (Map.Entry entry : this.downloads_in_common.entrySet()) {
                    Download d = (Download)entry.getKey();
                    buddyDownloadData bdd = (buddyDownloadData)entry.getValue();
                    if (d.isComplete(false) && bdd.isRemoteComplete()) {
                        this.log(d.getName() + " - not tracking, both complete", true, true);
                        continue;
                    }
                    long last_track = bdd.getTrackTime();
                    if (last_track == 0L || now - last_track >= 600000L) {
                        this.log(d.getName() + " - tracking", false, true);
                        bdd.setTrackTime(now);
                        res.put(d, new Boolean(true));
                        continue;
                    }
                    res.put(d, new Boolean(false));
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resetTracking(Download download) {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common == null) {
                    return;
                }
                buddyDownloadData bdd = (buddyDownloadData)this.downloads_in_common.get(download);
                if (bdd != null) {
                    bdd.resetTrackTime();
                }
            }
        }

        protected void log(String str) {
            BuddyPluginTracker.this.log(this.buddy.getName() + ": " + str);
        }

        protected void log(String str, boolean verbose, boolean no_buddy) {
            BuddyPluginTracker.this.log((no_buddy ? "" : this.buddy.getName() + ": ") + str, verbose);
        }
    }

    private static class buddyDownloadData {
        private boolean local_is_complete;
        private boolean remote_is_complete;
        private long last_track;

        protected buddyDownloadData(Download download) {
            this.local_is_complete = download.isComplete(false);
        }

        protected void setLocalComplete(boolean b) {
            this.local_is_complete = b;
        }

        protected boolean isLocalComplete() {
            return this.local_is_complete;
        }

        protected void setRemoteComplete(boolean b) {
            this.remote_is_complete = b;
        }

        protected boolean isRemoteComplete() {
            return this.remote_is_complete;
        }

        protected void setTrackTime(long time) {
            this.last_track = time;
        }

        protected long getTrackTime() {
            return this.last_track;
        }

        protected void resetTrackTime() {
            this.last_track = 0L;
        }

        protected String getString() {
            return "lic=" + this.local_is_complete + ",ric=" + this.remote_is_complete + ",lt=" + this.last_track;
        }
    }

    private static class downloadData {
        private static final byte[] IV = new byte[]{122, 122, -83, -85, -114, -65, -51, 57, -121, 0, -92, -72, -2, 64, -94, -24};
        private HashWrapper id;

        protected downloadData(Download download) {
            Torrent t = download.getTorrent();
            if (t != null) {
                byte[] hash = t.getHash();
                SHA1 sha1 = new SHA1();
                sha1.update(ByteBuffer.wrap(IV));
                sha1.update(ByteBuffer.wrap(hash));
                this.id = new HashWrapper(sha1.digest());
            }
        }

        protected HashWrapper getID() {
            return this.id;
        }
    }
}

