/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus;

import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTester;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterBT;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import com.aelitis.azureus.plugins.net.netstatus.swt.NetStatusPluginView;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class NetStatusPlugin
implements Plugin {
    public static final String VIEW_ID = "aznetstatus";
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private StringParameter ping_target;
    private ActionParameter test_button;
    private StringParameter test_address;
    private NetStatusProtocolTester protocol_tester;
    private AESemaphore protocol_tester_sem = new AESemaphore("ProtTestSem");

    public static void load(PluginInterface plugin_interface) {
        String name = plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.aznetstatus.title");
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", name);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.logger = this.plugin_interface.getLogger().getChannel("NetStatus");
        this.logger.setDiagnostic();
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.aznetstatus.title");
        this.ping_target = config.addStringParameter2("plugin.aznetstatus.pingtarget", "plugin.aznetstatus.pingtarget", "www.google.com");
        if (Constants.isCVSVersion()) {
            this.test_address = config.addStringParameter2("plugin.aznetstatus.test_address", "plugin.aznetstatus.test_address", "");
            this.test_button = config.addActionParameter2("test", "test ");
            this.test_button.setEnabled(false);
            this.test_button.addListener(new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    NetStatusPlugin.this.protocol_tester.runTest(NetStatusPlugin.this.test_address.getValue().trim(), new NetStatusProtocolTesterListener(){

                        public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                        }

                        public void complete(NetStatusProtocolTesterBT tester2) {
                        }

                        public void log(String str) {
                            NetStatusPlugin.this.logger.log(str);
                        }

                        public void logError(String str) {
                            NetStatusPlugin.this.logger.log(str);
                        }

                        public void logError(String str, Throwable e) {
                            NetStatusPlugin.this.logger.log(str, e);
                        }
                    });
                }
            });
        }
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UISWTInstance swt_ui = (UISWTInstance)instance;
                    NetStatusPluginView view = new NetStatusPluginView(NetStatusPlugin.this);
                    swt_ui.addView("Main", NetStatusPlugin.VIEW_ID, view);
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                new AEThread2("NetstatusPlugin:init", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NetStatusPlugin.this.protocol_tester = new NetStatusProtocolTester(NetStatusPlugin.this, NetStatusPlugin.this.plugin_interface);
                            if (NetStatusPlugin.this.test_button != null) {
                                NetStatusPlugin.this.test_button.setEnabled(true);
                            }
                        }
                        finally {
                            NetStatusPlugin.this.protocol_tester_sem.releaseForever();
                        }
                    }
                }.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    public NetStatusProtocolTester getProtocolTester() {
        this.protocol_tester_sem.reserve();
        return this.protocol_tester;
    }

    public String getPingTarget() {
        return this.ping_target.getValue();
    }

    public void setBooleanParameter(String name, boolean value) {
        this.plugin_interface.getPluginconfig().setPluginParameter(name, value);
    }

    public boolean getBooleanParameter(String name, boolean def) {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter(name, def);
    }

    public void log(String str) {
        this.logger.log(str);
    }

    public void log(String str, Throwable e) {
        this.logger.log(str);
        this.logger.log(e);
    }
}

