/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterBT;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;

public class NetStatusProtocolTester
implements DistributedDatabaseTransferHandler {
    private static final int REQUEST_HISTORY_MAX = 64;
    private static final int MAX_ACTIVE_TESTS = 3;
    private static final int MAX_TEST_TIME = 120000;
    private static final int TEST_TYPE_BT = 1;
    private static final int VERSION_INITIAL = 1;
    private static final int CURRENT_VERSION = 1;
    private static final int BT_MAX_SLAVES = 8;
    private NetStatusPlugin plugin;
    private PluginInterface plugin_interface;
    private DistributedDatabase ddb;
    private DHTPlugin dht_plugin;
    private testXferType transfer_type = new testXferType();
    private Map request_history = new LinkedHashMap(64, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 64;
        }
    };
    private List active_tests = new ArrayList();
    private TimerEventPeriodic timer_event = null;

    protected NetStatusProtocolTester(NetStatusPlugin _plugin, PluginInterface _plugin_interface) {
        this.plugin = _plugin;
        this.plugin_interface = _plugin_interface;
        try {
            PluginInterface dht_pi = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi != null) {
                this.dht_plugin = (DHTPlugin)dht_pi.getPlugin();
            }
            this.ddb = this.plugin_interface.getDistributedDatabase();
            this.ddb.addTransferHandler(this.transfer_type, this);
            this.log("DDB transfer type registered");
        }
        catch (Throwable e) {
            this.log("DDB transfer type registration failed", e);
        }
    }

    public NetStatusProtocolTesterBT runTest(NetStatusProtocolTesterListener listener) {
        return this.runTest("", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetStatusProtocolTesterBT runTest(String test_address, final NetStatusProtocolTesterListener listener) {
        NetStatusProtocolTesterBT bt_tester;
        block11: {
            String[] bits;
            block12: {
                bt_tester = new NetStatusProtocolTesterBT(this, true);
                bt_tester.addListener(listener);
                bt_tester.start();
                this.addToActive(bt_tester);
                if (test_address.length() == 0) {
                    DHT[] dhts = this.dht_plugin.getDHTs();
                    DHT target_dht = null;
                    int target_network = Constants.isCVSVersion() ? 1 : 0;
                    for (int i = 0; i < dhts.length; ++i) {
                        if (dhts[i].getTransport().getNetwork() != target_network) continue;
                        target_dht = dhts[i];
                        break;
                    }
                    if (target_dht == null) {
                        listener.logError("Distributed database unavailable");
                    } else {
                        int i;
                        DHTTransportContact[] contacts = target_dht.getTransport().getReachableContacts();
                        final ArrayList<DHTTransportContact> f_contacts = new ArrayList<DHTTransportContact>(Arrays.asList(contacts));
                        final int[] ok = new int[]{0};
                        final int num_threads = Math.min(8, contacts.length);
                        listener.log("Searching " + contacts.length + " contacts for " + num_threads + " test targets");
                        final AESemaphore sem = new AESemaphore("NetStatusProbe");
                        for (i = 0; i < num_threads; ++i) {
                            new AEThread2("NetStatusProbe", true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 * Converted monitor instructions to comments
                                 * Lifted jumps to return sites
                                 */
                                public void run() {
                                    try {
                                        while (!bt_tester.isDestroyed()) {
                                            DHTTransportContact contact = null;
                                            int[] nArray = ok;
                                            // MONITORENTER : ok
                                            if (ok[0] < num_threads && f_contacts.size() > 0) {
                                                contact = (DHTTransportContact)f_contacts.remove(0);
                                            }
                                            // MONITOREXIT : nArray
                                            if (contact == null) {
                                                return;
                                            }
                                            try {
                                                DistributedDatabaseContact ddb_contact = NetStatusProtocolTester.this.ddb.importContact(contact.getAddress());
                                                if (!NetStatusProtocolTester.this.tryTest(bt_tester, ddb_contact)) continue;
                                                int[] nArray2 = ok;
                                                // MONITORENTER : ok
                                                ok[0] = ok[0] + 1;
                                                // MONITOREXIT : nArray2
                                            }
                                            catch (Throwable e) {
                                                listener.logError("Contact import for " + contact.getName() + " failed", e);
                                            }
                                        }
                                        return;
                                    }
                                    finally {
                                        sem.release();
                                    }
                                }
                            }.start();
                        }
                        for (i = 0; i < num_threads; ++i) {
                            sem.reserve();
                        }
                        listener.log("Searching complete, " + ok[0] + " targets found");
                    }
                    break block11;
                }
                bits = test_address.split(":");
                if (bits.length == 2) break block12;
                this.log("Invalid address - use <host>:<port> ");
                NetStatusProtocolTesterBT target_dht = bt_tester;
                bt_tester.addListener(new NetStatusProtocolTesterListener(){

                    public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                    }

                    public void complete(NetStatusProtocolTesterBT tester2) {
                        NetStatusProtocolTester.this.removeFromActive(tester2);
                    }

                    public void log(String str) {
                    }

                    public void logError(String str) {
                    }

                    public void logError(String str, Throwable e) {
                    }
                });
                bt_tester.setOutboundConnectionsComplete();
                new DelayedEvent("NetStatus:killer", 10000L, new AERunnable(listener, bt_tester){
                    final /* synthetic */ NetStatusProtocolTesterListener val$listener;
                    final /* synthetic */ NetStatusProtocolTesterBT val$bt_tester;
                    {
                        this.val$listener = netStatusProtocolTesterListener;
                        this.val$bt_tester = netStatusProtocolTesterBT;
                    }

                    public void runSupport() {
                        this.val$listener.log("Destroying tester");
                        this.val$bt_tester.destroy();
                    }
                });
                return target_dht;
            }
            try {
                InetSocketAddress address = new InetSocketAddress(bits[0].trim(), Integer.parseInt(bits[1].trim()));
                DistributedDatabaseContact contact = this.ddb.importContact(address);
                this.tryTest(bt_tester, contact);
            }
            catch (Throwable e) {
                try {
                    listener.logError("Test failed", e);
                    bt_tester.addListener(new /* invalid duplicate definition of identical inner class */);
                    bt_tester.setOutboundConnectionsComplete();
                    new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
                }
                catch (Throwable throwable) {
                    bt_tester.addListener(new /* invalid duplicate definition of identical inner class */);
                    bt_tester.setOutboundConnectionsComplete();
                    new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
        }
        bt_tester.addListener(new /* invalid duplicate definition of identical inner class */);
        bt_tester.setOutboundConnectionsComplete();
        new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
        return bt_tester;
    }

    protected boolean tryTest(NetStatusProtocolTesterBT bt_tester, DistributedDatabaseContact contact) {
        byte[] server_hash;
        boolean use_crypto = NetworkManager.getCryptoRequired(0);
        this.log("Trying test to " + contact.getName());
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        request2.put("v", new Long(1L));
        request2.put("t", new Long(1L));
        request2.put("h", bt_tester.getServerHash());
        request2.put("c", new Long(use_crypto ? 1L : 0L));
        Map reply = this.sendRequest(contact, request2);
        byte[] byArray = server_hash = reply == null ? null : (byte[])reply.get("h");
        if (server_hash != null) {
            this.log("    " + contact.getName() + " accepted test");
            bt_tester.testOutbound(this.adjustLoopback(contact.getAddress()), server_hash, use_crypto);
            return true;
        }
        this.log("    " + contact.getName() + " declined test");
        return false;
    }

    protected InetSocketAddress adjustLoopback(InetSocketAddress address) {
        InetSocketAddress local = this.dht_plugin.getLocalAddress().getAddress();
        if (local.getAddress().getHostAddress().equals(address.getAddress().getHostAddress())) {
            return new InetSocketAddress("127.0.0.1", address.getPort());
        }
        return address;
    }

    protected Map sendRequest(DistributedDatabaseContact contact, Map request2) {
        try {
            this.log("Sending DDB request to " + contact.getName() + " - " + request2);
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, this.transfer_type, key, 10000L);
            if (value == null) {
                return null;
            }
            Map reply = BDecoder.decode((byte[])value.getValue(byte[].class));
            this.log("    received reply - " + reply);
            return reply;
        }
        catch (Throwable e) {
            this.log("sendRequest failed", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map receiveRequest(InetSocketAddress originator, Map request2) {
        HashMap<String, Object> reply = new HashMap<String, Object>();
        Long test_type = (Long)request2.get("t");
        reply.put("v", new Long(1L));
        if (test_type != null && test_type.intValue() == 1) {
            byte[] their_hash;
            TCPNetworkManager tcp_man = TCPNetworkManager.getSingleton();
            InetSocketAddress adjusted_originator = this.adjustLoopback(originator);
            boolean test = adjusted_originator.getAddress().isLoopbackAddress();
            if ((test || tcp_man.isTCPListenerEnabled() && tcp_man.getTCPListeningPortNumber() == this.ddb.getLocalContact().getAddress().getPort() && SystemTime.getCurrentTime() - tcp_man.getLastIncomingNonLocalConnectionTime() <= 86400000L) && (their_hash = (byte[])request2.get("h")) != null) {
                NetStatusProtocolTesterBT bt_tester;
                List list = this.active_tests;
                synchronized (list) {
                    if (this.active_tests.size() > 3) {
                        this.log("Too many active tests");
                        return reply;
                    }
                    bt_tester = new NetStatusProtocolTesterBT(this, false);
                    bt_tester.start();
                    this.addToActive(bt_tester);
                }
                Long l_crypto = (Long)request2.get("c");
                boolean use_crypto = l_crypto != null && l_crypto == 1L;
                bt_tester.testOutbound(adjusted_originator, their_hash, use_crypto);
                reply.put("h", bt_tester.getServerHash());
            }
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToActive(NetStatusProtocolTesterBT tester2) {
        List list = this.active_tests;
        synchronized (list) {
            this.active_tests.add(tester2);
            if (this.timer_event == null) {
                this.timer_event = SimpleTimer.addPeriodicEvent("NetStatusProtocolTester:timer", 30000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        long now = SystemTime.getCurrentTime();
                        ArrayList<NetStatusProtocolTesterBT> to_remove = new ArrayList<NetStatusProtocolTesterBT>();
                        List list = NetStatusProtocolTester.this.active_tests;
                        synchronized (list) {
                            for (int i = 0; i < NetStatusProtocolTester.this.active_tests.size(); ++i) {
                                NetStatusProtocolTesterBT tester2 = (NetStatusProtocolTesterBT)NetStatusProtocolTester.this.active_tests.get(i);
                                long start = tester2.getStartTime(now);
                                if (now - start <= 120000L) continue;
                                to_remove.add(tester2);
                            }
                        }
                        for (int i = 0; i < to_remove.size(); ++i) {
                            NetStatusProtocolTester.this.removeFromActive((NetStatusProtocolTesterBT)to_remove.get(i));
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromActive(NetStatusProtocolTesterBT tester2) {
        tester2.destroy();
        List list = this.active_tests;
        synchronized (list) {
            this.active_tests.remove(tester2);
            if (this.active_tests.size() == 0 && this.timer_event != null) {
                this.timer_event.cancel();
                this.timer_event = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey ddb_key) throws DistributedDatabaseException {
        Object o_key = ddb_key.getKey();
        try {
            byte[] key = (byte[])o_key;
            HashWrapper hw = new HashWrapper(key);
            Map map = this.request_history;
            synchronized (map) {
                if (this.request_history.containsKey(hw)) {
                    return null;
                }
                this.request_history.put(hw, "");
            }
            Map request2 = BDecoder.decode((byte[])o_key);
            this.log("Received DDB request from " + contact.getName() + " - " + request2);
            Map result = this.receiveRequest(contact.getAddress(), request2);
            return this.ddb.createValue(BEncoder.encode(result));
        }
        catch (Throwable e) {
            this.log("DDB read failed", e);
            return null;
        }
    }

    public void write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    public void log(String str) {
        this.plugin.log(str);
    }

    public void log(String str, Throwable e) {
        this.plugin.log(str, e);
    }

    protected class testXferType
    implements DistributedDatabaseTransferType {
        protected testXferType() {
        }
    }
}

