/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.peerauth;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.BufferedInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;

public class TrackerPeerAuthPlugin
implements Plugin,
DownloadManagerListener {
    private static final String PLUGIN_NAME = "Tracker Peer Auth";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.trackerpeerauth.name";
    private static final int DEFAULT_CHECK_PERIOD = 30000;
    private static final String STATE_ENABLED = "enabled";
    private static final String STATE_DISABLED = "disabled";
    private static final int TIMER_PERIOD = 10000;
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_state;
    private LoggerChannel log;
    private Map dt_map = new HashMap();
    private ThreadPool thread_pool = new ThreadPool("TrackerPeerAuthPlugin", 8, true);

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.ta_state = this.plugin_interface.getTorrentManager().getPluginAttribute("state");
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("Plugin.trackerpeerauth.info");
        final BasicPluginViewModel view_model = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        view_model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                view_model.getLogArea().appendText(content + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(str + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                view_model.getLogArea().appendText(sw.toString() + "\n");
            }
        });
        System.out.println("**** tracker peer auth disabled ****");
    }

    public void downloadAdded(final Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && torrent.isPrivate()) {
            download.addTrackerListener(new DownloadTrackerListener(){

                public void scrapeResult(DownloadScrapeResult result) {
                }

                public void announceResult(DownloadAnnounceResult result) {
                    if (result.getResponseType() == 1) {
                        Map ext = result.getExtensions();
                        boolean enabled = true;
                        int check_period = 30000;
                        if (ext != null) {
                            // empty if block
                        }
                        download.setAttribute(TrackerPeerAuthPlugin.this.ta_state, enabled ? TrackerPeerAuthPlugin.STATE_ENABLED : TrackerPeerAuthPlugin.STATE_DISABLED);
                        TrackerPeerAuthPlugin.this.setState(download, enabled, check_period);
                    }
                }
            });
            String state = download.getAttribute(this.ta_state);
            if (state != null) {
                boolean enabled = state.equals(STATE_ENABLED);
                this.setState(download, enabled, 30000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRemoved(Download download) {
        Map map = this.dt_map;
        synchronized (map) {
            this.dt_map.remove(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Download download, boolean enabled, int check_period) {
        Map map = this.dt_map;
        synchronized (map) {
            if (enabled) {
                DownloadTracker existing = (DownloadTracker)this.dt_map.get(download);
                if (existing == null) {
                    DownloadTracker dt = new DownloadTracker(download, check_period);
                    this.dt_map.put(download, dt);
                } else {
                    existing.setCheckPeriod(check_period);
                }
            } else {
                this.dt_map.remove(download);
            }
        }
    }

    protected void log(Download download, String str) {
        this.log.log("Download '" + download.getName() + "' - " + str);
    }

    protected class DownloadTracker
    implements DownloadPeerListener,
    PeerManagerListener,
    DownloadTrackerListener {
        private static final int BACKOFF_TICK_COUNT = 6;
        private static final int MAX_PEERS_PER_QUERY = 100;
        private static final int OK_BLOOM_INITIAL = 16384;
        private static final int OK_BLOOM_INC = 16384;
        private static final int OK_BLOOM_MAX = 131072;
        private static final int BAD_BLOOM_INITIAL = 4096;
        private static final int BAD_BLOOM_INC = 4096;
        private static final int BAD_BLOOM_MAX = 65536;
        private Download download;
        private BloomFilter ok_bloom = BloomFilterFactory.createAddOnly(16384);
        private BloomFilter bad_bloom = BloomFilterFactory.createAddOnly(4096);
        private long pending_check_peer_count = 0L;
        private boolean check_running;
        private int check_tick_count;
        private int backoff_tick_count;

        protected DownloadTracker(Download _download, int _min_check_period) {
            this.download = _download;
            this.download.addTrackerListener(this);
            this.download.addPeerListener(this);
            this.setCheckPeriod(_min_check_period);
            this.log("enabled, check period=" + _min_check_period);
        }

        protected void setCheckPeriod(int _min_check_period) {
            this.check_tick_count = _min_check_period / 10000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recordPeer(String source, byte[] id, String ip, int port, boolean ok) {
            if (id == null) {
                return;
            }
            byte[] key = this.getKey(id, ip);
            DownloadTracker downloadTracker = this;
            synchronized (downloadTracker) {
                if (ok) {
                    int entries = this.ok_bloom.getEntryCount();
                    if (entries > 0 && this.ok_bloom.getSize() / entries < 10) {
                        int new_size = this.ok_bloom.getSize() + 16384;
                        if (new_size > 131072) {
                            new_size = 131072;
                        }
                        this.log("Expanding ok bloom to " + new_size + " entries");
                        BloomFilter new_ok_bloom = BloomFilterFactory.createAddOnly(new_size);
                        PeerManager pm = this.download.getPeerManager();
                        if (pm != null) {
                            Peer[] peers = pm.getPeers();
                            for (int i = 0; i < peers.length; ++i) {
                                byte[] peer_key = this.getKey(peers[i]);
                                if (peer_key == null || !this.ok_bloom.contains(peer_key)) continue;
                                new_ok_bloom.add(peer_key);
                            }
                        }
                        this.ok_bloom = new_ok_bloom;
                        this.bad_bloom = BloomFilterFactory.createAddOnly(this.bad_bloom.getSize());
                    }
                    this.ok_bloom.add(key);
                } else {
                    int entries = this.bad_bloom.getEntryCount();
                    if (entries > 0 && this.bad_bloom.getSize() / entries < 10) {
                        int new_size = this.bad_bloom.getSize() + 4096;
                        if (new_size > 65536) {
                            new_size = 65536;
                        }
                        this.log("Expanding bad bloom to " + new_size + " entries");
                        this.bad_bloom = BloomFilterFactory.createAddOnly(new_size);
                    }
                    this.bad_bloom.add(key);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkPeers(long tick_count) {
            if (this.backoff_tick_count > 0) {
                --this.backoff_tick_count;
                return;
            }
            if (tick_count % (long)this.check_tick_count == 0L) {
                DownloadTracker downloadTracker = this;
                synchronized (downloadTracker) {
                    if (this.pending_check_peer_count <= 0L || this.check_running) {
                        return;
                    }
                    this.pending_check_peer_count = 0L;
                    this.check_running = true;
                }
                boolean gone_async = false;
                try {
                    PeerManager pm = this.download.getPeerManager();
                    if (pm != null) {
                        Peer[] peers = pm.getPeers();
                        final ArrayList<Peer> to_check = new ArrayList<Peer>();
                        for (int i = 0; i < peers.length; ++i) {
                            Peer peer = peers[i];
                            byte[] peer_key = this.getKey(peer);
                            if (peer_key == null || this.ok_bloom.contains(peer_key)) continue;
                            if (this.bad_bloom.contains(peer_key)) {
                                this.removePeer(peer);
                                continue;
                            }
                            to_check.add(peer);
                        }
                        if (to_check.size() > 0) {
                            TrackerPeerAuthPlugin.this.thread_pool.run(new AERunnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void runSupport() {
                                    try {
                                        DownloadTracker.this.check(to_check);
                                    }
                                    finally {
                                        DownloadTracker downloadTracker = DownloadTracker.this;
                                        synchronized (downloadTracker) {
                                            DownloadTracker.this.check_running = false;
                                        }
                                    }
                                }
                            });
                            gone_async = true;
                        }
                    }
                }
                finally {
                    if (!gone_async) {
                        DownloadTracker downloadTracker2 = this;
                        synchronized (downloadTracker2) {
                            this.check_running = false;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void check(List peers) {
            URL target;
            DownloadAnnounceResult an = this.download.getLastAnnounceResult();
            URL uRL = target = an == null ? null : an.getURL();
            if (target == null) {
                target = this.download.getTorrent().getAnnounceURL();
            }
            OutputStreamWriter out = null;
            BufferedInputStream in = null;
            try {
                String url_str = target.toString();
                int pos = url_str.indexOf("announce");
                if (pos == -1) {
                    this.log("announce URL '" + url_str + "' is non-conformant");
                    return;
                }
                url_str = url_str.substring(0, pos) + "testauth" + url_str.substring(pos + 8);
                target = new URL(url_str);
                HashMap map = new HashMap();
                String peer_str = "";
                for (int i = 0; i < peers.size() && i < 100; ++i) {
                    Peer peer = (Peer)peers.get(i);
                    ArrayList<Object> peer_data = new ArrayList<Object>();
                    peer_data.add(this.download.getTorrent().getHash());
                    peer_data.add(peer.getId());
                    peer_data.add(peer.getIp());
                    map.put("peer" + i, peer_data);
                    peer_str = peer_str + (i == 0 ? "" : ",") + peer.getIp();
                }
                this.log("Checking " + url_str + " : peers=" + peer_str);
                byte[] encoded = BEncoder.encode(map, true);
                HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                String data = "authpeers=" + new String(encoded, "ISO-8859-1");
                System.out.println("sending '" + data + "'");
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("User-Agent", "Azureus 4.2.0.8");
                connection.setRequestProperty("Connection", "close");
                connection.addRequestProperty("Accept-Encoding", "gzip");
                out = new OutputStreamWriter(connection.getOutputStream());
                out.write(data);
                out.flush();
                in = new BufferedInputStream(connection.getInputStream());
                Map result_map = BDecoder.decode(in);
                for (int i = 0; i < peers.size() && i < 100; ++i) {
                    Peer peer = (Peer)peers.get(i);
                    Long enabled = (Long)result_map.get("peer" + i);
                    if (enabled == null) {
                        this.log("No response for peer '" + peer.getIp() + "'");
                        continue;
                    }
                    boolean ok = enabled != 0L;
                    this.recordPeer("auth check", peer.getId(), peer.getIp(), peer.getPort(), ok);
                    if (ok) continue;
                    this.removePeer(peer);
                }
            }
            catch (Throwable e) {
                this.backoff_tick_count = 6;
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable e) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }

        protected byte[] getKey(Peer peer) {
            byte[] peer_id = peer.getId();
            if (peer_id == null) {
                return null;
            }
            return this.getKey(peer_id, peer.getIp());
        }

        protected byte[] getKey(byte[] peer_id, String ip_str) {
            byte[] ip = ip_str.getBytes();
            byte[] key = new byte[peer_id.length + ip.length];
            System.arraycopy(peer_id, 0, key, 0, peer_id.length);
            System.arraycopy(ip, 0, key, peer_id.length, ip.length);
            return key;
        }

        protected boolean knownToBeOK(Peer peer) {
            byte[] peer_id = peer.getId();
            if (peer_id == null) {
                return true;
            }
            byte[] key = this.getKey(peer_id, peer.getIp());
            return this.ok_bloom.contains(key);
        }

        protected boolean knownToBeBad(Peer peer) {
            byte[] peer_id = peer.getId();
            if (peer_id == null) {
                return true;
            }
            byte[] key = this.getKey(peer_id, peer.getIp());
            return this.bad_bloom.contains(key);
        }

        protected void peerMightBeBad(Peer peer) {
            if (!this.knownToBeOK(peer)) {
                if (this.knownToBeBad(peer)) {
                    this.removePeer(peer);
                } else {
                    ++this.pending_check_peer_count;
                }
            }
        }

        protected void removePeer(Peer peer) {
            this.log("Disconnecting peer " + peer.getIp() + "/" + peer.getPort() + ": not authorized");
            peer.close("Tracker peer authorization failure", false, false);
        }

        public void scrapeResult(DownloadScrapeResult result) {
        }

        public void announceResult(DownloadAnnounceResult result) {
            DownloadAnnounceResultPeer[] peers = result.getPeers();
            if (peers != null) {
                for (int i = 0; i < peers.length; ++i) {
                    DownloadAnnounceResultPeer peer = peers[i];
                    this.recordPeer("Tracker", peer.getPeerID(), peer.getAddress(), peer.getPort(), true);
                }
            }
        }

        public void peerAdded(PeerManager manager, Peer peer) {
            if (peer.isIncoming()) {
                this.peerMightBeBad(peer);
            } else {
                this.recordPeer("Outgoing", peer.getId(), peer.getIp(), peer.getPort(), true);
            }
        }

        public void peerRemoved(PeerManager manager, Peer peer) {
        }

        public void peerManagerAdded(Download download, PeerManager peer_manager) {
            peer_manager.addListener(this);
        }

        public void peerManagerRemoved(Download download, PeerManager peer_manager) {
            peer_manager.removeListener(this);
        }

        protected void log(String str) {
            TrackerPeerAuthPlugin.this.log(this.download, str);
        }
    }
}

